/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.impl;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.protobuf.ByteString;
import com.mapr.db.impl.AlwaysFalseCondition;
import com.mapr.db.impl.AlwaysTrueCondition;
import com.mapr.db.impl.ConditionDescriptor;
import com.mapr.db.impl.ConditionImpl;
import com.mapr.db.impl.ConditionLeaf;
import com.mapr.db.impl.ConditionNode;
import com.mapr.db.impl.ConditionVisitor;
import com.mapr.db.impl.MapRDBIndexImpl;
import com.mapr.fs.jni.MapRConstants;
import com.mapr.fs.proto.Dbfilters;
import com.mapr.org.apache.hadoop.hbase.util.Bytes;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ojai.FieldPath;
import org.ojai.annotation.API;
import org.ojai.store.QueryCondition;

@API.Internal
class ConditionBlock
extends ConditionNode {
    private BlockType type;
    private List<ConditionNode> children;
    private boolean closed = false;

    ConditionBlock(BlockType type, QueryCondition c) {
        super(c);
        this.type = type;
        this.children = Lists.newArrayList();
    }

    ConditionBlock(ByteString serializedState, QueryCondition c) {
        super(c);
        try {
            Dbfilters.FilterListProto proto = Dbfilters.FilterListProto.parseFrom((ByteString)serializedState);
            this.type = proto.getOperator() == Dbfilters.FilterListProto.OperatorProto.MUST_PASS_ALL ? BlockType.and : BlockType.or;
            ArrayList<ConditionNode> nodeList = new ArrayList<ConditionNode>(proto.getFiltersCount());
            block17: for (Dbfilters.FilterMsg filter : proto.getFiltersList()) {
                String nodeId = filter.getId();
                ByteString nodeState = filter.getSerializedState();
                switch (nodeId) {
                    case "d71875e1": {
                        nodeList.add(new AlwaysFalseCondition(c));
                        continue block17;
                    }
                    case "7846fa80": {
                        nodeList.add(new AlwaysTrueCondition(c));
                        continue block17;
                    }
                    case "469dbd04": 
                    case "rk_filter": 
                    case "8cbdcd12": 
                    case "17544506": {
                        nodeList.add(new ConditionLeaf(nodeId, nodeState, c));
                        continue block17;
                    }
                    case "a42ebf64": {
                        nodeList.add(new ConditionBlock(nodeState, c));
                        continue block17;
                    }
                }
                throw new IllegalArgumentException("Unknown filter in the serialized message: " + nodeId);
            }
            this.children = nodeList;
            this.closed = true;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to decode message", e);
        }
    }

    @Override
    protected ConditionBlock clone(ConditionImpl topLevelCondition) {
        ConditionBlock newBlock = (ConditionBlock)super.clone();
        newBlock.setTopLevelCondition(topLevelCondition);
        newBlock.children = Lists.newArrayList();
        for (int i = 0; i < this.children.size(); ++i) {
            newBlock.children.add(this.children.get(i).clone(topLevelCondition));
        }
        return newBlock;
    }

    BlockType getType() {
        return this.type;
    }

    void add(ConditionNode node) {
        this.children.add(node);
    }

    @Override
    public boolean isEmpty() {
        return this.children == null || this.children.size() == 0;
    }

    @Override
    boolean isLeaf() {
        return false;
    }

    List<ConditionNode> getChildren() {
        return this.children;
    }

    @Override
    void addProjections(Set<FieldPath> proj) {
        for (int i = 0; i < this.children.size(); ++i) {
            this.children.get(i).addProjections(proj);
        }
    }

    public String toString() {
        return this.expressionBuilder(new StringBuilder()).toString();
    }

    @Override
    StringBuilder expressionBuilder(StringBuilder sb) {
        sb.append('(');
        for (int i = 0; i < this.children.size(); ++i) {
            this.children.get(i).expressionBuilder(sb);
            if (i >= this.children.size() - 1) continue;
            sb.append(' ').append((Object)this.type).append(' ');
        }
        sb.append(')');
        return sb;
    }

    @Override
    StringBuilder treeBuilder(StringBuilder sb, int level) {
        int indent = 2 * level;
        ++level;
        sb.append((Object)this.type).append(" [");
        for (ConditionNode node : this.children) {
            sb.append('\n');
            ConditionBlock.indent(sb, indent);
            node.treeBuilder(sb, level);
        }
        if (this.closed) {
            sb.append('\n');
            ConditionBlock.indent(sb, indent - 2).append(']');
        }
        return sb;
    }

    @Override
    StringBuilder jsonBuilder(StringBuilder sb) {
        sb.append('{').append('\"').append('$').append((Object)this.type).append('\"').append(':').append(' ').append('[');
        for (ConditionNode node : this.children) {
            node.jsonBuilder(sb).append(',').append(' ');
        }
        if (sb.charAt(sb.length() - 1) != '[') {
            sb.delete(sb.length() - 2, sb.length());
        }
        sb.append(']').append('}');
        return sb;
    }

    @Override
    ConditionDescriptor getDescriptor(BiMap<FieldPath, Integer> pathIdMap) {
        return null;
    }

    @Override
    ConditionDescriptor getDescriptor(BiMap<FieldPath, Integer> pathIdMap, MapRDBIndexImpl indexTable) {
        Dbfilters.FilterListProto.Builder builder = Dbfilters.FilterListProto.newBuilder();
        builder.setOperator(this.type == BlockType.and ? Dbfilters.FilterListProto.OperatorProto.MUST_PASS_ALL : Dbfilters.FilterListProto.OperatorProto.MUST_PASS_ONE);
        HashMap blockFamilyFieldPathsMap = Maps.newHashMap();
        for (ConditionNode filter : this.children) {
            ConditionDescriptor child = filter.getDescriptor(pathIdMap, indexTable);
            if (child == null) continue;
            builder.addFilters(child.getFilterMsg());
            Map<Integer, ? extends Set<FieldPath>> childFamilyFieldPathsMap = child.getFamilyFieldPathsMap();
            for (Map.Entry<Integer, ? extends Set<FieldPath>> childFamilyFieldPathsEntry : childFamilyFieldPathsMap.entrySet()) {
                Integer familyId = childFamilyFieldPathsEntry.getKey();
                Set set = (Set)blockFamilyFieldPathsMap.get(familyId);
                if (set == null) {
                    set = Sets.newTreeSet();
                    blockFamilyFieldPathsMap.put(familyId, set);
                }
                set.addAll((Collection)childFamilyFieldPathsEntry.getValue());
            }
        }
        Dbfilters.FilterMsg filterMsg = Dbfilters.FilterMsg.newBuilder().setId("a42ebf64").setSerializedState(builder.build().toByteString()).build();
        return new ConditionDescriptor(filterMsg, blockFamilyFieldPathsMap);
    }

    @Override
    List<List<ConditionNode.RowkeyRange>> getRowkeyRanges() {
        if (this.children.size() == 0) {
            return this.getLLRR();
        }
        List<List<ConditionNode.RowkeyRange>> nodeRanges = this.children.get(0).getRowkeyRanges();
        for (int i = 1; i < this.children.size(); ++i) {
            List<List<ConditionNode.RowkeyRange>> nextNodeRanges = this.children.get(i).getRowkeyRanges();
            nodeRanges = this.mergeNodeRanges(nodeRanges, nextNodeRanges);
        }
        return nodeRanges;
    }

    ConditionBlock close() {
        this.closed = true;
        return this;
    }

    @Override
    boolean checkAndPrune() {
        ConditionNode child = null;
        if (this.type == BlockType.and) {
            Iterator<ConditionNode> itr = this.children.iterator();
            while (itr.hasNext()) {
                child = itr.next();
                if (!child.checkAndPrune() && !(child instanceof AlwaysTrueCondition)) continue;
                itr.remove();
            }
        }
        if (this.children.size() == 1 && !this.children.get(0).isLeaf()) {
            ConditionBlock rootBlock = (ConditionBlock)this.children.get(0);
            this.children = rootBlock.children;
            this.type = rootBlock.type;
        }
        return this.children.size() == 0;
    }

    private static boolean gt(byte[] left, byte[] right) {
        return Bytes.compareTo((byte[])left, (byte[])right) > 0;
    }

    private static boolean ge(byte[] left, byte[] right) {
        return Bytes.compareTo((byte[])left, (byte[])right) >= 0;
    }

    private static boolean lt(byte[] left, byte[] right) {
        return Bytes.compareTo((byte[])left, (byte[])right) < 0;
    }

    private static boolean le(byte[] left, byte[] right) {
        return Bytes.compareTo((byte[])left, (byte[])right) <= 0;
    }

    private ConditionNode.RowkeyRange getIntersection(ConditionNode.RowkeyRange a, ConditionNode.RowkeyRange b) {
        byte[] aStartRow = a.getStartRow();
        byte[] aStopRow = a.getStopRow();
        byte[] bStartRow = b.getStartRow();
        byte[] bStopRow = b.getStopRow();
        assert (aStartRow.length > 0 || aStopRow.length > 0);
        assert (bStartRow.length > 0 || bStopRow.length > 0);
        if (aStopRow.length == 0 && bStopRow.length == 0) {
            return ConditionBlock.le(aStartRow, bStartRow) ? b : a;
        }
        if (aStopRow.length == 0) {
            return ConditionBlock.le(bStopRow, aStartRow) ? null : new ConditionNode.RowkeyRange(aStartRow, bStopRow);
        }
        if (bStopRow.length == 0) {
            return ConditionBlock.le(aStopRow, bStartRow) ? null : new ConditionNode.RowkeyRange(bStartRow, aStopRow);
        }
        if (ConditionBlock.le(aStopRow, bStartRow) || ConditionBlock.le(bStopRow, aStartRow)) {
            return null;
        }
        byte[] startRow = Bytes.maxOfStartRows((byte[])aStartRow, (byte[])bStartRow);
        byte[] stopRow = Bytes.minOfStopRows((byte[])aStopRow, (byte[])bStopRow);
        return new ConditionNode.RowkeyRange(startRow, stopRow);
    }

    private List<ConditionNode.RowkeyRange> mergeAndRanges(List<ConditionNode.RowkeyRange> as, List<ConditionNode.RowkeyRange> bs) {
        if (as.size() == 0) {
            return as;
        }
        if (bs.size() == 0) {
            return bs;
        }
        if (as == FULL_TABLE_RANGE) {
            return bs;
        }
        if (bs == FULL_TABLE_RANGE) {
            return as;
        }
        ArrayList<ConditionNode.RowkeyRange> merged = new ArrayList<ConditionNode.RowkeyRange>();
        int i = 0;
        int j = 0;
        while (i < as.size() && j < bs.size()) {
            ConditionNode.RowkeyRange a = as.get(i);
            ConditionNode.RowkeyRange b = bs.get(j);
            byte[] aStopRow = a.getStopRow();
            byte[] bStopRow = b.getStopRow();
            ConditionNode.RowkeyRange range = this.getIntersection(a, b);
            if (range != null) {
                merged.add(range);
            }
            if (aStopRow.length > 0 && bStopRow.length == 0 || ConditionBlock.lt(aStopRow, bStopRow)) {
                ++i;
                continue;
            }
            if (aStopRow.length == 0 && bStopRow.length > 0 || ConditionBlock.gt(aStopRow, bStopRow)) {
                ++j;
                continue;
            }
            ++i;
            ++j;
        }
        return merged;
    }

    private List<List<ConditionNode.RowkeyRange>> mergeAndRangeLists(List<List<ConditionNode.RowkeyRange>> as, List<List<ConditionNode.RowkeyRange>> bs) {
        int nPartitionKeys = ((ConditionImpl)this.topLevelCondition).getPartitionKeys().size();
        int rowkeyRangeArraySize = Math.max(nPartitionKeys, 1);
        ArrayList<List<ConditionNode.RowkeyRange>> llrr = new ArrayList<List<ConditionNode.RowkeyRange>>(rowkeyRangeArraySize);
        for (int i = 0; i < rowkeyRangeArraySize; ++i) {
            llrr.add(this.mergeAndRanges(as.get(i), bs.get(i)));
        }
        return llrr;
    }

    private ConditionNode.RowkeyRange getUnionOfIntersectingRanges(ConditionNode.RowkeyRange a, ConditionNode.RowkeyRange b) {
        byte[] aStartRow = a.getStartRow();
        byte[] aStopRow = a.getStopRow();
        byte[] bStartRow = b.getStartRow();
        byte[] bStopRow = b.getStopRow();
        byte[] startRow = Bytes.minOfStartRows((byte[])aStartRow, (byte[])bStartRow);
        byte[] stopRow = Bytes.maxOfStopRows((byte[])aStopRow, (byte[])bStopRow);
        if (aStartRow.equals(startRow) && aStopRow.equals(stopRow)) {
            return a;
        }
        if (bStartRow.equals(startRow) && bStopRow.equals(stopRow)) {
            return b;
        }
        return new ConditionNode.RowkeyRange(startRow, stopRow);
    }

    private boolean areIntersectingRanges(ConditionNode.RowkeyRange left, ConditionNode.RowkeyRange right) {
        byte[] leftStop = left.getStopRow();
        byte[] rightStart = right.getStartRow();
        return leftStop.length == 0 && rightStart.length > 0 || ConditionBlock.ge(leftStop, rightStart);
    }

    private void appendToRangeList(List<ConditionNode.RowkeyRange> merged, ConditionNode.RowkeyRange nextRange) {
        ConditionNode.RowkeyRange last;
        int size = merged.size();
        ConditionNode.RowkeyRange rowkeyRange = last = size > 0 ? merged.get(size - 1) : null;
        if (last != null && this.areIntersectingRanges(last, nextRange)) {
            ConditionNode.RowkeyRange union = this.getUnionOfIntersectingRanges(last, nextRange);
            if (union != last) {
                merged.set(size - 1, union);
            }
        } else {
            merged.add(nextRange);
        }
    }

    private List<ConditionNode.RowkeyRange> mergeOrRanges(List<ConditionNode.RowkeyRange> as, List<ConditionNode.RowkeyRange> bs) {
        if (as.size() == 0) {
            return bs;
        }
        if (bs.size() == 0) {
            return as;
        }
        if (as == FULL_TABLE_RANGE) {
            return as;
        }
        if (bs == FULL_TABLE_RANGE) {
            return bs;
        }
        ArrayList<ConditionNode.RowkeyRange> merged = new ArrayList<ConditionNode.RowkeyRange>();
        int i = 0;
        int j = 0;
        while (i < as.size() || j < bs.size()) {
            if (i < as.size() && j < bs.size()) {
                ConditionNode.RowkeyRange nextRange;
                byte[] bStartRow;
                ConditionNode.RowkeyRange a = as.get(i);
                ConditionNode.RowkeyRange b = bs.get(j);
                byte[] aStartRow = a.getStartRow();
                if (ConditionBlock.lt(aStartRow, bStartRow = b.getStartRow())) {
                    nextRange = a;
                    ++i;
                } else {
                    nextRange = b;
                    ++j;
                }
                this.appendToRangeList(merged, nextRange);
                continue;
            }
            if (i == as.size()) {
                while (j < bs.size()) {
                    this.appendToRangeList(merged, bs.get(j++));
                }
            } else {
                while (i < as.size()) {
                    this.appendToRangeList(merged, as.get(i++));
                }
            }
            break;
        }
        return merged;
    }

    private List<List<ConditionNode.RowkeyRange>> mergeOrRangeLists(List<List<ConditionNode.RowkeyRange>> as, List<List<ConditionNode.RowkeyRange>> bs) {
        int nPartitionKeys = ((ConditionImpl)this.topLevelCondition).getPartitionKeys().size();
        int rowkeyRangeArraySize = Math.max(nPartitionKeys, 1);
        ArrayList<List<ConditionNode.RowkeyRange>> llrr = new ArrayList<List<ConditionNode.RowkeyRange>>(rowkeyRangeArraySize);
        for (int i = 0; i < rowkeyRangeArraySize; ++i) {
            llrr.add(this.mergeOrRanges(as.get(i), bs.get(i)));
        }
        return llrr;
    }

    private List<List<ConditionNode.RowkeyRange>> mergeNodeRanges(List<List<ConditionNode.RowkeyRange>> leftRanges, List<List<ConditionNode.RowkeyRange>> rightRanges) {
        List<List<ConditionNode.RowkeyRange>> llrr = this.getLLRR();
        if (((ConditionImpl)this.topLevelCondition).isSecondaryIndexQueryCondition()) {
            switch (this.type) {
                case and: {
                    return this.mergeAndRangeLists(leftRanges, rightRanges);
                }
                case or: {
                    return this.mergeOrRangeLists(leftRanges, rightRanges);
                }
            }
            assert (false) : (Object)((Object)this.type) + " is not handled.";
            return llrr;
        }
        byte[] startRow = MapRConstants.EMPTY_BYTE_ARRAY;
        byte[] stopRow = MapRConstants.EMPTY_BYTE_ARRAY;
        byte[] leftStartRow = leftRanges.get(0).get(0).getStartRow();
        byte[] leftStopRow = leftRanges.get(0).get(0).getStopRow();
        byte[] rightStartRow = rightRanges.get(0).get(0).getStartRow();
        byte[] rightStopRow = rightRanges.get(0).get(0).getStopRow();
        switch (this.type) {
            case and: {
                startRow = Bytes.maxOfStartRows((byte[])leftStartRow, (byte[])rightStartRow);
                stopRow = Bytes.minOfStopRows((byte[])leftStopRow, (byte[])rightStopRow);
                break;
            }
            case or: {
                startRow = Bytes.minOfStartRows((byte[])leftStartRow, (byte[])rightStartRow);
                stopRow = Bytes.maxOfStopRows((byte[])leftStopRow, (byte[])rightStopRow);
                break;
            }
            default: {
                assert (false) : (Object)((Object)this.type) + " is not handled.";
                break;
            }
        }
        if (startRow != MapRConstants.EMPTY_BYTE_ARRAY || stopRow != MapRConstants.EMPTY_BYTE_ARRAY) {
            llrr.set(0, (List<ConditionNode.RowkeyRange>)ImmutableList.of((Object)new ConditionNode.RowkeyRange(startRow, stopRow)));
        }
        return llrr;
    }

    @Override
    void visit(ConditionVisitor visitor) {
        for (ConditionNode node : this.children) {
            node.visit(visitor);
        }
        visitor.operator(this.type.getName(), this.children.size());
    }

    static enum BlockType {
        and("and"),
        or("or");

        private final String name;

        private BlockType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

