/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.tests.utils;

import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.rowcol.InsertContext;
import com.mapr.db.rowcol.KeyValue;
import com.mapr.db.rowcol.MutationImpl;
import com.mapr.db.rowcol.RowcolCodec;
import com.mapr.db.rowcol.TimeDescriptor;
import com.mapr.db.util.MutationParser;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.SimpleTest;
import java.nio.ByteBuffer;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;
import org.ojai.store.DocumentMutation;

@Category(value={SimpleTest.class})
public class TestMutationParserWithoutCluster
extends BaseTest {
    @Test
    public void testPutMutation() {
        String putMutation = "{\"$put\":[{\"a.b[0].boolean\":true},{\"a.c.d\":\"eureka\"},{\"a.x\":1}]}";
        MutationParser mutationParser = new MutationParser();
        MutationImpl jsonMutation = (MutationImpl)mutationParser.parseMutation(putMutation);
        DocumentMutation m = MapRDBImpl.newMutation().setOrReplace("a.b[0].boolean", true).setOrReplace("a.c.d", "eureka").setOrReplace("a.x", 1);
        Assert.assertEquals((Object)true, (Object)jsonMutation.needsReadOnServer());
        ByteBuffer b = jsonMutation.rowcolSerialize();
        Document rec = RowcolCodec.decode((ByteBuffer)b, null, (boolean)true, (boolean)false, (boolean)true);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)((KeyValue)rec)), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)((KeyValue)rec)), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)((KeyValue)rec)), (Object)false);
        KeyValue kv = (KeyValue)rec.getValue("a.b");
        Assert.assertEquals((Object)InsertContext.OpType.NONE, (Object)kv.getOpType());
        Assert.assertTrue((boolean)TimeDescriptor.isCreateTimeValid((KeyValue)kv));
        Assert.assertTrue((boolean)TimeDescriptor.isUpdateTimeValid((KeyValue)kv));
        Assert.assertFalse((boolean)TimeDescriptor.isDeleteTimeValid((KeyValue)kv));
        kv = (KeyValue)rec.getValue("a.b[0].boolean");
        Assert.assertEquals((Object)InsertContext.OpType.SET_OR_REPLACE, (Object)kv.getOpType());
        Assert.assertTrue((boolean)kv.getBoolean());
        Assert.assertTrue((boolean)TimeDescriptor.isCreateTimeValid((KeyValue)kv));
        Assert.assertTrue((boolean)TimeDescriptor.isUpdateTimeValid((KeyValue)kv));
        Assert.assertTrue((boolean)TimeDescriptor.isDeleteTimeValid((KeyValue)kv));
    }

    @Test
    public void testMergeMutation() {
        String mergeMutation = "{\"$merge\":{\"a.c\":{\"d\":11,\"y\":\"yo\"}}}";
        MutationParser mutationParser = new MutationParser();
        MutationImpl jsonMutation = (MutationImpl)mutationParser.parseMutation(mergeMutation);
        Assert.assertEquals((Object)true, (Object)jsonMutation.needsReadOnServer());
        ByteBuffer b = jsonMutation.rowcolSerialize();
        Document rec = RowcolCodec.decode((ByteBuffer)b, null, (boolean)true, (boolean)false, (boolean)true);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)((KeyValue)rec)), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)((KeyValue)rec)), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)((KeyValue)rec)), (Object)false);
        KeyValue kv = (KeyValue)rec.getValue("a.c");
        Assert.assertEquals((Object)InsertContext.OpType.MERGE, (Object)kv.getOpType());
        Assert.assertTrue((boolean)TimeDescriptor.isCreateTimeValid((KeyValue)kv));
        Assert.assertTrue((boolean)TimeDescriptor.isUpdateTimeValid((KeyValue)kv));
        Assert.assertFalse((boolean)TimeDescriptor.isDeleteTimeValid((KeyValue)kv));
    }

    @Test
    public void testIncrement() {
        String incrementMutation = "{\"$increment\":[\"p.q.r\",{\"a.c.d\":-5}]}";
        MutationParser mutationParser = new MutationParser();
        MutationImpl jsonMutation = (MutationImpl)mutationParser.parseMutation(incrementMutation);
        Assert.assertTrue((boolean)jsonMutation.needsReadOnServer());
        ByteBuffer b = jsonMutation.rowcolSerialize();
        Document rec = RowcolCodec.decode((ByteBuffer)b, null, (boolean)true, (boolean)false, (boolean)true);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)((KeyValue)rec)), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)((KeyValue)rec)), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)((KeyValue)rec)), (Object)false);
        KeyValue kv = (KeyValue)rec.getValue("a.c.d");
        Assert.assertEquals((Object)InsertContext.OpType.INCREMENT, (Object)kv.getOpType());
        Assert.assertEquals((double)-5.0, (double)kv.getDouble(), (double)0.0);
        Assert.assertTrue((boolean)TimeDescriptor.isCreateTimeValid((KeyValue)kv));
        Assert.assertTrue((boolean)TimeDescriptor.isUpdateTimeValid((KeyValue)kv));
        Assert.assertFalse((boolean)TimeDescriptor.isDeleteTimeValid((KeyValue)kv));
        kv = (KeyValue)rec.getValue("p.q.r");
        Assert.assertEquals((Object)InsertContext.OpType.INCREMENT, (Object)kv.getOpType());
        Assert.assertEquals((double)1.0, (double)kv.getDouble(), (double)0.0);
        Assert.assertTrue((boolean)TimeDescriptor.isCreateTimeValid((KeyValue)kv));
        Assert.assertTrue((boolean)TimeDescriptor.isUpdateTimeValid((KeyValue)kv));
        Assert.assertFalse((boolean)TimeDescriptor.isDeleteTimeValid((KeyValue)kv));
    }

    @Test
    public void testAppend() {
        String appendMutation = "{\"$append\":[{\"a.b\":{\"appd\":1}},{\"a.c.e\":\"MapR\"}]}";
        MutationParser mutationParser = new MutationParser();
        MutationImpl jsonMutation = (MutationImpl)mutationParser.parseMutation(appendMutation);
        Assert.assertTrue((boolean)jsonMutation.needsReadOnServer());
        ByteBuffer b = jsonMutation.rowcolSerialize();
        Document rec = RowcolCodec.decode((ByteBuffer)b, null, (boolean)true, (boolean)false, (boolean)true);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)((KeyValue)rec)), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)((KeyValue)rec)), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)((KeyValue)rec)), (Object)false);
        KeyValue kv = (KeyValue)rec.getValue("a.b");
        Assert.assertEquals((Object)InsertContext.OpType.APPEND, (Object)kv.getOpType());
        Assert.assertTrue((boolean)TimeDescriptor.isCreateTimeValid((KeyValue)kv));
        Assert.assertTrue((boolean)TimeDescriptor.isUpdateTimeValid((KeyValue)kv));
        Assert.assertFalse((boolean)TimeDescriptor.isDeleteTimeValid((KeyValue)kv));
        kv = (KeyValue)rec.getValue("a.c.e");
        Assert.assertEquals((Object)InsertContext.OpType.APPEND, (Object)kv.getOpType());
        Assert.assertEquals((Object)"MapR", (Object)kv.getString());
        Assert.assertTrue((boolean)TimeDescriptor.isCreateTimeValid((KeyValue)kv));
        Assert.assertTrue((boolean)TimeDescriptor.isUpdateTimeValid((KeyValue)kv));
        Assert.assertFalse((boolean)TimeDescriptor.isDeleteTimeValid((KeyValue)kv));
    }

    @Test
    public void testDelete() {
        String deleteMutation = "{\"$delete\":[\"a.b\",\"a.x\"]}";
        MutationParser mutationParser = new MutationParser();
        MutationImpl jsonMutation = (MutationImpl)mutationParser.parseMutation(deleteMutation);
        Assert.assertEquals((Object)false, (Object)jsonMutation.needsReadOnServer());
        ByteBuffer b = jsonMutation.rowcolSerialize();
        Document rec = RowcolCodec.decode((ByteBuffer)b, null, (boolean)true, (boolean)false, (boolean)true);
        Assert.assertFalse((boolean)TimeDescriptor.isCreateTimeValid((KeyValue)((KeyValue)rec)));
        Assert.assertTrue((boolean)TimeDescriptor.isUpdateTimeValid((KeyValue)((KeyValue)rec)));
        Assert.assertFalse((boolean)TimeDescriptor.isDeleteTimeValid((KeyValue)((KeyValue)rec)));
        KeyValue kv = (KeyValue)rec.getValue("a.b");
        Assert.assertEquals((Object)InsertContext.OpType.DELETE, (Object)kv.getOpType());
        Assert.assertFalse((boolean)TimeDescriptor.isCreateTimeValid((KeyValue)kv));
        Assert.assertTrue((boolean)TimeDescriptor.isUpdateTimeValid((KeyValue)kv));
        Assert.assertTrue((boolean)TimeDescriptor.isDeleteTimeValid((KeyValue)kv));
        kv = (KeyValue)rec.getValue("a.x");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.DELETE);
        Assert.assertFalse((boolean)TimeDescriptor.isCreateTimeValid((KeyValue)kv));
        Assert.assertTrue((boolean)TimeDescriptor.isUpdateTimeValid((KeyValue)kv));
        Assert.assertTrue((boolean)TimeDescriptor.isDeleteTimeValid((KeyValue)kv));
    }

    @Test
    public void testMixedWithCommand() {
        String mixedMutation = "{\"$set\":{\"a.x\":\"xyz\"},\"$delete\":\"k.m\",\"$decrement\":\"a.b.c\",\"$merge\":{\"p.q\":{\"r\":{\"$dateDay\":\"2000-02-02\"}}}}";
        MutationParser mutationParser = new MutationParser();
        MutationImpl jsonMutation = (MutationImpl)mutationParser.parseMutation(mixedMutation);
        Assert.assertEquals((Object)true, (Object)jsonMutation.needsReadOnServer());
        ByteBuffer b = jsonMutation.rowcolSerialize();
        Document rec = RowcolCodec.decode((ByteBuffer)b, null, (boolean)true, (boolean)false, (boolean)true);
        Assert.assertTrue((boolean)TimeDescriptor.isCreateTimeValid((KeyValue)((KeyValue)rec)));
        Assert.assertTrue((boolean)TimeDescriptor.isUpdateTimeValid((KeyValue)((KeyValue)rec)));
        Assert.assertFalse((boolean)TimeDescriptor.isDeleteTimeValid((KeyValue)((KeyValue)rec)));
        KeyValue kv = (KeyValue)rec.getValue("a.x");
        Assert.assertEquals((Object)InsertContext.OpType.SET, (Object)kv.getOpType());
        Assert.assertEquals((Object)"xyz", (Object)kv.getString());
        Assert.assertTrue((boolean)TimeDescriptor.isCreateTimeValid((KeyValue)kv));
        Assert.assertTrue((boolean)TimeDescriptor.isUpdateTimeValid((KeyValue)kv));
        Assert.assertTrue((boolean)TimeDescriptor.isDeleteTimeValid((KeyValue)kv));
        kv = (KeyValue)rec.getValue("k.m");
        Assert.assertEquals((Object)InsertContext.OpType.DELETE, (Object)kv.getOpType());
        Assert.assertFalse((boolean)TimeDescriptor.isCreateTimeValid((KeyValue)kv));
        Assert.assertTrue((boolean)TimeDescriptor.isUpdateTimeValid((KeyValue)kv));
        Assert.assertTrue((boolean)TimeDescriptor.isDeleteTimeValid((KeyValue)kv));
        kv = (KeyValue)rec.getValue("a.b.c");
        Assert.assertEquals((Object)InsertContext.OpType.INCREMENT, (Object)kv.getOpType());
        Assert.assertEquals((long)-1L, (long)kv.getInt());
        Assert.assertTrue((boolean)TimeDescriptor.isCreateTimeValid((KeyValue)kv));
        Assert.assertTrue((boolean)TimeDescriptor.isUpdateTimeValid((KeyValue)kv));
        Assert.assertFalse((boolean)TimeDescriptor.isDeleteTimeValid((KeyValue)kv));
        kv = (KeyValue)rec.getValue("p.q");
        Assert.assertEquals((Object)InsertContext.OpType.MERGE, (Object)kv.getOpType());
        Assert.assertTrue((boolean)TimeDescriptor.isCreateTimeValid((KeyValue)kv));
        Assert.assertTrue((boolean)TimeDescriptor.isUpdateTimeValid((KeyValue)kv));
        Assert.assertFalse((boolean)TimeDescriptor.isDeleteTimeValid((KeyValue)kv));
    }

    @Test
    public void testBug25461DTValidation() throws Exception {
        String mergeJson = "{\"a\":{\"b\":{\"c\":10}}}";
        MutationImpl m = (MutationImpl)new MutationParser().parseMutation(mergeJson);
        Assert.assertEquals((Object)true, (Object)m.needsReadOnServer());
        ByteBuffer b = m.rowcolSerialize();
        Document mRec = RowcolCodec.decode((ByteBuffer)b, null, (boolean)true, (boolean)false, (boolean)true);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)((KeyValue)mRec)), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)((KeyValue)mRec)), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)((KeyValue)mRec)), (Object)false);
        KeyValue kv = (KeyValue)mRec.getValue("a");
        Assert.assertTrue((boolean)TimeDescriptor.isCreateTimeValid((KeyValue)kv));
        Assert.assertTrue((boolean)TimeDescriptor.isUpdateTimeValid((KeyValue)kv));
        Assert.assertFalse((boolean)TimeDescriptor.isDeleteTimeValid((KeyValue)kv));
        kv = (KeyValue)mRec.getValue("a.b");
        Assert.assertTrue((boolean)TimeDescriptor.isCreateTimeValid((KeyValue)kv));
        Assert.assertTrue((boolean)TimeDescriptor.isUpdateTimeValid((KeyValue)kv));
        Assert.assertFalse((boolean)TimeDescriptor.isDeleteTimeValid((KeyValue)kv));
        kv = (KeyValue)mRec.getValue("a.b.c");
        Assert.assertTrue((boolean)TimeDescriptor.isCreateTimeValid((KeyValue)kv));
        Assert.assertTrue((boolean)TimeDescriptor.isUpdateTimeValid((KeyValue)kv));
        Assert.assertFalse((boolean)TimeDescriptor.isDeleteTimeValid((KeyValue)kv));
    }

    @Test
    public void testMergeJsonMutation() {
        String mergeJson = "{\"a\":{\"b\":true},\"k\":\"SanJose\"}";
        MutationParser mutationParser = new MutationParser();
        MutationImpl jsonMutation = (MutationImpl)mutationParser.parseMutation(mergeJson);
        Assert.assertEquals((Object)true, (Object)jsonMutation.needsReadOnServer());
        ByteBuffer b = jsonMutation.rowcolSerialize();
        Document rec = RowcolCodec.decode((ByteBuffer)b, null, (boolean)true, (boolean)false, (boolean)true);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)((KeyValue)rec)), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)((KeyValue)rec)), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)((KeyValue)rec)), (Object)false);
        KeyValue kv = (KeyValue)rec.getValue("a");
        Assert.assertEquals((Object)InsertContext.OpType.MERGE, (Object)kv.getOpType());
        Assert.assertTrue((boolean)TimeDescriptor.isCreateTimeValid((KeyValue)kv));
        Assert.assertTrue((boolean)TimeDescriptor.isUpdateTimeValid((KeyValue)kv));
        Assert.assertFalse((boolean)TimeDescriptor.isDeleteTimeValid((KeyValue)kv));
        kv = (KeyValue)rec.getValue("k");
        Assert.assertEquals((Object)InsertContext.OpType.SET_OR_REPLACE, (Object)kv.getOpType());
        Assert.assertTrue((boolean)TimeDescriptor.isCreateTimeValid((KeyValue)kv));
        Assert.assertTrue((boolean)TimeDescriptor.isUpdateTimeValid((KeyValue)kv));
        Assert.assertTrue((boolean)TimeDescriptor.isDeleteTimeValid((KeyValue)kv));
    }
}

