/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.tests.utils;

import com.mapr.db.Table;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.tests.utils.DBTests;
import com.mapr.db.util.ConditionParser;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.ClusterTest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;
import org.ojai.store.QueryCondition;
import org.ojai.types.ODate;

@Category(value={ClusterTest.class})
public class TestConditionParser
extends BaseTest {
    private static final String tableName = "conditionTab";
    static Table table;

    @BeforeClass
    public static void setup() throws Exception {
        table = DBTests.createOrReplaceTable(tableName);
    }

    @AfterClass
    public static void cleanUp() {
        table.close();
    }

    @Test
    public void testIdOnlyCondition() {
        Document d = MapRDBImpl.newDocument().set("a.b", 350).set("s", "Holger Way");
        table.insertOrReplace("k1", d);
        d.set("zip", "95134");
        table.insertOrReplace("k2", d);
        table.flush();
        String idOnlyCondition = "{\"$eq\":{\"_id\":\"k2\"}}";
        ConditionParser cParser = new ConditionParser();
        QueryCondition condition = cParser.parseCondition(idOnlyCondition);
        Iterator iter = table.find(condition).iterator();
        int count = 0;
        while (iter.hasNext()) {
            ++count;
            Document doc = (Document)iter.next();
            Assert.assertEquals((Object)"95134", (Object)doc.getString("zip"));
        }
        Assert.assertEquals((long)1L, (long)count);
        table.delete("k1");
        table.delete("k2");
    }

    @Test
    public void testSimpleConditionString() throws Exception {
        Document doc = MapRDBImpl.newDocument().set("a.b[0].boolean", false).set("a.b[1].decimal", 123.456).set("a.c.d", 5.0).set("a.c.e", "Hello").set("m", "MapR wins");
        table.insertOrReplace("k1", doc);
        doc.set("a.c.d", 11.0);
        table.insertOrReplace("k2", doc);
        doc.set("a.c.d", 8.0);
        table.insertOrReplace("k3", doc);
        doc.set("a.c.d", 14.0);
        table.insertOrReplace("k4", doc);
        table.flush();
        String simpleConditionWithComparisonOperator = "{\"$gt\":{\"a.c.d\":10}}";
        ConditionParser condition = new ConditionParser();
        QueryCondition c = condition.parseCondition(simpleConditionWithComparisonOperator);
        Iterator iter = table.find(c).iterator();
        int count = 0;
        while (iter.hasNext()) {
            ++count;
            Document rd = (Document)iter.next();
            Assert.assertTrue((rd.getDouble("a.c.d") > 10.0 ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)2L, (long)count);
        table.delete("k1");
        table.delete("k2");
        table.delete("k3");
        table.delete("k4");
    }

    @Test
    public void testSimpleNotExistsCondition() throws Exception {
        Document doc = MapRDBImpl.newDocument().set("a.b[0].boolean", false).set("a.b[1].decimal", 123.456).set("a.c.d", 5.0).set("m", "MapR wins");
        table.insertOrReplace("k1", doc);
        doc.set("a.c.e", "SanJose");
        table.insertOrReplace("k2", doc);
        doc.set("a.c.e", "Milpitas");
        table.insertOrReplace("k3", doc);
        table.insertOrReplace("k4", doc);
        table.flush();
        String simpleNotExistsCondition = "{\"$notexists\":\"a.c.e\"}";
        ConditionParser condition = new ConditionParser();
        QueryCondition c = condition.parseCondition(simpleNotExistsCondition);
        Iterator iter = table.find(c).iterator();
        int count = 0;
        while (iter.hasNext()) {
            ++count;
            Document d = (Document)iter.next();
            Assert.assertEquals((Object)"k1", (Object)d.getId().getString());
        }
        Assert.assertEquals((long)1L, (long)count);
        table.delete("k1");
        table.delete("k2");
        table.delete("k3");
        table.delete("k4");
    }

    @Test
    public void testInCondition() throws Exception {
        Document doc = MapRDBImpl.newDocument().set("a.boolean", false).set("a.c.d", ODate.parse((String)"2010-01-11")).set("m", "MapR wins");
        table.insertOrReplace("k1", doc);
        doc.set("a.c.d", ODate.parse((String)"2011-05-21"));
        table.insertOrReplace("k2", doc);
        doc.set("a.c.d", ODate.parse((String)"2005-06-21"));
        table.insertOrReplace("k3", doc);
        table.flush();
        String inCondition = "{\"$in\":{\"a.c.d\":[{\"$dateDay\":\"2011-05-21\"},{\"$dateDay\":\"2013-02-22\"}]}}";
        ConditionParser condition = new ConditionParser();
        QueryCondition cond = condition.parseCondition(inCondition);
        Iterator iter = table.find(cond).iterator();
        int count = 0;
        while (iter.hasNext()) {
            ++count;
            Document r = (Document)iter.next();
            Assert.assertEquals((Object)"k2", (Object)r.getId().getString());
        }
        Assert.assertEquals((long)1L, (long)count);
        table.delete("k1");
        table.delete("k2");
        table.delete("k3");
    }

    @Test
    public void testTypeOfCondition() throws Exception {
        Document doc = MapRDBImpl.newDocument().set("a.b[0].boolean", false).set("a.b[1].decimal", 123.456).set("a.c.d", 5).set("m", "MapR wins");
        table.insertOrReplace("k1", doc);
        doc.set("a.c.d", "SanJose");
        table.insertOrReplace("k2", doc);
        doc.set("a.c.d", "Milpitas");
        table.insertOrReplace("k3", doc);
        table.flush();
        String simpleTypeOfCondition = "{\"$typeof\":{\"a.c.d\":\"INT\"}}";
        ConditionParser condition = new ConditionParser();
        QueryCondition c = condition.parseCondition(simpleTypeOfCondition);
        Iterator iter = table.find(c).iterator();
        int count = 0;
        while (iter.hasNext()) {
            ++count;
            Document r = (Document)iter.next();
            Assert.assertEquals((Object)"k1", (Object)r.getId().getString());
        }
        Assert.assertEquals((long)1L, (long)count);
        table.delete("k1");
        table.delete("k2");
        table.delete("k3");
    }

    @Test
    public void testInConditionWithAnd() throws Exception {
        Document doc = MapRDBImpl.newDocument().set("a.b[0].boolean", false).set("a.b[1].decimal", 123.456).set("a.c.d", 5).set("a.c.e", "aaa").set("m", "MapR wins");
        table.insertOrReplace("k1", doc);
        table.insertOrReplace("k3", doc);
        doc.set("a.c.e", "xyz");
        table.insertOrReplace("k2", doc);
        table.flush();
        String inConditionWithMapAndArray = "{\"$and\":[{\"$in\":{\"a.c.d\":[5,10]}},{\"$notin\":{\"a.c.e\":[\"aaa\",\"bbb\"]}}]}";
        ConditionParser condition = new ConditionParser();
        QueryCondition cond = condition.parseCondition(inConditionWithMapAndArray);
        Iterator iter = table.find(cond).iterator();
        int count = 0;
        while (iter.hasNext()) {
            ++count;
            Document r = (Document)iter.next();
            Assert.assertEquals((Object)"k2", (Object)r.getId().getString());
        }
        Assert.assertEquals((long)1L, (long)count);
        table.delete("k1");
        table.delete("k2");
        table.delete("k3");
    }

    @Test
    public void testCompositeConditionWithAnd() throws Exception {
        Document doc = MapRDBImpl.newDocument().set("a.b[0].boolean", false).set("a.b[1].decimal", 123.456).set("a.c.d", 5.0).set("m", "MapR wins");
        table.insertOrReplace("k1", doc);
        doc.set("a.c.d", 10.0);
        doc.set("a.c.e", "xyz");
        table.insertOrReplace("k2", doc);
        doc.set("a.c.d", 8.0);
        table.insertOrReplace("k3", doc);
        table.flush();
        String compositeConditionWithAnd = "{\"$and\":[{\"$lt\":{\"a.c.d\":10}},{\"$exists\":\"a.c.e\"}]}";
        ConditionParser condition = new ConditionParser();
        QueryCondition c = condition.parseCondition(compositeConditionWithAnd);
        Iterator iter = table.find(c).iterator();
        int count = 0;
        while (iter.hasNext()) {
            ++count;
            Document r = (Document)iter.next();
            Assert.assertEquals((Object)"k3", (Object)r.getId().getString());
        }
        Assert.assertEquals((long)1L, (long)count);
        table.delete("k1");
        table.delete("k2");
        table.delete("k3");
    }

    @Test
    public void testCompositeRecursiveCondition() throws Exception {
        Document doc = MapRDBImpl.newDocument().set("a.b", 5.1).set("a.c.e", "mapR").set("m", "MapR wins").set("a.k", 25.1);
        table.insertOrReplace("k1", doc);
        doc.set("a.k", 10.11);
        table.insertOrReplace("k2", doc);
        table.flush();
        String compositeRecursiveCondition = "{\"$and\":[{\"$exists\":\"a.c.e\"},{\"$and\":[{\"$ge\":{\"a.b\":5}},{\"$lt\":{\"a.k\":20}}]}]}";
        ConditionParser condition = new ConditionParser();
        QueryCondition c = condition.parseCondition(compositeRecursiveCondition);
        Iterator iter = table.find(c).iterator();
        int count = 0;
        while (iter.hasNext()) {
            ++count;
            Document r = (Document)iter.next();
            Assert.assertEquals((Object)"k2", (Object)r.getId().getString());
        }
        Assert.assertEquals((long)1L, (long)count);
        table.delete("k1");
        table.delete("k2");
    }

    @Test
    public void testOrConditionWithTags() throws Exception {
        Document doc = MapRDBImpl.newDocument().set("a.b", 5.1).set("a.c.d", "mapR").set("m", "MapR wins").set("a.k", 25.1);
        table.insertOrReplace("k1", doc);
        doc.set("a.c.d", 101);
        table.insertOrReplace("k2", doc);
        doc.set("a.c.d", 100);
        table.insertOrReplace("k3", doc);
        doc.set("a.c.d", 99);
        table.insertOrReplace("k4", doc);
        table.flush();
        String orConditionWithTags = "{\"$or\":[{\"$gt\":{\"a.c.d\":{\"$numberLong\":100}}},{\"$typeof\":{\"a.c.d\":\"STRING\"}}]}";
        ConditionParser condition = new ConditionParser();
        QueryCondition cond = condition.parseCondition(orConditionWithTags);
        Iterator iter = table.find(cond).iterator();
        int count = 0;
        while (iter.hasNext()) {
            ++count;
            Document document = (Document)iter.next();
        }
        Assert.assertEquals((long)2L, (long)count);
        table.delete("k1");
        table.delete("k2");
        table.delete("k3");
        table.delete("k4");
    }

    @Test
    public void testCompositeConditionWithAndOnly() throws Exception {
        Document doc = MapRDBImpl.newDocument().set("a.c.d", 22).set("m", "MapR wins").set("p.q", ODate.parse((String)"2016-04-05"));
        table.insertOrReplace("id1", doc);
        doc.set("a.b", "xyz");
        table.insertOrReplace("id2", doc);
        table.flush();
        String compositeConditionWithAndOnly = "{\"$and\":[{\"$and\":[{\"$notexists\":\"a.b\"},{\"$typeof\":{\"p.q\":\"DATE\"}}]},{\"$gt\":{\"a.c.d\":{\"$numberLong\":20}}}]}";
        ConditionParser c = new ConditionParser();
        QueryCondition qCond = c.parseCondition(compositeConditionWithAndOnly);
        Iterator iter = table.find(qCond).iterator();
        int count = 0;
        while (iter.hasNext()) {
            ++count;
            Assert.assertEquals((Object)"id1", (Object)((Document)iter.next()).getId().getString());
        }
        Assert.assertEquals((long)1L, (long)count);
        table.delete("id1");
        table.delete("id2");
    }

    @Test
    public void testConditionWithBetweenOp() throws Exception {
        Document doc = MapRDBImpl.newDocument().set("a.b[0].boolean", false).set("a.c.d", ODate.parse((String)"2015-01-16")).set("a.c.e", "Hello").set("m", "MapR");
        table.insertOrReplace("id1", doc);
        doc.set("a.c.d", ODate.parse((String)"2015-01-14"));
        table.insertOrReplace("id2", doc);
        doc.set("a.c.d", ODate.parse((String)"2015-06-14"));
        table.insertOrReplace("id3", doc);
        doc.set("a.c.d", ODate.parse((String)"2015-02-26"));
        table.insertOrReplace("id4", doc);
        table.flush();
        String conditionWithBetweenOp = "{\"$between\":{\"a.c.d\":[{\"$dateDay\":\"2015-01-15\"},{\"$dateDay\":\"2015-05-15\"}]}}";
        ConditionParser c = new ConditionParser();
        QueryCondition cond = c.parseCondition(conditionWithBetweenOp);
        Iterator iter = table.find(cond).iterator();
        int count = 0;
        Assert.assertTrue((boolean)iter.hasNext());
        Document r = (Document)iter.next();
        ++count;
        Assert.assertEquals((Object)"id1", (Object)r.getString("_id"));
        Assert.assertTrue((boolean)iter.hasNext());
        r = (Document)iter.next();
        Assert.assertEquals((Object)"id4", (Object)r.getString("_id"));
        Assert.assertFalse((boolean)iter.hasNext());
        Assert.assertEquals((long)2L, (long)(++count));
        table.delete("id1");
        table.delete("id2");
        table.delete("id3");
        table.delete("id4");
    }

    @Test
    public void testEqWithList() throws Exception {
        Document d = MapRDBImpl.newDocument().set("a.b", 111.222).set("a.x", true);
        table.insertOrReplace("id1", d);
        Document d2 = d.set("a.b[0]", 12345).set("a.b[1]", "xyz");
        table.insertOrReplace("id2", d2);
        table.flush();
        String eqConditionWithList = "{\"$eq\":{\"a.b\":[{\"$numberLong\":12345},\"xyz\"]}}";
        ConditionParser c = new ConditionParser();
        QueryCondition cond = c.parseCondition(eqConditionWithList);
        Iterator iter = table.find(cond).iterator();
        Assert.assertTrue((boolean)iter.hasNext());
        Document r = (Document)iter.next();
        Assert.assertEquals((Object)"id2", (Object)r.getString("_id"));
        Assert.assertEquals((long)12345L, (long)r.getLong("a.b[0]"));
        Assert.assertEquals((Object)"xyz", (Object)r.getString("a.b[1]"));
        Assert.assertFalse((boolean)iter.hasNext());
        table.delete("id1");
        table.delete("id2");
    }

    @Test
    public void testEqWithMap() throws Exception {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("k", "kite");
        m.put("m", "map");
        Document doc = MapRDBImpl.newDocument().set("a", m).set("b.c.d", ODate.parse((String)"2013-03-22"));
        table.insertOrReplace("id1", doc);
        Document d2 = doc.set("a.m", "not map").setArray("x.y", new int[]{4, 44});
        table.insertOrReplace("id2", d2);
        table.flush();
        String eqWithMap = "{\"$eq\":{\"a\":{\"k\":\"kite\",\"m\":\"map\"}}}";
        ConditionParser c = new ConditionParser();
        QueryCondition cond = c.parseCondition(eqWithMap);
        Iterator iter = table.find(cond).iterator();
        Assert.assertTrue((boolean)iter.hasNext());
        Document r = (Document)iter.next();
        Assert.assertEquals((Object)"id1", (Object)r.getString("_id"));
        Assert.assertFalse((boolean)iter.hasNext());
        table.delete("id1");
        table.delete("id2");
    }

    @Test
    public void testFindSizeofLong() throws Exception {
        Document doc = MapRDBImpl.newDocument().set("a", 22).set("k", "abracadabra").set("b.c", "mapr");
        Document doc2 = MapRDBImpl.newDocument().set("k", "xyz").set("b.c", "abracadabra");
        table.insertOrReplace("id11", doc);
        table.insertOrReplace("id2", doc2);
        table.flush();
        String sizeofWithLong = "{\"$sizeof\":{\"b.c\":{\"$gt\":{\"$numberLong\":4}}}}";
        ConditionParser c = new ConditionParser();
        QueryCondition cond = c.parseCondition(sizeofWithLong);
        Iterator iter = table.find(cond).iterator();
        int count = 0;
        Document r = null;
        while (iter.hasNext()) {
            r = (Document)iter.next();
            ++count;
        }
        Assert.assertEquals((long)1L, (long)count);
        Assert.assertEquals((Object)"id2", (Object)r.getId().getString());
        Assert.assertEquals((Object)"xyz", (Object)r.getString("k"));
        Assert.assertEquals((Object)"abracadabra", (Object)r.getString("b.c"));
        table.delete("id11");
        table.delete("id2");
    }

    @Test
    public void testFindSizeOfDouble() throws Exception {
        Document doc = MapRDBImpl.newDocument().set("a", 22).set("k", "abracadabra").set("b.c", "mapr");
        Document doc2 = MapRDBImpl.newDocument().set("k", "xyz").set("b.c", "abracadabra");
        table.insertOrReplace("id11", doc);
        table.insertOrReplace("id2", doc2);
        table.flush();
        String sizeofCmd = "{\"$sizeof\":{\"b.c\":{\"$eq\":4}}}";
        ConditionParser c = new ConditionParser();
        QueryCondition cond = c.parseCondition(sizeofCmd);
        Iterator iter = table.find(cond).iterator();
        int count = 0;
        Document r = null;
        while (iter.hasNext()) {
            r = (Document)iter.next();
            ++count;
        }
        Assert.assertEquals((long)1L, (long)count);
        Assert.assertEquals((Object)"id11", (Object)r.getId().getString());
        Assert.assertEquals((double)22.0, (double)r.getDouble("a"), (double)0.0);
        Assert.assertEquals((Object)"mapr", (Object)r.getString("b.c"));
        table.delete("id11");
        table.delete("id2");
    }

    @Test
    public void testPrefixNotationWithGreaterThan() throws Exception {
        Document doc = MapRDBImpl.newDocument().set("a", 23).set("b", "xyz");
        table.insertOrReplace("id1", doc);
        doc.set("a", 33);
        table.insertOrReplace("id2", doc);
        table.flush();
        String isPrefix = "{\"$gt\":{\"a\":25}}";
        ConditionParser c = new ConditionParser();
        QueryCondition cond = c.parseCondition(isPrefix);
        Iterator iter = table.find(cond).iterator();
        Assert.assertTrue((boolean)iter.hasNext());
        Document r = (Document)iter.next();
        Assert.assertEquals((Object)"id2", (Object)r.getId().getString());
        Assert.assertEquals((double)33.0, (double)r.getDouble("a"), (double)0.0);
        Assert.assertFalse((boolean)iter.hasNext());
        table.delete("id1");
        table.delete("id2");
    }

    @Test
    public void testNeOpWithString() throws Exception {
        Document doc = MapRDBImpl.newDocument().set("a", "mapr").set("b", 100);
        table.insertOrReplace("id1", doc);
        doc.set("a", "sanjose").set("b", 200);
        table.insertOrReplace("id2", doc);
        table.flush();
        String cmd = "{\"$ne\":{\"a\":\"mapr\"}}";
        QueryCondition c = new ConditionParser().parseCondition(cmd);
        Iterator it = table.find(c).iterator();
        Assert.assertTrue((boolean)it.hasNext());
        Document r = (Document)it.next();
        Assert.assertEquals((Object)"id2", (Object)r.getId().getString());
        Assert.assertEquals((Object)"sanjose", (Object)r.getString("a"));
        Assert.assertFalse((boolean)it.hasNext());
        table.delete("id1");
        table.delete("id2");
    }

    @Test
    public void testConditionWithArray() throws Exception {
        ArrayList<Object> l1 = new ArrayList<Object>();
        ArrayList<Integer> l2 = new ArrayList<Integer>();
        l2.add(4);
        l2.add(5);
        l2.add(6);
        l1.add(1);
        l1.add(true);
        l1.add("mapr");
        l1.add(l2);
        Document doc = MapRDBImpl.newDocument().set("a", l1).set("b.c", "SanJose");
        table.insertOrReplace("id1", doc);
        table.flush();
        String cmd = "{\"$eq\":{\"a\":[1,true,\"mapr\",[4,5,6]]}}";
        ConditionParser conditionParser = new ConditionParser();
        QueryCondition c = conditionParser.parseCondition(cmd);
        Iterator iter = table.find(c).iterator();
        Assert.assertTrue((boolean)iter.hasNext());
        Document returnedDoc = (Document)iter.next();
        Assert.assertTrue((boolean)returnedDoc.getBoolean("a[1]"));
        Assert.assertEquals((double)6.0, (double)returnedDoc.getDouble("a[3][2]"), (double)0.0);
        Assert.assertFalse((boolean)iter.hasNext());
        table.delete("id1");
    }

    @Test
    public void testConditionParserWithMapWithinArray() throws Exception {
        Document doc = MapRDBImpl.newDocument().set("a", 25).set("b[0]", "b0").set("b[1].c", "b1c").set("b[1].d", "b1d").set("b[2]", false);
        table.insertOrReplace("id1", doc);
        table.flush();
        String cmd = "{\"$eq\":{\"b\":[\"b0\",{\"c\":\"b1c\",\"d\":\"b1d\"},false]}}";
        ConditionParser cp = new ConditionParser();
        QueryCondition c = cp.parseCondition(cmd);
        Iterator iter = table.find(c).iterator();
        Assert.assertTrue((boolean)iter.hasNext());
        Document returnedDoc = (Document)iter.next();
        Assert.assertEquals((Object)"b1c", (Object)returnedDoc.getString("b[1].c"));
        Assert.assertFalse((boolean)returnedDoc.getBoolean("b[2]"));
        Assert.assertFalse((boolean)iter.hasNext());
    }
}

