/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.impl.index;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.index.IndexFieldDesc;
import com.mapr.fs.proto.Dbserver;
import com.mapr.utils.JsonUtils;
import org.ojai.FieldPath;
import org.ojai.json.JsonOptions;

public class IndexFieldDescImpl
implements IndexFieldDesc {
    private final IndexFieldDesc.Order sortOrder;
    private final String fieldPathStr;
    private final boolean onMTime;
    private final boolean functional;
    private final String functionName;
    private int fieldPathIdx;
    @JsonIgnore
    private transient FieldPath fieldPath;

    public IndexFieldDescImpl(FieldPath fp, int fpIdx, Dbserver.SIndexInfo.SIndexOrder orderProto, boolean isFunctional, boolean isOnMTime) {
        this(IndexFieldDescImpl.asPathString(fp), fpIdx, IndexFieldDescImpl.toSortOder(orderProto), isFunctional, isOnMTime, null);
        this.fieldPath = fp;
    }

    public IndexFieldDescImpl(String fieldPathStr, int fpIdx, IndexFieldDesc.Order sortOrder, boolean isFunctional, boolean isOnMTime, String indexFunction) {
        this.fieldPathStr = fieldPathStr;
        this.fieldPathIdx = fpIdx;
        this.sortOrder = sortOrder;
        this.functional = isFunctional;
        this.onMTime = isOnMTime;
        this.functionName = indexFunction;
    }

    public String getFieldPathStr() {
        return this.fieldPathStr;
    }

    public int getFieldPathIdx() {
        return this.fieldPathIdx;
    }

    @Override
    public FieldPath getFieldPath() {
        if (this.fieldPath == null && this.fieldPathStr != null) {
            this.fieldPath = FieldPath.parseFrom((String)this.fieldPathStr);
        }
        return this.fieldPath;
    }

    @Override
    public IndexFieldDesc.Order getSortOrder() {
        return this.sortOrder;
    }

    @Override
    public boolean isFunctional() {
        return this.functional;
    }

    @Override
    public boolean isOnMTime() {
        return this.onMTime;
    }

    public String toString() {
        return "{\"fieldPath\":" + JsonUtils.toJsonValue((String)this.fieldPathStr) + ", \"sortOrder\":" + JsonUtils.toJsonValue((String)this.sortOrder.toString()) + ", \"isFunctional\":" + this.functional + "}";
    }

    @Override
    public String getFunctionName() {
        return this.functionName;
    }

    private static IndexFieldDesc.Order toSortOder(Dbserver.SIndexInfo.SIndexOrder siSortOrder) {
        switch (siSortOrder) {
            case ASC: {
                return IndexFieldDesc.Order.Asc;
            }
            case DESC: {
                return IndexFieldDesc.Order.Desc;
            }
        }
        throw new IllegalArgumentException("Unsupported sort order: " + siSortOrder);
    }

    private static String asPathString(FieldPath fp) {
        return fp == null ? null : fp.asPathString();
    }

    public String asJsonString() {
        return MapRDBImpl.newDocument(this).asJsonString();
    }

    public String asJsonString(JsonOptions options) {
        return MapRDBImpl.newDocument(this).asJsonString(options);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IndexFieldDescImpl other = (IndexFieldDescImpl)obj;
        if (this.fieldPathStr == null ? other.fieldPathStr != null : !this.fieldPathStr.equals(other.fieldPathStr)) {
            return false;
        }
        if (this.functionName == null ? other.functionName != null : !this.functionName.equals(other.functionName)) {
            return false;
        }
        if (this.functional != other.functional) {
            return false;
        }
        if (this.onMTime != other.onMTime) {
            return false;
        }
        return this.sortOrder == other.sortOrder;
    }

    public IndexFieldDescImpl() {
        this(null, 0, null, true, true, null);
    }
}

