/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.impl;

import com.mapr.db.MetaTable;
import com.mapr.db.TabletInfo;
import com.mapr.db.exceptions.DBException;
import com.mapr.db.exceptions.TableNotFoundException;
import com.mapr.db.impl.BaseJsonTable;
import com.mapr.db.impl.ConditionImpl;
import com.mapr.db.impl.ConditionNode;
import com.mapr.db.impl.HashedIndexMetaTableImpl;
import com.mapr.db.impl.MapRDBIndexImpl;
import com.mapr.db.impl.TabletInfoImpl;
import com.mapr.db.index.IndexDesc;
import com.mapr.fs.proto.Dbserver;
import com.mapr.org.apache.hadoop.hbase.util.Bytes;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.ojai.annotation.API;
import org.ojai.store.QueryCondition;

@API.Internal
public class MapRDBHashedIndexImpl
extends MapRDBIndexImpl {
    private List<MetaTable> openHashIndexMetaTables = null;
    private int numPartitions = 0;

    public MapRDBHashedIndexImpl(Configuration config, Path primaryTablePath, String secondaryIndexFid, String secondaryIndexName) throws DBException, TableNotFoundException {
        super(config, primaryTablePath, secondaryIndexFid, secondaryIndexName);
        this.openHashIndexMetaTables = new LinkedList<MetaTable>();
    }

    public MapRDBHashedIndexImpl(Configuration config, IndexDesc indexDesc) throws DBException, TableNotFoundException {
        super(config, indexDesc);
        this.numPartitions = indexDesc.getNumHashPartitions();
        this.openHashIndexMetaTables = new LinkedList<MetaTable>();
    }

    @Override
    public BaseJsonTable.TableType getTableType() {
        return BaseJsonTable.TableType.TABLE_INDEX_HASHED;
    }

    @Override
    public MetaTable getMetaTable() throws DBException {
        HashedIndexMetaTableImpl meta = new HashedIndexMetaTableImpl(this);
        this.openHashIndexMetaTables.add(meta);
        return meta;
    }

    public void closeMetaTable(HashedIndexMetaTableImpl metaTableImpl) {
        this.openHashIndexMetaTables.remove(metaTableImpl);
    }

    @Override
    public TabletInfo[] getTabletInfos(QueryCondition qc) {
        throw new UnsupportedOperationException("Requested operation is not supported on Hashed Index Table");
    }

    @Override
    protected ConditionImpl getRangeCondition(byte[] startKey, byte[] stopKey) {
        ConditionImpl c = new ConditionImpl();
        return this.getRangeConditionCommon(c, startKey, stopKey);
    }

    @Override
    protected TabletInfo toTabletInfo(Dbserver.TabletDesc tablet, ConditionNode.RowkeyRange rr) throws IOException {
        byte[] end;
        byte[] start;
        int cid = tablet.getFid().getCid();
        String host = this.maprTable.getServerForCid(cid);
        String[] tokens = host.split(":");
        if (tokens == null || tokens.length != 2) {
            throw new IOException("Bad host information for cid=" + cid + ", host=" + host);
        }
        long estimatedSize = -1L;
        long estimatedNumRows = -1L;
        if (tablet.hasSpaceUsage()) {
            estimatedNumRows = tablet.getSpaceUsage().getNumRows();
            estimatedSize = tablet.getSpaceUsage().getNumLogicalBlocks() * 8192L;
        }
        if (rr != null) {
            start = Bytes.maxOfStartRows((byte[])tablet.getStartKey().toByteArray(), (byte[])rr.getStartRow());
            end = Bytes.minOfStopRows((byte[])tablet.getEndKey().toByteArray(), (byte[])rr.getStopRow());
        } else {
            start = tablet.getStartKey().toByteArray();
            end = tablet.getEndKey().toByteArray();
        }
        ConditionImpl c = this.getRangeCondition(start, end);
        return new TabletInfoImpl(c, new ConditionNode.RowkeyRange(start, end), new String[]{tokens[0]}, estimatedSize, estimatedNumRows, tablet.getFid());
    }

    int getNumPartitions() {
        return this.numPartitions;
    }

    @Override
    protected ConditionImpl _cloneCondition(QueryCondition condition) {
        return ((ConditionImpl)condition).cloneUnbuilt().setPartitionKeys(this.indexedFieldList, true, this.numPartitions, this.missingAndNullFirst).build();
    }

    @Override
    protected ConditionImpl _cloneConditionOptimized(QueryCondition condition) {
        return ((ConditionImpl)condition).cloneUnbuilt().setPartitionKeys(this.indexedFieldList, true, this.numPartitions, this.missingAndNullFirst).build(true);
    }
}

