/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.tests.tableops;

import com.mapr.db.Table;
import com.mapr.db.impl.ConditionImpl;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.db.tests.utils.DBTests;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.ClusterTest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.ojai.Document;
import org.ojai.DocumentStream;
import org.ojai.store.DocumentMutation;
import org.ojai.store.QueryCondition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ClusterTest.class})
public class TestMapRDBWithClusterEmptyKeys
extends BaseTest {
    private static final Logger _logger = LoggerFactory.getLogger(TestMapRDBWithClusterEmptyKeys.class);
    private static final String TEST_NAME = "TestMapRDBWithClusterEmptyKeys";
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testSimple() throws IOException, InterruptedException {
        String tableName = "testSimple-TestMapRDBWithClusterEmptyKeys";
        Table t = DBTests.createOrReplaceTable(tableName);
        DBDocumentImpl putRec = new DBDocumentImpl();
        this.thrown.expect(IllegalArgumentException.class);
        putRec.set("a.b", 1).set("", 2);
        t.insertOrReplace("KEY", (Document)putRec);
        t.flush();
        Document d = t.findById("KEY");
        Iterator itr = t.find().iterator();
        for (Document document : t.find()) {
        }
    }

    @Test
    public void testNestedMapEmptyKeys() throws IOException, InterruptedException {
        String tableName = "testNestedEmptyKeys-TestMapRDBWithClusterEmptyKeys";
        Table t = DBTests.createOrReplaceTable(tableName);
        DBDocumentImpl putRec = new DBDocumentImpl();
        putRec.set("a.b", 1);
        this.thrown.expect(IllegalArgumentException.class);
        DBDocumentImpl put2 = new DBDocumentImpl().set("", "empty.empty");
        putRec.set("", (Document)put2);
        t.insertOrReplace("KEY", (Document)putRec);
        t.flush();
        Document d = t.findById("KEY");
        Iterator itr = t.find().iterator();
        for (Document document : t.find()) {
        }
    }

    @Test
    public void testNestedArrayEmptyKeys() throws IOException, InterruptedException {
        String tableName = "testNestedEmptyKeys-TestMapRDBWithClusterEmptyKeys";
        Table t = DBTests.createOrReplaceTable(tableName);
        DBDocumentImpl putRec = new DBDocumentImpl();
        putRec.set("a.b", 1);
        ArrayList<String> l = new ArrayList<String>();
        l.add("empty");
        this.thrown.expect(IllegalArgumentException.class);
        putRec.set("", l);
        t.insertOrReplace("KEY", (Document)putRec);
        t.flush();
        Document d = t.findById("KEY");
        Iterator itr = t.find().iterator();
        for (Document document : t.find()) {
        }
    }

    @Test
    public void testMultipleEmptyKeys() throws IOException, InterruptedException {
        String tableName = "testMultipleEmptyKeys-TestMapRDBWithClusterEmptyKeys";
        Table t = DBTests.createOrReplaceTable(tableName);
        DBDocumentImpl putRec = new DBDocumentImpl();
        putRec.set("a", 1);
        ArrayList<String> l = new ArrayList<String>();
        l.add("array-empty");
        DBDocumentImpl putList = new DBDocumentImpl();
        this.thrown.expect(IllegalArgumentException.class);
        putList.set("", l);
        putRec.set("b", (Document)putList);
        this.thrown.expect(IllegalArgumentException.class);
        DBDocumentImpl putMap = new DBDocumentImpl().set("", "map-empty");
        putRec.set("c", (Document)putMap);
        t.insertOrReplace("KEY", (Document)putRec);
        t.flush();
        Document d = t.findById("KEY");
        Iterator itr = t.find().iterator();
        for (Document document : t.find()) {
        }
    }

    @Test
    public void testLargeDocumentEmptyKeys() throws IOException, InterruptedException {
        String tableName = "testLargeDocumentEmptyKeys-TestMapRDBWithClusterEmptyKeys";
        Table t = DBTests.createOrReplaceTable(tableName);
        for (int i = 0; i < 10; ++i) {
            Document d = MapRDBImpl.newDocument().set("_id", "blank-" + i).set("a", "A").set("b.c.d.e.f", "alpha");
            this.thrown.expect(IllegalArgumentException.class);
            Document d2 = MapRDBImpl.newDocument().set("", "<empty>");
            d.set("b.c.e", d2);
            t.insertOrReplace(d);
        }
        t.flush();
        ConditionImpl c = MapRDBImpl.newCondition().is("a", QueryCondition.Op.EQUAL, "A").build();
        DocumentStream rs = t.find((QueryCondition)c, new String[]{"b.c"});
        try {
            Iterator iter = rs.iterator();
            while (iter.hasNext()) {
                iter.next();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testEmptyKeysWithMutation() throws Exception {
        String tableName = "testEmptyKeysWithMutation-TestMapRDBWithClusterEmptyKeys";
        Table t = DBTests.createOrReplaceTable(tableName);
        Document doc = MapRDBImpl.newDocument().set("a.b", 1).set("a.c", "hello");
        t.insertOrReplace("id1", doc);
        t.flush();
        DocumentMutation m = MapRDBImpl.newMutation();
        this.thrown.expect(IllegalArgumentException.class);
        m.setOrReplace("a.d", true).increment("a.b", 1).setOrReplace("", 25);
        t.update("id1", m);
        t.flush();
        for (Document document : t.find()) {
        }
    }
}

