/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.tests.tableops;

import com.mapr.db.Table;
import com.mapr.db.tests.utils.DBTests;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.ClusterTest;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.fs.Path;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;
import org.ojai.DocumentStream;
import org.ojai.json.Json;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ClusterTest.class})
public class TestMapRTabletScanner
extends BaseTest {
    private static final Logger _logger = LoggerFactory.getLogger(TestMapRTabletScanner.class);
    private static final String AAAA = "aaaaa";
    private static final String BBBB = "bbbbb";
    private static final String CCCC = "ccccc";
    private static final String DDDD = "ddddd";
    private static final String EEEE = "eeeee";
    private static final String FFFF = "fffff";
    private static final String[] SLPITS_KEYS = new String[]{"bbbbb", "ccccc", "ddddd", "eeeee", "fffff"};
    private static final String TABLE_NAME = "testtable-" + TestMapRTabletScanner.class.getSimpleName();
    private static Table table;
    private static Path tablePath;
    private static Document document;

    @BeforeClass
    public static void setup_TestMapRTabletScanner() throws IOException {
        try (InputStream testJson = TestMapRTabletScanner.class.getClassLoader().getResourceAsStream("com/mapr/db/tests/json/complex.json");
             DocumentStream stream = Json.newDocumentStream((InputStream)testJson);){
            document = (Document)stream.iterator().next();
        }
        table = DBTests.createOrReplaceTable(TABLE_NAME, SLPITS_KEYS).setOption(Table.TableOption.BUFFERWRITE, false);
        tablePath = table.getPath();
        TestMapRTabletScanner.insertRows(table, AAAA, 10L);
        TestMapRTabletScanner.insertRows(table, BBBB, 20L);
        TestMapRTabletScanner.insertRows(table, CCCC, 30L);
        TestMapRTabletScanner.insertRows(table, DDDD, 40L);
        TestMapRTabletScanner.insertRows(table, EEEE, 20L);
        TestMapRTabletScanner.insertRows(table, FFFF, 10L);
        _logger.info("Starting wait for row count.");
        long startTime = System.currentTimeMillis();
        DBTests.waitForRowCount(tablePath, 130L, 20000L);
        _logger.info("Wait for row count took {} milliseconds.", (Object)(System.currentTimeMillis() - startTime));
    }

    private static void insertRows(Table table, String prefix, long rowCount) {
        int i = 0;
        while ((long)i < rowCount) {
            table.insertOrReplace(prefix + String.format("%010d", i), document);
            ++i;
        }
    }

    @AfterClass
    public static void cleanup_TestMapRTabletScanner() throws IOException {
        if (table != null) {
            table.close();
            DBTests.deleteTables(TABLE_NAME);
        }
    }

    @Test
    public void testMapRTabletScanner() throws IOException {
        long numRows = DBTests.mapradmin().getNumRows(tablePath);
        Assert.assertEquals((long)130L, (long)numRows);
    }
}

