/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.tests.tableops;

import com.mapr.db.MapRDB;
import com.mapr.db.MetaTable;
import com.mapr.db.Table;
import com.mapr.db.TabletInfo;
import com.mapr.db.exceptions.AccessDeniedException;
import com.mapr.db.exceptions.DBException;
import com.mapr.db.impl.ConditionImpl;
import com.mapr.db.impl.Constants;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.impl.MapRDBIndexImpl;
import com.mapr.db.impl.MapRDBTableImpl;
import com.mapr.db.index.IndexDesc;
import com.mapr.db.index.IndexFieldDesc;
import com.mapr.db.scan.ScanRange;
import com.mapr.db.tests.utils.DBTests;
import com.mapr.db.util.ByteBufs;
import com.mapr.fs.FSTests;
import com.mapr.fs.jni.IndexSyncStateTracker;
import com.mapr.fs.proto.Dbserver;
import com.mapr.fs.utils.ssh.TestCluster;
import com.mapr.org.apache.hadoop.hbase.util.Bytes;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.ClusterTest;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;
import org.ojai.DocumentStream;
import org.ojai.Value;
import org.ojai.store.DocumentMutation;
import org.ojai.store.QueryCondition;
import org.ojai.types.ODate;
import org.ojai.types.OTime;
import org.ojai.types.OTimestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ClusterTest.class})
public class TestIndexTable
extends BaseTest {
    private static final Logger _logger = LoggerFactory.getLogger(TestIndexTable.class);
    private static final String TABLE_NAME = "testtable-TestIndexTable";
    private static final String INDEX_NAME = "testindex-TestIndexTable";
    private static Table table;
    private static Collection<IndexDesc> tableIndexList;

    private IndexDesc createIndex(Table tab, String indexName, String indexedFields, String nonIndexedFields, boolean isHashed, int numHashPartitions) throws Exception {
        String indexCreateCommand = "maprcli table index add  -path " + tab.getPath() + " -index " + indexName + " -indexedfields " + indexedFields + (nonIndexedFields == null ? "" : " -includedfields " + nonIndexedFields) + (isHashed ? " -hashed true -numhashpartitions " + Integer.toString(numHashPartitions) : "");
        TestCluster.runCommand((String)indexCreateCommand);
        DBTests.waitForSchemaUpdate();
        tableIndexList = DBTests.admin().getTableIndexes(table.getPath(), true);
        for (IndexDesc idx : tableIndexList) {
            if (!idx.getIndexName().equals(indexName)) continue;
            return idx;
        }
        return null;
    }

    private IndexDesc createIndex(Table tab, String indexName, String indexedFields, String nonIndexedFields) throws Exception {
        return this.createIndex(tab, indexName, indexedFields, nonIndexedFields, false, 0);
    }

    private IndexDesc getIndex(Table table, String indexName) throws DBException, IOException {
        Collection indexList = DBTests.admin().getTableIndexes(table.getPath(), true);
        for (IndexDesc idx : indexList) {
            if (!idx.getIndexName().equals(indexName)) continue;
            return idx;
        }
        return null;
    }

    @Before
    public void startupBefore() throws Exception {
        HashMap<String, String> cfMap = new HashMap<String, String>();
        cfMap.put("cf1", "a.b");
        cfMap.put("cf2", "x.y");
        cfMap.put("cf3", "x.y.z");
        String[] splitKeys = new String[]{"user001", "user002", "user003", "user004", "user005"};
        table = DBTests.createOrReplaceTable(TABLE_NAME, cfMap, splitKeys);
        table.setOption(Table.TableOption.BUFFERWRITE, false);
        TestCluster.runCommand((String)("maprcli table index add -path " + table.getPath() + " -index " + INDEX_NAME + " -indexedfields '\"name.last\":1,\"name.first\":1,\"salary\":1' -includedfields '\"age\":1'"));
        DBTests.waitForSchemaUpdate();
        tableIndexList = DBTests.admin().getTableIndexes(table.getPath(), true);
        table.insertOrReplace(MapRDBImpl.newDocument((String)"{\"_id\":\"user001\", \"age\":43, \"salary\":43000, \"name\": {\"first\":\"Sam\", \"last\":\"Harris\"}}"));
        table.insertOrReplace(MapRDBImpl.newDocument((String)"{\"_id\":\"user002\", \"age\":12, \"salary\":340000, \"name\": {\"first\":\"Leon\", \"last\":\"Russel\"}}"));
        table.insertOrReplace(MapRDBImpl.newDocument((String)"{\"_id\":\"user003\", \"age\":87, \"salary\":9999999, \"name\": {\"first\":\"David\", \"last\":\"Bowie\"}}"));
        table.insertOrReplace(MapRDBImpl.newDocument((String)"{\"_id\":\"user004\", \"age\":56, \"salary\":7, \"name\": {\"first\":\"Bob\", \"last\":\"Dylan\"}}"));
        table.insertOrReplace(MapRDBImpl.newDocument((String)"{\"_id\":\"user005\", \"age\":54, \"salary\":123, \"name\": {\"first\":\"David\", \"last\":\"Ackert\"}}"));
        table.flush();
        DBTests.waitForIndexFlush(table.getPath());
    }

    @After
    public void cleanupAfter() throws IOException, Exception {
        if (table != null) {
            table.close();
            DBTests.deleteTables(TABLE_NAME);
        }
    }

    @Test
    public void testRyowAPIs() throws IOException, Exception {
        String testTable = "testtable-testRyowAPIs";
        Table t = DBTests.createOrReplaceTable(testTable);
        t.setOption(Table.TableOption.BUFFERWRITE, false);
        t.close();
        this.createIndex(t, "i1", "'\"a\"'", null);
        t = DBTests.getTable(testTable);
        MapRDBTableImpl tI = (MapRDBTableImpl)t;
        tI.beginTrackingWrites();
        try {
            tI.beginTrackingWrites();
            Assert.fail((String)"beginTrackingWrites() should have thrown exception");
        }
        catch (DBException dBException) {
            // empty catch block
        }
        t.insertOrReplace(MapRDBImpl.newDocument((String)"{\"_id\":\"user001\", \"age\":43, \"salary\":43000, \"a\":1}"));
        String ctx1 = tI.endTrackingWrites();
        try {
            tI.endTrackingWrites();
            Assert.fail((String)"endTrackingWrites() should have thrown exception");
        }
        catch (DBException dBException) {
            // empty catch block
        }
        tI.beginTrackingWrites(ctx1);
        int numRows = 5000;
        for (int i = 2; i <= numRows; ++i) {
            t.insertOrReplace(MapRDBImpl.newDocument((String)("{\"_id\":\"user00" + i + "\", \"age\":43, \"salary\":43000, \"a\":" + i + "}")));
        }
        String ctx2 = tI.endTrackingWrites();
        Path path = t.getPath();
        IndexSyncStateTracker trkr = tI.createIndexSyncStateTracker(ctx2);
        int totalWaitTime = 0;
        while (totalWaitTime < 60000 && !trkr.haveIndexesSynced()) {
            long waitMs = trkr.getEstimatedWaitMs() > 5000L ? 5000L : trkr.getEstimatedWaitMs();
            Thread.sleep(waitMs);
            totalWaitTime = (int)((long)totalWaitTime + waitMs);
        }
        if (!trkr.haveIndexesSynced()) {
            Assert.fail((String)("Indexes not synced after " + totalWaitTime / 1000 + " secs"));
        }
        t.close();
        IndexDesc indexTableDesc = (IndexDesc)DBTests.admin().getTableIndexes(path, true).iterator().next();
        Table i = MapRDBImpl.getIndexTable((IndexDesc)indexTableDesc);
        Iterator dsItr = i.find().iterator();
        int docs = 0;
        while (dsItr.hasNext()) {
            ++docs;
            dsItr.next();
        }
        Assert.assertEquals((long)numRows, (long)docs);
    }

    @Test
    public void testScanHang() throws IOException, Exception {
        Table t = DBTests.createOrReplaceTable("testtable-testScanHang");
        t.setOption(Table.TableOption.BUFFERWRITE, false);
        TestCluster.runCommand((String)("maprcli table index add -path " + t.getPath() + " -index i1 -indexedfields '\"a\"'"));
        int numRows = 0;
        for (int i = 0; i < numRows; ++i) {
            t.insertOrReplace(MapRDBImpl.newDocument((String)("{\"_id\":\"user00" + i + "\", \"age\":43, \"salary\":43000, \"a\":" + i + "}")));
        }
        t.flush();
        DBTests.waitForIndexFlush(t.getPath());
        IndexDesc indexTableDesc = (IndexDesc)DBTests.admin().getTableIndexes(t.getPath(), true).iterator().next();
        Table i = MapRDBImpl.getIndexTable((IndexDesc)indexTableDesc);
        Iterator dsItr = i.find().iterator();
        int docs = 0;
        while (dsItr.hasNext()) {
            ++docs;
            dsItr.next();
        }
        Assert.assertEquals((long)docs, (long)numRows);
    }

    @Test
    public void testMutation() throws IOException, Exception {
        Table t = DBTests.createOrReplaceTable("testtable-testMutation");
        t.setOption(Table.TableOption.BUFFERWRITE, false);
        TestCluster.runCommand((String)("maprcli table index add -path " + t.getPath() + " -index i1 -indexedfields '\"a\"' -includedfields '\"b\"'"));
        int numRows = 4;
        t.insertOrReplace(MapRDBImpl.newDocument((String)"{\"_id\":\"user001\",\"a\":25,\"b\":20}"));
        t.insertOrReplace(MapRDBImpl.newDocument((String)"{\"_id\":\"user002\",\"a\":15}"));
        t.insertOrReplace(MapRDBImpl.newDocument((String)"{\"_id\":\"user003\",\"b\":20}"));
        t.flush();
        t.update("user001", MapRDBImpl.newMutation().decrement("a", 20).decrement("b", 1));
        t.update("user002", MapRDBImpl.newMutation().decrement("a", 5));
        t.update("user003", MapRDBImpl.newMutation().decrement("b", 1));
        t.update("user004", MapRDBImpl.newMutation().increment("a", 20).decrement("b", 1));
        t.flush();
        DBTests.waitForIndexFlush(t.getPath(), 120000L);
        IndexDesc indexTableDesc = (IndexDesc)DBTests.admin().getTableIndexes(t.getPath(), true).iterator().next();
        Table i = MapRDBImpl.getIndexTable((IndexDesc)indexTableDesc);
        Iterator dsItr = i.find().iterator();
        int docs = 0;
        while (dsItr.hasNext()) {
            dsItr.next();
            ++docs;
        }
        Assert.assertEquals((long)docs, (long)numRows);
    }

    @Test
    public void testSimpleScan() throws IOException {
        Document doc = null;
        IndexDesc indexTableDesc = tableIndexList.iterator().next();
        try (Table indexTable = MapRDBImpl.getIndexTable((IndexDesc)indexTableDesc);
             DocumentStream stream = indexTable.find();){
            Iterator itr = stream.iterator();
            doc = (Document)itr.next();
            Assert.assertNotNull((Object)doc);
            Assert.assertEquals((Object)"user005", (Object)doc.getIdString());
            Assert.assertEquals((Object)"Ackert", (Object)doc.getString("name.last"));
            Assert.assertEquals((Object)"David", (Object)doc.getString("name.first"));
            Assert.assertEquals((long)123L, (long)doc.getInt("salary"));
            doc = (Document)itr.next();
            Assert.assertNotNull((Object)doc);
            Assert.assertEquals((Object)"user003", (Object)doc.getIdString());
            Assert.assertEquals((Object)"Bowie", (Object)doc.getString("name.last"));
            Assert.assertEquals((Object)"David", (Object)doc.getString("name.first"));
            Assert.assertEquals((long)9999999L, (long)doc.getInt("salary"));
            doc = (Document)itr.next();
            Assert.assertNotNull((Object)doc);
            Assert.assertEquals((Object)"user004", (Object)doc.getIdString());
            Assert.assertEquals((Object)"Dylan", (Object)doc.getString("name.last"));
            Assert.assertEquals((Object)"Bob", (Object)doc.getString("name.first"));
            Assert.assertEquals((long)7L, (long)doc.getInt("salary"));
            doc = (Document)itr.next();
            Assert.assertNotNull((Object)doc);
            Assert.assertEquals((Object)"user001", (Object)doc.getIdString());
            Assert.assertEquals((Object)"Harris", (Object)doc.getString("name.last"));
            Assert.assertEquals((Object)"Sam", (Object)doc.getString("name.first"));
            Assert.assertEquals((long)43000L, (long)doc.getInt("salary"));
            doc = (Document)itr.next();
            Assert.assertNotNull((Object)doc);
            Assert.assertEquals((Object)"user002", (Object)doc.getIdString());
            Assert.assertEquals((Object)"Russel", (Object)doc.getString("name.last"));
            Assert.assertEquals((Object)"Leon", (Object)doc.getString("name.first"));
            Assert.assertEquals((long)340000L, (long)doc.getInt("salary"));
            Assert.assertFalse((boolean)itr.hasNext());
        }
    }

    @Ignore(value="http://bugs.corp.maprtech.com/show_bug.cgi?id=26999")
    @Test
    public void testScanCFAces() throws IOException, InterruptedException {
        Iterator itr2;
        Throwable throwable;
        DocumentStream stream;
        DBTests.setCFAce(DBTests.getTablePath(TABLE_NAME), "default", Dbserver.DBAccessType.FamilyTraverseData, "u:mapr");
        DBTests.setCFAce(DBTests.getTablePath(TABLE_NAME), "default", Dbserver.DBAccessType.FamilyReadData, "u:mapr");
        Document doc = null;
        IndexDesc indexTableDesc = tableIndexList.iterator().next();
        try (Table indexTable = MapRDBImpl.getIndexTable((IndexDesc)indexTableDesc);){
            stream = indexTable.find();
            throwable = null;
            try {
                itr2 = stream.iterator();
                try {
                    ((Document)itr2.next()).getIdString();
                    Assert.assertNotNull(null);
                }
                catch (AccessDeniedException e) {
                    _logger.debug("index scan failed with an exception: " + e.getMessage());
                }
            }
            catch (Throwable itr2) {
                throwable = itr2;
                throw itr2;
            }
            finally {
                if (stream != null) {
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable itr2) {
                            throwable.addSuppressed(itr2);
                        }
                    } else {
                        stream.close();
                    }
                }
            }
        }
        DBTests.setCFAce(DBTests.getTablePath(TABLE_NAME), "default", Dbserver.DBAccessType.FamilyTraverseData, "u:root");
        DBTests.setCFAce(DBTests.getTablePath(TABLE_NAME), "default", Dbserver.DBAccessType.FamilyReadData, "u:root");
        Thread.sleep(200000L);
        indexTable = MapRDBImpl.getIndexTable((IndexDesc)indexTableDesc);
        var4_4 = null;
        try {
            stream = indexTable.find();
            throwable = null;
            try {
                itr2 = stream.iterator();
                doc = (Document)itr2.next();
                Assert.assertNotNull((Object)doc);
                Assert.assertEquals((Object)"user005", (Object)doc.getIdString());
                doc = (Document)itr2.next();
                Assert.assertNotNull((Object)doc);
                Assert.assertEquals((Object)"user003", (Object)doc.getIdString());
                doc = (Document)itr2.next();
                Assert.assertNotNull((Object)doc);
                Assert.assertEquals((Object)"user004", (Object)doc.getIdString());
                doc = (Document)itr2.next();
                Assert.assertNotNull((Object)doc);
                Assert.assertEquals((Object)"user001", (Object)doc.getIdString());
                doc = (Document)itr2.next();
                Assert.assertNotNull((Object)doc);
                Assert.assertEquals((Object)"user002", (Object)doc.getIdString());
                Assert.assertFalse((boolean)itr2.hasNext());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (stream != null) {
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        stream.close();
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            var4_4 = throwable4;
            throw throwable4;
        }
        finally {
            if (indexTable != null) {
                if (var4_4 != null) {
                    try {
                        indexTable.close();
                    }
                    catch (Throwable throwable5) {
                        var4_4.addSuppressed(throwable5);
                    }
                } else {
                    indexTable.close();
                }
            }
        }
    }

    @Ignore(value="http://bugs.corp.maprtech.com/show_bug.cgi?id=27406")
    @Test
    public void testScanCFAcesNoTraverse() throws IOException, InterruptedException {
        Iterator itr2;
        Throwable throwable;
        DocumentStream stream;
        DBTests.setCFAce(DBTests.getTablePath(TABLE_NAME), "default", Dbserver.DBAccessType.FamilyReadData, "u:mapr");
        Document doc = null;
        IndexDesc indexTableDesc = tableIndexList.iterator().next();
        try (Table indexTable = MapRDBImpl.getIndexTable((IndexDesc)indexTableDesc);){
            stream = indexTable.find();
            throwable = null;
            try {
                itr2 = stream.iterator();
                try {
                    ((Document)itr2.next()).getIdString();
                    Assert.assertNotNull(null);
                }
                catch (AccessDeniedException e) {
                    _logger.debug("index scan failed with an exception: " + e.getMessage());
                }
            }
            catch (Throwable itr2) {
                throwable = itr2;
                throw itr2;
            }
            finally {
                if (stream != null) {
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable itr2) {
                            throwable.addSuppressed(itr2);
                        }
                    } else {
                        stream.close();
                    }
                }
            }
        }
        DBTests.setCFAce(DBTests.getTablePath(TABLE_NAME), "default", Dbserver.DBAccessType.FamilyReadData, "u:root");
        Thread.sleep(200000L);
        indexTable = MapRDBImpl.getIndexTable((IndexDesc)indexTableDesc);
        var4_4 = null;
        try {
            stream = indexTable.find();
            throwable = null;
            try {
                itr2 = stream.iterator();
                doc = (Document)itr2.next();
                Assert.assertNotNull((Object)doc);
                Assert.assertEquals((Object)"user005", (Object)doc.getIdString());
                doc = (Document)itr2.next();
                Assert.assertNotNull((Object)doc);
                Assert.assertEquals((Object)"user003", (Object)doc.getIdString());
                doc = (Document)itr2.next();
                Assert.assertNotNull((Object)doc);
                Assert.assertEquals((Object)"user004", (Object)doc.getIdString());
                doc = (Document)itr2.next();
                Assert.assertNotNull((Object)doc);
                Assert.assertEquals((Object)"user001", (Object)doc.getIdString());
                doc = (Document)itr2.next();
                Assert.assertNotNull((Object)doc);
                Assert.assertEquals((Object)"user002", (Object)doc.getIdString());
                Assert.assertFalse((boolean)itr2.hasNext());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (stream != null) {
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        stream.close();
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            var4_4 = throwable4;
            throw throwable4;
        }
        finally {
            if (indexTable != null) {
                if (var4_4 != null) {
                    try {
                        indexTable.close();
                    }
                    catch (Throwable throwable5) {
                        var4_4.addSuppressed(throwable5);
                    }
                } else {
                    indexTable.close();
                }
            }
        }
    }

    @Test
    public void testScanCFAcesOnlyTraverse() throws IOException {
        DBTests.setCFAce(DBTests.getTablePath(TABLE_NAME), "default", Dbserver.DBAccessType.FamilyTraverseData, "u:mapr");
        Document doc = null;
        IndexDesc indexTableDesc = tableIndexList.iterator().next();
        try (Table indexTable = MapRDBImpl.getIndexTable((IndexDesc)indexTableDesc);
             DocumentStream stream = indexTable.find();){
            Iterator itr = stream.iterator();
            doc = (Document)itr.next();
            Assert.assertNotNull((Object)doc);
            Assert.assertEquals((Object)"user005", (Object)doc.getIdString());
            doc = (Document)itr.next();
            Assert.assertNotNull((Object)doc);
            Assert.assertEquals((Object)"user003", (Object)doc.getIdString());
            doc = (Document)itr.next();
            Assert.assertNotNull((Object)doc);
            Assert.assertEquals((Object)"user004", (Object)doc.getIdString());
            doc = (Document)itr.next();
            Assert.assertNotNull((Object)doc);
            Assert.assertEquals((Object)"user001", (Object)doc.getIdString());
            doc = (Document)itr.next();
            Assert.assertNotNull((Object)doc);
            Assert.assertEquals((Object)"user002", (Object)doc.getIdString());
            Assert.assertFalse((boolean)itr.hasNext());
        }
    }

    @Ignore(value="http://bugs.corp.maprtech.com/show_bug.cgi?id=27408")
    @Test
    public void testScanCFAcesParentTraverse() throws IOException {
        Iterator itr2;
        Throwable throwable;
        DocumentStream stream;
        DBTests.setFieldAce(DBTests.getTablePath(TABLE_NAME), "default", "name", Dbserver.DBAccessType.ColumnReadData, "u:mapr");
        DBTests.setFieldAce(DBTests.getTablePath(TABLE_NAME), "default", "name", Dbserver.DBAccessType.ColumnTraverseData, "u:mapr");
        DBTests.setFieldAce(DBTests.getTablePath(TABLE_NAME), "default", "name.first", Dbserver.DBAccessType.ColumnReadData, "u:root");
        DBTests.setFieldAce(DBTests.getTablePath(TABLE_NAME), "default", "name.last", Dbserver.DBAccessType.ColumnReadData, "u:root");
        Document doc = null;
        IndexDesc indexTableDesc = tableIndexList.iterator().next();
        try (Table indexTable = MapRDBImpl.getIndexTable((IndexDesc)indexTableDesc);){
            stream = indexTable.find();
            throwable = null;
            try {
                itr2 = stream.iterator();
                try {
                    ((Document)itr2.next()).getIdString();
                    Assert.assertNotNull(null);
                }
                catch (AccessDeniedException e) {
                    _logger.debug("index scan failed with an exception: " + e.getMessage());
                }
            }
            catch (Throwable itr2) {
                throwable = itr2;
                throw itr2;
            }
            finally {
                if (stream != null) {
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable itr2) {
                            throwable.addSuppressed(itr2);
                        }
                    } else {
                        stream.close();
                    }
                }
            }
        }
        DBTests.setFieldAce(DBTests.getTablePath(TABLE_NAME), "default", "name", Dbserver.DBAccessType.ColumnTraverseData, "u:root");
        indexTable = MapRDBImpl.getIndexTable((IndexDesc)indexTableDesc);
        var4_4 = null;
        try {
            stream = indexTable.find();
            throwable = null;
            try {
                itr2 = stream.iterator();
                doc = (Document)itr2.next();
                Assert.assertNotNull((Object)doc);
                Assert.assertEquals((Object)"user005", (Object)doc.getIdString());
                doc = (Document)itr2.next();
                Assert.assertNotNull((Object)doc);
                Assert.assertEquals((Object)"user003", (Object)doc.getIdString());
                doc = (Document)itr2.next();
                Assert.assertNotNull((Object)doc);
                Assert.assertEquals((Object)"user004", (Object)doc.getIdString());
                doc = (Document)itr2.next();
                Assert.assertNotNull((Object)doc);
                Assert.assertEquals((Object)"user001", (Object)doc.getIdString());
                doc = (Document)itr2.next();
                Assert.assertNotNull((Object)doc);
                Assert.assertEquals((Object)"user002", (Object)doc.getIdString());
                Assert.assertFalse((boolean)itr2.hasNext());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (stream != null) {
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        stream.close();
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            var4_4 = throwable4;
            throw throwable4;
        }
        finally {
            if (indexTable != null) {
                if (var4_4 != null) {
                    try {
                        indexTable.close();
                    }
                    catch (Throwable throwable5) {
                        var4_4.addSuppressed(throwable5);
                    }
                } else {
                    indexTable.close();
                }
            }
        }
    }

    @Ignore(value="http://bugs.corp.maprtech.com/show_bug.cgi?id=27409")
    @Test
    public void testScanCFAcesLeafRead() throws IOException {
        Iterator itr2;
        Throwable throwable;
        DocumentStream stream;
        DBTests.setFieldAce(DBTests.getTablePath(TABLE_NAME), "default", "name.first", Dbserver.DBAccessType.ColumnReadData, "u:mapr");
        Document doc = null;
        IndexDesc indexTableDesc = tableIndexList.iterator().next();
        try (Table indexTable = MapRDBImpl.getIndexTable((IndexDesc)indexTableDesc);){
            stream = indexTable.find();
            throwable = null;
            try {
                itr2 = stream.iterator();
                try {
                    ((Document)itr2.next()).getIdString();
                    Assert.assertNotNull(null);
                }
                catch (AccessDeniedException e) {
                    _logger.debug("index scan failed with an exception: " + e.getMessage());
                }
            }
            catch (Throwable itr2) {
                throwable = itr2;
                throw itr2;
            }
            finally {
                if (stream != null) {
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable itr2) {
                            throwable.addSuppressed(itr2);
                        }
                    } else {
                        stream.close();
                    }
                }
            }
        }
        DBTests.setFieldAce(DBTests.getTablePath(TABLE_NAME), "default", "name.first", Dbserver.DBAccessType.ColumnReadData, "u:root");
        indexTable = MapRDBImpl.getIndexTable((IndexDesc)indexTableDesc);
        var4_4 = null;
        try {
            stream = indexTable.find();
            throwable = null;
            try {
                itr2 = stream.iterator();
                doc = (Document)itr2.next();
                Assert.assertNotNull((Object)doc);
                Assert.assertEquals((Object)"user005", (Object)doc.getIdString());
                doc = (Document)itr2.next();
                Assert.assertNotNull((Object)doc);
                Assert.assertEquals((Object)"user003", (Object)doc.getIdString());
                doc = (Document)itr2.next();
                Assert.assertNotNull((Object)doc);
                Assert.assertEquals((Object)"user004", (Object)doc.getIdString());
                doc = (Document)itr2.next();
                Assert.assertNotNull((Object)doc);
                Assert.assertEquals((Object)"user001", (Object)doc.getIdString());
                doc = (Document)itr2.next();
                Assert.assertNotNull((Object)doc);
                Assert.assertEquals((Object)"user002", (Object)doc.getIdString());
                Assert.assertFalse((boolean)itr2.hasNext());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (stream != null) {
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        stream.close();
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            var4_4 = throwable4;
            throw throwable4;
        }
        finally {
            if (indexTable != null) {
                if (var4_4 != null) {
                    try {
                        indexTable.close();
                    }
                    catch (Throwable throwable5) {
                        var4_4.addSuppressed(throwable5);
                    }
                } else {
                    indexTable.close();
                }
            }
        }
    }

    @Test
    public void testScanCFAcesColTraverse() throws IOException {
        DBTests.setFieldAce(DBTests.getTablePath(TABLE_NAME), "default", "age", Dbserver.DBAccessType.ColumnTraverseData, "u:mapr");
        Document doc = null;
        IndexDesc indexTableDesc = tableIndexList.iterator().next();
        try (Table indexTable = MapRDBImpl.getIndexTable((IndexDesc)indexTableDesc);
             DocumentStream stream = indexTable.find();){
            Iterator itr = stream.iterator();
            doc = (Document)itr.next();
            Assert.assertNotNull((Object)doc);
            Assert.assertEquals((Object)"user005", (Object)doc.getIdString());
            doc = (Document)itr.next();
            Assert.assertNotNull((Object)doc);
            Assert.assertEquals((Object)"user003", (Object)doc.getIdString());
            doc = (Document)itr.next();
            Assert.assertNotNull((Object)doc);
            Assert.assertEquals((Object)"user004", (Object)doc.getIdString());
            doc = (Document)itr.next();
            Assert.assertNotNull((Object)doc);
            Assert.assertEquals((Object)"user001", (Object)doc.getIdString());
            doc = (Document)itr.next();
            Assert.assertNotNull((Object)doc);
            Assert.assertEquals((Object)"user002", (Object)doc.getIdString());
            Assert.assertFalse((boolean)itr.hasNext());
        }
    }

    @Ignore(value="http://bugs.corp.maprtech.com/show_bug.cgi?id=27407")
    @Test
    public void testScanCFShortPath() throws IOException {
        Iterator itr2;
        Throwable throwable;
        DocumentStream stream;
        DBTests.setFieldAce(DBTests.getTablePath(TABLE_NAME), "default", "name.first.init.a", Dbserver.DBAccessType.ColumnReadData, "u:mapr");
        Document doc = null;
        IndexDesc indexTableDesc = tableIndexList.iterator().next();
        try (Table indexTable = MapRDBImpl.getIndexTable((IndexDesc)indexTableDesc);){
            stream = indexTable.find();
            throwable = null;
            try {
                itr2 = stream.iterator();
                try {
                    ((Document)itr2.next()).getIdString();
                    Assert.assertNotNull(null);
                }
                catch (AccessDeniedException e) {
                    _logger.debug("index scan failed with an exception: " + e.getMessage());
                }
            }
            catch (Throwable itr2) {
                throwable = itr2;
                throw itr2;
            }
            finally {
                if (stream != null) {
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable itr2) {
                            throwable.addSuppressed(itr2);
                        }
                    } else {
                        stream.close();
                    }
                }
            }
        }
        DBTests.setFieldAce(DBTests.getTablePath(TABLE_NAME), "default", "name.first.init.a", Dbserver.DBAccessType.ColumnReadData, "u:root");
        indexTable = MapRDBImpl.getIndexTable((IndexDesc)indexTableDesc);
        var4_4 = null;
        try {
            stream = indexTable.find();
            throwable = null;
            try {
                itr2 = stream.iterator();
                doc = (Document)itr2.next();
                Assert.assertNotNull((Object)doc);
                Assert.assertEquals((Object)"user005", (Object)doc.getIdString());
                doc = (Document)itr2.next();
                Assert.assertNotNull((Object)doc);
                Assert.assertEquals((Object)"user003", (Object)doc.getIdString());
                doc = (Document)itr2.next();
                Assert.assertNotNull((Object)doc);
                Assert.assertEquals((Object)"user004", (Object)doc.getIdString());
                doc = (Document)itr2.next();
                Assert.assertNotNull((Object)doc);
                Assert.assertEquals((Object)"user001", (Object)doc.getIdString());
                doc = (Document)itr2.next();
                Assert.assertNotNull((Object)doc);
                Assert.assertEquals((Object)"user002", (Object)doc.getIdString());
                Assert.assertFalse((boolean)itr2.hasNext());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (stream != null) {
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        stream.close();
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            var4_4 = throwable4;
            throw throwable4;
        }
        finally {
            if (indexTable != null) {
                if (var4_4 != null) {
                    try {
                        indexTable.close();
                    }
                    catch (Throwable throwable5) {
                        var4_4.addSuppressed(throwable5);
                    }
                } else {
                    indexTable.close();
                }
            }
        }
    }

    @Test
    public void testInitialIndexSync() throws Exception {
        String i1 = "TestIndexTable-testInitialIndexSync-" + Long.toString(System.currentTimeMillis());
        IndexDesc i1Desc = null;
        Document doc = MapRDBImpl.newDocument();
        doc.set("a.b.c", "abc").set("a.c.d", "acd");
        int count = 10;
        int maxkey = count << 1;
        while (count < maxkey) {
            String key = "key" + Integer.toString(count++);
            table.insert(key, doc);
        }
        table.flush();
        i1Desc = this.createIndex(table, i1, "'\"a.b.c\"'", "'\"a.c.d\"'");
        DBTests.waitForIndexFlush(table.getPath());
        Table indexTable = MapRDBImpl.getIndexTable((IndexDesc)i1Desc);
        DocumentStream ds = indexTable.find();
        Iterator itr = ds.iterator();
        Assert.assertTrue((boolean)itr.hasNext());
        count = 10;
        while (itr.hasNext()) {
            Document d = (Document)itr.next();
            Assert.assertEquals((Object)("key" + Integer.toString(count++)), (Object)d.getIdString());
            Assert.assertEquals((Object)"abc", (Object)doc.getString("a.b.c"));
            Assert.assertEquals((Object)"acd", (Object)doc.getString("a.c.d"));
        }
    }

    @Test
    public void testInitialIndexSyncWithDates() throws Exception {
        String i1 = "TestIndexTable-testInitialIndexSyncWithDates-" + Long.toString(System.currentTimeMillis());
        ODate date0 = ODate.parse((String)"2012-02-02");
        ODate date1 = ODate.parse((String)"2012-02-03");
        OTimestamp ts0 = OTimestamp.parse((String)"2012-02-03T10:00:00.000Z");
        OTimestamp ts1 = OTimestamp.parse((String)"2012-02-03T09:00:00.000Z");
        OTimestamp ts2 = OTimestamp.parse((String)"2012-02-01T19:00:00.000Z");
        int i = 0;
        int count = 5;
        Document[] doc = new Document[5];
        doc[i++] = MapRDBImpl.newDocument().set("a.b.c", date0).set("a.c.d", "acd");
        doc[i++] = MapRDBImpl.newDocument().set("a.b.c", date1).set("a.c.d", "acd");
        doc[i++] = MapRDBImpl.newDocument().set("a.b.c", ts0).set("a.c.d", "acd");
        doc[i++] = MapRDBImpl.newDocument().set("a.b.c", ts1).set("a.c.d", "acd");
        doc[i++] = MapRDBImpl.newDocument().set("a.b.c", ts2).set("a.c.d", "acd");
        for (i = 0; i < 5; ++i) {
            table.insert("key" + Integer.toString(i), doc[i]);
        }
        table.flush();
        IndexDesc i1Desc = this.createIndex(table, i1, "'\"a.b.c\"'", "'\"a.c.d\"'");
        DBTests.waitForIndexFlush(table.getPath());
        Table indexTable = MapRDBImpl.getIndexTable((IndexDesc)i1Desc);
        DocumentStream ds = indexTable.find();
        Iterator itr = ds.iterator();
        Assert.assertTrue((boolean)itr.hasNext());
        Document d = (Document)itr.next();
        Assert.assertEquals((long)date0.compareTo(d.getDate("a.b.c")), (long)0L);
        Assert.assertTrue((boolean)itr.hasNext());
        d = (Document)itr.next();
        Assert.assertEquals((long)date1.compareTo(d.getDate("a.b.c")), (long)0L);
        Assert.assertTrue((boolean)itr.hasNext());
        d = (Document)itr.next();
        Assert.assertEquals((long)ts2.compareTo(d.getTimestamp("a.b.c")), (long)0L);
        Assert.assertTrue((boolean)itr.hasNext());
        d = (Document)itr.next();
        Assert.assertEquals((long)ts1.compareTo(d.getTimestamp("a.b.c")), (long)0L);
        Assert.assertTrue((boolean)itr.hasNext());
        d = (Document)itr.next();
        Assert.assertEquals((long)ts0.compareTo(d.getTimestamp("a.b.c")), (long)0L);
    }

    @Test
    public void testUpdatesWithNoIndexImpact() throws Exception {
        String i1 = "TestIndexTable-testUpdatesWithNoIndexImpact-" + Long.toString(System.currentTimeMillis());
        IndexDesc i1Desc = this.createIndex(table, i1, "'\"a.b.c\"'", "'\"a.c.d\"'");
        DocumentMutation mut = MapRDBImpl.newMutation();
        mut.setOrReplace("b.c.d", "bcd").setOrReplace("a.d.e", "ace").setOrReplace("y.x.y", "yxy");
        int count = 10;
        int maxkey = count << 1;
        while (count < maxkey) {
            String key = "key" + Integer.toString(count++);
            table.update(key, mut);
        }
        table.flush();
        DBTests.waitForIndexFlush(table.getPath());
        Table indexTable = MapRDBImpl.getIndexTable((IndexDesc)i1Desc);
        DocumentStream ds = indexTable.find();
        Iterator itr = ds.iterator();
        Assert.assertTrue((!itr.hasNext() ? 1 : 0) != 0);
    }

    @Test
    public void testConditionFilterString() throws Exception {
        Document doc = null;
        IndexDesc indexTableDesc = tableIndexList.iterator().next();
        Table indexTable = MapRDBImpl.getIndexTable((IndexDesc)indexTableDesc);
        ConditionImpl qc = MapRDBImpl.newCondition().is("name.last", QueryCondition.Op.EQUAL, "Harris").build();
        DocumentStream stream = indexTable.find((QueryCondition)qc);
        Iterator itr = stream.iterator();
        doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().is("name.last", QueryCondition.Op.EQUAL, "Eugene").build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        Assert.assertFalse((boolean)itr.hasNext());
        ArrayList<String> blockList = new ArrayList<String>();
        blockList.add("Sam");
        blockList.add("Fisher");
        blockList.add("Harris");
        qc = MapRDBImpl.newCondition().in("name.last", blockList).build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertFalse((boolean)itr.hasNext());
        blockList.remove(2);
        qc = MapRDBImpl.newCondition().in("name.last", blockList).build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().and().is("name.last", QueryCondition.Op.EQUAL, "Harris").is("name.first", QueryCondition.Op.EQUAL, "Sam").close().build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().and().is("name.last", QueryCondition.Op.EQUAL, "Liu").is("name.first", QueryCondition.Op.EQUAL, "Eugene").close().build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        Assert.assertFalse((boolean)itr.hasNext());
    }

    @Test
    public void testConditionFilterNoBinaryComparator() throws Exception {
        String i1 = "TestIndexTable-testConditionInteger-" + Long.toString(System.currentTimeMillis());
        IndexDesc i1Desc = this.createIndex(table, i1, "'\"a.b.c\":-1','\"p.q\"'", "'\"a.c.d\"'");
        DocumentMutation mut = MapRDBImpl.newMutation();
        mut.setOrReplace("p.q", 35).setOrReplace("a.c.d", 100).setOrReplace("e", 1000);
        table.update("key", mut);
        table.flush();
        DBTests.waitForIndexFlush(table.getPath());
        Table indexTable = MapRDBImpl.getIndexTable((IndexDesc)i1Desc);
        ConditionImpl qc = MapRDBImpl.newCondition().exists("a.b.c").build();
        DocumentStream stream = indexTable.find((QueryCondition)qc);
        Iterator itr = stream.iterator();
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().notExists("a.b.c").build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        Document doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertEquals((Object)"key", (Object)doc.getIdString());
        Assert.assertEquals((long)100L, (long)doc.getInt("a.c.d"));
        Assert.assertEquals((long)35L, (long)doc.getInt("p.q"));
        Assert.assertFalse((boolean)itr.hasNext());
        mut.setOrReplace("a.b.c", "xyz").setOrReplace("p.q", 20).setOrReplace("a.c.d", 12).setOrReplace("e", 18);
        table.update("key1", mut);
        table.flush();
        DBTests.waitForIndexFlush(table.getPath());
        qc = MapRDBImpl.newCondition().exists("a.b.c").build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertEquals((Object)"key1", (Object)doc.getIdString());
        Assert.assertEquals((Object)"xyz", (Object)doc.getString("a.b.c"));
        Assert.assertEquals((long)12L, (long)doc.getInt("a.c.d"));
        Assert.assertEquals((long)20L, (long)doc.getInt("p.q"));
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().typeOf("a.b.c", Value.Type.INT).build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().notTypeOf("a.b.c", Value.Type.INT).build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertEquals((Object)"key1", (Object)doc.getIdString());
        Assert.assertEquals((Object)"xyz", (Object)doc.getString("a.b.c"));
        Assert.assertEquals((long)12L, (long)doc.getInt("a.c.d"));
        Assert.assertEquals((long)20L, (long)doc.getInt("p.q"));
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().typeOf("a.b.c", Value.Type.STRING).build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertEquals((Object)"key1", (Object)doc.getIdString());
        Assert.assertEquals((Object)"xyz", (Object)doc.getString("a.b.c"));
        Assert.assertEquals((long)12L, (long)doc.getInt("a.c.d"));
        Assert.assertEquals((long)20L, (long)doc.getInt("p.q"));
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().sizeOf("a.b.c", QueryCondition.Op.EQUAL, 5L).build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().sizeOf("a.b.c", QueryCondition.Op.EQUAL, 3L).build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertEquals((Object)"key1", (Object)doc.getIdString());
        Assert.assertEquals((Object)"xyz", (Object)doc.getString("a.b.c"));
        Assert.assertEquals((long)12L, (long)doc.getInt("a.c.d"));
        Assert.assertEquals((long)20L, (long)doc.getInt("p.q"));
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().matches("a.b.c", ".*m.*").build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().notMatches("a.b.c", ".*m.*").build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertEquals((Object)"key1", (Object)doc.getIdString());
        Assert.assertEquals((Object)"xyz", (Object)doc.getString("a.b.c"));
        Assert.assertEquals((long)12L, (long)doc.getInt("a.c.d"));
        Assert.assertEquals((long)20L, (long)doc.getInt("p.q"));
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().matches("a.b.c", ".*y.*").build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertEquals((Object)"key1", (Object)doc.getIdString());
        Assert.assertEquals((Object)"xyz", (Object)doc.getString("a.b.c"));
        Assert.assertEquals((long)12L, (long)doc.getInt("a.c.d"));
        Assert.assertEquals((long)20L, (long)doc.getInt("p.q"));
        Assert.assertFalse((boolean)itr.hasNext());
        table.delete("key1");
        table.flush();
        DBTests.waitForIndexFlush(table.getPath());
        qc = MapRDBImpl.newCondition().exists("a.b.c").build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().notExists("a.b.c").build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertEquals((Object)"key", (Object)doc.getIdString());
        Assert.assertEquals((long)100L, (long)doc.getInt("a.c.d"));
        Assert.assertEquals((long)35L, (long)doc.getInt("p.q"));
        Assert.assertFalse((boolean)itr.hasNext());
        mut.setOrReplace("a.b.c", 5).setOrReplace("p.q", 20).setOrReplace("a.c.d", 12).setOrReplace("e", 18);
        table.update("key1", mut);
        table.flush();
        DBTests.waitForIndexFlush(table.getPath());
        qc = MapRDBImpl.newCondition().exists("a.b.c").build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertEquals((Object)"key1", (Object)doc.getIdString());
        Assert.assertEquals((long)5L, (long)doc.getInt("a.b.c"));
        Assert.assertEquals((long)12L, (long)doc.getInt("a.c.d"));
        Assert.assertEquals((long)20L, (long)doc.getInt("p.q"));
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().typeOf("a.b.c", Value.Type.STRING).build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().notTypeOf("a.b.c", Value.Type.STRING).build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertEquals((Object)"key1", (Object)doc.getIdString());
        Assert.assertEquals((long)5L, (long)doc.getInt("a.b.c"));
        Assert.assertEquals((long)12L, (long)doc.getInt("a.c.d"));
        Assert.assertEquals((long)20L, (long)doc.getInt("p.q"));
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().typeOf("a.b.c", Value.Type.INT).build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertEquals((Object)"key1", (Object)doc.getIdString());
        Assert.assertEquals((long)5L, (long)doc.getInt("a.b.c"));
        Assert.assertEquals((long)12L, (long)doc.getInt("a.c.d"));
        Assert.assertEquals((long)20L, (long)doc.getInt("p.q"));
        Assert.assertFalse((boolean)itr.hasNext());
    }

    @Test
    public void testConditionFilterInteger() throws Exception {
        String i1 = "TestIndexTable-testConditionInteger-" + Long.toString(System.currentTimeMillis());
        IndexDesc i1Desc = this.createIndex(table, i1, "'\"a.b.c\"','\"p.q\"'", "'\"a.c.d\"'");
        DocumentMutation mut = MapRDBImpl.newMutation();
        mut.setOrReplace("a.b.c", 5).setOrReplace("p.q", 35).setOrReplace("a.c.d", 100).setOrReplace("e", 1000);
        table.update("key", mut);
        mut.setOrReplace("a.b.c", 11).setOrReplace("p.q", 20).setOrReplace("a.c.d", 12).setOrReplace("e", 18);
        table.update("key1", mut);
        table.flush();
        DBTests.waitForIndexFlush(table.getPath());
        Table indexTable = MapRDBImpl.getIndexTable((IndexDesc)i1Desc);
        ConditionImpl qc = MapRDBImpl.newCondition().is("a.b.c", QueryCondition.Op.EQUAL, 5).build();
        DocumentStream stream = indexTable.find((QueryCondition)qc);
        Iterator itr = stream.iterator();
        Document doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().and().is("a.b.c", QueryCondition.Op.LESS, 10).is("a.b.c", QueryCondition.Op.GREATER_OR_EQUAL, 1).close().build();
        stream = indexTable.find((QueryCondition)qc, new String[]{"a.b.c"});
        itr = stream.iterator();
        doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().and().is("a.b.c", QueryCondition.Op.GREATER_OR_EQUAL, 1).is("a.b.c", QueryCondition.Op.LESS, 10).close().build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().and().is("a.b.c", QueryCondition.Op.GREATER_OR_EQUAL, 1).is("a.b.c", QueryCondition.Op.LESS, 10).close().build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().and().is("a.b.c", QueryCondition.Op.LESS, 3).is("a.b.c", QueryCondition.Op.GREATER_OR_EQUAL, 1).close().build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().and().is("a.b.c", QueryCondition.Op.LESS, 3).is("p.q", QueryCondition.Op.GREATER_OR_EQUAL, 41).close().build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().and().is("a.b.c", QueryCondition.Op.LESS, 10).is("p.q", QueryCondition.Op.GREATER, 20).close().build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        doc = (Document)itr.next();
        System.out.println(doc);
        qc = MapRDBImpl.newCondition().is("a.b.c", QueryCondition.Op.GREATER_OR_EQUAL, 5).build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        doc = (Document)itr.next();
        System.out.println(doc);
        doc = (Document)itr.next();
        System.out.println(doc);
        qc = MapRDBImpl.newCondition().or().is("a.b.c", QueryCondition.Op.GREATER_OR_EQUAL, 12).is("a.b.c", QueryCondition.Op.LESS_OR_EQUAL, 7).close().build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        doc = (Document)itr.next();
        System.out.println(doc);
        qc = MapRDBImpl.newCondition().or().is("a.b.c", QueryCondition.Op.GREATER_OR_EQUAL, 12).is("a.b.c", QueryCondition.Op.LESS_OR_EQUAL, 2).close().build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().or().is("a.b.c", QueryCondition.Op.GREATER_OR_EQUAL, 12).is("p.q", QueryCondition.Op.LESS, 20).close().build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().or().is("a.b.c", QueryCondition.Op.GREATER_OR_EQUAL, 12).is("p.q", QueryCondition.Op.LESS_OR_EQUAL, 20).close().build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().and().is("a.b.c", QueryCondition.Op.GREATER_OR_EQUAL, 1).is("a.c.d", QueryCondition.Op.GREATER_OR_EQUAL, 25).close().build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertFalse((boolean)itr.hasNext());
    }

    @Test
    public void testIndexProjection() throws Exception {
        String i1 = "TestIndexTable-testConditionInteger-" + Long.toString(System.currentTimeMillis());
        IndexDesc i1Desc = this.createIndex(table, i1, "'\"a.b.c\"','\"p.q\"'", "'\"a.c.d\"','\"m.n\"'");
        DocumentMutation mut = MapRDBImpl.newMutation();
        mut.setOrReplace("a.b.c", 5).setOrReplace("p.q", 35).setOrReplace("a.c.d", 100).setOrReplace("m.n", 717).setOrReplace("e", 1000);
        table.update("key", mut);
        mut.setOrReplace("a.b.c", 11).setOrReplace("p.q", 20).setOrReplace("a.c.d", 12).setOrReplace("m.n", (Map)MapRDBImpl.newDocument().set("z", 818)).setOrReplace("e", 18);
        table.update("key1", mut);
        table.flush();
        DBTests.waitForIndexFlush(table.getPath());
        Table indexTable = MapRDBImpl.getIndexTable((IndexDesc)i1Desc);
        ConditionImpl qc = MapRDBImpl.newCondition().is("a.b.c", QueryCondition.Op.EQUAL, 5).build();
        DocumentStream stream = indexTable.find((QueryCondition)qc);
        Iterator itr = stream.iterator();
        Document doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertEquals((Object)"key", (Object)doc.getIdString());
        Assert.assertEquals((long)5L, (long)doc.getInt("a.b.c"));
        Assert.assertEquals((long)100L, (long)doc.getInt("a.c.d"));
        Assert.assertEquals((long)35L, (long)doc.getInt("p.q"));
        Assert.assertEquals((long)717L, (long)doc.getInt("m.n"));
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().and().is("a.b.c", QueryCondition.Op.LESS, 10).is("a.b.c", QueryCondition.Op.GREATER_OR_EQUAL, 1).close().build();
        stream = indexTable.find((QueryCondition)qc, new String[]{"a.b.c"});
        itr = stream.iterator();
        doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertEquals((Object)"key", (Object)doc.getIdString());
        Assert.assertEquals((long)5L, (long)doc.getInt("a.b.c"));
        Assert.assertEquals((long)doc.size(), (long)2L);
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().and().is("a.b.c", QueryCondition.Op.LESS, 10).is("a.b.c", QueryCondition.Op.GREATER_OR_EQUAL, 1).close().build();
        stream = indexTable.find((QueryCondition)qc, new String[]{"a.c.d"});
        itr = stream.iterator();
        doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertEquals((Object)"key", (Object)doc.getIdString());
        Assert.assertEquals((long)100L, (long)doc.getInt("a.c.d"));
        Assert.assertEquals((long)doc.size(), (long)2L);
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().and().is("a.b.c", QueryCondition.Op.LESS, 10).is("a.b.c", QueryCondition.Op.GREATER_OR_EQUAL, 1).close().build();
        stream = indexTable.find((QueryCondition)qc, new String[]{"a.b.c", "p.q"});
        itr = stream.iterator();
        doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertEquals((Object)"key", (Object)doc.getIdString());
        Assert.assertEquals((long)5L, (long)doc.getInt("a.b.c"));
        Assert.assertEquals((long)35L, (long)doc.getInt("p.q"));
        Assert.assertEquals((long)doc.size(), (long)3L);
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().and().is("a.b.c", QueryCondition.Op.LESS, 10).is("a.b.c", QueryCondition.Op.GREATER_OR_EQUAL, 1).close().build();
        stream = indexTable.find((QueryCondition)qc, new String[]{"a.b.c", "m.n"});
        itr = stream.iterator();
        doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertEquals((Object)"key", (Object)doc.getIdString());
        Assert.assertEquals((long)5L, (long)doc.getInt("a.b.c"));
        Assert.assertEquals((long)717L, (long)doc.getInt("m.n"));
        Assert.assertEquals((long)doc.size(), (long)3L);
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().is("a.b.c", QueryCondition.Op.EQUAL, 11).build();
        stream = indexTable.find((QueryCondition)qc, new String[]{"m.n.z"});
        itr = stream.iterator();
        doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertEquals((Object)"key1", (Object)doc.getIdString());
        Assert.assertEquals((long)818L, (long)doc.getInt("m.n.z"));
        Assert.assertEquals((long)doc.size(), (long)2L);
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().is("a.b.c", QueryCondition.Op.EQUAL, 11).build();
        stream = indexTable.find((QueryCondition)qc, new String[]{"m.n.p"});
        itr = stream.iterator();
        doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertEquals((Object)"key1", (Object)doc.getIdString());
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().is("a.b.c", QueryCondition.Op.EQUAL, 11).build();
        stream = indexTable.find((QueryCondition)qc, new String[]{"u.f.o"});
        itr = stream.iterator();
        doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertEquals((Object)"key1", (Object)doc.getIdString());
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().is("a.b.c", QueryCondition.Op.EQUAL, 11).build();
        stream = indexTable.find((QueryCondition)qc, new String[]{"_id"});
        itr = stream.iterator();
        doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertEquals((Object)"key1", (Object)doc.getIdString());
        Assert.assertFalse((boolean)itr.hasNext());
    }

    @Test
    public void testErrorEncoding() throws Exception {
        String i1 = "TestIndexTable-testConditionInteger-" + Long.toString(System.currentTimeMillis());
        IndexDesc i1Desc = this.createIndex(table, i1, "'\"a.b.c\"','\"p.q\"'", "'\"a.c.d\"'");
        DocumentMutation mut = MapRDBImpl.newMutation();
        mut.setOrReplace("a.b.c", (Map)MapRDBImpl.newDocument().set("eliu", 5)).setOrReplace("p.q", Arrays.asList("o", "p", "q")).setOrReplace("a.c.d", 100).setOrReplace("e", 1000);
        table.update("key", mut);
        table.flush();
        DBTests.waitForIndexFlush(table.getPath());
        Table indexTable = MapRDBImpl.getIndexTable((IndexDesc)i1Desc);
        ConditionImpl qc = MapRDBImpl.newCondition().is("a.b.c", QueryCondition.Op.EQUAL, 5).build();
        DocumentStream stream = indexTable.find((QueryCondition)qc, new String[]{"a.b.c"});
        Iterator itr = stream.iterator();
        Assert.assertFalse((boolean)itr.hasNext());
        mut.setOrReplace("a.b.c", 11).setOrReplace("p.q", "Eugene").setOrReplace("a.c.d", 12).setOrReplace("e", 18);
        table.update("key", mut);
        DBTests.waitForIndexFlush(table.getPath());
        qc = MapRDBImpl.newCondition().and().is("a.b.c", QueryCondition.Op.GREATER, 10).is("p.q", QueryCondition.Op.EQUAL, "Eugene").close().build();
        stream = indexTable.find((QueryCondition)qc, new String[]{"a.b.c"});
        itr = stream.iterator();
        Document doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertFalse((boolean)itr.hasNext());
    }

    @Test
    public void testCastToNumeric() throws Exception {
        String i1 = "TestIndexTable-testCastToNumeric-" + Long.toString(System.currentTimeMillis());
        IndexDesc i1Desc = this.createIndex(table, i1, "'\"$CAST(i@INT)\",\"$CAST(l@LONG)\",\"$CAST(f@FLOAT)\",\"$CAST(d@DOUBLE)\"'", null);
        DocumentMutation mut = MapRDBImpl.newMutation();
        mut.setOrReplace("i", "1357").setOrReplace("l", "1357").setOrReplace("f", "1357").setOrReplace("d", "1357");
        table.update("fromString", mut);
        mut = MapRDBImpl.newMutation();
        mut.setOrReplace("i", Short.MAX_VALUE).setOrReplace("l", Short.MAX_VALUE).setOrReplace("f", Short.MAX_VALUE).setOrReplace("d", Short.MAX_VALUE);
        table.update("fromShort", mut);
        mut = MapRDBImpl.newMutation();
        mut.setOrReplace("i", Integer.MAX_VALUE).setOrReplace("l", Integer.MAX_VALUE).setOrReplace("f", Integer.MAX_VALUE).setOrReplace("d", Integer.MAX_VALUE);
        table.update("fromInt", mut);
        mut = MapRDBImpl.newMutation();
        mut.setOrReplace("i", Long.MAX_VALUE).setOrReplace("l", Long.MAX_VALUE).setOrReplace("f", Long.MAX_VALUE).setOrReplace("d", Long.MAX_VALUE);
        table.update("fromLong", mut);
        mut = MapRDBImpl.newMutation();
        mut.setOrReplace("i", 31400.0f).setOrReplace("l", 31400.0f).setOrReplace("f", 31400.0f).setOrReplace("d", 31400.0f);
        table.update("fromFloat", mut);
        mut = MapRDBImpl.newMutation();
        mut.setOrReplace("i", 3.142345678).setOrReplace("l", 3.142345678).setOrReplace("f", 3.142345678).setOrReplace("d", 3.142345678);
        table.update("fromDouble", mut);
        mut = MapRDBImpl.newMutation();
        mut.setOrReplace("i", true).setOrReplace("l", false);
        table.update("fromBool", mut);
        mut = MapRDBImpl.newMutation();
        mut.setOrReplace("i", Bytes.toByteBuffer((String)"1000000")).setOrReplace("l", Bytes.toByteBuffer((String)"1000000")).setOrReplace("d", Bytes.toByteBuffer((String)"1000000")).setOrReplace("f", Bytes.toByteBuffer((String)"1000000"));
        table.update("fromBinary", mut);
        table.flush();
        DBTests.waitForIndexFlush(table.getPath());
        Table indexTable = MapRDBImpl.getIndexTable((IndexDesc)i1Desc);
        ConditionImpl qc = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, 1357).build();
        Iterator dsItr = indexTable.find((QueryCondition)qc).iterator();
        Document doc = (Document)dsItr.next();
        Assert.assertFalse((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"fromString", (Object)doc.getIdString());
        Assert.assertEquals((long)1357L, (long)doc.getLong("$1"));
        Assert.assertEquals((double)1357.0, (double)doc.getFloat("$2"), (double)0.0);
        Assert.assertEquals((double)1357.0, (double)doc.getDouble("$3"), (double)0.0);
        qc = MapRDBImpl.newCondition().is("$1", QueryCondition.Op.EQUAL, Short.MAX_VALUE).build();
        dsItr = indexTable.find((QueryCondition)qc).iterator();
        doc = (Document)dsItr.next();
        Assert.assertFalse((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"fromShort", (Object)doc.getIdString());
        Assert.assertEquals((long)32767L, (long)doc.getLong("$1"));
        Assert.assertEquals((double)32767.0, (double)doc.getFloat("$2"), (double)0.0);
        Assert.assertEquals((double)32767.0, (double)doc.getDouble("$3"), (double)0.0);
        qc = MapRDBImpl.newCondition().is("$1", QueryCondition.Op.EQUAL, Integer.MAX_VALUE).build();
        dsItr = indexTable.find((QueryCondition)qc).iterator();
        doc = (Document)dsItr.next();
        Assert.assertFalse((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"fromInt", (Object)doc.getIdString());
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)doc.getLong("$1"));
        Assert.assertEquals((double)2.147483648E9, (double)doc.getFloat("$2"), (double)0.0);
        Assert.assertEquals((double)2.147483647E9, (double)doc.getDouble("$3"), (double)0.0);
        qc = MapRDBImpl.newCondition().is("$1", QueryCondition.Op.EQUAL, Long.MAX_VALUE).build();
        dsItr = indexTable.find((QueryCondition)qc).iterator();
        doc = (Document)dsItr.next();
        Assert.assertFalse((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"fromLong", (Object)doc.getIdString());
        Assert.assertEquals((long)-1L, (long)doc.getInt("$0"));
        Assert.assertEquals((double)9.223372036854776E18, (double)doc.getFloat("$2"), (double)0.0);
        Assert.assertEquals((double)9.223372036854776E18, (double)doc.getDouble("$3"), (double)0.0);
        qc = MapRDBImpl.newCondition().is("$2", QueryCondition.Op.EQUAL, 31400.0f).build();
        dsItr = indexTable.find((QueryCondition)qc).iterator();
        doc = (Document)dsItr.next();
        Assert.assertFalse((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"fromFloat", (Object)doc.getIdString());
        Assert.assertEquals((long)31400L, (long)doc.getInt("$0"));
        Assert.assertEquals((double)31400.0, (double)doc.getLong("$1"), (double)0.0);
        Assert.assertEquals((double)31400.0, (double)doc.getDouble("$3"), (double)0.0);
        qc = MapRDBImpl.newCondition().is("$3", QueryCondition.Op.EQUAL, 3.142345678).build();
        dsItr = indexTable.find((QueryCondition)qc).iterator();
        doc = (Document)dsItr.next();
        Assert.assertFalse((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"fromDouble", (Object)doc.getIdString());
        Assert.assertEquals((long)3L, (long)doc.getInt("$0"));
        Assert.assertEquals((double)3.0, (double)doc.getLong("$1"), (double)0.0);
        Assert.assertEquals((double)3.142345666885376, (double)doc.getFloat("$2"), (double)0.0);
        qc = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, 1).build();
        dsItr = indexTable.find((QueryCondition)qc).iterator();
        doc = (Document)dsItr.next();
        Assert.assertFalse((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"fromBool", (Object)doc.getIdString());
        Assert.assertEquals((long)0L, (long)doc.getLong("$1"));
        qc = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, 1000000).build();
        dsItr = indexTable.find((QueryCondition)qc).iterator();
        doc = (Document)dsItr.next();
        Assert.assertFalse((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"fromBinary", (Object)doc.getIdString());
        Assert.assertEquals((long)1000000L, (long)doc.getLong("$1"));
        Assert.assertEquals((double)1000000.0, (double)doc.getFloat("$2"), (double)0.0);
        Assert.assertEquals((double)1000000.0, (double)doc.getDouble("$3"), (double)0.0);
    }

    @Test
    public void testCastToNumeric2() throws Exception {
        String i1 = "TestIndexTable-testCastToNumeric2-" + Long.toString(System.currentTimeMillis());
        IndexDesc i1Desc = this.createIndex(table, i1, "'\"$CAST(i@INT)\",\"$CAST(l@LONG)\",\"$CAST(f@FLOAT)\",\"$CAST(d@DOUBLE)\"'", null);
        DocumentMutation mut = MapRDBImpl.newMutation();
        mut.setOrReplace("i", "1357").setOrReplace("l", "1357").setOrReplace("f", "1357").setOrReplace("d", "1357");
        table.update("fromString", mut);
        mut = MapRDBImpl.newMutation();
        mut.setOrReplace("i", Short.MAX_VALUE).setOrReplace("l", Short.MAX_VALUE).setOrReplace("f", Short.MAX_VALUE).setOrReplace("d", Short.MAX_VALUE);
        table.update("fromShort", mut);
        mut = MapRDBImpl.newMutation();
        mut.setOrReplace("i", Integer.MAX_VALUE).setOrReplace("l", Integer.MAX_VALUE).setOrReplace("f", Integer.MAX_VALUE).setOrReplace("d", Integer.MAX_VALUE);
        table.update("fromInt", mut);
        mut = MapRDBImpl.newMutation();
        mut.setOrReplace("i", Long.MAX_VALUE).setOrReplace("l", Long.MAX_VALUE).setOrReplace("f", Long.MAX_VALUE).setOrReplace("d", Long.MAX_VALUE);
        table.update("fromLong", mut);
        mut = MapRDBImpl.newMutation();
        mut.setOrReplace("i", 31400.0f).setOrReplace("l", 31400.0f).setOrReplace("f", 31400.0f).setOrReplace("d", 31400.0f);
        table.update("fromFloat", mut);
        mut = MapRDBImpl.newMutation();
        mut.setOrReplace("i", 3.142345678).setOrReplace("l", 3.142345678).setOrReplace("f", 3.142345678).setOrReplace("d", 3.142345678);
        table.update("fromDouble", mut);
        mut = MapRDBImpl.newMutation();
        mut.setOrReplace("i", true).setOrReplace("l", false);
        table.update("fromBool", mut);
        mut = MapRDBImpl.newMutation();
        mut.setOrReplace("i", Bytes.toByteBuffer((String)"1000000")).setOrReplace("l", Bytes.toByteBuffer((String)"1000000")).setOrReplace("d", Bytes.toByteBuffer((String)"1000000")).setOrReplace("f", Bytes.toByteBuffer((String)"1000000"));
        table.update("fromBinary", mut);
        table.flush();
        DBTests.waitForIndexFlush(table.getPath());
        Table indexTable = MapRDBImpl.getIndexTable((IndexDesc)i1Desc);
        MetaTable indexMetaTable = indexTable.getMetaTable();
        ConditionImpl qc = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, 1357).build();
        List scanRanges = indexMetaTable.getScanRanges((QueryCondition)qc);
        Assert.assertNotNull((Object)scanRanges);
        Assert.assertEquals((long)1L, (long)scanRanges.size());
        ScanRange range = (ScanRange)scanRanges.get(0);
        Iterator dsItr = indexTable.find(range.getCondition()).iterator();
        Document doc = (Document)dsItr.next();
        Assert.assertFalse((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"fromString", (Object)doc.getIdString());
        Assert.assertEquals((long)1357L, (long)doc.getLong("$1"));
        Assert.assertEquals((double)1357.0, (double)doc.getFloat("$2"), (double)0.0);
        Assert.assertEquals((double)1357.0, (double)doc.getDouble("$3"), (double)0.0);
        qc = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, 1000000).build();
        scanRanges = indexMetaTable.getScanRanges((QueryCondition)qc);
        Assert.assertNotNull((Object)scanRanges);
        Assert.assertEquals((long)1L, (long)scanRanges.size());
        range = (ScanRange)scanRanges.get(0);
        dsItr = indexTable.find(range.getCondition()).iterator();
        doc = (Document)dsItr.next();
        Assert.assertFalse((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"fromBinary", (Object)doc.getIdString());
        Assert.assertEquals((long)1000000L, (long)doc.getLong("$1"));
        Assert.assertEquals((double)1000000.0, (double)doc.getFloat("$2"), (double)0.0);
        Assert.assertEquals((double)1000000.0, (double)doc.getDouble("$3"), (double)0.0);
    }

    @Test
    public void testCastCompositeIndexesString() throws Exception {
        String i1 = "TestIndexTable-testCastCompIndexesString-" + Long.toString(System.currentTimeMillis());
        IndexDesc i1Desc = this.createIndex(table, i1, "'\"$CAST(a@STRING)\",\"$CAST(b@STRING)\"'", null);
        DocumentMutation mut = MapRDBImpl.newMutation();
        mut.setOrReplace("a", 1234).setOrReplace("b", 56);
        table.update("k1", mut);
        mut.setOrReplace("a", 1).setOrReplace("b", 2345678);
        table.update("k2", mut);
        mut.setOrReplace("a", 350.0f).setOrReplace("b", false);
        table.update("k3", mut);
        mut.setOrReplace("a", true).setOrReplace("b", "bval");
        table.update("k4", mut);
        mut.setOrReplace("a", Long.MAX_VALUE).setOrReplace("b", 2.0);
        table.update("k5", mut);
        mut.setOrReplace("a", Bytes.toByteBuffer((String)"testStringA")).setOrReplace("b", Bytes.toByteBuffer((String)"testStringB"));
        table.update("k6", mut);
        ODate date1 = ODate.parse((String)"1977-05-20");
        ODate date2 = ODate.parse((String)"2006-02-07");
        mut.setOrReplace("a", date1).setOrReplace("b", date2);
        table.update("days", mut);
        OTime t1 = OTime.parse((String)"09:01:39.001");
        OTime t2 = OTime.parse((String)"23:59:25.234");
        mut.setOrReplace("a", t1).setOrReplace("b", t2);
        table.update("times", mut);
        OTimestamp ts1 = OTimestamp.parse((String)"2017-06-17T13:30:05.999Z");
        OTimestamp ts2 = OTimestamp.parse((String)"1947-08-15T00:05:59.156Z");
        mut.setOrReplace("a", ts1).setOrReplace("b", ts2);
        table.update("timestamps", mut);
        table.flush();
        DBTests.waitForIndexFlush(table.getPath());
        Table indexTable = MapRDBImpl.getIndexTable((IndexDesc)i1Desc);
        ConditionImpl qc = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, "1234").build();
        Iterator dsItr = indexTable.find((QueryCondition)qc).iterator();
        Document doc = (Document)dsItr.next();
        Assert.assertFalse((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"k1", (Object)doc.getIdString());
        Assert.assertEquals((Object)"56", (Object)doc.getString("$1"));
        qc = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, "1").build();
        dsItr = indexTable.find((QueryCondition)qc).iterator();
        doc = (Document)dsItr.next();
        Assert.assertFalse((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"k2", (Object)doc.getIdString());
        Assert.assertEquals((Object)"2345678", (Object)doc.getString("$1"));
        qc = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, "350.000000").build();
        dsItr = indexTable.find((QueryCondition)qc).iterator();
        doc = (Document)dsItr.next();
        Assert.assertFalse((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"k3", (Object)doc.getIdString());
        Assert.assertEquals((Object)"false", (Object)doc.getString("$1"));
        qc = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, "true").build();
        dsItr = indexTable.find((QueryCondition)qc).iterator();
        doc = (Document)dsItr.next();
        Assert.assertFalse((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"k4", (Object)doc.getIdString());
        Assert.assertEquals((Object)"bval", (Object)doc.getString("$1"));
        qc = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, "9223372036854775807").build();
        dsItr = indexTable.find((QueryCondition)qc).iterator();
        doc = (Document)dsItr.next();
        Assert.assertFalse((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"k5", (Object)doc.getIdString());
        Assert.assertEquals((Object)"2.000000", (Object)doc.getString("$1"));
        qc = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, "testStringA");
        dsItr = indexTable.find((QueryCondition)qc).iterator();
        doc = (Document)dsItr.next();
        Assert.assertFalse((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"k6", (Object)doc.getIdString());
        Assert.assertEquals((Object)"testStringB", (Object)doc.getString("$1"));
        qc = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, "1977-05-20").build();
        dsItr = indexTable.find((QueryCondition)qc).iterator();
        doc = (Document)dsItr.next();
        Assert.assertFalse((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"days", (Object)doc.getIdString());
        Assert.assertEquals((Object)"2006-02-07", (Object)doc.getString("$1"));
        qc = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, "09:01:39.001").build();
        dsItr = indexTable.find((QueryCondition)qc).iterator();
        doc = (Document)dsItr.next();
        Assert.assertFalse((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"times", (Object)doc.getIdString());
        Assert.assertEquals((Object)"23:59:25.234", (Object)doc.getString("$1"));
        qc = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, "2017-06-17 13:30:05.999").build();
        dsItr = indexTable.find((QueryCondition)qc).iterator();
        doc = (Document)dsItr.next();
        Assert.assertFalse((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"timestamps", (Object)doc.getIdString());
        Assert.assertEquals((Object)"1947-08-15 00:06:00.-844", (Object)doc.getString("$1"));
    }

    @Test
    public void testCastToTimestamp() throws Exception {
        String i1 = "TestIndexTable-testCastToTime-" + Long.toString(System.currentTimeMillis());
        IndexDesc i1Desc = this.createIndex(table, i1, "'\"$CAST(a@TIMESTAMP)\"'", null);
        DocumentMutation mut = MapRDBImpl.newMutation();
        mut.setOrReplace("a", 732000);
        table.update("fromInt", mut);
        mut = MapRDBImpl.newMutation();
        mut.setOrReplace("a", 1497701532456L);
        table.update("fromLong", mut);
        mut = MapRDBImpl.newMutation();
        mut.setOrReplace("a", "2006-02-07 12:36:02.750");
        table.update("fromString", mut);
        OTimestamp ts = OTimestamp.parse((String)"1977-01-02T04:59:59.267Z");
        mut = MapRDBImpl.newMutation();
        mut.setOrReplace("a", ts);
        table.update("fromTimestamp", mut);
        ODate date = ODate.parse((String)"1977-05-20");
        mut = MapRDBImpl.newMutation();
        mut.setOrReplace("a", date);
        table.update("fromDate", mut);
        mut = MapRDBImpl.newMutation();
        mut.setOrReplace("a", Bytes.toByteBuffer((String)"2020-12-31 20:20:20.020"));
        table.update("fromBinary", mut);
        table.flush();
        DBTests.waitForIndexFlush(table.getPath());
        Table indexTable = MapRDBImpl.getIndexTable((IndexDesc)i1Desc);
        OTimestamp ts1 = OTimestamp.parse((String)"1970-01-01T00:12:12.000Z");
        ConditionImpl qc = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, ts1).build();
        Iterator dsItr = indexTable.find((QueryCondition)qc).iterator();
        Document doc = (Document)dsItr.next();
        Assert.assertFalse((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"fromInt", (Object)doc.getIdString());
        ts1 = OTimestamp.parse((String)"2017-06-17T12:12:12.456Z");
        qc = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, ts1).build();
        dsItr = indexTable.find((QueryCondition)qc).iterator();
        doc = (Document)dsItr.next();
        Assert.assertFalse((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"fromLong", (Object)doc.getIdString());
        ts1 = OTimestamp.parse((String)"2006-02-07T12:36:02.750Z");
        qc = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, ts1).build();
        dsItr = indexTable.find((QueryCondition)qc).iterator();
        doc = (Document)dsItr.next();
        Assert.assertFalse((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"fromString", (Object)doc.getIdString());
        ts1 = OTimestamp.parse((String)"1977-01-02T04:59:59.267Z");
        qc = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, ts1).build();
        dsItr = indexTable.find((QueryCondition)qc).iterator();
        doc = (Document)dsItr.next();
        Assert.assertFalse((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"fromTimestamp", (Object)doc.getIdString());
        ts1 = OTimestamp.parse((String)"1977-05-20T00:00:00.000Z");
        qc = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, ts1).build();
        dsItr = indexTable.find((QueryCondition)qc).iterator();
        doc = (Document)dsItr.next();
        Assert.assertFalse((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"fromDate", (Object)doc.getIdString());
        ts1 = OTimestamp.parse((String)"2020-12-31T20:20:20.020Z");
        qc = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, ts1).build();
        dsItr = indexTable.find((QueryCondition)qc).iterator();
        doc = (Document)dsItr.next();
        Assert.assertFalse((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"fromBinary", (Object)doc.getIdString());
    }

    @Test
    public void testCastToTime() throws Exception {
        String i1 = "TestIndexTable-testCastToTime-" + Long.toString(System.currentTimeMillis());
        IndexDesc i1Desc = this.createIndex(table, i1, "'\"$CAST(a@TIME)\"'", null);
        DocumentMutation mut = MapRDBImpl.newMutation();
        mut.setOrReplace("a", 100000);
        table.update("fromInt", mut);
        mut = MapRDBImpl.newMutation();
        mut.setOrReplace("a", 84640123L);
        table.update("fromLong", mut);
        mut = MapRDBImpl.newMutation();
        mut.setOrReplace("a", "10:01:02.750");
        table.update("fromString", mut);
        OTimestamp ts = OTimestamp.parse((String)"1977-01-02T04:59:59.267Z");
        mut = MapRDBImpl.newMutation();
        mut.setOrReplace("a", ts);
        table.update("fromTimestamp", mut);
        ODate date = ODate.parse((String)"1977-05-20");
        mut = MapRDBImpl.newMutation();
        mut.setOrReplace("a", date);
        table.update("fromDate", mut);
        OTime t1 = OTime.parse((String)"12:00:00.000");
        mut = MapRDBImpl.newMutation();
        mut.setOrReplace("a", t1);
        table.update("fromTime", mut);
        table.flush();
        DBTests.waitForIndexFlush(table.getPath());
        Table indexTable = MapRDBImpl.getIndexTable((IndexDesc)i1Desc);
        OTime time1 = OTime.parse((String)"00:01:40.000");
        ConditionImpl qc = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, time1).build();
        Iterator dsItr = indexTable.find((QueryCondition)qc).iterator();
        Document doc = (Document)dsItr.next();
        Assert.assertFalse((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"fromInt", (Object)doc.getIdString());
        time1 = OTime.parse((String)"23:30:40.123");
        qc = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, time1).build();
        dsItr = indexTable.find((QueryCondition)qc).iterator();
        doc = (Document)dsItr.next();
        Assert.assertFalse((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"fromLong", (Object)doc.getIdString());
        time1 = OTime.parse((String)"10:01:02.750");
        qc = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, time1).build();
        dsItr = indexTable.find((QueryCondition)qc).iterator();
        doc = (Document)dsItr.next();
        Assert.assertFalse((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"fromString", (Object)doc.getIdString());
        time1 = OTime.parse((String)"04:59:59.267");
        qc = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, time1).build();
        dsItr = indexTable.find((QueryCondition)qc).iterator();
        doc = (Document)dsItr.next();
        Assert.assertFalse((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"fromTimestamp", (Object)doc.getIdString());
        time1 = OTime.parse((String)"00:00:00.000");
        qc = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, time1).build();
        dsItr = indexTable.find((QueryCondition)qc).iterator();
        doc = (Document)dsItr.next();
        Assert.assertFalse((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"fromDate", (Object)doc.getIdString());
        time1 = OTime.parse((String)"12:00:00.000");
        qc = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, time1).build();
        dsItr = indexTable.find((QueryCondition)qc).iterator();
        doc = (Document)dsItr.next();
        Assert.assertFalse((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"fromTime", (Object)doc.getIdString());
    }

    @Test
    public void testCastToDate() throws Exception {
        String i1 = "TestIndexTable-testCastToDate-" + Long.toString(System.currentTimeMillis());
        IndexDesc i1Desc = this.createIndex(table, i1, "'\"$CAST(a@DATE)\"'", null);
        DocumentMutation mut = MapRDBImpl.newMutation();
        mut.setOrReplace("a", 100000);
        table.update("fromInt", mut);
        mut = MapRDBImpl.newMutation();
        mut.setOrReplace("a", 1497651277000L);
        table.update("fromLong", mut);
        mut = MapRDBImpl.newMutation();
        mut.setOrReplace("a", "2000-12-31");
        table.update("fromString", mut);
        OTimestamp ts = OTimestamp.parse((String)"1977-01-02T04:30:45.267Z");
        mut = MapRDBImpl.newMutation();
        mut.setOrReplace("a", ts);
        table.update("fromTimestamp", mut);
        ODate date = ODate.parse((String)"1977-05-20");
        mut = MapRDBImpl.newMutation();
        mut.setOrReplace("a", date);
        table.update("fromDate", mut);
        table.flush();
        DBTests.waitForIndexFlush(table.getPath());
        Table indexTable = MapRDBImpl.getIndexTable((IndexDesc)i1Desc);
        ODate date1 = ODate.parse((String)"1970-01-01");
        ConditionImpl qc = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, date1).build();
        Iterator dsItr = indexTable.find((QueryCondition)qc).iterator();
        Document doc = (Document)dsItr.next();
        Assert.assertFalse((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"fromInt", (Object)doc.getIdString());
        date1 = ODate.parse((String)"2017-06-16");
        qc = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, date1).build();
        dsItr = indexTable.find((QueryCondition)qc).iterator();
        doc = (Document)dsItr.next();
        Assert.assertFalse((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"fromLong", (Object)doc.getIdString());
        date1 = ODate.parse((String)"2000-12-31");
        qc = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, date1).build();
        dsItr = indexTable.find((QueryCondition)qc).iterator();
        doc = (Document)dsItr.next();
        Assert.assertFalse((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"fromString", (Object)doc.getIdString());
        date1 = ODate.parse((String)"1977-01-02");
        qc = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, date1).build();
        dsItr = indexTable.find((QueryCondition)qc).iterator();
        doc = (Document)dsItr.next();
        Assert.assertFalse((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"fromTimestamp", (Object)doc.getIdString());
        date1 = ODate.parse((String)"1977-05-20");
        qc = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, date1).build();
        dsItr = indexTable.find((QueryCondition)qc).iterator();
        doc = (Document)dsItr.next();
        Assert.assertFalse((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"fromDate", (Object)doc.getIdString());
    }

    @Test
    public void testCastToBool() throws Exception {
        Document doc;
        String i1 = "TestIndexTable-testCastToBool-" + Long.toString(System.currentTimeMillis());
        IndexDesc i1Desc = this.createIndex(table, i1, "'\"$CAST(b@BOOLEAN)\"'", null);
        DocumentMutation mut = MapRDBImpl.newMutation();
        mut.setOrReplace("b", (short)25);
        table.update("fromShort", mut);
        mut.setOrReplace("b", 0);
        table.update("fromInt", mut);
        mut.setOrReplace("b", 1L);
        table.update("fromLong", mut);
        mut.setOrReplace("b", 0.0f);
        table.update("fromFloat", mut);
        mut.setOrReplace("b", 9.0);
        table.update("fromDouble", mut);
        mut.setOrReplace("b", "true");
        table.update("fromTrue", mut);
        mut.setOrReplace("b", "YeS");
        table.update("fromYes", mut);
        mut.setOrReplace("b", "On");
        table.update("fromOn", mut);
        mut.setOrReplace("b", "Y");
        table.update("fromY", mut);
        mut.setOrReplace("b", "t");
        table.update("fromT", mut);
        mut.setOrReplace("b", "1");
        table.update("fromOne", mut);
        mut.setOrReplace("b", "faLse");
        table.update("fromFalse", mut);
        mut.setOrReplace("b", "no");
        table.update("fromNo", mut);
        mut.setOrReplace("b", "OFf");
        table.update("fromOff", mut);
        mut.setOrReplace("b", "n");
        table.update("fromN", mut);
        mut.setOrReplace("b", "F");
        table.update("fromF", mut);
        mut.setOrReplace("b", "0");
        table.update("fromZero", mut);
        table.flush();
        DBTests.waitForIndexFlush(table.getPath());
        Table indexTable = MapRDBImpl.getIndexTable((IndexDesc)i1Desc);
        QueryCondition qc = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, true).build();
        Iterator dsItr = indexTable.find(qc).iterator();
        int docs = 0;
        block21: while (dsItr.hasNext()) {
            doc = (Document)dsItr.next();
            switch (++docs) {
                case 1: {
                    Assert.assertEquals((Object)"fromDouble", (Object)doc.getIdString());
                    continue block21;
                }
                case 2: {
                    Assert.assertEquals((Object)"fromLong", (Object)doc.getIdString());
                    continue block21;
                }
                case 3: {
                    Assert.assertEquals((Object)"fromOn", (Object)doc.getIdString());
                    continue block21;
                }
                case 4: {
                    Assert.assertEquals((Object)"fromOne", (Object)doc.getIdString());
                    continue block21;
                }
                case 5: {
                    Assert.assertEquals((Object)"fromShort", (Object)doc.getIdString());
                    continue block21;
                }
                case 6: {
                    Assert.assertEquals((Object)"fromT", (Object)doc.getIdString());
                    continue block21;
                }
                case 7: {
                    Assert.assertEquals((Object)"fromTrue", (Object)doc.getIdString());
                    continue block21;
                }
                case 8: {
                    Assert.assertEquals((Object)"fromY", (Object)doc.getIdString());
                    continue block21;
                }
                case 9: {
                    Assert.assertEquals((Object)"fromYes", (Object)doc.getIdString());
                    continue block21;
                }
            }
        }
        Assert.assertEquals((long)9L, (long)docs);
        qc = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, false).build();
        dsItr = indexTable.find(qc).iterator();
        docs = 0;
        block22: while (dsItr.hasNext()) {
            doc = (Document)dsItr.next();
            switch (++docs) {
                case 1: {
                    Assert.assertEquals((Object)"fromF", (Object)doc.getIdString());
                    continue block22;
                }
                case 2: {
                    Assert.assertEquals((Object)"fromFalse", (Object)doc.getIdString());
                    continue block22;
                }
                case 3: {
                    Assert.assertEquals((Object)"fromFloat", (Object)doc.getIdString());
                    continue block22;
                }
                case 4: {
                    Assert.assertEquals((Object)"fromInt", (Object)doc.getIdString());
                    continue block22;
                }
                case 5: {
                    Assert.assertEquals((Object)"fromN", (Object)doc.getIdString());
                    continue block22;
                }
                case 6: {
                    Assert.assertEquals((Object)"fromNo", (Object)doc.getIdString());
                    continue block22;
                }
                case 7: {
                    Assert.assertEquals((Object)"fromOff", (Object)doc.getIdString());
                    continue block22;
                }
                case 8: {
                    Assert.assertEquals((Object)"fromZero", (Object)doc.getIdString());
                    continue block22;
                }
            }
        }
        Assert.assertEquals((long)8L, (long)docs);
    }

    @Test
    public void testCastBoolString() throws Exception {
        String i1 = "TestIndexTable-testCastBoolToString-" + Long.toString(System.currentTimeMillis());
        String i2 = "TestIndexTable-testCastStringToBool-" + Long.toString(System.currentTimeMillis());
        IndexDesc i1Desc = this.createIndex(table, i1, "'\"$CAST(y@STRING)\"'", null);
        IndexDesc i2Desc = this.createIndex(table, i2, "'\"$CAST(z@BOOLEAN)\"'", null);
        DocumentMutation mut = MapRDBImpl.newMutation();
        mut.setOrReplace("y", false).setOrReplace("z", "false");
        table.update("falsekey", mut);
        mut.setOrReplace("y", true).setOrReplace("z", "true");
        table.update("truekey", mut);
        table.flush();
        DBTests.waitForIndexFlush(table.getPath());
        Table indexTable = MapRDBImpl.getIndexTable((IndexDesc)i1Desc);
        Iterator dsItr = indexTable.find().iterator();
        int docs = 0;
        while (dsItr.hasNext()) {
            ++docs;
            dsItr.next();
        }
        Assert.assertEquals((long)2L, (long)docs);
        ConditionImpl qc = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, "false").build();
        dsItr = indexTable.find((QueryCondition)qc, new String[]{"$0"}).iterator();
        Document doc = (Document)dsItr.next();
        Assert.assertEquals((Object)"falsekey", (Object)doc.getIdString());
        Assert.assertFalse((boolean)dsItr.hasNext());
        qc = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, "true").build();
        dsItr = indexTable.find((QueryCondition)qc, new String[]{"$0"}).iterator();
        doc = (Document)dsItr.next();
        Assert.assertEquals((Object)"truekey", (Object)doc.getIdString());
        Assert.assertFalse((boolean)dsItr.hasNext());
        indexTable = MapRDBImpl.getIndexTable((IndexDesc)i2Desc);
        dsItr = indexTable.find().iterator();
        docs = 0;
        while (dsItr.hasNext()) {
            ++docs;
            dsItr.next();
        }
        Assert.assertEquals((long)2L, (long)docs);
        qc = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, false).build();
        dsItr = indexTable.find((QueryCondition)qc, new String[]{"$0"}).iterator();
        doc = (Document)dsItr.next();
        Assert.assertEquals((Object)"falsekey", (Object)doc.getIdString());
        Assert.assertFalse((boolean)dsItr.hasNext());
        qc = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, true).build();
        dsItr = indexTable.find((QueryCondition)qc, new String[]{"$0"}).iterator();
        doc = (Document)dsItr.next();
        Assert.assertEquals((Object)"truekey", (Object)doc.getIdString());
        Assert.assertFalse((boolean)dsItr.hasNext());
    }

    @Test
    public void testConditionFilterCast() throws Exception {
        String i1 = "TestIndexTable-testConditionInteger-" + Long.toString(System.currentTimeMillis());
        IndexDesc i1Desc = this.createIndex(table, i1, "'\"$CAST(a.b.c@INT)\"'", "'\"a.c.d\"'");
        DocumentMutation mut = MapRDBImpl.newMutation();
        mut.setOrReplace("a.b.c", "5").setOrReplace("a.c.d", 100).setOrReplace("e", 1000);
        table.update("key", mut);
        mut.setOrReplace("a.b.c", "11").setOrReplace("a.c.d", 12).setOrReplace("e", 13);
        table.update("key1", mut);
        table.flush();
        DBTests.waitForIndexFlush(table.getPath());
        Table indexTable = MapRDBImpl.getIndexTable((IndexDesc)i1Desc);
        ConditionImpl qc = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, 5).build();
        DocumentStream stream = indexTable.find((QueryCondition)qc, new String[]{"$0"});
        Iterator itr = stream.iterator();
        Document doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().and().is("$0", QueryCondition.Op.LESS, 10).is("$0", QueryCondition.Op.GREATER_OR_EQUAL, 1).close().build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().and().is("$0", QueryCondition.Op.GREATER_OR_EQUAL, 1).is("$0", QueryCondition.Op.LESS, 10).close().build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().and().is("$0", QueryCondition.Op.GREATER_OR_EQUAL, 1).is("$0", QueryCondition.Op.LESS, 10).close().build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().and().is("$0", QueryCondition.Op.LESS, 3).is("$0", QueryCondition.Op.GREATER_OR_EQUAL, 1).close().build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.GREATER_OR_EQUAL, 5).build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        doc = (Document)itr.next();
        System.out.println(doc);
        doc = (Document)itr.next();
        System.out.println(doc);
        qc = MapRDBImpl.newCondition().or().is("$0", QueryCondition.Op.GREATER_OR_EQUAL, 12).is("$0", QueryCondition.Op.LESS_OR_EQUAL, 7).close().build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        doc = (Document)itr.next();
        System.out.println(doc);
        qc = MapRDBImpl.newCondition().or().is("$0", QueryCondition.Op.GREATER_OR_EQUAL, 12).is("$0", QueryCondition.Op.LESS_OR_EQUAL, 2).close().build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        Assert.assertFalse((boolean)itr.hasNext());
    }

    private void runQueryAndCheckResults(Table indexTable, QueryCondition qc, String[] expectedIds) throws Exception {
        this.runQueryAndCheckResults(indexTable, qc, expectedIds, null);
    }

    private void runQueryAndCheckResults(Table indexTable, QueryCondition qc, String[] expectedIds, IndexFieldDesc[] fieldDescArray) throws Exception {
        int i;
        if (fieldDescArray != null) {
            ConditionImpl cond = (ConditionImpl)qc;
            cond.setPartitionKeys(fieldDescArray);
        }
        DocumentStream stream = indexTable.find(qc);
        Iterator itr = stream.iterator();
        Assert.assertTrue((expectedIds.length == 0 && !itr.hasNext() || expectedIds.length != 0 && itr.hasNext() ? 1 : 0) != 0);
        if (expectedIds.length == 0) {
            return;
        }
        HashMap<String, Integer> ei = new HashMap<String, Integer>();
        for (i = 0; i < expectedIds.length; ++i) {
            ei.put(expectedIds[i], 0);
        }
        for (i = 0; i < expectedIds.length; ++i) {
            Document doc = (Document)itr.next();
            System.out.println("0. id = " + doc.getIdString());
            Assert.assertTrue((boolean)ei.containsKey(doc.getIdString()));
        }
        Assert.assertFalse((boolean)itr.hasNext());
    }

    private void runQueries(Table indexTable, QueryCondition qc, String[] expectedIds, IndexFieldDesc[] fieldDescArray) throws Exception {
        this.runQueryAndCheckResults(indexTable, qc, expectedIds);
        this.runQueryAndCheckResults(indexTable, qc, expectedIds, fieldDescArray);
    }

    private String getIndexAddFieldSpecification(String indexedField, boolean descending) {
        return "'\"" + indexedField + (descending ? "\":-1'" : "\"'");
    }

    private void testQueryConditionOnTime(String indexedField0, String indexedField1, boolean firstIndexedFieldIsDescending) throws Exception {
        String i1 = "TestIndexTable-testQueryConditionOnTime-" + Long.toString(System.currentTimeMillis());
        IndexDesc i1Desc = this.createIndex(table, i1, this.getIndexAddFieldSpecification(indexedField0, firstIndexedFieldIsDescending), this.getIndexAddFieldSpecification(indexedField1, false));
        List fieldDescList = i1Desc.getIndexedFields();
        IndexFieldDesc[] fieldDescArray = new IndexFieldDesc[fieldDescList.size()];
        fieldDescList.toArray(fieldDescArray);
        int numberOfDocs = 10;
        DocumentMutation mut = MapRDBImpl.newMutation();
        for (int i = 0; i < numberOfDocs; ++i) {
            mut.setOrReplace(indexedField0, OTime.parse((String)("20:12:0" + i))).setOrReplace(indexedField1, 100).setOrReplace("e", 1000);
            table.update("id" + i, mut);
        }
        table.flush();
        DBTests.waitForIndexFlush(table.getPath());
        Table indexTable = MapRDBImpl.getIndexTable((IndexDesc)i1Desc);
        this.runQueries(indexTable, (QueryCondition)MapRDBImpl.newCondition().is(indexedField0, QueryCondition.Op.EQUAL, OTime.parse((String)"20:12:05")).build(), new String[]{"id5"}, fieldDescArray);
        this.runQueries(indexTable, (QueryCondition)MapRDBImpl.newCondition().is(indexedField0, QueryCondition.Op.EQUAL, OTime.parse((String)"20:12:55")).build(), new String[0], fieldDescArray);
        this.runQueries(indexTable, (QueryCondition)MapRDBImpl.newCondition().is(indexedField0, QueryCondition.Op.LESS_OR_EQUAL, OTime.parse((String)"20:12:05")).build(), new String[]{"id0", "id1", "id2", "id3", "id4", "id5"}, fieldDescArray);
        this.runQueries(indexTable, (QueryCondition)MapRDBImpl.newCondition().is(indexedField0, QueryCondition.Op.LESS, OTime.parse((String)"20:12:05")).build(), new String[]{"id0", "id1", "id2", "id3", "id4"}, fieldDescArray);
        this.runQueries(indexTable, (QueryCondition)MapRDBImpl.newCondition().is(indexedField0, QueryCondition.Op.GREATER_OR_EQUAL, OTime.parse((String)"20:12:05")).build(), new String[]{"id5", "id6", "id7", "id8", "id9"}, fieldDescArray);
        this.runQueries(indexTable, (QueryCondition)MapRDBImpl.newCondition().is(indexedField0, QueryCondition.Op.GREATER, OTime.parse((String)"20:12:05")).build(), new String[]{"id6", "id7", "id8", "id9"}, fieldDescArray);
        this.runQueries(indexTable, (QueryCondition)MapRDBImpl.newCondition().is(indexedField0, QueryCondition.Op.GREATER_OR_EQUAL, OTime.parse((String)"20:12:55")).build(), new String[0], fieldDescArray);
        this.runQueries(indexTable, (QueryCondition)MapRDBImpl.newCondition().and().is(indexedField0, QueryCondition.Op.EQUAL, OTime.parse((String)"20:12:05")).is(indexedField0, QueryCondition.Op.EQUAL, OTime.parse((String)"20:12:05")).close().build(), new String[]{"id5"}, fieldDescArray);
        this.runQueryAndCheckResults(indexTable, (QueryCondition)MapRDBImpl.newCondition().and().is(indexedField0, QueryCondition.Op.EQUAL, OTime.parse((String)"20:12:05")).is(indexedField0, QueryCondition.Op.EQUAL, OTime.parse((String)"20:12:07")).close().build(), new String[0]);
    }

    @Test
    public void testConditionOnTime() throws Exception {
        boolean firstIndexedFieldIsDescending = true;
        this.testQueryConditionOnTime("a.b.c", "a.c.d", firstIndexedFieldIsDescending);
        firstIndexedFieldIsDescending = false;
        this.testQueryConditionOnTime("a.b.c", "a.c.d", firstIndexedFieldIsDescending);
    }

    private void testQueryConditionOnString(String indexedField0, String indexedField1, boolean firstIndexedFieldIsDescending) throws Exception {
        String i1 = "TestIndexTable-testQueryConditionOnString-" + Long.toString(System.currentTimeMillis());
        IndexDesc i1Desc = this.createIndex(table, i1, this.getIndexAddFieldSpecification(indexedField0, firstIndexedFieldIsDescending), this.getIndexAddFieldSpecification(indexedField1, false));
        List fieldDescList = i1Desc.getIndexedFields();
        IndexFieldDesc[] fieldDescArray = new IndexFieldDesc[fieldDescList.size()];
        fieldDescList.toArray(fieldDescArray);
        int numberOfDocs = 10;
        DocumentMutation mut = MapRDBImpl.newMutation();
        for (int i = 0; i < numberOfDocs; ++i) {
            mut.setOrReplace(indexedField0, "id" + i).setOrReplace(indexedField1, 100).setOrReplace("e", 1000);
            table.update("id" + i, mut);
        }
        table.flush();
        DBTests.waitForIndexFlush(table.getPath());
        Table indexTable = MapRDBImpl.getIndexTable((IndexDesc)i1Desc);
        this.runQueries(indexTable, (QueryCondition)MapRDBImpl.newCondition().is(indexedField0, QueryCondition.Op.EQUAL, "id5").build(), new String[]{"id5"}, fieldDescArray);
        this.runQueries(indexTable, (QueryCondition)MapRDBImpl.newCondition().is(indexedField0, QueryCondition.Op.EQUAL, "id99").build(), new String[0], fieldDescArray);
        this.runQueries(indexTable, (QueryCondition)MapRDBImpl.newCondition().is(indexedField0, QueryCondition.Op.LESS_OR_EQUAL, "id5").build(), new String[]{"id0", "id1", "id2", "id3", "id4", "id5"}, fieldDescArray);
        this.runQueries(indexTable, (QueryCondition)MapRDBImpl.newCondition().is(indexedField0, QueryCondition.Op.LESS, "id5").build(), new String[]{"id0", "id1", "id2", "id3", "id4"}, fieldDescArray);
        this.runQueries(indexTable, (QueryCondition)MapRDBImpl.newCondition().is(indexedField0, QueryCondition.Op.GREATER_OR_EQUAL, "id5").build(), new String[]{"id5", "id6", "id7", "id8", "id9"}, fieldDescArray);
        this.runQueries(indexTable, (QueryCondition)MapRDBImpl.newCondition().is(indexedField0, QueryCondition.Op.GREATER, "id5").build(), new String[]{"id6", "id7", "id8", "id9"}, fieldDescArray);
        this.runQueries(indexTable, (QueryCondition)MapRDBImpl.newCondition().is(indexedField0, QueryCondition.Op.GREATER_OR_EQUAL, "id99").build(), new String[0], fieldDescArray);
        this.runQueries(indexTable, (QueryCondition)MapRDBImpl.newCondition().and().is(indexedField0, QueryCondition.Op.EQUAL, "id5").is(indexedField0, QueryCondition.Op.EQUAL, "id5").close().build(), new String[]{"id5"}, fieldDescArray);
        this.runQueryAndCheckResults(indexTable, (QueryCondition)MapRDBImpl.newCondition().and().is(indexedField0, QueryCondition.Op.EQUAL, "id5").is(indexedField0, QueryCondition.Op.EQUAL, "id7").close().build(), new String[0]);
    }

    @Test
    public void testConditionOnString() throws Exception {
        boolean firstIndexedFieldIsDescending = true;
        this.testQueryConditionOnString("a.b.c", "a.c.d", firstIndexedFieldIsDescending);
        firstIndexedFieldIsDescending = false;
        this.testQueryConditionOnString("a.b.c", "a.c.d", firstIndexedFieldIsDescending);
    }

    private void testQueryConditionOnNoneBinaryComparator(String indexedField0, String indexedField1, boolean firstIndexedFieldIsDescending) throws Exception {
        int i;
        String i1 = "TestIndexTable-testQueryConditionOnInt-" + Long.toString(System.currentTimeMillis());
        IndexDesc i1Desc = this.createIndex(table, i1, this.getIndexAddFieldSpecification(indexedField0, firstIndexedFieldIsDescending), this.getIndexAddFieldSpecification(indexedField1, false));
        List fieldDescList = i1Desc.getIndexedFields();
        IndexFieldDesc[] fieldDescArray = new IndexFieldDesc[fieldDescList.size()];
        fieldDescList.toArray(fieldDescArray);
        int numberOfDocs = 5;
        DocumentMutation mut = MapRDBImpl.newMutation();
        for (i = 0; i < numberOfDocs; ++i) {
            mut.setOrReplace(indexedField0, "xyz").setOrReplace(indexedField1, 100).setOrReplace("e", 1000);
            table.update("id" + i, mut);
        }
        mut = MapRDBImpl.newMutation();
        for (i = 5; i < 5 + numberOfDocs; ++i) {
            mut.setOrReplace(indexedField1, i).setOrReplace("e", 1000);
            table.update("id" + i, mut);
        }
        table.flush();
        DBTests.waitForIndexFlush(table.getPath());
        Table indexTable = MapRDBImpl.getIndexTable((IndexDesc)i1Desc);
        this.runQueries(indexTable, (QueryCondition)MapRDBImpl.newCondition().exists(indexedField0).build(), new String[]{"id0", "id1", "id2", "id3", "id4"}, fieldDescArray);
        this.runQueries(indexTable, (QueryCondition)MapRDBImpl.newCondition().notExists(indexedField0).build(), new String[]{"id5", "id6", "id7", "id8", "id9"}, fieldDescArray);
        this.runQueries(indexTable, (QueryCondition)MapRDBImpl.newCondition().typeOf(indexedField0, Value.Type.STRING).build(), new String[]{"id0", "id1", "id2", "id3", "id4"}, fieldDescArray);
        this.runQueries(indexTable, (QueryCondition)MapRDBImpl.newCondition().notTypeOf(indexedField0, Value.Type.STRING).build(), new String[0], fieldDescArray);
        this.runQueries(indexTable, (QueryCondition)MapRDBImpl.newCondition().typeOf(indexedField0, Value.Type.INT).build(), new String[0], fieldDescArray);
        this.runQueries(indexTable, (QueryCondition)MapRDBImpl.newCondition().notTypeOf(indexedField0, Value.Type.INT).build(), new String[]{"id0", "id1", "id2", "id3", "id4"}, fieldDescArray);
        this.runQueries(indexTable, MapRDBImpl.newCondition().sizeOf(indexedField0, QueryCondition.Op.EQUAL, 3L).build(), new String[]{"id0", "id1", "id2", "id3", "id4"}, fieldDescArray);
        this.runQueries(indexTable, MapRDBImpl.newCondition().sizeOf(indexedField0, QueryCondition.Op.EQUAL, 5L).build(), new String[0], fieldDescArray);
        this.runQueries(indexTable, MapRDBImpl.newCondition().sizeOf(indexedField0, QueryCondition.Op.LESS, 5L).build(), new String[]{"id0", "id1", "id2", "id3", "id4"}, fieldDescArray);
        this.runQueries(indexTable, (QueryCondition)MapRDBImpl.newCondition().matches(indexedField0, ".*m.*").build(), new String[0], fieldDescArray);
        this.runQueries(indexTable, (QueryCondition)MapRDBImpl.newCondition().notMatches(indexedField0, ".*m.*").build(), new String[]{"id0", "id1", "id2", "id3", "id4"}, fieldDescArray);
    }

    private void testQueryConditionOnInt(String indexedField0, String indexedField1, boolean firstIndexedFieldIsDescending) throws Exception {
        String i1 = "TestIndexTable-testQueryConditionOnInt-" + Long.toString(System.currentTimeMillis());
        IndexDesc i1Desc = this.createIndex(table, i1, this.getIndexAddFieldSpecification(indexedField0, firstIndexedFieldIsDescending), this.getIndexAddFieldSpecification(indexedField1, false));
        List fieldDescList = i1Desc.getIndexedFields();
        IndexFieldDesc[] fieldDescArray = new IndexFieldDesc[fieldDescList.size()];
        fieldDescList.toArray(fieldDescArray);
        int numberOfDocs = 10;
        DocumentMutation mut = MapRDBImpl.newMutation();
        for (int i = 0; i < numberOfDocs; ++i) {
            mut.setOrReplace(indexedField0, i).setOrReplace(indexedField1, 100).setOrReplace("e", 1000);
            table.update("id" + i, mut);
        }
        table.flush();
        DBTests.waitForIndexFlush(table.getPath());
        Table indexTable = MapRDBImpl.getIndexTable((IndexDesc)i1Desc);
        this.runQueries(indexTable, (QueryCondition)MapRDBImpl.newCondition().is(indexedField0, QueryCondition.Op.EQUAL, 5).build(), new String[]{"id5"}, fieldDescArray);
        this.runQueries(indexTable, (QueryCondition)MapRDBImpl.newCondition().is(indexedField0, QueryCondition.Op.EQUAL, 99).build(), new String[0], fieldDescArray);
        this.runQueries(indexTable, (QueryCondition)MapRDBImpl.newCondition().is(indexedField0, QueryCondition.Op.LESS_OR_EQUAL, 5).build(), new String[]{"id0", "id1", "id2", "id3", "id4", "id5"}, fieldDescArray);
        this.runQueries(indexTable, (QueryCondition)MapRDBImpl.newCondition().is(indexedField0, QueryCondition.Op.LESS, 5).build(), new String[]{"id0", "id1", "id2", "id3", "id4"}, fieldDescArray);
        this.runQueries(indexTable, (QueryCondition)MapRDBImpl.newCondition().is(indexedField0, QueryCondition.Op.GREATER_OR_EQUAL, 5).build(), new String[]{"id5", "id6", "id7", "id8", "id9"}, fieldDescArray);
        this.runQueries(indexTable, (QueryCondition)MapRDBImpl.newCondition().is(indexedField0, QueryCondition.Op.GREATER, 5).build(), new String[]{"id6", "id7", "id8", "id9"}, fieldDescArray);
        this.runQueries(indexTable, (QueryCondition)MapRDBImpl.newCondition().is(indexedField0, QueryCondition.Op.GREATER_OR_EQUAL, 99).build(), new String[0], fieldDescArray);
        this.runQueries(indexTable, (QueryCondition)MapRDBImpl.newCondition().and().is(indexedField0, QueryCondition.Op.EQUAL, 5).is(indexedField0, QueryCondition.Op.EQUAL, 5).close().build(), new String[]{"id5"}, fieldDescArray);
        this.runQueryAndCheckResults(indexTable, (QueryCondition)MapRDBImpl.newCondition().and().is(indexedField0, QueryCondition.Op.EQUAL, 5).is(indexedField0, QueryCondition.Op.EQUAL, 7).close().build(), new String[0]);
    }

    @Test
    public void testConditionOnInt() throws Exception {
        boolean firstIndexedFieldIsDescending = true;
        this.testQueryConditionOnInt("a.b.c", "a.c.d", firstIndexedFieldIsDescending);
        firstIndexedFieldIsDescending = false;
        this.testQueryConditionOnInt("a.b.c", "a.c.d", firstIndexedFieldIsDescending);
    }

    @Test
    public void testConditionOnNoneBinaryComparator() throws Exception {
        boolean firstIndexedFieldIsDescending = true;
        this.testQueryConditionOnNoneBinaryComparator("a.b.c", "a.c.d", firstIndexedFieldIsDescending);
        firstIndexedFieldIsDescending = false;
        this.testQueryConditionOnNoneBinaryComparator("a.b.c", "a.c.d", firstIndexedFieldIsDescending);
    }

    @Test
    public void testConditionFilterIntegerDesc() throws Exception {
        String i1 = "TestIndexTable-testConditionFilterIntegerDesc-" + Long.toString(System.currentTimeMillis());
        IndexDesc i1Desc = this.createIndex(table, i1, "'\"a.b.c\":-1'", "'\"a.c.d\"'");
        DocumentMutation mut = MapRDBImpl.newMutation();
        mut.setOrReplace("a.b.c", 5).setOrReplace("a.c.d", 100).setOrReplace("e", 1000);
        table.update("key", mut);
        table.flush();
        DBTests.waitForIndexFlush(table.getPath());
        Table indexTable = MapRDBImpl.getIndexTable((IndexDesc)i1Desc);
        ConditionImpl qc = MapRDBImpl.newCondition().is("a.b.c", QueryCondition.Op.EQUAL, 5).build();
        DocumentStream stream = indexTable.find((QueryCondition)qc);
        Iterator itr = stream.iterator();
        Document doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().is("a.b.c", QueryCondition.Op.EQUAL, 7).build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().is("a.b.c", QueryCondition.Op.GREATER_OR_EQUAL, 5).build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().is("a.b.c", QueryCondition.Op.GREATER_OR_EQUAL, 7).build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().and().is("a.b.c", QueryCondition.Op.EQUAL, 5).is("a.b.c", QueryCondition.Op.EQUAL, 5).close().build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().and().is("a.b.c", QueryCondition.Op.EQUAL, 5).is("a.b.c", QueryCondition.Op.EQUAL, 7).close().build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        Assert.assertFalse((boolean)itr.hasNext());
    }

    @Test
    public void testConditionFilterNonIndexed() throws Exception {
        String i1 = "TestIndexTable-testConditionNonindexed-" + Long.toString(System.currentTimeMillis());
        IndexDesc i1Desc = this.createIndex(table, i1, "'\"a.b.c\"'", "'\"a.c.d\"'");
        DocumentMutation mut = MapRDBImpl.newMutation();
        mut.setOrReplace("a.b.c", 5).setOrReplace("a.c.d", 100).setOrReplace("e", 1000);
        table.update("key", mut);
        table.flush();
        DBTests.waitForIndexFlush(table.getPath());
        Table indexTable = MapRDBImpl.getIndexTable((IndexDesc)i1Desc);
        ConditionImpl qc = MapRDBImpl.newCondition().is("a.c.d", QueryCondition.Op.EQUAL, 100).build();
        DocumentStream stream = indexTable.find((QueryCondition)qc);
        Iterator itr = stream.iterator();
        Document doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().is("a.c.d", QueryCondition.Op.EQUAL, 7).build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().and().is("a.c.d", QueryCondition.Op.EQUAL, 100).is("a.b.c", QueryCondition.Op.EQUAL, 5).close().build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().and().is("a.c.d", QueryCondition.Op.EQUAL, 100).is("a.b.c", QueryCondition.Op.EQUAL, 7).close().build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        Assert.assertFalse((boolean)itr.hasNext());
    }

    @Test
    public void testConditionFilterNonIndexedDesc() throws Exception {
        String i1 = "TestIndexTable-testConditionNonindexedDesc-" + Long.toString(System.currentTimeMillis());
        IndexDesc i1Desc = this.createIndex(table, i1, "'\"a.b.c\":-1'", "'\"a.c.d\"'");
        DocumentMutation mut = MapRDBImpl.newMutation();
        mut.setOrReplace("a.b.c", 5).setOrReplace("a.c.d", 100).setOrReplace("e", 1000);
        table.update("key", mut);
        mut.setOrReplace("a.b.c", 11).setOrReplace("a.c.d", 12).setOrReplace("e", 13);
        table.update("key1", mut);
        table.flush();
        DBTests.waitForIndexFlush(table.getPath());
        Table indexTable = MapRDBImpl.getIndexTable((IndexDesc)i1Desc);
        ConditionImpl qc = MapRDBImpl.newCondition().is("a.c.d", QueryCondition.Op.EQUAL, 100).build();
        DocumentStream stream = indexTable.find((QueryCondition)qc);
        Iterator itr = stream.iterator();
        Document doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().is("a.c.d", QueryCondition.Op.EQUAL, 7).build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().and().is("a.c.d", QueryCondition.Op.EQUAL, 100).is("a.b.c", QueryCondition.Op.EQUAL, 5).close().build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().and().is("a.c.d", QueryCondition.Op.EQUAL, 100).is("a.b.c", QueryCondition.Op.EQUAL, 7).close().build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        Assert.assertFalse((boolean)itr.hasNext());
    }

    @Test
    public void testConditionFilterMap() throws Exception {
        String i1 = "TestIndexTable-testConditionMap-" + Long.toString(System.currentTimeMillis());
        IndexDesc i1Desc = this.createIndex(table, i1, "'\"a.b.c\"'", "'\"a.c.d\"'");
        DocumentMutation mut = MapRDBImpl.newMutation();
        mut.setOrReplace("a.c.d", (Map)MapRDBImpl.newDocument().set("z", 5)).setOrReplace("a.b.c", 100).setOrReplace("e", 1000);
        table.update("key", mut);
        mut.setOrReplace("a.c.d", (Map)MapRDBImpl.newDocument().set("z", 4)).setOrReplace("a.b.c", 100).setOrReplace("e", 1000);
        table.update("key1", mut);
        table.flush();
        DBTests.waitForIndexFlush(table.getPath());
        Table indexTable = MapRDBImpl.getIndexTable((IndexDesc)i1Desc);
        ConditionImpl qc = MapRDBImpl.newCondition().is("a.c.d.z", QueryCondition.Op.EQUAL, 5).build();
        DocumentStream stream = indexTable.find((QueryCondition)qc);
        Iterator itr = stream.iterator();
        Document doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().is("a.c.d.z", QueryCondition.Op.EQUAL, 7).build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        Assert.assertFalse((boolean)itr.hasNext());
    }

    @Test
    public void testConditionFilterList() throws Exception {
        String i1 = "TestIndexTable-testConditionList-" + Long.toString(System.currentTimeMillis());
        IndexDesc i1Desc = this.createIndex(table, i1, "'\"a.b.c\"'", "'\"a.c.d\"'");
        DocumentMutation mut = MapRDBImpl.newMutation();
        mut.setOrReplace("a.c.d", Arrays.asList(5, 9)).setOrReplace("a.b.c", 100).setOrReplace("e", 1000);
        table.update("key", mut);
        mut.setOrReplace("a.c.d", Arrays.asList(6, 4)).setOrReplace("a.b.c", 100).setOrReplace("e", 1000);
        table.update("key1", mut);
        table.flush();
        DBTests.waitForIndexFlush(table.getPath());
        Table indexTable = MapRDBImpl.getIndexTable((IndexDesc)i1Desc);
        ConditionImpl qc = MapRDBImpl.newCondition().is("a.c.d[0]", QueryCondition.Op.EQUAL, 5).build();
        DocumentStream stream = indexTable.find((QueryCondition)qc);
        Iterator itr = stream.iterator();
        Document doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().is("a.c.d[0]", QueryCondition.Op.EQUAL, 7).build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        Assert.assertFalse((boolean)itr.hasNext());
    }

    @Test
    public void testHashedIndexPutsAndScanNoQueryCondition() throws Exception {
        int numRows;
        Assert.assertNotNull((Object)table);
        String i1Name = "i1-testHashedIndexPutsAndScanNoQueryCondition";
        int startKey = numRows = 100000;
        int endKey1 = startKey + numRows / 2;
        int endKey2 = startKey * 2;
        int insCount = 0;
        for (int i = startKey; i < endKey1; ++i) {
            Document d = MapRDBImpl.newDocument().set("a.b.c", "abc" + Integer.toString(i)).set("a.b.d", "abd" + Integer.toString(i)).set("x", "xyz" + Integer.toString(i));
            table.insert("key" + Integer.toString(i), d);
            ++insCount;
        }
        table.flush();
        IndexDesc i1Desc = this.createIndex(table, i1Name, "'\"a.b.c\"'", "'\"x\"'", true, 10);
        if (i1Desc == null) {
            DBTests.waitForIndexFlush(table.getPath());
            i1Desc = this.getIndex(table, i1Name);
        }
        Assert.assertTrue((boolean)i1Desc.isHashed());
        for (int i = endKey1 + 1; i < endKey2; ++i) {
            Document d = MapRDBImpl.newDocument().set("a.b.c", "abc" + Integer.toString(i)).set("a.b.d", "abd" + Integer.toString(i)).set("x", "xyz" + Integer.toString(i));
            table.insert("key" + Integer.toString(i), d);
            ++insCount;
        }
        table.flush();
        DBTests.waitForIndexFlush(table.getPath());
        Table indexTable = MapRDBImpl.getIndexTable((IndexDesc)i1Desc);
        DocumentStream stream = indexTable.find();
        Iterator itr = stream.iterator();
        Assert.assertTrue((boolean)itr.hasNext());
        int count = 0;
        while (itr.hasNext()) {
            Document d = (Document)itr.next();
            String key = d.getIdString();
            String ordinal = key.substring("key".length());
            Assert.assertEquals((Object)d.getString("a.b.c"), (Object)("abc" + ordinal));
            Assert.assertEquals((Object)d.getString("x"), (Object)("xyz" + ordinal));
            ++count;
        }
        Assert.assertEquals((long)count, (long)insCount);
    }

    @Test
    public void testHashedIndexScanWithQueryConditionOnPartitionKey() throws Exception {
        String ordinal;
        String key;
        DocumentStream ds;
        String ordinal2;
        String key2;
        DocumentStream ds2;
        QueryCondition finalCond;
        int numRows;
        Assert.assertNotNull((Object)table);
        String i1Name = "i1-testHashedIndexPutsAndScanNoQueryCondition";
        int startKey = numRows = 10000;
        int endKey1 = startKey + numRows / 2;
        int endKey2 = startKey * 2;
        int insCount = 0;
        for (int i = startKey; i < endKey1; ++i) {
            Document d = MapRDB.newDocument().set("a.b.c", "abc" + Integer.toString(i)).set("a.b.d", "abd" + Integer.toString(i)).set("x", "xyz" + Integer.toString(i));
            table.insert("key" + Integer.toString(i), d);
            ++insCount;
        }
        table.flush();
        IndexDesc i1Desc = this.createIndex(table, i1Name, "'\"a.b.c\"'", "'\"x\"'", true, 3);
        if (i1Desc == null) {
            DBTests.waitForIndexFlush(table.getPath());
            i1Desc = this.getIndex(table, i1Name);
        }
        Assert.assertTrue((i1Desc.isHashed() && i1Desc.getNumHashPartitions() > 0 ? 1 : 0) != 0);
        DBTests.waitForIndexFlush(table.getPath());
        for (int i = endKey1; i < endKey2; ++i) {
            Document d = MapRDB.newDocument().set("a.b.c", "abc" + Integer.toString(i)).set("a.b.d", "abd" + Integer.toString(i)).set("x", "xyz" + Integer.toString(i));
            table.insert("key" + Integer.toString(i), d);
            ++insCount;
        }
        table.flush();
        DBTests.waitForIndexFlush(table.getPath());
        Table indexTable = MapRDBImpl.getIndexTable((IndexDesc)i1Desc);
        MetaTable indexMetaTable = indexTable.getMetaTable();
        _logger.info("Testing GREATER, LESS operators");
        int scanCount = 0;
        int scanStart = startKey + numRows / 20;
        int scanStop = endKey1 - numRows / 10;
        QueryCondition qc = MapRDB.newCondition().and().is("a.b.c", QueryCondition.Op.GREATER, "abc" + Integer.toString(scanStart)).is("a.b.c", QueryCondition.Op.LESS, "abc" + Integer.toString(scanStop)).close().build();
        List scanRanges = indexMetaTable.getScanRanges(qc);
        Assert.assertNotNull((Object)scanRanges);
        Assert.assertEquals((long)3L, (long)scanRanges.size());
        ArrayList<String> keys = new ArrayList<String>();
        QueryCondition userCond = MapRDB.newCondition().and().is("x", QueryCondition.Op.LESS, "xyz" + Integer.toString(scanStop - 10)).close().build();
        for (ScanRange range : scanRanges) {
            finalCond = MapRDB.newCondition().and().condition(userCond).condition(range.getCondition()).close().build();
            ds2 = indexTable.find(finalCond);
            for (Document d : ds2) {
                key2 = d.getIdString();
                ordinal2 = key2.substring("key".length());
                Assert.assertTrue((ordinal2.compareTo(Integer.toString(scanStart)) > 0 && ordinal2.compareTo(Integer.toString(scanStop - 10)) < 0 ? 1 : 0) != 0);
                Assert.assertEquals((Object)d.getString("a.b.c"), (Object)("abc" + ordinal2));
                Assert.assertEquals((Object)d.getString("x"), (Object)("xyz" + ordinal2));
                keys.add(key2);
                ++scanCount;
            }
            keys.sort(null);
            ds2.close();
        }
        Assert.assertEquals((long)scanCount, (long)(scanStop - 10 - (scanStart + 1)));
        _logger.info("Testing GREATER_OR_EQUAL, LESS_OR_EQUAL operators");
        scanCount = 0;
        scanStart = startKey + numRows / 20;
        scanStop = endKey2 - numRows / 10;
        keys.clear();
        qc = MapRDB.newCondition().and().is("a.b.c", QueryCondition.Op.GREATER_OR_EQUAL, "abc" + Integer.toString(scanStart)).is("a.b.c", QueryCondition.Op.LESS_OR_EQUAL, "abc" + Integer.toString(scanStop)).close().build();
        scanRanges = indexMetaTable.getScanRanges(qc);
        Assert.assertNotNull((Object)scanRanges);
        Assert.assertEquals((long)3L, (long)scanRanges.size());
        userCond = MapRDB.newCondition().and().is("x", QueryCondition.Op.LESS, "xyz" + Integer.toString(scanStop - 10)).close().build();
        for (ScanRange range : scanRanges) {
            finalCond = MapRDB.newCondition().and().condition(userCond).condition(range.getCondition()).close().build();
            ds2 = indexTable.find(finalCond);
            for (Document d : ds2) {
                key2 = d.getIdString();
                ordinal2 = key2.substring("key".length());
                Assert.assertTrue((ordinal2.compareTo(Integer.toString(scanStart)) >= 0 && ordinal2.compareTo(Integer.toString(scanStop - 10)) < 0 ? 1 : 0) != 0);
                Assert.assertEquals((Object)d.getString("a.b.c"), (Object)("abc" + ordinal2));
                Assert.assertEquals((Object)d.getString("x"), (Object)("xyz" + ordinal2));
                keys.add(key2);
                ++scanCount;
            }
            keys.sort(null);
            ds2.close();
        }
        Assert.assertEquals((long)(scanStop - 10 - scanStart), (long)scanCount);
        _logger.info("Testing EQUAL operators");
        scanCount = 0;
        scanStart = startKey + numRows / 20;
        scanStop = endKey2 - numRows / 10;
        keys.clear();
        qc = MapRDB.newCondition().or().is("a.b.c", QueryCondition.Op.EQUAL, "abc" + Integer.toString(scanStart)).is("a.b.c", QueryCondition.Op.EQUAL, "abc" + Integer.toString(scanStop)).close().build();
        scanRanges = indexMetaTable.getScanRanges(qc);
        Assert.assertNotNull((Object)scanRanges);
        Assert.assertEquals((long)6L, (long)scanRanges.size());
        for (ScanRange range : scanRanges) {
            ds = indexTable.find(range.getCondition());
            for (Document d : ds) {
                key = d.getIdString();
                ordinal = key.substring("key".length());
                Assert.assertTrue((ordinal.compareTo(Integer.toString(scanStart)) == 0 || ordinal.compareTo(Integer.toString(scanStop)) == 0 ? 1 : 0) != 0);
                Assert.assertEquals((Object)d.getString("a.b.c"), (Object)("abc" + ordinal));
                Assert.assertEquals((Object)d.getString("x"), (Object)("xyz" + ordinal));
                keys.add(key);
                ++scanCount;
            }
            keys.sort(null);
            ds.close();
        }
        Assert.assertEquals((long)2L, (long)scanCount);
        _logger.info("Testing EXISTS api");
        scanCount = 0;
        scanStart = startKey + numRows / 20;
        scanStop = endKey2 - numRows / 10;
        keys.clear();
        qc = MapRDB.newCondition().exists("a.b.c").build();
        scanRanges = indexMetaTable.getScanRanges(qc);
        Assert.assertNotNull((Object)scanRanges);
        Assert.assertEquals((long)1L, (long)scanRanges.size());
        for (ScanRange range : scanRanges) {
            ds = indexTable.find(range.getCondition());
            for (Document d : ds) {
                key = d.getIdString();
                ordinal = key.substring("key".length());
                Assert.assertTrue((ordinal.compareTo(Integer.toString(startKey)) >= 0 && ordinal.compareTo(Integer.toString(endKey2)) < 0 ? 1 : 0) != 0);
                Assert.assertEquals((Object)d.getString("a.b.c"), (Object)("abc" + ordinal));
                Assert.assertEquals((Object)d.getString("x"), (Object)("xyz" + ordinal));
                keys.add(key);
                ++scanCount;
            }
            keys.sort(null);
            ds.close();
        }
        Assert.assertEquals((long)(endKey2 - startKey), (long)scanCount);
        _logger.info("Testing non-partition key condition.");
        scanCount = 0;
        scanStart = startKey + numRows / 20;
        scanStop = endKey2 - numRows / 10;
        keys.clear();
        qc = MapRDB.newCondition().and().and().is("a.b.c", QueryCondition.Op.GREATER, "abc" + Integer.toString(scanStart)).is("x", QueryCondition.Op.LESS, "xyz" + Integer.toString(scanStop)).close().and().is("a.b.c", QueryCondition.Op.LESS, "abc" + Integer.toString(scanStop - 10)).close().close().build();
        scanRanges = indexMetaTable.getScanRanges(qc);
        Assert.assertNotNull((Object)scanRanges);
        Assert.assertEquals((long)3L, (long)scanRanges.size());
        for (ScanRange range : scanRanges) {
            ds = indexTable.find(range.getCondition());
            for (Document d : ds) {
                key = d.getIdString();
                ordinal = key.substring("key".length());
                Assert.assertTrue((ordinal.compareTo(Integer.toString(scanStart)) > 0 && ordinal.compareTo(Integer.toString(scanStop - 10)) < 0 ? 1 : 0) != 0);
                Assert.assertEquals((Object)d.getString("a.b.c"), (Object)("abc" + ordinal));
                Assert.assertEquals((Object)d.getString("x"), (Object)("xyz" + ordinal));
                keys.add(key);
                ++scanCount;
            }
            keys.sort(null);
            ds.close();
        }
        Assert.assertEquals((long)(scanStop - 10 - (scanStart + 1)), (long)scanCount);
    }

    @Ignore(value="Enable manually, run and disable when done - long running test")
    @Test
    public void testHashedIndexScanWithQueryConditionOnPartitionKeyXL() throws Exception {
        String ordinal;
        String key;
        DocumentStream ds;
        int numRows;
        Assert.assertNotNull((Object)table);
        String i1Name = "i1-testHashedIndexPutsAndScanWithQueryConditionOnPartitionKeyXL";
        int startKey = numRows = 100000000;
        int endKey1 = startKey + numRows / 2;
        int endKey2 = startKey * 2;
        int insCount = 0;
        IndexDesc i1Desc = this.createIndex(table, i1Name, "'\"a.b.c\"'", "'\"x\"'", true, 3);
        if (i1Desc == null) {
            DBTests.waitForIndexFlush(table.getPath());
            i1Desc = this.getIndex(table, i1Name);
        }
        System.err.println(i1Desc.getIndexName());
        Assert.assertTrue((i1Desc.isHashed() && i1Desc.getNumHashPartitions() > 0 ? 1 : 0) != 0);
        DBTests.waitForIndexFlush(table.getPath());
        for (int i = startKey; i < endKey2; ++i) {
            Document d = MapRDB.newDocument().set("a.b.c", "abc" + Integer.toString(i)).set("a.b.d", "abd" + Integer.toString(i)).set("x", "xyz" + Integer.toString(i));
            table.insert("key" + Integer.toString(i), d);
            ++insCount;
        }
        table.flush();
        DBTests.waitForIndexFlush(table.getPath());
        Table indexTable = MapRDBImpl.getIndexTable((IndexDesc)i1Desc);
        MetaTable indexMetaTable = indexTable.getMetaTable();
        _logger.info("Testing GREATER, LESS operators");
        int scanCount = 0;
        int scanStart = startKey + numRows / 20;
        int scanStop = endKey1 - numRows / 10;
        QueryCondition qc = MapRDB.newCondition().and().is("a.b.c", QueryCondition.Op.GREATER, "abc" + Integer.toString(scanStart)).is("a.b.c", QueryCondition.Op.LESS, "abc" + Integer.toString(scanStop)).close().build();
        List scanRanges = indexMetaTable.getScanRanges(qc);
        Assert.assertNotNull((Object)scanRanges);
        ArrayList<String> keys = new ArrayList<String>();
        for (ScanRange range : scanRanges) {
            ds = indexTable.find(range.getCondition());
            for (Document d : ds) {
                key = d.getIdString();
                ordinal = key.substring("key".length());
                Assert.assertTrue((ordinal.compareTo(Integer.toString(scanStart)) > 0 && ordinal.compareTo(Integer.toString(scanStop)) < 0 ? 1 : 0) != 0);
                Assert.assertEquals((Object)d.getString("a.b.c"), (Object)("abc" + ordinal));
                Assert.assertEquals((Object)d.getString("x"), (Object)("xyz" + ordinal));
                keys.add(key);
                ++scanCount;
            }
            keys.sort(null);
            ds.close();
        }
        Assert.assertEquals((long)scanCount, (long)(scanStop - (scanStart + 1)));
        _logger.info("Testing GREATER_OR_EQUAL, LESS_OR_EQUAL operators");
        scanCount = 0;
        scanStart = startKey + numRows / 20;
        scanStop = endKey2 - numRows / 10;
        keys.clear();
        qc = MapRDB.newCondition().and().is("a.b.c", QueryCondition.Op.GREATER_OR_EQUAL, "abc" + Integer.toString(scanStart)).is("a.b.c", QueryCondition.Op.LESS_OR_EQUAL, "abc" + Integer.toString(scanStop)).close().build();
        scanRanges = indexMetaTable.getScanRanges(qc);
        Assert.assertNotNull((Object)scanRanges);
        for (ScanRange range : scanRanges) {
            ds = indexTable.find(range.getCondition());
            for (Document d : ds) {
                key = d.getIdString();
                ordinal = key.substring("key".length());
                Assert.assertTrue((ordinal.compareTo(Integer.toString(scanStart)) >= 0 && ordinal.compareTo(Integer.toString(scanStop)) <= 0 ? 1 : 0) != 0);
                Assert.assertEquals((Object)d.getString("a.b.c"), (Object)("abc" + ordinal));
                Assert.assertEquals((Object)d.getString("x"), (Object)("xyz" + ordinal));
                keys.add(key);
                ++scanCount;
            }
            keys.sort(null);
            ds.close();
        }
        Assert.assertEquals((long)(scanStop - (scanStart - 1)), (long)scanCount);
        _logger.info("Testing EQUAL operators");
        scanCount = 0;
        scanStart = startKey + numRows / 20;
        scanStop = endKey2 - numRows / 10;
        keys.clear();
        qc = MapRDB.newCondition().or().is("a.b.c", QueryCondition.Op.EQUAL, "abc" + Integer.toString(scanStart)).is("a.b.c", QueryCondition.Op.EQUAL, "abc" + Integer.toString(scanStop)).close().build();
        scanRanges = indexMetaTable.getScanRanges(qc);
        Assert.assertNotNull((Object)scanRanges);
        for (ScanRange range : scanRanges) {
            ds = indexTable.find(range.getCondition());
            for (Document d : ds) {
                key = d.getIdString();
                ordinal = key.substring("key".length());
                Assert.assertTrue((ordinal.compareTo(Integer.toString(scanStart)) == 0 || ordinal.compareTo(Integer.toString(scanStop)) == 0 ? 1 : 0) != 0);
                Assert.assertEquals((Object)d.getString("a.b.c"), (Object)("abc" + ordinal));
                Assert.assertEquals((Object)d.getString("x"), (Object)("xyz" + ordinal));
                keys.add(key);
                ++scanCount;
            }
            keys.sort(null);
            ds.close();
        }
        Assert.assertEquals((long)2L, (long)scanCount);
        _logger.info("Testing EXISTS api");
        scanCount = 0;
        scanStart = startKey + numRows / 20;
        scanStop = endKey2 - numRows / 10;
        keys.clear();
        qc = MapRDB.newCondition().exists("a.b.c").build();
        scanRanges = indexMetaTable.getScanRanges(qc);
        Assert.assertNotNull((Object)scanRanges);
        for (ScanRange range : scanRanges) {
            ds = indexTable.find(range.getCondition());
            for (Document d : ds) {
                key = d.getIdString();
                ordinal = key.substring("key".length());
                Assert.assertTrue((ordinal.compareTo(Integer.toString(startKey)) >= 0 && ordinal.compareTo(Integer.toString(endKey2)) < 0 ? 1 : 0) != 0);
                Assert.assertEquals((Object)d.getString("a.b.c"), (Object)("abc" + ordinal));
                Assert.assertEquals((Object)d.getString("x"), (Object)("xyz" + ordinal));
                keys.add(key);
                ++scanCount;
            }
            keys.sort(null);
            ds.close();
        }
        Assert.assertEquals((long)(endKey2 - startKey), (long)scanCount);
        _logger.info("Testing non-partition key condition.");
        scanCount = 0;
        scanStart = startKey + numRows / 20;
        scanStop = endKey2 - numRows / 10;
        keys.clear();
        qc = MapRDB.newCondition().and().and().is("a.b.c", QueryCondition.Op.GREATER, "abc" + Integer.toString(scanStart)).is("x", QueryCondition.Op.LESS, "xyz" + Integer.toString(scanStop)).close().and().is("a.b.c", QueryCondition.Op.LESS, "abc" + Integer.toString(scanStop - 10)).close().close().build();
        scanRanges = indexMetaTable.getScanRanges(qc);
        Assert.assertNotNull((Object)scanRanges);
        for (ScanRange range : scanRanges) {
            ds = indexTable.find(range.getCondition());
            for (Document d : ds) {
                key = d.getIdString();
                ordinal = key.substring("key".length());
                Assert.assertTrue((ordinal.compareTo(Integer.toString(scanStart)) > 0 && ordinal.compareTo(Integer.toString(scanStop - 10)) < 0 ? 1 : 0) != 0);
                Assert.assertEquals((Object)d.getString("a.b.c"), (Object)("abc" + ordinal));
                Assert.assertEquals((Object)d.getString("x"), (Object)("xyz" + ordinal));
                keys.add(key);
                ++scanCount;
            }
            keys.sort(null);
            ds.close();
        }
        Assert.assertEquals((long)(scanStop - 10 - (scanStart + 1)), (long)scanCount);
    }

    @Test
    public void testUpdateTimeOnlyIndexScanWithCondition() throws Exception {
        if (MapRDBImpl.tableExists((String)table.getPath().toString())) {
            MapRDBImpl.deleteTable((String)table.getPath().toString());
        }
        String myTableName = "testUpdateTimeOnlyIndexScanWithCondition-table";
        table = DBTests.createOrReplaceTable(myTableName);
        String indexName = "testUpdateTimeOnlyIndexScanWithCondition-index";
        String indexedFields = "'\"$$timestamp\"'";
        String nonIndexedFields = "'\"x.y\",\"a.b\"'";
        IndexDesc idxDesc = this.createIndex(table, indexName, indexedFields, nonIndexedFields);
        _logger.trace("Index " + indexName + " created for table " + table.getName() + " on  indexed fields " + indexedFields + " and non-indexed fields " + nonIndexedFields);
        int count = 10;
        this.testUpdateTimeIndexHelper(count, indexName, idxDesc);
        this.testUpdateTimeIndexHelper(count << 2, indexName, idxDesc);
    }

    @Test
    public void testUpdateTimeCompositeIndexScanWithCondition() throws Exception {
        if (MapRDBImpl.tableExists((String)table.getPath().toString())) {
            MapRDBImpl.deleteTable((String)table.getPath().toString());
        }
        String myTableName = "testUpdateTimeCompositeIndexScanWithCondition-table";
        table = DBTests.createOrReplaceTable(myTableName);
        String indexName = "testUpdateTimeIndexScanWithCondition-index";
        String indexedFields = "'\"$$timestamp\",\"a.b\"'";
        String nonIndexedFields = "'\"x.y\"'";
        IndexDesc idxDesc = this.createIndex(table, indexName, indexedFields, nonIndexedFields);
        _logger.trace("Index " + indexName + " created for table " + table.getName() + " on  indexed fields " + indexedFields + " and non-indexed fields " + nonIndexedFields);
        int count = 10;
        this.testUpdateTimeIndexHelper(count, indexName, idxDesc);
        this.testUpdateTimeIndexHelper(count << 2, indexName, idxDesc);
    }

    private void testUpdateTimeIndexHelper(int count, String indexName, IndexDesc idxDesc) throws Exception {
        Document d;
        for (int i = 0; i < count; ++i) {
            Document d2 = MapRDBImpl.newDocument().set("a.b", i);
            String key = "key" + Integer.toString(i);
            table.insertOrReplace(key, d2);
            table.flush();
            Thread.sleep(1000L);
            _logger.trace("Inserted document: ( " + key + ", " + d2.toString() + " )");
        }
        Table indexTable = MapRDBImpl.getIndexTable((IndexDesc)idxDesc);
        DocumentStream ds = indexTable.find();
        Iterator itr = ds.iterator();
        int resCount = 0;
        int lesser = 0;
        int greater = 0;
        OTimestamp refTime = null;
        while (itr.hasNext()) {
            Document d3 = (Document)itr.next();
            OTimestamp ts = d3.getTimestamp("$$timestamp");
            if (resCount < count / 2) {
                ++lesser;
            } else if (resCount == count / 2) {
                refTime = ts;
            } else {
                ++greater;
            }
            _logger.trace("Received Document " + Integer.toString(resCount) + ":" + d3.getIdString() + ", " + d3.asJsonString());
            ++resCount;
        }
        ds.close();
        ConditionImpl cond = MapRDBImpl.newCondition().is(Constants.LAST_MODIFIED_TIMESTAMP_FP, QueryCondition.Op.LESS, refTime).build();
        ds = indexTable.find((QueryCondition)cond);
        itr = ds.iterator();
        resCount = 0;
        while (itr.hasNext()) {
            d = (Document)itr.next();
            Assert.assertTrue((refTime.compareTo(d.getTimestamp("$$timestamp")) > 0 ? 1 : 0) != 0);
            ++resCount;
        }
        Assert.assertEquals((long)lesser, (long)resCount);
        ds.close();
        _logger.trace("LESS ok");
        cond = MapRDBImpl.newCondition().is("$$timestamp", QueryCondition.Op.EQUAL, refTime).build();
        ds = indexTable.find((QueryCondition)cond);
        itr = ds.iterator();
        resCount = 0;
        while (itr.hasNext()) {
            d = (Document)itr.next();
            Assert.assertTrue((refTime.compareTo(d.getTimestamp("$$timestamp")) == 0 ? 1 : 0) != 0);
            ++resCount;
        }
        Assert.assertEquals((long)1L, (long)resCount);
        ds.close();
        _logger.trace("EQUAL ok");
        cond = MapRDBImpl.newCondition().and().is("$$timestamp", QueryCondition.Op.GREATER_OR_EQUAL, refTime).is("a.b", QueryCondition.Op.LESS, 9).close().build();
        ds = indexTable.find((QueryCondition)cond);
        itr = ds.iterator();
        resCount = 0;
        while (itr.hasNext()) {
            d = (Document)itr.next();
            Assert.assertTrue((refTime.compareTo(d.getTimestamp("$$timestamp")) <= 0 ? 1 : 0) != 0);
            Assert.assertTrue((d.getInt("a.b") < 9 ? 1 : 0) != 0);
            ++resCount;
        }
        Assert.assertTrue((resCount <= greater + 1 ? 1 : 0) != 0);
        ds.close();
        _logger.trace("GREATER_OR_EQUAL ok");
    }

    @Test
    @Ignore(value="Enable after Bugzilla Bug 27311 is fixed.")
    public void testIndexTabletInfos() throws Exception {
        Assert.assertNotNull((Object)table);
        String indexName = "testIndexTabletInfos-index";
        IndexDesc i1Desc = this.createIndex(table, indexName, "'\"a.b.c\"'", "'\"a.c.d\"'");
        MapRDBIndexImpl index = (MapRDBIndexImpl)MapRDBImpl.getIndexTable((IndexDesc)i1Desc);
        TabletInfo[] tablets = index.getTabletInfos();
        Assert.assertEquals((long)1L, (long)tablets.length);
    }

    @Test
    public void testWithNonJsonTable() throws Exception {
        Path tPath = DBTests.getTablePath("binarytable1");
        if (FSTests.maprfs().exists(tPath)) {
            _logger.info("Table {} exists, deleting.", (Object)tPath);
            FSTests.maprfs().delete(tPath);
        }
        String tableCreateCommand = "maprcli table create -path " + tPath.toString() + " -tabletype binary";
        TestCluster.runCommand((String)tableCreateCommand);
        try {
            Collection indexList = DBTests.admin().getTableIndexes(tPath, true);
            Assert.fail((String)"Expected DBException");
        }
        catch (DBException dBException) {
            // empty catch block
        }
        FSTests.maprfs().delete(tPath);
    }

    @Test
    public void testIndexSizeOf() throws Exception {
        String indexName = "testIndexSizeOf-index";
        IndexDesc i1desc = this.createIndex(table, indexName, "'\"a\"'", "'\"x\"'");
        Table index = MapRDBImpl.getIndexTable((IndexDesc)i1desc);
        String val = "aaaaa";
        byte[] byteVal = val.getBytes();
        Document d1 = MapRDB.newDocument().set("a", ByteBufs.wrap((byte[])byteVal));
        Document d2 = MapRDB.newDocument().set("a", "bbbbb");
        String val2 = "ccc";
        byte[] byteVal2 = val2.getBytes();
        Document d3 = MapRDB.newDocument().set("a", ByteBufs.wrap((byte[])byteVal2));
        String val3 = "dddddd";
        byte[] byteVal3 = val3.getBytes();
        Document d4 = MapRDB.newDocument().set("a", ByteBufs.wrap((byte[])byteVal3));
        try {
            table.insert("key1", d1);
            table.insert("key2", d2);
            table.insert("key3", d3);
            table.insert("key4", d4);
            table.flush();
        }
        catch (Exception e) {
            Assert.fail();
        }
        DBTests.waitForIndexFlush(table.getPath());
        QueryCondition cond = MapRDB.newCondition().sizeOf("a", QueryCondition.Op.GREATER, 4L).build();
        DocumentStream ds = index.find(cond);
        Iterator itr = ds.iterator();
        int count = 0;
        while (itr.hasNext()) {
            Object value;
            Document doc = (Document)itr.next();
            if (doc.getIdString().equals("key1")) {
                value = doc.getBinary("a");
                Assert.assertTrue((boolean)Arrays.equals(((ByteBuffer)value).array(), byteVal));
            } else if (doc.getIdString().equals("key2")) {
                value = doc.getString("a");
                Assert.assertEquals((Object)"bbbbb", (Object)value);
            } else {
                Assert.assertEquals((Object)"key4", (Object)doc.getIdString());
                value = doc.getBinary("a");
                Assert.assertTrue((boolean)Arrays.equals(((ByteBuffer)value).array(), byteVal3));
            }
            ++count;
        }
        Assert.assertEquals((long)3L, (long)count);
    }
}

