/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.tests.ojai;

import com.mapr.db.Table;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.tests.utils.DBTests;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.ClusterTest;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;
import org.ojai.DocumentReader;
import org.ojai.store.DocumentMutation;
import org.ojai.types.ODate;
import org.ojai.types.OTime;

@Category(value={ClusterTest.class})
public class TestDBDocumentReaderMCF
extends BaseTest {
    private void validateSimple(DocumentReader r) {
        Assert.assertTrue((boolean)r.inMap());
        Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
        Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)r.next());
        Assert.assertEquals((Object)"_id", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
        Assert.assertEquals((Object)"a", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.BOOLEAN, (Object)r.next());
        Assert.assertEquals((Object)false, (Object)r.getBoolean());
        Assert.assertEquals((Object)DocumentReader.EventType.DOUBLE, (Object)r.next());
        Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
        Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
        Assert.assertEquals((Object)"n", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
        Assert.assertEquals((Object)"x1", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.DOUBLE, (Object)r.next());
        Assert.assertEquals((Object)"y1", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
        Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
        Assert.assertEquals((Object)"x2", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)r.next());
        Assert.assertEquals((Object)"y2", (Object)r.getFieldName());
        Assert.assertEquals((Object)"aaa", (Object)r.getString());
        Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
        Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
        Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
        Assert.assertEquals((Object)"k", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)r.next());
        Assert.assertEquals((Object)"x2", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
        Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
        Assert.assertNull((Object)r.next());
    }

    @Test
    @Ignore(value="http://bugs.corp.maprtech.com/show_bug.cgi?id=27189")
    public void testSimple() throws IOException {
        HashMap<String, String> cfPath = new HashMap<String, String>();
        cfPath.put("cf2", "k");
        cfPath.put("cf3", "n");
        Table tab = DBTests.createOrReplaceTable("mytab", cfPath);
        Document d = MapRDBImpl.newDocument().set("a.d", false).set("a.e", 111.222).set("k.x2", "abcd").set("n.x1.y1", 1.23).set("n.x2.y2", "aaa");
        tab.insertOrReplace("r1", d);
        tab.flush();
        for (DocumentReader reader : tab.find().documentReaders()) {
            this.validateSimple(reader);
        }
    }

    @Test
    public void testNestedCFStructure() throws IOException {
        HashMap<String, String> cfPath = new HashMap<String, String>();
        cfPath.put("cf1", "a.a1.a2");
        cfPath.put("cf2", "b");
        Table tab = DBTests.createOrReplaceTable("mytab", cfPath);
        Document d = MapRDBImpl.newDocument().set("a.a1.a2.a3", "xyz").set("a.a1.a2.a4", "pqr").setArray("a.a1.a5.a7", new int[]{1, 2, 3}).set("a.a1.a6", true).set("b.b1", 256).set("b.b2", 11.22).set("c", "abracadabra");
        tab.insertOrReplace("r1", d);
        tab.flush();
        Iterator iter = tab.find().documentReaders().iterator();
        DocumentReader r = (DocumentReader)iter.next();
        Assert.assertTrue((boolean)r.inMap());
        Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
        Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)r.next());
        Assert.assertEquals((Object)"_id", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
        Assert.assertEquals((Object)"a", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
        Assert.assertEquals((Object)"a1", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
        Assert.assertEquals((Object)"a5", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.START_ARRAY, (Object)r.next());
        Assert.assertEquals((Object)"a7", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.INT, (Object)r.next());
        Assert.assertEquals((long)1L, (long)r.getInt());
        Assert.assertEquals((Object)DocumentReader.EventType.INT, (Object)r.next());
        Assert.assertEquals((long)2L, (long)r.getInt());
        Assert.assertEquals((Object)DocumentReader.EventType.INT, (Object)r.next());
        Assert.assertEquals((long)3L, (long)r.getInt());
        Assert.assertEquals((Object)DocumentReader.EventType.END_ARRAY, (Object)r.next());
        Assert.assertEquals((Object)"a7", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
        Assert.assertEquals((Object)DocumentReader.EventType.BOOLEAN, (Object)r.next());
        Assert.assertEquals((Object)true, (Object)r.getBoolean());
        Assert.assertEquals((Object)"a6", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
        Assert.assertEquals((Object)"a2", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)r.next());
        Assert.assertEquals((Object)"a3", (Object)r.getFieldName());
        Assert.assertEquals((Object)"xyz", (Object)r.getString());
        Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)r.next());
        Assert.assertEquals((Object)"a4", (Object)r.getFieldName());
        Assert.assertEquals((Object)"pqr", (Object)r.getString());
        Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
        Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
        Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
        Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)r.next());
        Assert.assertEquals((Object)"c", (Object)r.getFieldName());
        Assert.assertEquals((Object)"abracadabra", (Object)r.getString());
        Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
        Assert.assertEquals((Object)"b", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.INT, (Object)r.next());
        Assert.assertEquals((Object)DocumentReader.EventType.DOUBLE, (Object)r.next());
        Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
        Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
        Assert.assertNull((Object)r.next());
    }

    private void validateReaderWithMissingCF(DocumentReader r) {
        Assert.assertTrue((boolean)r.inMap());
        Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
        Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)r.next());
        Assert.assertEquals((Object)"_id", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
        Assert.assertEquals((Object)"a", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.BOOLEAN, (Object)r.next());
        Assert.assertEquals((Object)false, (Object)r.getBoolean());
        Assert.assertEquals((Object)DocumentReader.EventType.DOUBLE, (Object)r.next());
        Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
        Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
        Assert.assertEquals((Object)"n", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
        Assert.assertEquals((Object)"x1", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.DOUBLE, (Object)r.next());
        Assert.assertEquals((Object)"y1", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
        Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
        Assert.assertEquals((Object)"x2", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)r.next());
        Assert.assertEquals((Object)"y2", (Object)r.getFieldName());
        Assert.assertEquals((Object)"aaa", (Object)r.getString());
        Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
        Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
        Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
        Assert.assertNull((Object)r.next());
    }

    @Test
    public void testMissingCFData() throws IOException {
        HashMap<String, String> cfPath = new HashMap<String, String>();
        cfPath.put("cf2", "k");
        cfPath.put("cf3", "n");
        Table tab = DBTests.createOrReplaceTable("mytab", cfPath);
        Document d = MapRDBImpl.newDocument().set("a.d", false).set("a.e", 111.222).set("k.x2", "abcd").set("n.x1.y1", 1.23).set("n.x2.y2", "aaa");
        tab.insertOrReplace("r1", d);
        tab.flush();
        String[] paths = new String[]{"a", "n"};
        for (DocumentReader reader : tab.find(paths).documentReaders()) {
            this.validateReaderWithMissingCF(reader);
        }
    }

    @Test
    @Ignore(value="http://bugs.corp.maprtech.com/show_bug.cgi?id=27189")
    public void testWithEmptyDefaultCF() throws IOException {
        HashMap<String, String> cfPath = new HashMap<String, String>();
        cfPath.put("cf2", "k");
        cfPath.put("cf3", "n");
        Table tab = DBTests.createOrReplaceTable("mytab", cfPath);
        Document d = MapRDBImpl.newDocument().set("a.d", false).set("a.e", 111.222).set("k.x2", "abcd").set("n.x1.y1", 1.23).set("n.x2.y2", "aaa");
        tab.insertOrReplace("r1", d);
        tab.flush();
        String[] paths = new String[]{"k", "n"};
        Iterator docIter = tab.find(paths).iterator();
        Iterator iter = tab.find(paths).documentReaders().iterator();
        DocumentReader r = (DocumentReader)iter.next();
        Assert.assertTrue((boolean)r.inMap());
        Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
        Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)r.next());
        Assert.assertEquals((Object)"_id", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
        Assert.assertEquals((Object)"k", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)r.next());
        Assert.assertEquals((Object)"x2", (Object)r.getFieldName());
        Assert.assertEquals((Object)"abcd", (Object)r.getString());
        Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
        Assert.assertEquals((Object)"k", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
        Assert.assertEquals((Object)"n", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
        Assert.assertEquals((Object)"x1", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.DOUBLE, (Object)r.next());
        Assert.assertEquals((Object)"y1", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
        Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
        Assert.assertEquals((Object)"x2", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)r.next());
        Assert.assertEquals((Object)"y2", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
        Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
        Assert.assertEquals((Object)"n", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
        Assert.assertNull((Object)r.next());
    }

    @Test
    public void testMutatedDocumentReader() throws IOException {
        HashMap<String, String> cfPath = new HashMap<String, String>();
        cfPath.put("cf1", "a.b");
        Table tab = DBTests.createOrReplaceTable("mytab", cfPath);
        Document d = MapRDBImpl.newDocument().set("X", "abcd").set("p.q", "lala");
        tab.insertOrReplace("r1", d);
        DocumentMutation m = MapRDBImpl.newMutation();
        m.setOrReplace("a.b.k.c", "tablet");
        tab.update("r1", m);
        tab.flush();
        Iterator iter = tab.find().iterator();
        Iterator docIter = tab.find().documentReaders().iterator();
        DocumentReader r = (DocumentReader)docIter.next();
        Assert.assertTrue((boolean)r.inMap());
        Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
        Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)r.next());
        Assert.assertEquals((Object)"_id", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)r.next());
        Assert.assertEquals((Object)"X", (Object)r.getFieldName());
        Assert.assertEquals((Object)"abcd", (Object)r.getString());
        Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
        Assert.assertEquals((Object)"p", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)r.next());
        Assert.assertEquals((Object)"q", (Object)r.getFieldName());
        Assert.assertEquals((Object)"lala", (Object)r.getString());
        Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
        Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
        Assert.assertEquals((Object)"a", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
        Assert.assertEquals((Object)"b", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
        Assert.assertEquals((Object)"k", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)r.next());
        Assert.assertEquals((Object)"c", (Object)r.getFieldName());
        Assert.assertEquals((Object)"tablet", (Object)r.getString());
        Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
        Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
        Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
    }

    @Test
    public void testSimple2() throws IOException {
        HashMap<String, String> cfPath = new HashMap<String, String>();
        cfPath.put("first_name", "first_name");
        Table tab = DBTests.createOrReplaceTable("mytab", cfPath);
        Document d = MapRDBImpl.newDocument().set("first_name", "Jane").set("last_name", "Dane");
        tab.insertOrReplace("r1", d);
        tab.flush();
        for (DocumentReader r : tab.find(new String[]{"first_name"}).documentReaders()) {
            Assert.assertTrue((boolean)r.inMap());
            Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
            Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)r.next());
            Assert.assertEquals((Object)"_id", (Object)r.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)r.next());
            Assert.assertEquals((Object)"first_name", (Object)r.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
            Assert.assertNull((Object)r.next());
        }
    }

    @Test
    public void testMultiMCFScalarDataWithDefaultCFEmpty() throws IOException {
        HashMap<String, String> cfPath = new HashMap<String, String>();
        cfPath.put("first_name", "first_name");
        cfPath.put("age", "age");
        cfPath.put("zip", "zip");
        Table tab = DBTests.createOrReplaceTable("mytab", cfPath);
        Document d = MapRDBImpl.newDocument().set("first_name", "Jane").set("last_name", "Dane").set("zip", 92026);
        tab.insertOrReplace("r1", d);
        tab.flush();
        for (DocumentReader r : tab.find(new String[]{"first_name", "zip"}).documentReaders()) {
            Assert.assertTrue((boolean)r.inMap());
            Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
            Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)r.next());
            Assert.assertEquals((Object)"_id", (Object)r.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.INT, (Object)r.next());
            Assert.assertEquals((Object)"zip", (Object)r.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)r.next());
            Assert.assertEquals((Object)"first_name", (Object)r.getFieldName());
            Assert.assertEquals((Object)"Jane", (Object)r.getString());
            Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
            Assert.assertNull((Object)r.next());
        }
    }

    @Test
    public void testMultiCFWithMapAndEmptyDefault() throws IOException {
        HashMap<String, String> cfPath = new HashMap<String, String>();
        cfPath.put("first_name", "first_name");
        cfPath.put("age", "age");
        cfPath.put("address.zip", "address.zip");
        Table tab = DBTests.createOrReplaceTable("mytab", cfPath);
        Document d = MapRDBImpl.newDocument().set("first_name", "Jane").set("last_name", "Dane").set("age", 22).set("address.name", "Bond St").set("address.zip", 92026);
        tab.insertOrReplace("r1", d);
        tab.flush();
        for (DocumentReader r : tab.find(new String[]{"first_name", "address"}).documentReaders()) {
            Assert.assertTrue((boolean)r.inMap());
            Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
            Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)r.next());
            Assert.assertEquals((Object)"_id", (Object)r.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
            Assert.assertEquals((Object)"address", (Object)r.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)r.next());
            Assert.assertEquals((Object)"name", (Object)r.getFieldName());
            Assert.assertEquals((Object)"Bond St", (Object)r.getString());
            Assert.assertEquals((Object)DocumentReader.EventType.INT, (Object)r.next());
            Assert.assertEquals((Object)"zip", (Object)r.getFieldName());
            Assert.assertEquals((long)92026L, (long)r.getInt());
            Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
            Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)r.next());
            Assert.assertEquals((Object)"first_name", (Object)r.getFieldName());
            Assert.assertEquals((Object)"Jane", (Object)r.getString());
            Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
            Assert.assertNull((Object)r.next());
        }
    }

    @Test
    public void testMultiCFWithArrayInNonDefaultCFProj() throws Exception {
        HashMap<String, String> cfPath = new HashMap<String, String>();
        cfPath.put("first_name", "first_name");
        cfPath.put("phone", "phone");
        cfPath.put("zip", "zip");
        Table tab = DBTests.createOrReplaceTable("mytab", cfPath);
        Document d = MapRDBImpl.newDocument().set("dept", "Sales").set("first_name", "Greg").setArray("phone", new String[]{"111111", "222222"}).set("zip", 92025);
        tab.insertOrReplace("r1", d);
        tab.flush();
        for (DocumentReader r : tab.find(new String[]{"phone"}).documentReaders()) {
            Assert.assertTrue((boolean)r.inMap());
            Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
            Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)r.next());
            Assert.assertEquals((Object)"_id", (Object)r.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.START_ARRAY, (Object)r.next());
            Assert.assertEquals((Object)"phone", (Object)r.getFieldName());
            Assert.assertTrue((boolean)r.inMap());
            Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)r.next());
            Assert.assertEquals((Object)"111111", (Object)r.getString());
            Assert.assertTrue((!r.inMap() ? 1 : 0) != 0);
            Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)r.next());
            Assert.assertEquals((Object)"222222", (Object)r.getString());
            Assert.assertEquals((Object)DocumentReader.EventType.END_ARRAY, (Object)r.next());
            Assert.assertEquals((Object)"phone", (Object)r.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
            Assert.assertNull((Object)r.next());
        }
    }

    @Test
    public void testEmptyDefaultWithArrayProjInCF() throws Exception {
        HashMap<String, String> cfPath = new HashMap<String, String>();
        cfPath.put("first_name", "first_name");
        cfPath.put("phone", "phone");
        cfPath.put("zip", "zip");
        Table tab = DBTests.createOrReplaceTable("mytab", cfPath);
        Document d = MapRDBImpl.newDocument().set("dept", "Sales").set("first_name", "Greg").setArray("phone", new String[]{"111111", "222222", "333333"}).set("zip", 92025);
        tab.insertOrReplace("r1", d);
        tab.flush();
        for (DocumentReader r : tab.find(new String[]{"phone[1]", "phone[2]", "zip"}).documentReaders()) {
            Assert.assertTrue((boolean)r.inMap());
            Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
            Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)r.next());
            Assert.assertEquals((Object)"_id", (Object)r.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.INT, (Object)r.next());
            Assert.assertEquals((Object)"zip", (Object)r.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.START_ARRAY, (Object)r.next());
            Assert.assertEquals((Object)"phone", (Object)r.getFieldName());
            Assert.assertTrue((boolean)r.inMap());
            Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)r.next());
            Assert.assertEquals((Object)"222222", (Object)r.getString());
            Assert.assertEquals((long)1L, (long)r.getArrayIndex());
            Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)r.next());
            Assert.assertEquals((Object)"333333", (Object)r.getString());
            Assert.assertEquals((long)2L, (long)r.getArrayIndex());
            Assert.assertTrue((!r.inMap() ? 1 : 0) != 0);
            Assert.assertEquals((Object)DocumentReader.EventType.END_ARRAY, (Object)r.next());
            Assert.assertEquals((Object)"phone", (Object)r.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
            Assert.assertNull((Object)r.next());
        }
    }

    @Test
    public void testMultipleArrayOnMultipleCF() throws Exception {
        HashMap<String, String> cfPath = new HashMap<String, String>();
        cfPath.put("k", "k");
        cfPath.put("phone", "phone");
        cfPath.put("zip", "zip");
        Table tab = DBTests.createOrReplaceTable("mytab", cfPath);
        Document d = MapRDBImpl.newDocument().set("dept", "Sales").setArray("k", new int[]{123, 7777}).setArray("phone", new String[]{"111111", "222222", "333333"}).set("zip", 92025);
        tab.insertOrReplace("r1", d);
        tab.flush();
        for (DocumentReader r : tab.find(new String[]{"k", "phone[1]", "phone[2]"}).documentReaders()) {
            Assert.assertTrue((boolean)r.inMap());
            Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
            Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)r.next());
            Assert.assertEquals((Object)"_id", (Object)r.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.START_ARRAY, (Object)r.next());
            Assert.assertEquals((Object)"phone", (Object)r.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)r.next());
            Assert.assertEquals((Object)"222222", (Object)r.getString());
            Assert.assertEquals((long)1L, (long)r.getArrayIndex());
            Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)r.next());
            Assert.assertEquals((Object)"333333", (Object)r.getString());
            Assert.assertEquals((long)2L, (long)r.getArrayIndex());
            Assert.assertEquals((Object)DocumentReader.EventType.END_ARRAY, (Object)r.next());
            Assert.assertEquals((Object)"phone", (Object)r.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.START_ARRAY, (Object)r.next());
            Assert.assertEquals((Object)DocumentReader.EventType.INT, (Object)r.next());
            Assert.assertEquals((long)123L, (long)r.getInt());
            Assert.assertEquals((long)0L, (long)r.getArrayIndex());
            Assert.assertEquals((Object)DocumentReader.EventType.INT, (Object)r.next());
            Assert.assertEquals((long)7777L, (long)r.getInt());
            Assert.assertEquals((long)1L, (long)r.getArrayIndex());
            Assert.assertEquals((Object)DocumentReader.EventType.END_ARRAY, (Object)r.next());
            Assert.assertEquals((Object)"k", (Object)r.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
        }
    }

    @Test
    public void testBug23524Reop() throws Exception {
        HashMap<String, String> cfPath = new HashMap<String, String>();
        cfPath.put("a.b", "a.b");
        cfPath.put("s1.s2", "s1.s2");
        Table tab = DBTests.createOrReplaceTable("mytab", cfPath);
        Document d = MapRDBImpl.newDocument().set("x.y", "elan").set("x.z", 350).set("a.b.c1", 23).set("a.b.c2", true).set("s1.s2.s3.s4", 12345).set("s1.s2.s5", false);
        tab.insertOrReplace("r1", d);
        tab.flush();
        for (DocumentReader r : tab.find(new String[]{"a.b"}).documentReaders()) {
            Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
            Assert.assertNull((Object)r.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)r.next());
            Assert.assertEquals((Object)"r1", (Object)r.getString());
            Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
            Assert.assertEquals((Object)"a", (Object)r.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
            Assert.assertEquals((Object)"b", (Object)r.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.INT, (Object)r.next());
            Assert.assertEquals((Object)"c1", (Object)r.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.BOOLEAN, (Object)r.next());
            Assert.assertTrue((boolean)r.getBoolean());
            Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
            Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
            Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
            Assert.assertNull((Object)r.next());
        }
    }

    @Test
    public void testReaderWithMultiLevelMCFAndProjection() throws Exception {
        HashMap<String, String> cfPath = new HashMap<String, String>();
        cfPath.put("a.b.c", "a.b.c");
        cfPath.put("a.b.d", "a.b.d");
        cfPath.put("s1.s2", "s1.s2");
        Document d = MapRDBImpl.newDocument().set("x.y.k1.k2.k3", "elan").set("x.z", 350).set("a.b.c.k1.n1", 23).set("a.b.c.k2.n2", true).set("a.b.d.l1", "sanjose").set("s1.s2.s3.s4.p1", 12345).set("s1.s2.s5.s6.p2", false);
        Table tab = DBTests.createOrReplaceTable("mytab", cfPath);
        tab.insertOrReplace("r1", d);
        tab.flush();
        Iterator iter = tab.find(new String[]{"a.b.c.k2"}).documentReaders().iterator();
        Object et = null;
        while (iter.hasNext()) {
            DocumentReader reader = (DocumentReader)iter.next();
            Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)reader.next());
            Assert.assertNull((Object)reader.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)reader.next());
            Assert.assertEquals((Object)"r1", (Object)reader.getString());
            Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)reader.next());
            Assert.assertEquals((Object)"a", (Object)reader.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)reader.next());
            Assert.assertEquals((Object)"b", (Object)reader.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)reader.next());
            Assert.assertEquals((Object)"c", (Object)reader.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)reader.next());
            Assert.assertEquals((Object)"k2", (Object)reader.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.BOOLEAN, (Object)reader.next());
            Assert.assertEquals((Object)"n2", (Object)reader.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)reader.next());
            Assert.assertEquals((Object)"k2", (Object)reader.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)reader.next());
            Assert.assertEquals((Object)"c", (Object)reader.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)reader.next());
            Assert.assertEquals((Object)"b", (Object)reader.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)reader.next());
            Assert.assertEquals((Object)"a", (Object)reader.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)reader.next());
            Assert.assertNull((Object)reader.getFieldName());
            Assert.assertNull((Object)reader.next());
        }
    }

    @Test
    public void testBug24189() throws Exception {
        HashMap<String, String> cfPath = new HashMap<String, String>();
        cfPath.put("a.b", "a.b");
        cfPath.put("a.b.c", "a.b.c");
        Table tab = DBTests.createOrReplaceTable("mytab", cfPath);
        Document d = MapRDBImpl.newDocument().set("x", 222).set("a.b.c.k", "xyz").set("a.b.c.x1.x2.x3.x4.x5", ODate.parse((String)"2012-10-10")).set("a.b.c.x1.x2.x3.z1.z2.z3.z4", OTime.parse((String)"12:30:01.111")).set("a.b.c.x1.x2.x3.z1.z2.z3.z5", 0x12E1E2).set("a.b.c.p", true).set("a.b.d", 1.1);
        tab.insertOrReplace("k1", d);
        tab.flush();
        for (DocumentReader reader : tab.find(new String[]{"a.b.c.x1.x2.x3.x4", "a.b.c.k", "a.b.c.x1.x2.x3.z1.z2", "a.b.d"}).documentReaders()) {
            Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)reader.next());
            Assert.assertNull((Object)reader.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)reader.next());
            Assert.assertEquals((Object)"k1", (Object)reader.getString());
            Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)reader.next());
            Assert.assertEquals((Object)"a", (Object)reader.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)reader.next());
            Assert.assertEquals((Object)"b", (Object)reader.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.DOUBLE, (Object)reader.next());
            Assert.assertEquals((double)1.1, (double)reader.getDouble(), (double)0.0);
            Assert.assertEquals((Object)"d", (Object)reader.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)reader.next());
            Assert.assertEquals((Object)"c", (Object)reader.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)reader.next());
            Assert.assertEquals((Object)"xyz", (Object)reader.getString());
            Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)reader.next());
            Assert.assertEquals((Object)"x1", (Object)reader.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)reader.next());
            Assert.assertEquals((Object)"x2", (Object)reader.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)reader.next());
            Assert.assertEquals((Object)"x3", (Object)reader.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)reader.next());
            Assert.assertEquals((Object)"x4", (Object)reader.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.DATE, (Object)reader.next());
            Assert.assertEquals((Object)"x5", (Object)reader.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)reader.next());
            Assert.assertEquals((Object)"x4", (Object)reader.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)reader.next());
            Assert.assertEquals((Object)"z1", (Object)reader.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)reader.next());
            Assert.assertEquals((Object)"z2", (Object)reader.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)reader.next());
            Assert.assertEquals((Object)"z3", (Object)reader.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.TIME, (Object)reader.next());
            Assert.assertEquals((Object)"z4", (Object)reader.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.INT, (Object)reader.next());
            Assert.assertEquals((Object)"z5", (Object)reader.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)reader.next());
            Assert.assertEquals((Object)"z3", (Object)reader.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)reader.next());
            Assert.assertEquals((Object)"z2", (Object)reader.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)reader.next());
            Assert.assertEquals((Object)"z1", (Object)reader.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)reader.next());
            Assert.assertEquals((Object)"x3", (Object)reader.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)reader.next());
            Assert.assertEquals((Object)"x2", (Object)reader.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)reader.next());
            Assert.assertEquals((Object)"x1", (Object)reader.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)reader.next());
            Assert.assertEquals((Object)"c", (Object)reader.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)reader.next());
            Assert.assertEquals((Object)"b", (Object)reader.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)reader.next());
            Assert.assertEquals((Object)"a", (Object)reader.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)reader.next());
            Assert.assertNull((Object)reader.getFieldName());
            Assert.assertNull((Object)reader.next());
        }
    }

    @Test
    public void testBug24167() throws Exception {
        HashMap<String, String> cfPath = new HashMap<String, String>();
        cfPath.put("a", "a");
        cfPath.put("x.y", "x.y");
        Table tab = DBTests.createOrReplaceTable("mytab", cfPath);
        Document d = MapRDBImpl.newDocument().set("p.k1.k2.k3", 12).set("a.g1.g2.g3", "eureka").set("x.y.z1.z2.z3.z4", true);
        tab.insertOrReplace("k1", d);
        tab.flush();
        for (DocumentReader reader : tab.find(new String[]{"p.k1.k2.k3", "a.g1.g2", "x.y.z1.z2.z3"}).documentReaders()) {
            Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)reader.next());
            Assert.assertNull((Object)reader.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)reader.next());
            Assert.assertEquals((Object)"k1", (Object)reader.getString());
            Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)reader.next());
            Assert.assertEquals((Object)"p", (Object)reader.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)reader.next());
            Assert.assertEquals((Object)"k1", (Object)reader.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)reader.next());
            Assert.assertEquals((Object)"k2", (Object)reader.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.INT, (Object)reader.next());
            Assert.assertEquals((long)12L, (long)reader.getInt());
            Assert.assertEquals((Object)"k3", (Object)reader.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)reader.next());
            Assert.assertEquals((Object)"k2", (Object)reader.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)reader.next());
            Assert.assertEquals((Object)"k1", (Object)reader.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)reader.next());
            Assert.assertEquals((Object)"p", (Object)reader.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)reader.next());
            Assert.assertEquals((Object)"a", (Object)reader.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)reader.next());
            Assert.assertEquals((Object)"g1", (Object)reader.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)reader.next());
            Assert.assertEquals((Object)"g2", (Object)reader.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)reader.next());
            Assert.assertEquals((Object)"eureka", (Object)reader.getString());
            Assert.assertEquals((Object)"g3", (Object)reader.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)reader.next());
            Assert.assertEquals((Object)"g2", (Object)reader.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)reader.next());
            Assert.assertEquals((Object)"g1", (Object)reader.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)reader.next());
            Assert.assertEquals((Object)"a", (Object)reader.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)reader.next());
            Assert.assertEquals((Object)"x", (Object)reader.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)reader.next());
            Assert.assertEquals((Object)"y", (Object)reader.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)reader.next());
            Assert.assertEquals((Object)"z1", (Object)reader.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)reader.next());
            Assert.assertEquals((Object)"z2", (Object)reader.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)reader.next());
            Assert.assertEquals((Object)"z3", (Object)reader.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.BOOLEAN, (Object)reader.next());
            Assert.assertEquals((Object)"z4", (Object)reader.getFieldName());
            Assert.assertTrue((boolean)reader.getBoolean());
            Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)reader.next());
            Assert.assertEquals((Object)"z3", (Object)reader.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)reader.next());
            Assert.assertEquals((Object)"z2", (Object)reader.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)reader.next());
            Assert.assertEquals((Object)"z1", (Object)reader.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)reader.next());
            Assert.assertEquals((Object)"y", (Object)reader.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)reader.next());
            Assert.assertEquals((Object)"x", (Object)reader.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)reader.next());
            Assert.assertNull((Object)reader.getFieldName());
            Assert.assertNull((Object)reader.next());
        }
    }
}

