/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.tests.ojai;

import com.google.common.collect.ImmutableMap;
import com.mapr.db.ojai.DBDocumentReader;
import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.db.rowcol.DBValueBuilderImpl;
import com.mapr.db.rowcol.KeyValue;
import com.mapr.db.rowcol.RowcolCodec;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.SimpleTest;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;
import org.ojai.DocumentReader;
import org.ojai.DocumentStream;
import org.ojai.FieldPath;
import org.ojai.json.Json;

@Category(value={SimpleTest.class})
public class TestDBDocumentReader
extends BaseTest {
    private static final KeyValue _ID = DBValueBuilderImpl.KeyValueBuilder.initFrom("id1");

    @Test
    public void testSkipChildren() throws Exception {
        try (InputStream testJson = this.getResourceStream("com/mapr/db/tests/json/complex.json");
             DocumentStream stream = Json.newDocumentStream((InputStream)testJson);){
            DBDocumentImpl dbDoc = RowcolCodec.getDBDocument((Document)((Document)stream.iterator().next()));
            ByteBuffer encoded = RowcolCodec.encode((Document)dbDoc);
            DBDocumentReader r = new DBDocumentReader((Map)ImmutableMap.of((Object)0, (Object)encoded), (Map)ImmutableMap.of((Object)FieldPath.EMPTY, (Object)0), _ID, false);
            DocumentReader.EventType et = null;
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertTrue((boolean)r.inMap());
            Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)et);
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertTrue((boolean)r.inMap());
            Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)et);
            Assert.assertEquals((Object)"_id", (Object)r.getFieldName());
            r.skipChildren();
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertEquals((Object)"active", (Object)r.getFieldName());
            r.skipChildren();
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertEquals((Object)"age", (Object)r.getFieldName());
            r.skipChildren();
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)et);
            Assert.assertEquals((Object)"favorites", (Object)r.getFieldName());
            r.skipChildren();
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertTrue((boolean)r.inMap());
            Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)et);
            Assert.assertEquals((Object)"first", (Object)r.getFieldName());
            r.skipChildren();
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertEquals((Object)DocumentReader.EventType.START_ARRAY, (Object)et);
            Assert.assertEquals((Object)"interests", (Object)r.getFieldName());
            r.skipChildren();
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertEquals((Object)"last", (Object)r.getFieldName());
            r.skipChildren();
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertEquals((Object)"salary", (Object)r.getFieldName());
            r.skipChildren();
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertEquals((Object)"sex", (Object)r.getFieldName());
            r.skipChildren();
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertEquals((Object)DocumentReader.EventType.START_ARRAY, (Object)et);
            Assert.assertEquals((Object)"skills", (Object)r.getFieldName());
            r.skipChildren();
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)et);
            r.skipChildren();
            et = r.next();
            Assert.assertNull((Object)et);
        }
    }
}

