/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.tests.condition;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mapr.db.impl.ConditionImpl;
import com.mapr.db.impl.ConditionNode;
import com.mapr.db.impl.Constants;
import com.mapr.db.impl.IdCodec;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.impl.index.IndexFieldDescImpl;
import com.mapr.db.index.IndexFieldDesc;
import com.mapr.db.indexrowkeyfmt.IndexRowKeyEncoder;
import com.mapr.db.rowcol.DBValueBuilderImpl;
import com.mapr.db.rowcol.KeyValue;
import com.mapr.fs.jni.MapRConstants;
import com.mapr.fs.proto.Dbfilters;
import com.mapr.org.apache.hadoop.hbase.util.Bytes;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.SimpleTest;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.MathContext;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.DocumentConstants;
import org.ojai.Value;
import org.ojai.store.QueryCondition;
import org.ojai.types.ODate;
import org.ojai.types.OInterval;
import org.ojai.types.OTime;
import org.ojai.types.OTimestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={SimpleTest.class})
public class TestCondition
extends BaseTest {
    private static final Logger _logger = LoggerFactory.getLogger(TestCondition.class);

    @Test
    public void testRowExist() {
        QueryCondition condition = Constants.ROW_EXISTS_CONDITION;
        this.serializeAndCompare(condition, "(_id != null)");
    }

    @Test
    public void testRowNotExist() {
        QueryCondition condition = Constants.ROW_NOT_EXISTS_CONDITION;
        this.serializeAndCompare(condition, "(_id = null)");
    }

    @Test
    public void testSimpleConditionsNonExistent() {
        ConditionImpl condition = MapRDBImpl.newCondition().notExists("nonExistantElem").build();
        this.serializeAndCompare((QueryCondition)condition, "(nonExistantElem = null)");
    }

    @Test
    public void testSimpleConditionsExistent() {
        ConditionImpl condition = MapRDBImpl.newCondition().exists("existantElem").build();
        this.serializeAndCompare((QueryCondition)condition, "(existantElem != null)");
    }

    @Test
    public void testSimpleConditionsNullType() {
        ConditionImpl condition = MapRDBImpl.newCondition().typeOf("nullElem", Value.Type.NULL).build();
        this.serializeAndCompare((QueryCondition)condition, "(TYPE_OF(nullElem) = NULL)");
    }

    @Test
    public void testSimpleConditionsBool() {
        QueryCondition condition = MapRDBImpl.newCondition().is("boolElem", QueryCondition.Op.EQUAL, false).build();
        this.serializeAndCompare(condition, "(boolElem = false)");
    }

    @Test
    public void testSimpleConditionsString() {
        ConditionImpl condition = MapRDBImpl.newCondition().is("stringElem", QueryCondition.Op.GREATER, "stupidity").build();
        this.serializeAndCompare((QueryCondition)condition, "(stringElem > \"stupidity\")");
    }

    @Test
    public void testSimpleConditionsInt() {
        ConditionImpl condition = MapRDBImpl.newCondition().is("intElem", QueryCondition.Op.NOT_EQUAL, 5).build();
        this.serializeAndCompare((QueryCondition)condition, "(intElem != {\"$numberLong\":5})");
    }

    @Test
    public void testSimpleConditionsLong() {
        ConditionImpl condition = MapRDBImpl.newCondition().is("longElem", QueryCondition.Op.LESS_OR_EQUAL, 527346237644235L).build();
        this.serializeAndCompare((QueryCondition)condition, "(longElem <= {\"$numberLong\":527346237644235})");
    }

    @Test
    public void testSimpleConditionsEmptyByteBuffer() {
        ByteBuffer bb = ByteBuffer.allocate(4).putInt(300);
        ConditionImpl condition = MapRDBImpl.newCondition().is("emptyByteBuffer", QueryCondition.Op.EQUAL, bb).build();
        this.serializeAndCompare((QueryCondition)condition, "(emptyByteBuffer = {\"$binary\":\"\"})");
    }

    @Test
    public void testSimpleConditionsFloat() {
        ConditionImpl condition = MapRDBImpl.newCondition().is("floatElem", QueryCondition.Op.LESS, 3.141592f).build();
        this.serializeAndCompare((QueryCondition)condition, "(floatElem < 3.141592025756836)");
    }

    @Test
    public void testSimpleConditionsDouble() {
        ConditionImpl condition = MapRDBImpl.newCondition().is("doubleElem", QueryCondition.Op.GREATER_OR_EQUAL, Math.PI).build();
        this.serializeAndCompare((QueryCondition)condition, "(doubleElem >= 3.141592653589793)");
    }

    @Test
    @Ignore(value="BigDecimal type not supported")
    public void testSimpleConditionsDecimal() {
        ConditionImpl condition = MapRDBImpl.newCondition().is("deceimalElem", QueryCondition.Op.EQUAL, new BigDecimal("3.141592653589793238462643383279502884197169399375105820974944592307816406286208998628034825342117068", new MathContext(100))).build();
        this.serializeAndCompare((QueryCondition)condition, "(deceimalElem = {\"$decimal\":\"3.141592653589793238462643383279502884197169399375105820974944592307816406286208998628034825342117068\"})");
    }

    @Test
    public void testSimpleConditionsDate() {
        ConditionImpl condition = MapRDBImpl.newCondition().is("dateElem", QueryCondition.Op.NOT_EQUAL, ODate.parse((String)"1979-08-24")).build();
        this.serializeAndCompare((QueryCondition)condition, "(dateElem != {\"$dateDay\":\"1979-08-24\"})");
    }

    @Test
    public void testSimpleConditionsTime() {
        ConditionImpl condition = MapRDBImpl.newCondition().is("timeElem", QueryCondition.Op.LESS_OR_EQUAL, OTime.parse((String)"16:32:00")).build();
        this.serializeAndCompare((QueryCondition)condition, "(timeElem <= {\"$time\":\"16:32:00\"})");
    }

    @Test
    public void testSimpleConditionsTimestamp() {
        ConditionImpl condition = MapRDBImpl.newCondition().is("timestampElem", QueryCondition.Op.EQUAL, OTimestamp.parse((String)"1979-08-24T16:32:00.000+05:30")).build();
        this.serializeAndCompare((QueryCondition)condition, "(timestampElem = {\"$date\":\"1979-08-24T11:02:00.000Z\"})");
    }

    @Test
    @Ignore(value="Interval type not supported")
    public void testSimpleConditionsInterval() {
        ConditionImpl condition = MapRDBImpl.newCondition().is("intervalElem", QueryCondition.Op.GREATER, new OInterval(1239213L)).build();
        this.serializeAndCompare((QueryCondition)condition, "(intervalElem > {\"$interval\":1239213})");
    }

    @Test
    public void testSimpleConditionsBinary() {
        ConditionImpl condition = MapRDBImpl.newCondition().is("binaryElem", QueryCondition.Op.EQUAL, ByteBuffer.wrap(new byte[]{97, 100, 105, 116, 121, 97})).build();
        this.serializeAndCompare((QueryCondition)condition, "(binaryElem = {\"$binary\":\"YWRpdHlh\"})");
    }

    @Test
    public void testSimpleConditionsMap() {
        ConditionImpl condition = MapRDBImpl.newCondition().equals("mapElem", (Map)ImmutableMap.of((Object)"name", (Object)"hulk", (Object)"weight", (Object)526, (Object)"id", (Object)627131273323L, (Object)"dob", (Object)OTimestamp.parse((String)"1979-10-12T05:23:00.122+07:00"))).build();
        this.serializeAndCompare((QueryCondition)condition, "(mapElem = {\"name\":\"hulk\",\"weight\":{\"$numberLong\":526},\"id\":{\"$numberLong\":627131273323},\"dob\":{\"$date\":\"1979-10-11T22:23:00.122Z\"}})");
    }

    @Test
    public void testSimpleConditionsEmptyMap() {
        ImmutableMap emptyMap = ImmutableMap.of();
        ConditionImpl condition = MapRDBImpl.newCondition().equals("emptyMapElem", (Map)emptyMap).build();
        this.serializeAndCompare((QueryCondition)condition, "(emptyMapElem = {})");
    }

    @Test
    public void testSimpleConditionsArray() {
        ConditionImpl condition = MapRDBImpl.newCondition().equals("listElem", (List)ImmutableList.of((Object)"January", (Object)4, (Object)OTimestamp.parse((String)"2015-03-14T20:12:21.000+00:00"), (Object)ODate.parse((String)"1969-12-31"), (Object)ODate.parse((String)"1970-01-01"), (Object)ODate.parse((String)"1950-01-26"), (Object)OTime.parse((String)"11:22:33"))).build();
        this.serializeAndCompare((QueryCondition)condition, "(listElem = [\"January\",{\"$numberLong\":4},{\"$date\":\"2015-03-14T20:12:21.000Z\"},{\"$dateDay\":\"1969-12-31\"},{\"$dateDay\":\"1970-01-01\"},{\"$dateDay\":\"1950-01-26\"},{\"$time\":\"11:22:33\"}])");
    }

    @Test
    public void testSimpleConditionsEmptyArray() {
        ConditionImpl condition = MapRDBImpl.newCondition().equals("emptyListElem", (List)ImmutableList.of()).build();
        this.serializeAndCompare((QueryCondition)condition, "(emptyListElem = [])");
    }

    @Test
    public void testSimpleConditionsWithLike() {
        QueryCondition condition = MapRDBImpl.newCondition().like("likeElem", "San%").build();
        this.serializeAndCompare(condition, "(likeElem MATCHES \"^\\\\QSan\\\\E.*$\")");
    }

    @Test
    public void testSimpleConditionsWithNotLike() {
        QueryCondition condition = MapRDBImpl.newCondition().notLike("likeElem", "%San__%").build();
        this.serializeAndCompare(condition, "(likeElem NOT_MATCHES \"^.*\\\\QSan\\\\E...*$\")");
    }

    @Test
    public void testSimpleConditionsRegexMatch() {
        ConditionImpl condition = MapRDBImpl.newCondition().matches("patternElem", ".*peace$").build();
        this.serializeAndCompare((QueryCondition)condition, "(patternElem MATCHES \".*peace$\")");
    }

    @Test
    public void testSimpleConditionsRegecNonMatch() {
        ConditionImpl condition = MapRDBImpl.newCondition().notMatches("antiPatternElem", ".*war.*").build();
        this.serializeAndCompare((QueryCondition)condition, "(antiPatternElem NOT_MATCHES \".*war.*\")");
    }

    @Test
    public void testSimpleConditionsRegexMatchId() {
        ConditionImpl condition = MapRDBImpl.newCondition().matches("_id", ".*peace$").build();
        this.serializeAndCompare((QueryCondition)condition, "(_id MATCHES \".*peace$\")");
    }

    @Test
    public void testSimpleConditionsRegecNonMatchId() {
        ConditionImpl condition = MapRDBImpl.newCondition().notMatches("_id", ".*war.*").build();
        this.serializeAndCompare((QueryCondition)condition, "(_id NOT_MATCHES \".*war.*\")");
    }

    @Test
    public void testSimpleConditionsIn() {
        ConditionImpl condition = MapRDBImpl.newCondition().in("oneInTheListElem", (List)ImmutableList.of((Object)42, (Object)"42", (Object)new ODate(42L), (Object)new OTime(42L), (Object)new OTimestamp(42L))).build();
        this.serializeAndCompare((QueryCondition)condition, "((oneInTheListElem = {\"$numberLong\":42}) or (oneInTheListElem = \"42\") or (oneInTheListElem = {\"$dateDay\":\"1969-12-31\"}) or (oneInTheListElem = {\"$time\":\"17:00:00.042\"}) or (oneInTheListElem = {\"$date\":\"1970-01-01T00:00:00.042Z\"}))");
    }

    @Test
    public void testSimpleConditionsNotIn() {
        ConditionImpl condition = MapRDBImpl.newCondition().notIn("noneInTheListElem", (List)ImmutableList.of((Object)"gold", (Object)"silver", (Object)"bronze")).build();
        this.serializeAndCompare((QueryCondition)condition, "((noneInTheListElem != \"gold\") and (noneInTheListElem != \"silver\") and (noneInTheListElem != \"bronze\"))");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConditionCompoundingWihoutBlock() {
        ConditionImpl condition = MapRDBImpl.newCondition().is("a", QueryCondition.Op.EQUAL, 6).matches("b", "wrong_condition_grouping").build();
    }

    @Test
    public void testConditionWithId() {
        ConditionImpl condition = MapRDBImpl.newCondition().is(DocumentConstants.ID_FIELD, QueryCondition.Op.GREATER_OR_EQUAL, "pqr").build();
        condition = condition.cloneOptimized();
        Assert.assertTrue((boolean)condition.isEmpty());
        this.checkAndGetRange((QueryCondition)condition, this.encode("pqr"), MapRConstants.EMPTY_BYTE_ARRAY);
        this.serializeAndCompare((QueryCondition)condition);
    }

    @Test
    public void testConditionWithIdEqual() {
        ConditionImpl condition = MapRDBImpl.newCondition().is(DocumentConstants.ID_FIELD, QueryCondition.Op.EQUAL, "pqr").build();
        condition = condition.cloneOptimized();
        Assert.assertTrue((boolean)condition.isEmpty());
        this.checkAndGetRange((QueryCondition)condition, this.encode("pqr"), this.encode("pqr\u0000"));
        this.serializeAndCompare((QueryCondition)condition);
    }

    @Test
    public void testConditionWithIdNotEqual() {
        ConditionImpl condition = MapRDBImpl.newCondition().is(DocumentConstants.ID_FIELD, QueryCondition.Op.NOT_EQUAL, "pqr").build();
        Assert.assertTrue((!(condition = condition.cloneOptimized()).isEmpty() ? 1 : 0) != 0);
        this.checkAndGetRange((QueryCondition)condition, MapRConstants.EMPTY_BYTE_ARRAY, MapRConstants.EMPTY_BYTE_ARRAY);
        this.serializeAndCompare((QueryCondition)condition, "(_id != \"pqr\")");
    }

    @Test
    public void testConditionWithIdOnMatches() {
        ConditionImpl condition = MapRDBImpl.newCondition().matches(DocumentConstants.ID_FIELD, "device.*").build();
        Assert.assertFalse((boolean)condition.isEmpty());
        this.checkAndGetRange((QueryCondition)condition, this.encode("device"), this.encode("devicf"));
        this.serializeAndCompare((QueryCondition)condition, "(_id MATCHES \"device.*\")");
    }

    @Test
    public void testConditionWithIdRange() {
        ConditionImpl condition = MapRDBImpl.newCondition().and().is(DocumentConstants.ID_FIELD, QueryCondition.Op.GREATER_OR_EQUAL, "pqr").is(DocumentConstants.ID_FIELD, QueryCondition.Op.LESS, "uvw").close().build();
        condition = condition.cloneOptimized();
        Assert.assertTrue((boolean)condition.isEmpty());
        this.checkAndGetRange((QueryCondition)condition, this.encode("pqr"), this.encode("uvw"));
        this.serializeAndCompare((QueryCondition)condition);
    }

    @Test
    public void testConditionWithIdDisjointRange() {
        ConditionImpl condition = MapRDBImpl.newCondition().or().is(DocumentConstants.ID_FIELD, QueryCondition.Op.LESS, "pqr").is(DocumentConstants.ID_FIELD, QueryCondition.Op.GREATER, "uvw").close().build();
        condition = condition.cloneOptimized();
        Assert.assertFalse((boolean)condition.isEmpty());
        this.checkAndGetRange((QueryCondition)condition, MapRConstants.EMPTY_BYTE_ARRAY, MapRConstants.EMPTY_BYTE_ARRAY);
        this.serializeAndCompare((QueryCondition)condition, "((_id < \"pqr\") or (_id > \"uvw\"))");
    }

    @Test
    public void testConditionWithIdReveseRange() {
        ConditionImpl condition = MapRDBImpl.newCondition().and().is(DocumentConstants.ID_FIELD, QueryCondition.Op.LESS, "pqr").is(DocumentConstants.ID_FIELD, QueryCondition.Op.GREATER, "uvw").close().build();
        condition = condition.cloneOptimized();
        this.checkAndGetRange((QueryCondition)condition, this.encodeStringBinary("uvw\\x00"), this.encode("pqr"));
        this.serializeAndCompare((QueryCondition)condition);
    }

    @Test
    public void testMultiLevelAndConditionsOnId() {
        ConditionImpl condition = MapRDBImpl.newCondition().and().and().is(DocumentConstants.ID_FIELD, QueryCondition.Op.GREATER, "abc").is(DocumentConstants.ID_FIELD, QueryCondition.Op.LESS, "pqr").close().is(DocumentConstants.ID_FIELD, QueryCondition.Op.GREATER_OR_EQUAL, "rst").is(DocumentConstants.ID_FIELD, QueryCondition.Op.LESS_OR_EQUAL, "xyz").close().build();
        this.serializeAndCompare((QueryCondition)condition, "(((_id > \"abc\") and (_id < \"pqr\")) and (_id >= \"rst\") and (_id <= \"xyz\"))");
        condition = condition.cloneOptimized();
        this.checkAndGetRange((QueryCondition)condition, this.encode("rst"), this.encode("pqr"));
        this.serializeAndCompare((QueryCondition)condition);
    }

    @Test
    public void testOrOfAndsConditionsOnId() {
        ConditionImpl condition = MapRDBImpl.newCondition().or().and().is(DocumentConstants.ID_FIELD, QueryCondition.Op.GREATER, "abc").is(DocumentConstants.ID_FIELD, QueryCondition.Op.LESS, "pqr").close().and().is(DocumentConstants.ID_FIELD, QueryCondition.Op.GREATER_OR_EQUAL, "efg").is(DocumentConstants.ID_FIELD, QueryCondition.Op.LESS_OR_EQUAL, "xyz").close().close().build();
        condition = condition.cloneOptimized();
        Assert.assertFalse((boolean)condition.isEmpty());
        this.checkAndGetRange((QueryCondition)condition, this.encodeStringBinary("abc\\x00"), this.encodeStringBinary("xyz\\x00"));
        this.serializeAndCompare((QueryCondition)condition, "(((_id > \"abc\") and (_id < \"pqr\")) or ((_id >= \"efg\") and (_id <= \"xyz\")))");
    }

    @Test
    public void testMultiLevelCondition() {
        QueryCondition condition = this.newComplexCondition1();
        Assert.assertEquals((Object)"((c.u.r != null) and (TYPE_OF(c.u.r) = ARRAY) and (c.u.r[0].d = 10.5) and ((a.b[4] = {\"$numberLong\":4}) or (b.e.t = \"35\")))", (Object)condition.toString());
        this.serializeAndCompare(condition, "((c.u.r != null) and (TYPE_OF(c.u.r) = ARRAY) and (c.u.r[0].d = 10.5) and ((a.b[4] = {\"$numberLong\":4}) or (b.e.t = \"35\")))");
    }

    @Test
    public void testAddConditionToAnotherCondition() {
        QueryCondition inner = this.newComplexCondition1();
        ConditionImpl outer0 = MapRDBImpl.newCondition().condition(inner).build();
        this.serializeAndCompare((QueryCondition)outer0, "((c.u.r != null) and (TYPE_OF(c.u.r) = ARRAY) and (c.u.r[0].d = 10.5) and ((a.b[4] = {\"$numberLong\":4}) or (b.e.t = \"35\")))");
        Assert.assertFalse((boolean)outer0.isEmpty());
        Assert.assertEquals((Object)inner, (Object)outer0);
        ConditionImpl outer1 = MapRDBImpl.newCondition().and().is(DocumentConstants.ID_FIELD, QueryCondition.Op.GREATER_OR_EQUAL, "pqr").is(DocumentConstants.ID_FIELD, QueryCondition.Op.LESS, "uvw").condition(inner).close().build();
        outer1 = outer1.cloneOptimized();
        this.serializeAndCompare((QueryCondition)outer1, "((c.u.r != null) and (TYPE_OF(c.u.r) = ARRAY) and (c.u.r[0].d = 10.5) and ((a.b[4] = {\"$numberLong\":4}) or (b.e.t = \"35\")))");
        Assert.assertFalse((boolean)outer1.isEmpty());
        Assert.assertEquals((Object)inner, (Object)outer1);
        ConditionImpl outer2 = MapRDBImpl.newCondition().and().is(DocumentConstants.ID_FIELD, QueryCondition.Op.GREATER_OR_EQUAL, "pqr").is("some.other.field", QueryCondition.Op.EQUAL, 25.69).condition(inner).close().build();
        outer2 = outer2.cloneOptimized();
        this.serializeAndCompare((QueryCondition)outer2, "((some.other.field = 25.69) and ((c.u.r != null) and (TYPE_OF(c.u.r) = ARRAY) and (c.u.r[0].d = 10.5) and ((a.b[4] = {\"$numberLong\":4}) or (b.e.t = \"35\"))))");
        Assert.assertFalse((boolean)outer2.isEmpty());
        Assert.assertNotEquals((Object)inner, (Object)outer2);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddConditionToAnotherConditionFail() {
        QueryCondition inner = this.newComplexCondition1();
        MapRDBImpl.newCondition().is("abc", QueryCondition.Op.EQUAL, "pqr").condition(inner).build();
    }

    @Test
    public void testComplexMixCondition() {
        ConditionImpl condition = MapRDBImpl.newCondition().and().is(DocumentConstants.ID_FIELD, QueryCondition.Op.GREATER, "device001").is("price", QueryCondition.Op.GREATER_OR_EQUAL, 75).is(DocumentConstants.ID_FIELD, QueryCondition.Op.LESS, "user999").or().is(DocumentConstants.ID_FIELD, QueryCondition.Op.GREATER, "parts550").is("price", QueryCondition.Op.LESS_OR_EQUAL, 100).close().close().build();
        condition = condition.cloneOptimized();
        this.checkAndGetRange((QueryCondition)condition, this.encodeStringBinary("device001\\x00"), this.encode("user999"));
        this.serializeAndCompare((QueryCondition)condition, "((price >= {\"$numberLong\":75}) and ((_id > \"parts550\") or (price <= {\"$numberLong\":100})))");
    }

    private byte[] encode(String in) {
        return IdCodec.encodeAsBytes((String)in);
    }

    private byte[] encodeStringBinary(String in) {
        return IdCodec.encodeStringBinary((String)in);
    }

    private void serializeAndCompare(QueryCondition condition) {
        this.serializeAndCompare(condition, "<EMPTY>");
    }

    private void serializeAndCompare(QueryCondition condition, String infix) {
        _logger.info("Serializing condition\n{}", (Object)((ConditionImpl)condition).asPrefix());
        ByteBuffer serialized = ((ConditionImpl)condition).getDescriptor().getSerialized();
        QueryCondition newCondition = ConditionImpl.parseFrom((ByteBuffer)serialized);
        Assert.assertEquals((Object)condition, (Object)newCondition);
        Assert.assertEquals((Object)infix, (Object)((ConditionImpl)condition).asInfix());
    }

    private ConditionNode.RowkeyRange checkAndGetRange(QueryCondition condition, byte[] start, byte[] stop) {
        List rowkeyRanges = ((ConditionImpl)condition).getRowkeyRanges();
        Assert.assertEquals((long)1L, (long)rowkeyRanges.size());
        ConditionNode.RowkeyRange rowkeyRange = (ConditionNode.RowkeyRange)rowkeyRanges.get(0);
        _logger.info("{}", (Object)rowkeyRange);
        Assert.assertArrayEquals((byte[])start, (byte[])rowkeyRange.getStartRow());
        Assert.assertArrayEquals((byte[])stop, (byte[])rowkeyRange.getStopRow());
        return rowkeyRange;
    }

    private QueryCondition newComplexCondition1() {
        return MapRDBImpl.newCondition().and().exists("c.u.r").typeOf("c.u.r", Value.Type.ARRAY).is("c.u.r[0].d", QueryCondition.Op.EQUAL, 10.5).or().is("a.b[4]", QueryCondition.Op.EQUAL, 4).is("b.e.t", QueryCondition.Op.EQUAL, "35").close().close().build();
    }

    private void checkRangeCalculationResults(ConditionNode.RowkeyRange[] expectedRanges, List<ConditionNode.RowkeyRange> calculatedRanges) {
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        out.println("");
        out.println("The ranges:");
        Assert.assertTrue((expectedRanges.length == calculatedRanges.size() ? 1 : 0) != 0);
        for (int i = 0; i < calculatedRanges.size(); ++i) {
            ConditionNode.RowkeyRange exp;
            ConditionNode.RowkeyRange calc = calculatedRanges.get(i);
            if (!calc.equals((Object)(exp = expectedRanges[i]))) {
                out.println("Failure for rowkey range " + i);
            }
            out.println("c" + i + " start: '" + Arrays.toString(calc.getStartRow()) + "', stop: '" + Arrays.toString(calc.getStopRow()) + "'");
            out.println("e" + i + " start: '" + Arrays.toString(exp.getStartRow()) + "', stop: '" + Arrays.toString(exp.getStopRow()) + "'");
            Assert.assertTrue((boolean)calc.equals((Object)exp));
        }
        out.println("Done!");
        out.close();
        _logger.debug(sw.toString());
    }

    private List<ConditionNode.RowkeyRange> getRowKeyRange(IndexRowKeyEncoder encoder, Dbfilters.CompareOpProto op, KeyValue value) {
        return encoder.getRowKeyRange(op, value, 0);
    }

    @Test
    public void testSecIdxRangeCalculation() {
        String fieldPath1 = "x.a";
        String fieldPath2 = "x.b";
        IndexFieldDescImpl[] partitionKeys = new IndexFieldDescImpl[]{new IndexFieldDescImpl(fieldPath1, IndexFieldDesc.Order.Asc, false, false, null), new IndexFieldDescImpl(fieldPath2, IndexFieldDesc.Order.Desc, false, false, null)};
        boolean[] descendingOrder = new boolean[]{false, true};
        IndexRowKeyEncoder encoder = new IndexRowKeyEncoder(descendingOrder);
        List<ConditionNode.RowkeyRange> expectedRangeList = this.getRowKeyRange(encoder, Dbfilters.CompareOpProto.GREATER_OR_EQUAL, DBValueBuilderImpl.KeyValueBuilder.initFrom("rst"));
        Assert.assertEquals((long)1L, (long)expectedRangeList.size());
        ConditionNode.RowkeyRange[] expectedRanges = expectedRangeList.toArray(new ConditionNode.RowkeyRange[expectedRangeList.size()]);
        ConditionImpl condition = MapRDBImpl.newCondition().is(fieldPath1, QueryCondition.Op.GREATER_OR_EQUAL, "rst");
        condition.setPartitionKeys((IndexFieldDesc[])partitionKeys).build();
        List calculatedRanges = condition.getRowkeyRanges();
        this.checkRangeCalculationResults(expectedRanges, calculatedRanges);
        expectedRangeList = this.getRowKeyRange(encoder, Dbfilters.CompareOpProto.LESS_OR_EQUAL, DBValueBuilderImpl.KeyValueBuilder.initFrom("rst"));
        Assert.assertEquals((long)1L, (long)expectedRangeList.size());
        expectedRanges = expectedRangeList.toArray(new ConditionNode.RowkeyRange[expectedRangeList.size()]);
        condition = MapRDBImpl.newCondition().is(fieldPath1, QueryCondition.Op.LESS_OR_EQUAL, "rst");
        condition.setPartitionKeys((IndexFieldDesc[])partitionKeys).build();
        calculatedRanges = condition.getRowkeyRanges();
        this.checkRangeCalculationResults(expectedRanges, calculatedRanges);
        expectedRangeList = this.getRowKeyRange(encoder, Dbfilters.CompareOpProto.GREATER, DBValueBuilderImpl.KeyValueBuilder.initFrom("rst"));
        Assert.assertEquals((long)1L, (long)expectedRangeList.size());
        expectedRanges = expectedRangeList.toArray(new ConditionNode.RowkeyRange[expectedRangeList.size()]);
        condition = MapRDBImpl.newCondition().is(fieldPath1, QueryCondition.Op.GREATER, "rst");
        condition.setPartitionKeys((IndexFieldDesc[])partitionKeys).build();
        calculatedRanges = condition.getRowkeyRanges();
        this.checkRangeCalculationResults(expectedRanges, calculatedRanges);
        expectedRangeList = this.getRowKeyRange(encoder, Dbfilters.CompareOpProto.LESS, DBValueBuilderImpl.KeyValueBuilder.initFrom("rst"));
        Assert.assertEquals((long)1L, (long)expectedRangeList.size());
        expectedRanges = expectedRangeList.toArray(new ConditionNode.RowkeyRange[expectedRangeList.size()]);
        condition = MapRDBImpl.newCondition().is(fieldPath1, QueryCondition.Op.LESS, "rst");
        condition.setPartitionKeys((IndexFieldDesc[])partitionKeys).build();
        calculatedRanges = condition.getRowkeyRanges();
        this.checkRangeCalculationResults(expectedRanges, calculatedRanges);
        ArrayList<ConditionNode.RowkeyRange> rangeList = new ArrayList<ConditionNode.RowkeyRange>(this.getRowKeyRange(encoder, Dbfilters.CompareOpProto.GREATER, DBValueBuilderImpl.KeyValueBuilder.initFrom("abc")));
        Assert.assertEquals((long)1L, (long)rangeList.size());
        rangeList.addAll(this.getRowKeyRange(encoder, Dbfilters.CompareOpProto.LESS, DBValueBuilderImpl.KeyValueBuilder.initFrom("rst")));
        Assert.assertEquals((long)2L, (long)rangeList.size());
        ConditionNode.RowkeyRange[] ranges = rangeList.toArray(new ConditionNode.RowkeyRange[rangeList.size()]);
        expectedRanges = new ConditionNode.RowkeyRange[]{new ConditionNode.RowkeyRange(ranges[0].getStartRow(), ranges[1].getStopRow())};
        condition = MapRDBImpl.newCondition().and().is(fieldPath1, QueryCondition.Op.GREATER, "abc").is(fieldPath1, QueryCondition.Op.LESS, "rst").close();
        condition.setPartitionKeys((IndexFieldDesc[])partitionKeys).build();
        calculatedRanges = condition.getRowkeyRanges();
        this.checkRangeCalculationResults(expectedRanges, calculatedRanges);
        rangeList = new ArrayList<ConditionNode.RowkeyRange>(this.getRowKeyRange(encoder, Dbfilters.CompareOpProto.GREATER, DBValueBuilderImpl.KeyValueBuilder.initFrom("abc")));
        Assert.assertEquals((long)1L, (long)rangeList.size());
        rangeList.addAll(this.getRowKeyRange(encoder, Dbfilters.CompareOpProto.LESS, DBValueBuilderImpl.KeyValueBuilder.initFrom("rst")));
        Assert.assertEquals((long)2L, (long)rangeList.size());
        ranges = rangeList.toArray(new ConditionNode.RowkeyRange[rangeList.size()]);
        expectedRanges = new ConditionNode.RowkeyRange[]{new ConditionNode.RowkeyRange(ranges[1].getStartRow(), ranges[0].getStopRow())};
        condition = MapRDBImpl.newCondition().or().is(fieldPath1, QueryCondition.Op.GREATER, "abc").is(fieldPath1, QueryCondition.Op.LESS, "rst").close();
        condition.setPartitionKeys((IndexFieldDesc[])partitionKeys).build();
        calculatedRanges = condition.getRowkeyRanges();
        this.checkRangeCalculationResults(expectedRanges, calculatedRanges);
        expectedRanges = new ConditionNode.RowkeyRange[]{};
        condition = MapRDBImpl.newCondition().and().is(fieldPath1, QueryCondition.Op.LESS, "abc").is(fieldPath1, QueryCondition.Op.GREATER, "rst").close();
        condition.setPartitionKeys((IndexFieldDesc[])partitionKeys).build();
        calculatedRanges = condition.getRowkeyRanges();
        this.checkRangeCalculationResults(expectedRanges, calculatedRanges);
        expectedRangeList = new ArrayList<ConditionNode.RowkeyRange>(this.getRowKeyRange(encoder, Dbfilters.CompareOpProto.LESS, DBValueBuilderImpl.KeyValueBuilder.initFrom("abc")));
        Assert.assertEquals((long)1L, (long)expectedRangeList.size());
        expectedRangeList.addAll(this.getRowKeyRange(encoder, Dbfilters.CompareOpProto.GREATER, DBValueBuilderImpl.KeyValueBuilder.initFrom("rst")));
        Assert.assertEquals((long)2L, (long)expectedRangeList.size());
        expectedRanges = expectedRangeList.toArray(new ConditionNode.RowkeyRange[expectedRangeList.size()]);
        condition = MapRDBImpl.newCondition().or().is(fieldPath1, QueryCondition.Op.LESS, "abc").is(fieldPath1, QueryCondition.Op.GREATER, "rst").close();
        condition.setPartitionKeys((IndexFieldDesc[])partitionKeys).build();
        calculatedRanges = condition.getRowkeyRanges();
        this.checkRangeCalculationResults(expectedRanges, calculatedRanges);
        rangeList = new ArrayList<ConditionNode.RowkeyRange>(this.getRowKeyRange(encoder, Dbfilters.CompareOpProto.GREATER, DBValueBuilderImpl.KeyValueBuilder.initFrom("pqr")));
        Assert.assertEquals((long)1L, (long)rangeList.size());
        rangeList.addAll(this.getRowKeyRange(encoder, Dbfilters.CompareOpProto.LESS, DBValueBuilderImpl.KeyValueBuilder.initFrom("rst")));
        Assert.assertEquals((long)2L, (long)rangeList.size());
        ranges = rangeList.toArray(new ConditionNode.RowkeyRange[rangeList.size()]);
        expectedRanges = new ConditionNode.RowkeyRange[]{new ConditionNode.RowkeyRange(ranges[0].getStartRow(), ranges[1].getStopRow())};
        condition = MapRDBImpl.newCondition().and().and().is(fieldPath1, QueryCondition.Op.GREATER, "abc").is(fieldPath1, QueryCondition.Op.LESS, "rst").close().is(fieldPath1, QueryCondition.Op.GREATER, "pqr").is(fieldPath1, QueryCondition.Op.LESS, "xyz").close();
        condition.setPartitionKeys((IndexFieldDesc[])partitionKeys).build();
        calculatedRanges = condition.getRowkeyRanges();
        this.checkRangeCalculationResults(expectedRanges, calculatedRanges);
        expectedRanges = new ConditionNode.RowkeyRange[]{};
        condition = MapRDBImpl.newCondition().and().and().is(fieldPath1, QueryCondition.Op.GREATER, "abc").is(fieldPath1, QueryCondition.Op.LESS, "rst").close().is(fieldPath1, QueryCondition.Op.GREATER_OR_EQUAL, "rst").is(fieldPath1, QueryCondition.Op.LESS, "xyz").close();
        condition.setPartitionKeys((IndexFieldDesc[])partitionKeys).build();
        calculatedRanges = condition.getRowkeyRanges();
        this.checkRangeCalculationResults(expectedRanges, calculatedRanges);
        rangeList = new ArrayList<ConditionNode.RowkeyRange>(this.getRowKeyRange(encoder, Dbfilters.CompareOpProto.GREATER, DBValueBuilderImpl.KeyValueBuilder.initFrom("pqs")));
        Assert.assertEquals((long)1L, (long)rangeList.size());
        rangeList.addAll(this.getRowKeyRange(encoder, Dbfilters.CompareOpProto.LESS, DBValueBuilderImpl.KeyValueBuilder.initFrom("rss")));
        Assert.assertEquals((long)2L, (long)rangeList.size());
        ranges = rangeList.toArray(new ConditionNode.RowkeyRange[rangeList.size()]);
        expectedRanges = new ConditionNode.RowkeyRange[]{new ConditionNode.RowkeyRange(ranges[0].getStartRow(), ranges[1].getStopRow())};
        condition = MapRDBImpl.newCondition().and().and().and().is(fieldPath1, QueryCondition.Op.GREATER, "abc").is(fieldPath1, QueryCondition.Op.LESS, "rst").close().is(fieldPath1, QueryCondition.Op.GREATER, "pqr").is(fieldPath1, QueryCondition.Op.LESS, "xyz").close().and().and().is(fieldPath1, QueryCondition.Op.GREATER, "bcd").is(fieldPath1, QueryCondition.Op.LESS, "rss").close().is(fieldPath1, QueryCondition.Op.GREATER, "pqs").is(fieldPath1, QueryCondition.Op.LESS, "xyz").close().close();
        condition.setPartitionKeys((IndexFieldDesc[])partitionKeys).build();
        calculatedRanges = condition.getRowkeyRanges();
        this.checkRangeCalculationResults(expectedRanges, calculatedRanges);
        rangeList = new ArrayList<ConditionNode.RowkeyRange>(this.getRowKeyRange(encoder, Dbfilters.CompareOpProto.GREATER, DBValueBuilderImpl.KeyValueBuilder.initFrom("pqr")));
        rangeList.addAll(this.getRowKeyRange(encoder, Dbfilters.CompareOpProto.LESS, DBValueBuilderImpl.KeyValueBuilder.initFrom("rst")));
        ranges = rangeList.toArray(new ConditionNode.RowkeyRange[rangeList.size()]);
        expectedRanges = new ConditionNode.RowkeyRange[]{new ConditionNode.RowkeyRange(ranges[0].getStartRow(), ranges[1].getStopRow())};
        condition = MapRDBImpl.newCondition().or().and().and().is(fieldPath1, QueryCondition.Op.GREATER, "abc").is(fieldPath1, QueryCondition.Op.LESS, "rst").close().is(fieldPath1, QueryCondition.Op.GREATER, "pqr").is(fieldPath1, QueryCondition.Op.LESS, "xyz").close().and().and().is(fieldPath1, QueryCondition.Op.GREATER, "bcd").is(fieldPath1, QueryCondition.Op.LESS, "rss").close().is(fieldPath1, QueryCondition.Op.GREATER, "pqs").is(fieldPath1, QueryCondition.Op.LESS, "xyz").close().close();
        condition.setPartitionKeys((IndexFieldDesc[])partitionKeys).build();
        calculatedRanges = condition.getRowkeyRanges();
        this.checkRangeCalculationResults(expectedRanges, calculatedRanges);
    }

    @Test
    public void testSecIdxRangeCalculation2() {
        String[] fieldPath = new String[]{"x.a", "x.b"};
        boolean[] descendingOrder = new boolean[]{true, true};
        IndexFieldDesc.Order[] order = new IndexFieldDesc.Order[]{descendingOrder[0] ? IndexFieldDesc.Order.Desc : IndexFieldDesc.Order.Asc, descendingOrder[1] ? IndexFieldDesc.Order.Desc : IndexFieldDesc.Order.Asc};
        IndexFieldDescImpl[] partitionKeys = new IndexFieldDescImpl[]{new IndexFieldDescImpl(fieldPath[0], order[0], false, false, null), new IndexFieldDescImpl(fieldPath[1], order[1], false, false, null)};
        IndexRowKeyEncoder encoder = new IndexRowKeyEncoder(descendingOrder);
        List<ConditionNode.RowkeyRange> expectedRangeList = this.getRowKeyRange(encoder, Dbfilters.CompareOpProto.EQUAL, DBValueBuilderImpl.KeyValueBuilder.initFrom("5"));
        Assert.assertEquals((long)1L, (long)expectedRangeList.size());
        ConditionNode.RowkeyRange[] expectedRanges = expectedRangeList.toArray(new ConditionNode.RowkeyRange[expectedRangeList.size()]);
        ConditionImpl condition = MapRDBImpl.newCondition().is(fieldPath[0], QueryCondition.Op.EQUAL, "5");
        condition.setPartitionKeys((IndexFieldDesc[])partitionKeys).build();
        List calculatedRanges = condition.getRowkeyRanges();
        this.checkRangeCalculationResults(expectedRanges, calculatedRanges);
    }

    @Test
    public void testSecIdxRangeCalculation3() {
        ConditionNode.RowkeyRange[] ranges;
        String[] fieldPath = new String[]{"x.a", "x.b"};
        boolean[] descendingOrder = new boolean[]{true, false};
        IndexFieldDesc.Order[] order = new IndexFieldDesc.Order[]{descendingOrder[0] ? IndexFieldDesc.Order.Desc : IndexFieldDesc.Order.Asc, descendingOrder[1] ? IndexFieldDesc.Order.Desc : IndexFieldDesc.Order.Asc};
        IndexFieldDescImpl[] partitionKeys = new IndexFieldDescImpl[]{new IndexFieldDescImpl(fieldPath[0], order[0], false, false, null), new IndexFieldDescImpl(fieldPath[1], order[1], false, false, null)};
        IndexRowKeyEncoder encoder = new IndexRowKeyEncoder(descendingOrder);
        ArrayList rangeList = new ArrayList(encoder.getRowKeyRange(Dbfilters.CompareOpProto.GREATER, DBValueBuilderImpl.KeyValueBuilder.initFrom("abc"), 0));
        Assert.assertEquals((long)1L, (long)rangeList.size());
        ConditionNode.RowkeyRange[] expectedRanges = ranges = rangeList.toArray(new ConditionNode.RowkeyRange[rangeList.size()]);
        ConditionImpl condition = MapRDBImpl.newCondition().and().is(fieldPath[0], QueryCondition.Op.GREATER, "abc").is(fieldPath[1], QueryCondition.Op.LESS, "rst").close();
        condition.setPartitionKeys((IndexFieldDesc[])partitionKeys).build();
        List calculatedRanges = condition.getRowkeyRanges();
        this.checkRangeCalculationResults(expectedRanges, calculatedRanges);
    }

    @Test
    public void testSecIdxRangeCalculation4() {
        String[] fieldPath = new String[]{"x.a", "x.b"};
        boolean[] descendingOrder = new boolean[]{false, true};
        IndexFieldDesc.Order[] order = new IndexFieldDesc.Order[]{descendingOrder[0] ? IndexFieldDesc.Order.Desc : IndexFieldDesc.Order.Asc, descendingOrder[1] ? IndexFieldDesc.Order.Desc : IndexFieldDesc.Order.Asc};
        IndexFieldDescImpl[] partitionKeys = new IndexFieldDescImpl[]{new IndexFieldDescImpl(fieldPath[0], order[0], false, false, null), new IndexFieldDescImpl(fieldPath[1], order[1], false, false, null)};
        IndexRowKeyEncoder encoder = new IndexRowKeyEncoder(descendingOrder);
        ArrayList rangeList = new ArrayList(encoder.getRowKeyRange(Dbfilters.CompareOpProto.EQUAL, DBValueBuilderImpl.KeyValueBuilder.initFrom("abc"), 0));
        Assert.assertEquals((long)1L, (long)rangeList.size());
        rangeList.addAll(encoder.getRowKeyRange(Dbfilters.CompareOpProto.EQUAL, DBValueBuilderImpl.KeyValueBuilder.initFrom("rst"), 1));
        Assert.assertEquals((long)2L, (long)rangeList.size());
        ConditionNode.RowkeyRange[] ranges = rangeList.toArray(new ConditionNode.RowkeyRange[rangeList.size()]);
        ConditionNode.RowkeyRange[] expectedRanges = new ConditionNode.RowkeyRange[]{new ConditionNode.RowkeyRange(Bytes.concatenate((byte[])ranges[0].getStartRow(), (byte[])ranges[1].getStartRow()), Bytes.concatenate((byte[])ranges[0].getStartRow(), (byte[])ranges[1].getStopRow()))};
        ConditionImpl condition = MapRDBImpl.newCondition().and().is(fieldPath[0], QueryCondition.Op.EQUAL, "abc").is(fieldPath[1], QueryCondition.Op.EQUAL, "rst").close();
        condition.setPartitionKeys((IndexFieldDesc[])partitionKeys).build();
        List calculatedRanges = condition.getRowkeyRanges();
        this.checkRangeCalculationResults(expectedRanges, calculatedRanges);
    }

    @Test
    public void testSecIdxRangeCalculation5() {
        ConditionNode.RowkeyRange[] ranges;
        String[] fieldPath = new String[]{"x.a", "x.b"};
        boolean[] descendingOrder = new boolean[]{true, true};
        IndexFieldDesc.Order[] order = new IndexFieldDesc.Order[]{descendingOrder[0] ? IndexFieldDesc.Order.Desc : IndexFieldDesc.Order.Asc, descendingOrder[1] ? IndexFieldDesc.Order.Desc : IndexFieldDesc.Order.Asc};
        IndexFieldDescImpl[] partitionKeys = new IndexFieldDescImpl[]{new IndexFieldDescImpl(fieldPath[0], order[0], false, false, null), new IndexFieldDescImpl(fieldPath[1], order[1], false, false, null)};
        IndexRowKeyEncoder encoder = new IndexRowKeyEncoder(descendingOrder);
        ArrayList rangeList = new ArrayList(encoder.getRowKeyRange(Dbfilters.CompareOpProto.EQUAL, DBValueBuilderImpl.KeyValueBuilder.initFrom("xyz"), 0));
        Assert.assertEquals((long)1L, (long)rangeList.size());
        rangeList.addAll(encoder.getRowKeyRange(Dbfilters.CompareOpProto.EQUAL, DBValueBuilderImpl.KeyValueBuilder.initFrom("abc"), 0));
        Assert.assertEquals((long)2L, (long)rangeList.size());
        ConditionNode.RowkeyRange[] expectedRanges = ranges = rangeList.toArray(new ConditionNode.RowkeyRange[rangeList.size()]);
        ConditionImpl condition = MapRDBImpl.newCondition().or().is(fieldPath[0], QueryCondition.Op.EQUAL, "xyz").and().is(fieldPath[0], QueryCondition.Op.EQUAL, "abc").is(fieldPath[1], QueryCondition.Op.EQUAL, "rst").close().close();
        condition.setPartitionKeys((IndexFieldDesc[])partitionKeys).build();
        List calculatedRanges = condition.getRowkeyRanges();
        this.checkRangeCalculationResults(expectedRanges, calculatedRanges);
    }

    @Test
    public void testSecIdxRangeCalculation6() {
        String[] fieldPath = new String[]{"x.a", "x.b"};
        boolean[] descendingOrder = new boolean[]{true, true};
        IndexFieldDesc.Order[] order = new IndexFieldDesc.Order[]{descendingOrder[0] ? IndexFieldDesc.Order.Desc : IndexFieldDesc.Order.Asc, descendingOrder[1] ? IndexFieldDesc.Order.Desc : IndexFieldDesc.Order.Asc};
        IndexFieldDescImpl[] partitionKeys = new IndexFieldDescImpl[]{new IndexFieldDescImpl(fieldPath[0], order[0], false, false, null), new IndexFieldDescImpl(fieldPath[1], order[1], false, false, null)};
        IndexRowKeyEncoder encoder = new IndexRowKeyEncoder(descendingOrder);
        ArrayList rangeList = new ArrayList(encoder.getRowKeyRange(Dbfilters.CompareOpProto.EQUAL, DBValueBuilderImpl.KeyValueBuilder.initFrom("xyz"), 0));
        Assert.assertEquals((long)1L, (long)rangeList.size());
        rangeList.addAll(encoder.getRowKeyRange(Dbfilters.CompareOpProto.EQUAL, DBValueBuilderImpl.KeyValueBuilder.initFrom("abc"), 0));
        Assert.assertEquals((long)2L, (long)rangeList.size());
        rangeList.addAll(encoder.getRowKeyRange(Dbfilters.CompareOpProto.LESS, DBValueBuilderImpl.KeyValueBuilder.initFrom("rs"), 1));
        Assert.assertEquals((long)3L, (long)rangeList.size());
        ConditionNode.RowkeyRange[] ranges = rangeList.toArray(new ConditionNode.RowkeyRange[rangeList.size()]);
        ConditionNode.RowkeyRange[] expectedRanges = new ConditionNode.RowkeyRange[]{new ConditionNode.RowkeyRange(Bytes.concatenate((byte[])ranges[0].getStartRow(), (byte[])ranges[2].getStartRow()), Bytes.concatenate((byte[])ranges[0].getStartRow(), (byte[])ranges[2].getStopRow())), new ConditionNode.RowkeyRange(Bytes.concatenate((byte[])ranges[1].getStartRow(), (byte[])ranges[2].getStartRow()), Bytes.concatenate((byte[])ranges[1].getStartRow(), (byte[])ranges[2].getStopRow()))};
        ConditionImpl condition = MapRDBImpl.newCondition().and().or().is(fieldPath[0], QueryCondition.Op.EQUAL, "xyz").and().is(fieldPath[0], QueryCondition.Op.EQUAL, "abc").is(fieldPath[1], QueryCondition.Op.GREATER, "jh").close().close().is(fieldPath[1], QueryCondition.Op.LESS, "rs").close();
        condition.setPartitionKeys((IndexFieldDesc[])partitionKeys).build();
        List calculatedRanges = condition.getRowkeyRanges();
        this.checkRangeCalculationResults(expectedRanges, calculatedRanges);
    }

    @Test
    public void testSecIdxRangeCalculation7() {
        ConditionNode.RowkeyRange[] ranges;
        String[] fieldPath = new String[]{"x.a", "x.b", "x.c"};
        boolean[] descendingOrder = new boolean[]{true, true, true};
        IndexFieldDesc.Order[] order = new IndexFieldDesc.Order[]{descendingOrder[0] ? IndexFieldDesc.Order.Desc : IndexFieldDesc.Order.Asc, descendingOrder[1] ? IndexFieldDesc.Order.Desc : IndexFieldDesc.Order.Asc, descendingOrder[2] ? IndexFieldDesc.Order.Desc : IndexFieldDesc.Order.Asc};
        IndexFieldDescImpl[] partitionKeys = new IndexFieldDescImpl[]{new IndexFieldDescImpl(fieldPath[0], order[0], false, false, null), new IndexFieldDescImpl(fieldPath[1], order[1], false, false, null), new IndexFieldDescImpl(fieldPath[2], order[2], false, false, null)};
        IndexRowKeyEncoder encoder = new IndexRowKeyEncoder(descendingOrder);
        ArrayList rangeList = new ArrayList(encoder.getRowKeyRange(Dbfilters.CompareOpProto.EQUAL, DBValueBuilderImpl.KeyValueBuilder.initFrom("xyz"), 0));
        Assert.assertEquals((long)1L, (long)rangeList.size());
        rangeList.addAll(encoder.getRowKeyRange(Dbfilters.CompareOpProto.EQUAL, DBValueBuilderImpl.KeyValueBuilder.initFrom("abc"), 0));
        Assert.assertEquals((long)2L, (long)rangeList.size());
        ConditionNode.RowkeyRange[] expectedRanges = ranges = rangeList.toArray(new ConditionNode.RowkeyRange[rangeList.size()]);
        ConditionImpl condition = MapRDBImpl.newCondition().and().or().is(fieldPath[0], QueryCondition.Op.EQUAL, "xyz").and().is(fieldPath[0], QueryCondition.Op.EQUAL, "abc").is(fieldPath[1], QueryCondition.Op.GREATER, "jh").close().close().is(fieldPath[2], QueryCondition.Op.LESS, "rs").close();
        condition.setPartitionKeys((IndexFieldDesc[])partitionKeys).build();
        List calculatedRanges = condition.getRowkeyRanges();
        this.checkRangeCalculationResults(expectedRanges, calculatedRanges);
    }

    @Test
    public void testSecIdxRangeCalculation8() {
        String[] fieldPath = new String[]{"x.a", "x.b", "x.c"};
        boolean[] descendingOrder = new boolean[]{true, false, true};
        IndexFieldDesc.Order[] order = new IndexFieldDesc.Order[]{descendingOrder[0] ? IndexFieldDesc.Order.Desc : IndexFieldDesc.Order.Asc, descendingOrder[1] ? IndexFieldDesc.Order.Desc : IndexFieldDesc.Order.Asc, descendingOrder[2] ? IndexFieldDesc.Order.Desc : IndexFieldDesc.Order.Asc};
        IndexFieldDescImpl[] partitionKeys = new IndexFieldDescImpl[]{new IndexFieldDescImpl(fieldPath[0], order[0], false, false, null), new IndexFieldDescImpl(fieldPath[1], order[1], false, false, null), new IndexFieldDescImpl(fieldPath[2], order[2], false, false, null)};
        IndexRowKeyEncoder encoder = new IndexRowKeyEncoder(descendingOrder);
        ArrayList rangeList = new ArrayList(encoder.getRowKeyRange(Dbfilters.CompareOpProto.EQUAL, DBValueBuilderImpl.KeyValueBuilder.initFrom("abc"), 0));
        Assert.assertEquals((long)1L, (long)rangeList.size());
        rangeList.addAll(encoder.getRowKeyRange(Dbfilters.CompareOpProto.EQUAL, DBValueBuilderImpl.KeyValueBuilder.initFrom("rst"), 1));
        Assert.assertEquals((long)2L, (long)rangeList.size());
        rangeList.addAll(encoder.getRowKeyRange(Dbfilters.CompareOpProto.EQUAL, DBValueBuilderImpl.KeyValueBuilder.initFrom("klm"), 2));
        Assert.assertEquals((long)3L, (long)rangeList.size());
        ConditionNode.RowkeyRange[] ranges = rangeList.toArray(new ConditionNode.RowkeyRange[rangeList.size()]);
        ConditionNode.RowkeyRange[] expectedRanges = new ConditionNode.RowkeyRange[]{new ConditionNode.RowkeyRange(Bytes.concatenate((byte[])Bytes.concatenate((byte[])ranges[0].getStartRow(), (byte[])ranges[1].getStartRow()), (byte[])ranges[2].getStartRow()), Bytes.concatenate((byte[])Bytes.concatenate((byte[])ranges[0].getStartRow(), (byte[])ranges[1].getStartRow()), (byte[])ranges[2].getStopRow()))};
        ConditionImpl condition = MapRDBImpl.newCondition().and().is(fieldPath[0], QueryCondition.Op.EQUAL, "abc").is(fieldPath[1], QueryCondition.Op.EQUAL, "rst").is(fieldPath[2], QueryCondition.Op.EQUAL, "klm").close();
        condition.setPartitionKeys((IndexFieldDesc[])partitionKeys).build();
        List calculatedRanges = condition.getRowkeyRanges();
        this.checkRangeCalculationResults(expectedRanges, calculatedRanges);
    }

    @Test
    public void testSecIdxRangeCalculation9() {
        ConditionNode.RowkeyRange[] ranges;
        String[] fieldPath = new String[]{"x.a", "x.b", "x.c"};
        boolean[] descendingOrder = new boolean[]{false, true, false};
        IndexFieldDesc.Order[] order = new IndexFieldDesc.Order[]{descendingOrder[0] ? IndexFieldDesc.Order.Desc : IndexFieldDesc.Order.Asc, descendingOrder[1] ? IndexFieldDesc.Order.Desc : IndexFieldDesc.Order.Asc, descendingOrder[2] ? IndexFieldDesc.Order.Desc : IndexFieldDesc.Order.Asc};
        IndexFieldDescImpl[] partitionKeys = new IndexFieldDescImpl[]{new IndexFieldDescImpl(fieldPath[0], order[0], false, false, null), new IndexFieldDescImpl(fieldPath[1], order[1], false, false, null), new IndexFieldDescImpl(fieldPath[2], order[2], false, false, null)};
        IndexRowKeyEncoder encoder = new IndexRowKeyEncoder(descendingOrder);
        ArrayList rangeList = new ArrayList(encoder.getRowKeyRange(Dbfilters.CompareOpProto.GREATER, DBValueBuilderImpl.KeyValueBuilder.initFrom("abc"), 0));
        Assert.assertEquals((long)1L, (long)rangeList.size());
        ConditionNode.RowkeyRange[] expectedRanges = ranges = rangeList.toArray(new ConditionNode.RowkeyRange[rangeList.size()]);
        ConditionImpl condition = MapRDBImpl.newCondition().and().is(fieldPath[0], QueryCondition.Op.GREATER, "abc").is(fieldPath[1], QueryCondition.Op.LESS_OR_EQUAL, "rst").is(fieldPath[2], QueryCondition.Op.LESS, "klm").close();
        condition.setPartitionKeys((IndexFieldDesc[])partitionKeys).build();
        List calculatedRanges = condition.getRowkeyRanges();
        this.checkRangeCalculationResults(expectedRanges, calculatedRanges);
    }

    @Test
    public void testSecIdxRangeCalculation10() {
        ConditionNode.RowkeyRange[] ranges;
        String[] fieldPath = new String[]{"x.a", "x.b", "x.c"};
        boolean[] descendingOrder = new boolean[]{false, true, false};
        IndexFieldDesc.Order[] order = new IndexFieldDesc.Order[]{descendingOrder[0] ? IndexFieldDesc.Order.Desc : IndexFieldDesc.Order.Asc, descendingOrder[1] ? IndexFieldDesc.Order.Desc : IndexFieldDesc.Order.Asc, descendingOrder[2] ? IndexFieldDesc.Order.Desc : IndexFieldDesc.Order.Asc};
        IndexFieldDescImpl[] partitionKeys = new IndexFieldDescImpl[]{new IndexFieldDescImpl(fieldPath[0], order[0], false, false, null), new IndexFieldDescImpl(fieldPath[1], order[1], false, false, null), new IndexFieldDescImpl(fieldPath[2], order[2], false, false, null)};
        IndexRowKeyEncoder encoder = new IndexRowKeyEncoder(descendingOrder);
        ArrayList rangeList = new ArrayList(encoder.getRowKeyRange(Dbfilters.CompareOpProto.LESS_OR_EQUAL, DBValueBuilderImpl.KeyValueBuilder.initFrom("abc"), 0));
        Assert.assertEquals((long)1L, (long)rangeList.size());
        ConditionNode.RowkeyRange[] expectedRanges = ranges = rangeList.toArray(new ConditionNode.RowkeyRange[rangeList.size()]);
        QueryCondition condition = MapRDBImpl.newCondition().and().is(fieldPath[0], QueryCondition.Op.LESS_OR_EQUAL, "abc").like(fieldPath[0], "%text%").close();
        ((ConditionImpl)condition).setPartitionKeys((IndexFieldDesc[])partitionKeys).build();
        List calculatedRanges = ((ConditionImpl)condition).getRowkeyRanges();
        this.checkRangeCalculationResults(expectedRanges, calculatedRanges);
    }

    @Test
    public void testConditionWithDateTime() {
        ConditionImpl cond1 = MapRDBImpl.newCondition().is("a", QueryCondition.Op.GREATER, ODate.parse((String)"2015-12-11")).build();
        ConditionImpl cond2 = MapRDBImpl.newCondition().condition((QueryCondition)cond1).build();
        Assert.assertEquals((Object)cond1, (Object)cond2);
    }

    @Test
    public void testConditionWithDateTime2() {
        ConditionImpl c1 = MapRDBImpl.newCondition().is("a.b", QueryCondition.Op.GREATER, OTimestamp.parse((String)"2013-08-22T15:11:22Z")).build();
        ConditionImpl c2 = MapRDBImpl.newCondition().and().is("k", QueryCondition.Op.EQUAL, "xyz").is("a.b", QueryCondition.Op.GREATER, OTimestamp.parse((String)"2013-08-22T15:11:22Z")).close().build();
        ConditionImpl c3 = MapRDBImpl.newCondition().and().is("k", QueryCondition.Op.EQUAL, "xyz").condition((QueryCondition)c1).close().build();
        Assert.assertEquals((Object)c2, (Object)c3);
    }
}

