/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.indexrowkeyfmt;

import com.mapr.db.impl.ConditionNode;
import com.mapr.db.indexrowkeyfmt.IndexRowKeyComponent;
import com.mapr.db.indexrowkeyfmt.IndexRowKeyDecoder;
import com.mapr.db.indexrowkeyfmt.IndexRowKeyEncoder;
import com.mapr.db.indexrowkeyfmt.Nmbr;
import com.mapr.db.indexrowkeyfmt.Null;
import com.mapr.db.indexrowkeyfmt.NullComponent;
import com.mapr.db.indexrowkeyfmt.OArray;
import com.mapr.db.indexrowkeyfmt.OMap;
import com.mapr.db.rowcol.KeyValue;
import com.mapr.db.rowcol.KeyValueBuilder;
import com.mapr.db.util.HashedIndexUtil;
import com.mapr.fs.proto.Dbfilters;
import com.mapr.org.apache.hadoop.hbase.util.Bytes;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.SimpleTest;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.types.ODate;
import org.ojai.types.OTime;
import org.ojai.types.OTimestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={SimpleTest.class})
public class BasicTest
extends BaseTest {
    private static final Logger _logger = LoggerFactory.getLogger(BasicTest.class);
    private static final String state = "CAMPZ";
    private static final String county = "Santa Clara";
    private static final String city = "San Jose";
    private static final String rk = "EMP0001";
    private static final String prk = "E";

    @Test
    public void testSingleString() {
        String rowKey = "row";
        boolean numComponents = true;
        boolean[] descendingOrder = new boolean[]{false};
        String addressState = "CA";
        IndexRowKeyEncoder encoder = new IndexRowKeyEncoder(descendingOrder);
        encoder.setPrimaryKey(rowKey);
        encoder.setComponent(0, addressState.getBytes());
        byte[] encodedKey = new byte[encoder.getEstimatedEncodingSize()];
        int encodedKeySize = encoder.getRowKey(encodedKey);
        IndexRowKeyDecoder dec = new IndexRowKeyDecoder(null);
        dec.init(descendingOrder);
        dec.setRowKey(Arrays.copyOfRange(encodedKey, 0, encodedKeySize));
        try {
            Assert.assertTrue((boolean)addressState.equals(dec.getComponent(0).getString()));
        }
        catch (UnsupportedEncodingException e) {
            System.out.println("UTF-8 encoding is not supported");
        }
        Assert.assertTrue((boolean)rowKey.equals(new String(dec.getPrimaryTableRowKey())));
    }

    @Test
    public void testArrayField() {
        String rowKey = "row";
        int numComponents = 3;
        boolean[] descendingOrder = new boolean[]{false, false, false};
        OArray a = new OArray((Object)0);
        IndexRowKeyEncoder encoder = new IndexRowKeyEncoder(descendingOrder);
        encoder.setPrimaryKey(rowKey);
        encoder.setComponent(0, state.getBytes());
        encoder.setComponent(1, a);
        encoder.setComponent(2, city.getBytes());
        byte[] encodedKey = new byte[encoder.getEstimatedEncodingSize()];
        int encodedKeySize = encoder.getRowKey(encodedKey);
        encodedKey = Arrays.copyOfRange(encodedKey, 0, encodedKeySize);
        IndexRowKeyDecoder dec = new IndexRowKeyDecoder();
        dec.init(descendingOrder);
        dec.setRowKey(Arrays.copyOfRange(encodedKey, 0, encodedKeySize));
        Assert.assertTrue((dec.getComponent(0).getType() == 16 ? 1 : 0) != 0);
        Assert.assertTrue((dec.getComponent((int)0).getError().id == -2 ? 1 : 0) != 0);
        Assert.assertTrue((dec.getComponent((int)0).getError().idx == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)rowKey.equals(new String(dec.getPrimaryTableRowKey())));
    }

    @Test
    public void testMapField() {
        String rowKey = "row";
        int numComponents = 3;
        boolean[] descendingOrder = new boolean[]{false, false, false};
        OMap m = new OMap((Object)0);
        IndexRowKeyEncoder encoder = new IndexRowKeyEncoder(descendingOrder);
        encoder.setPrimaryKey(rowKey);
        encoder.setComponent(0, state.getBytes());
        encoder.setComponent(1, county.getBytes());
        encoder.setComponent(2, m);
        byte[] encodedKey = new byte[encoder.getEstimatedEncodingSize()];
        int encodedKeySize = encoder.getRowKey(encodedKey);
        encodedKey = Arrays.copyOfRange(encodedKey, 0, encodedKeySize);
        IndexRowKeyDecoder dec = new IndexRowKeyDecoder();
        dec.init(descendingOrder);
        dec.setRowKey(Arrays.copyOfRange(encodedKey, 0, encodedKeySize));
        Assert.assertTrue((dec.getComponent(0).getType() == 16 ? 1 : 0) != 0);
        Assert.assertTrue((dec.getComponent((int)0).getError().id == -1 ? 1 : 0) != 0);
        Assert.assertTrue((dec.getComponent((int)0).getError().idx == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)rowKey.equals(new String(dec.getPrimaryTableRowKey())));
    }

    @Test
    public void testEmptyString() {
        String rowKey = "row";
        boolean numComponents = true;
        boolean[] descendingOrder = new boolean[]{false};
        String emptyStr = "";
        IndexRowKeyEncoder encoder = new IndexRowKeyEncoder(descendingOrder);
        encoder.setPrimaryKey(rowKey);
        encoder.setComponent(0, emptyStr.getBytes());
        byte[] encodedKey = new byte[encoder.getEstimatedEncodingSize()];
        int encodedKeySize = encoder.getRowKey(encodedKey);
        IndexRowKeyDecoder dec = new IndexRowKeyDecoder();
        dec.init(descendingOrder);
        dec.setRowKey(Arrays.copyOfRange(encodedKey, 0, encodedKeySize));
        try {
            Assert.assertTrue((boolean)emptyStr.equals(dec.getComponent(0).getString()));
        }
        catch (UnsupportedEncodingException e) {
            System.out.println("UTF-8 encoding is not supported");
        }
        Assert.assertTrue((boolean)rowKey.equals(new String(dec.getPrimaryTableRowKey())));
    }

    @Test
    public void testMultiString() {
        String rowKey = "row";
        int numComponents = 2;
        boolean[] descendingOrder = new boolean[]{false, false};
        String addressState = "CA";
        String nameFirst = "Maximilian";
        IndexRowKeyEncoder encoder = new IndexRowKeyEncoder(descendingOrder);
        encoder.setPrimaryKey(rowKey);
        encoder.setComponent(0, addressState.getBytes());
        encoder.setComponent(1, nameFirst.getBytes());
        byte[] encodedKey = new byte[encoder.getEstimatedEncodingSize()];
        int encodedKeySize = encoder.getRowKey(encodedKey);
        IndexRowKeyDecoder dec = new IndexRowKeyDecoder();
        dec.init(descendingOrder);
        dec.setRowKey(Arrays.copyOfRange(encodedKey, 0, encodedKeySize));
        try {
            Assert.assertTrue((boolean)addressState.equals(dec.getComponent(0).getString()));
            Assert.assertTrue((boolean)nameFirst.equals(dec.getComponent(1).getString()));
        }
        catch (UnsupportedEncodingException e) {
            System.out.println("UTF-8 encoding is not supported");
        }
        Assert.assertTrue((boolean)rowKey.equals(new String(dec.getPrimaryTableRowKey())));
    }

    @Test
    public void testMultiBoolean() {
        String rowKey = "xyz";
        int numComponents = 4;
        boolean[] descendingOrder = new boolean[]{false, true, true, false};
        boolean field0 = true;
        boolean field1 = true;
        boolean field2 = false;
        boolean field3 = false;
        IndexRowKeyEncoder encoder = new IndexRowKeyEncoder(descendingOrder);
        encoder.setPrimaryKey(rowKey);
        encoder.setComponent(0, field0);
        encoder.setComponent(1, field1);
        encoder.setComponent(2, field2);
        encoder.setComponent(3, field3);
        byte[] encodedKey = new byte[encoder.getEstimatedEncodingSize()];
        int encodedKeySize = encoder.getRowKey(encodedKey);
        IndexRowKeyDecoder dec = new IndexRowKeyDecoder();
        dec.init(descendingOrder);
        dec.setRowKey(Arrays.copyOfRange(encodedKey, 0, encodedKeySize));
        Assert.assertTrue((field0 == dec.getComponent(0).getBoolean() ? 1 : 0) != 0);
        Assert.assertTrue((field1 == dec.getComponent(1).getBoolean() ? 1 : 0) != 0);
        Assert.assertTrue((field2 == dec.getComponent(2).getBoolean() ? 1 : 0) != 0);
        Assert.assertTrue((field3 == dec.getComponent(3).getBoolean() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)rowKey.equals(new String(dec.getPrimaryTableRowKey())));
    }

    @Test
    public void testMultiField() {
        String rowKey = "row";
        int numComponents = 10;
        boolean[] descendingOrder = new boolean[]{false, false, true, false, true, false, true, true, true, false, false, false};
        int i = 0;
        boolean field0 = true;
        OTimestamp field1 = OTimestamp.parse((String)"2012-02-02T09:00:00.000Z");
        OTimestamp field2 = OTimestamp.parse((String)"2100-02-02T11:00:00.123Z");
        ODate field3 = ODate.parse((String)"2010-02-01");
        ODate field4 = ODate.parse((String)"1957-02-01");
        OTime field5 = OTime.parse((String)"11:22:33");
        OTime field6 = OTime.parse((String)"22:33:55");
        boolean field7 = true;
        boolean field8 = false;
        Null field9 = new Null(true);
        boolean field10 = false;
        Null field11 = new Null(false);
        IndexRowKeyEncoder encoder = new IndexRowKeyEncoder(descendingOrder);
        encoder.setPrimaryKey(rowKey);
        encoder.setComponent(i++, field0);
        encoder.setComponent(i++, field1);
        encoder.setComponent(i++, field2);
        encoder.setComponent(i++, field3);
        encoder.setComponent(i++, field4);
        encoder.setComponent(i++, field5);
        encoder.setComponent(i++, field6);
        encoder.setComponent(i++, field7);
        encoder.setComponent(i++, field8);
        encoder.setComponent(i++, field9);
        encoder.setComponent(i++, field10);
        encoder.setComponent(i++, field11);
        byte[] encodedKey = new byte[encoder.getEstimatedEncodingSize()];
        int encodedKeySize = encoder.getRowKey(encodedKey);
        IndexRowKeyDecoder dec = new IndexRowKeyDecoder();
        dec.init(descendingOrder);
        dec.setRowKey(Arrays.copyOfRange(encodedKey, 0, encodedKeySize));
        i = 0;
        Assert.assertTrue((field0 == dec.getComponent(i++).getBoolean() ? 1 : 0) != 0);
        Assert.assertTrue((field1.compareTo(dec.getComponent(i++).getTimestamp()) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((field2.compareTo(dec.getComponent(i++).getTimestamp()) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((field3.compareTo(dec.getComponent(i++).getDate()) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((field4.compareTo(dec.getComponent(i++).getDate()) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((field5.compareTo(dec.getComponent(i++).getTime()) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((field6.compareTo(dec.getComponent(i++).getTime()) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((field7 == dec.getComponent(i++).getBoolean() ? 1 : 0) != 0);
        Assert.assertTrue((field8 == dec.getComponent(i++).getBoolean() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(dec.getComponent(i++) instanceof NullComponent));
        Assert.assertTrue((field10 == dec.getComponent(i++).getBoolean() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(dec.getComponent(i++) instanceof NullComponent));
        Assert.assertTrue((boolean)rowKey.equals(new String(dec.getPrimaryTableRowKey())));
    }

    @Test
    public void testMultiFieldWithNull() {
        int encodedKeySize;
        int i;
        int numComponents = 3;
        IndexRowKeyEncoder encoder = new IndexRowKeyEncoder();
        boolean[] descendingOrder = new boolean[]{false, false, false};
        boolean nullFirst0 = false;
        boolean nullFirst1 = true;
        String[] state = new String[]{"CA1", "CA2", "CA3"};
        String[] county = new String[]{"SC1", "SC2", "SC3"};
        String[] city = new String[]{"Gilroy1", "Gilroy2", "Gilroy3"};
        Null nullFalse = new Null(false);
        byte[][] encodedKey = new byte[3][];
        encoder.init(descendingOrder, nullFirst0, false, 0);
        for (i = 0; i < 3; ++i) {
            encoder.resetComponents();
            if (i == 1) {
                encoder.setComponent(0, nullFalse);
            } else {
                encoder.setComponent(0, state[i].getBytes());
            }
            encoder.setComponent(1, county[i].getBytes());
            encoder.setComponent(2, city[i].getBytes());
            encoder.setPrimaryKey(rk);
            encodedKey[i] = new byte[encoder.getEstimatedEncodingSize()];
            encodedKeySize = encoder.getRowKey(encodedKey[i]);
            encodedKey[i] = Arrays.copyOfRange(encodedKey[i], 0, encodedKeySize);
        }
        Assert.assertTrue((BasicTest.memcmp(encodedKey[0], encodedKey[1]) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((BasicTest.memcmp(encodedKey[0], encodedKey[2]) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((BasicTest.memcmp(encodedKey[1], encodedKey[2]) > 0 ? 1 : 0) != 0);
        encoder.init(descendingOrder, nullFirst1, false, 0);
        for (i = 0; i < 3; ++i) {
            encoder.resetComponents();
            if (i == 1) {
                encoder.setComponent(0, nullFalse);
            } else {
                encoder.setComponent(0, state[i].getBytes());
            }
            encoder.setComponent(1, county[i].getBytes());
            encoder.setComponent(2, city[i].getBytes());
            encoder.setPrimaryKey(rk);
            encodedKey[i] = new byte[encoder.getEstimatedEncodingSize()];
            encodedKeySize = encoder.getRowKey(encodedKey[i]);
            encodedKey[i] = Arrays.copyOfRange(encodedKey[i], 0, encodedKeySize);
        }
        Assert.assertTrue((BasicTest.memcmp(encodedKey[0], encodedKey[1]) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((BasicTest.memcmp(encodedKey[0], encodedKey[2]) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((BasicTest.memcmp(encodedKey[1], encodedKey[2]) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testMultiStringMissing() {
        String rowKey = "row";
        int numComponents = 3;
        boolean[] descendingOrder = new boolean[]{false, false, false};
        String addressState = "CA";
        String nameFirst = "John";
        IndexRowKeyEncoder encoder = new IndexRowKeyEncoder(descendingOrder);
        encoder.setPrimaryKey(rowKey);
        encoder.setComponent(0, addressState.getBytes());
        encoder.setComponent(1, nameFirst.getBytes());
        byte[] encodedKey = new byte[encoder.getEstimatedEncodingSize()];
        int encodedKeySize = encoder.getRowKey(encodedKey);
        encodedKey = Arrays.copyOfRange(encodedKey, 0, encodedKeySize);
        IndexRowKeyDecoder dec = new IndexRowKeyDecoder();
        dec.init(descendingOrder);
        dec.setRowKey(Arrays.copyOfRange(encodedKey, 0, encodedKeySize));
        try {
            Assert.assertTrue((boolean)addressState.equals(dec.getComponent(0).getString()));
            Assert.assertTrue((boolean)nameFirst.equals(dec.getComponent(1).getString()));
        }
        catch (UnsupportedEncodingException e) {
            System.out.println("UTF-8 encoding is not supported");
        }
        Assert.assertTrue((dec.getComponent(2).getType() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)rowKey.equals(new String(dec.getPrimaryTableRowKey())));
    }

    @Test
    public void testSingleByteArray() {
        String rowKey = "row";
        boolean numComponents = true;
        boolean[] descendingOrder = new boolean[]{true};
        boolean nullFirst = true;
        String addressState = "CA";
        IndexRowKeyEncoder encoder = new IndexRowKeyEncoder(descendingOrder, nullFirst);
        encoder.setPrimaryKey(rowKey);
        encoder.setComponent(0, addressState.getBytes(), addressState.length());
        byte[] encodedKey = new byte[encoder.getEstimatedEncodingSize()];
        int encodedKeySize = encoder.getRowKey(encodedKey);
        encodedKey = Arrays.copyOfRange(encodedKey, 0, encodedKeySize);
        IndexRowKeyDecoder dec = new IndexRowKeyDecoder();
        dec.init(descendingOrder);
        dec.setRowKey(Arrays.copyOfRange(encodedKey, 0, encodedKeySize));
        Assert.assertTrue((boolean)addressState.equals(new String(dec.getComponent(0).getByteArray())));
        Assert.assertTrue((boolean)rowKey.equals(new String(dec.getPrimaryTableRowKey())));
    }

    @Test
    public void testMultiByteArray() {
        String rowKey = "row";
        int numComponents = 2;
        boolean[] descendingOrder = new boolean[]{true, true};
        boolean nullFirst = true;
        String addressState = "CA";
        String nameFirst = "John";
        IndexRowKeyEncoder encoder = new IndexRowKeyEncoder(descendingOrder, nullFirst);
        encoder.setPrimaryKey(rowKey);
        encoder.setComponent(0, addressState.getBytes(), addressState.length());
        encoder.setComponent(1, nameFirst.getBytes(), nameFirst.length());
        byte[] encodedKey = new byte[encoder.getEstimatedEncodingSize()];
        int encodedKeySize = encoder.getRowKey(encodedKey);
        encodedKey = Arrays.copyOfRange(encodedKey, 0, encodedKeySize);
        IndexRowKeyDecoder dec = new IndexRowKeyDecoder();
        dec.init(descendingOrder);
        dec.setRowKey(Arrays.copyOfRange(encodedKey, 0, encodedKeySize));
        Assert.assertTrue((boolean)addressState.equals(new String(dec.getComponent(0).getByteArray())));
        Assert.assertTrue((boolean)nameFirst.equals(new String(dec.getComponent(1).getByteArray())));
        Assert.assertTrue((boolean)rowKey.equals(new String(dec.getPrimaryTableRowKey())));
    }

    @Test
    public void testMultiByteArrayMissing() {
        String rowKey = "row";
        int numComponents = 3;
        boolean[] descendingOrder = new boolean[]{true, true, true};
        boolean nullFirst = true;
        String addressState = "CA";
        String nameFirst = "John";
        IndexRowKeyEncoder encoder = new IndexRowKeyEncoder(descendingOrder, nullFirst);
        encoder.setPrimaryKey(rowKey);
        encoder.setComponent(0, addressState.getBytes(), addressState.length());
        encoder.setComponent(1, nameFirst.getBytes(), nameFirst.length());
        byte[] encodedKey = new byte[encoder.getEstimatedEncodingSize()];
        int encodedKeySize = encoder.getRowKey(encodedKey);
        IndexRowKeyDecoder dec = new IndexRowKeyDecoder();
        dec.init(descendingOrder);
        dec.setRowKey(Arrays.copyOfRange(encodedKey, 0, encodedKeySize));
        Assert.assertTrue((boolean)addressState.equals(new String(dec.getComponent(0).getByteArray())));
        Assert.assertTrue((boolean)nameFirst.equals(new String(dec.getComponent(1).getByteArray())));
        Assert.assertTrue((dec.getComponent(2).getType() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)rowKey.equals(new String(dec.getPrimaryTableRowKey())));
    }

    @Test
    public void test1ByteField() {
        boolean numComponents = true;
        IndexRowKeyEncoder enc = new IndexRowKeyEncoder();
        boolean[][] descendingOrder = new boolean[][]{{false}, {true}};
        boolean[] nullFirst = new boolean[]{false, true};
        for (int i = 0; i <= 255; ++i) {
            for (int j = 0; j < 2; ++j) {
                enc.init(descendingOrder[j], nullFirst[j], false, 0);
                enc.resetComponents();
                byte in = (byte)i;
                enc.setComponent(0, in);
                enc.setPrimaryKey(rk.getBytes());
                byte[] encodedBuf = new byte[enc.getEstimatedEncodingSize()];
                int encodedSize = enc.getRowKey(encodedBuf);
                IndexRowKeyDecoder dec = new IndexRowKeyDecoder();
                dec.init(descendingOrder[j]);
                dec.setRowKey(Arrays.copyOfRange(encodedBuf, 0, encodedSize));
                IndexRowKeyComponent comp1 = dec.getComponent(0);
                byte out = comp1.getByte();
                Assert.assertTrue((out == in ? 1 : 0) != 0);
                byte[] compRk = dec.getPrimaryTableRowKey();
                Assert.assertTrue((boolean)new String(compRk).equals(rk));
            }
        }
    }

    @Test
    public void test1ShortField() {
        boolean numComponents = true;
        IndexRowKeyEncoder enc = new IndexRowKeyEncoder();
        boolean[][] descendingOrder = new boolean[][]{{false}, {true}};
        boolean[] nullFirst = new boolean[]{false, true};
        for (int i = 0; i <= 65535; ++i) {
            for (int j = 0; j < 2; ++j) {
                enc.init(descendingOrder[j], nullFirst[j], false, 0);
                enc.resetComponents();
                short in = (short)i;
                enc.setComponent(0, in);
                enc.setPrimaryKey(rk.getBytes());
                byte[] encodedBuf = new byte[enc.getEstimatedEncodingSize()];
                int encodedSize = enc.getRowKey(encodedBuf);
                IndexRowKeyDecoder dec = new IndexRowKeyDecoder();
                dec.init(descendingOrder[j]);
                dec.setRowKey(Arrays.copyOfRange(encodedBuf, 0, encodedSize));
                IndexRowKeyComponent comp1 = dec.getComponent(0);
                short out = comp1.getShort();
                Assert.assertTrue((out == in ? 1 : 0) != 0);
                byte[] compRk = dec.getPrimaryTableRowKey();
                Assert.assertTrue((boolean)new String(compRk).equals(rk));
            }
        }
    }

    @Test
    public void test1IntField() {
        boolean numComponents = true;
        IndexRowKeyEncoder enc = new IndexRowKeyEncoder();
        int[] values = new int[]{0, 1, 3, 5, 9, 0x33333333, 0x55555555, -1717986919, -1431655766, -1414812757, -1145324613, -1010580541, -858993460, -572662307, -286331154, -1};
        boolean[][] descendingOrder = new boolean[][]{{false}, {true}};
        boolean[] nullFirst = new boolean[]{false, true};
        for (int i = 0; i < values.length; ++i) {
            for (int j = 0; j < 2; ++j) {
                enc.init(descendingOrder[j], nullFirst[j], false, 0);
                enc.resetComponents();
                int in = values[i];
                enc.setComponent(0, in);
                enc.setPrimaryKey(rk.getBytes());
                byte[] encodedBuf = new byte[enc.getEstimatedEncodingSize()];
                int encodedSize = enc.getRowKey(encodedBuf);
                IndexRowKeyDecoder dec = new IndexRowKeyDecoder();
                dec.init(descendingOrder[j]);
                dec.setRowKey(Arrays.copyOfRange(encodedBuf, 0, encodedSize));
                IndexRowKeyComponent comp1 = dec.getComponent(0);
                int out = comp1.getInt();
                Assert.assertTrue((out == in ? 1 : 0) != 0);
                byte[] compRk = dec.getPrimaryTableRowKey();
                Assert.assertTrue((boolean)new String(compRk).equals(rk));
            }
        }
    }

    @Test
    public void test1LongField() {
        boolean numComponents = true;
        IndexRowKeyEncoder enc = new IndexRowKeyEncoder();
        long[] values = new long[]{0L, 1L, 3L, 5L, 9L, 0x3333333333333333L, 0x5555555555555555L, -7378697629483820647L, -6148914691236517206L, -6076574518398440533L, -4919131752989213765L, -4340410370284600381L, -3689348814741910324L, -2459565876494606883L, -1229782938247303442L, -1L};
        boolean[][] descendingOrder = new boolean[][]{{false}, {true}};
        boolean[] nullFirst = new boolean[]{false, true};
        for (int i = 0; i < values.length; ++i) {
            for (int j = 0; j < 2; ++j) {
                enc.init(descendingOrder[j], nullFirst[j], false, 0);
                enc.resetComponents();
                long in = values[i];
                enc.setComponent(0, in);
                enc.setPrimaryKey(rk.getBytes());
                byte[] encodedBuf = new byte[enc.getEstimatedEncodingSize()];
                int encodedSize = enc.getRowKey(encodedBuf);
                IndexRowKeyDecoder dec = new IndexRowKeyDecoder();
                dec.init(descendingOrder[j]);
                dec.setRowKey(Arrays.copyOfRange(encodedBuf, 0, encodedSize));
                IndexRowKeyComponent comp1 = dec.getComponent(0);
                long out = comp1.getLong();
                Assert.assertTrue((out == in ? 1 : 0) != 0);
                byte[] compRk = dec.getPrimaryTableRowKey();
                Assert.assertTrue((boolean)new String(compRk).equals(rk));
            }
        }
    }

    private byte[] getRK(IndexRowKeyEncoder enc, byte[] value) {
        String rowKey = "row";
        enc.resetComponents();
        enc.setPrimaryKey(rowKey);
        enc.setComponent(0, value);
        byte[] encodedKey = new byte[enc.getEstimatedEncodingSize()];
        int encodedKeySize = enc.getRowKey(encodedKey);
        return encodedKey;
    }

    @Test
    public void testRowKeyRangeForPrefixMatch() {
        boolean numComponents = true;
        IndexRowKeyEncoder enc = new IndexRowKeyEncoder();
        byte[][] prefix = new byte[][]{{0, 0, 0}, {97, 98, 99}, {-1, -1, -1}};
        byte[][] matching = new byte[][]{{0, 0, 0, 0}, {97, 98, 99, 100}, {-1, -1, -1, 0}};
        byte[][] nonmatching = new byte[][]{{0, 0}, {97, 98, 120}, {-1, -1}};
        boolean[][] descendingOrder = new boolean[][]{{false}, {true}};
        boolean[] nullFirst = new boolean[]{false, true};
        for (int i = 0; i < prefix.length; ++i) {
            for (int j = 0; j < 2; ++j) {
                enc.init(descendingOrder[j], nullFirst[j], false, 0);
                enc.resetComponents();
                List ranges = enc.getRowKeyRangeForPrefixMatch(prefix[i], 0);
                ConditionNode.RowkeyRange range = (ConditionNode.RowkeyRange)ranges.get(0);
                byte[] startRow = range.getStartRow();
                byte[] stopRow = range.getStopRow();
                byte[] encodedMatching = this.getRK(enc, matching[i]);
                Assert.assertTrue((BasicTest.memcmp(startRow, encodedMatching) <= 0 ? 1 : 0) != 0);
                Assert.assertTrue((BasicTest.memcmp(stopRow, encodedMatching) > 0 || stopRow.length == 0 ? 1 : 0) != 0);
                byte[] encodedNonMatching = this.getRK(enc, nonmatching[i]);
                Assert.assertTrue((BasicTest.memcmp(startRow, encodedNonMatching) > 0 || BasicTest.memcmp(stopRow, encodedNonMatching) <= 0 ? 1 : 0) != 0);
            }
        }
    }

    private static int memcmp(byte[] b1, byte[] b2) {
        int sz = b1.length < b2.length ? b1.length : b2.length;
        for (int i = 0; i < sz; ++i) {
            if (b1[i] == b2[i]) continue;
            return (b1[i] & 0xFF) - (b2[i] & 0xFF);
        }
        return b1.length - b2.length;
    }

    private void run32K() {
        int NUMBER_COUNT = 32768;
        Object[] arr = new Nmbr[32768];
        boolean[][] descendingOrder = new boolean[][]{{false}, {true}};
        for (int i = 0; i < 32768; ++i) {
            arr[i] = new Nmbr();
            ((Nmbr)arr[i]).generate();
        }
        Arrays.sort(arr);
        for (int j = 0; j < 2; ++j) {
            int k;
            for (k = 0; k < 32768; ++k) {
                ((Nmbr)arr[k]).init(descendingOrder[j]);
                ((Nmbr)arr[k]).encode();
            }
            for (k = 0; k < 32768; ++k) {
                ((Nmbr)arr[k]).decode();
            }
            for (k = 0; k < 32768; ++k) {
                ((Nmbr)arr[k]).checkDecodingCorrectness();
            }
            for (k = 0; k < 32768; ++k) {
                boolean testSucceeded;
                boolean bothGTZero;
                if (k + 1 >= 32768) continue;
                int memCmpResult = BasicTest.memcmp(((Nmbr)arr[k]).getEncoding(), ((Nmbr)arr[k + 1]).getEncoding());
                int compareResult = ((Nmbr)arr[k]).compareTo((Nmbr)arr[k + 1]);
                if (j != 0) {
                    compareResult *= -1;
                }
                boolean bothZero = memCmpResult == 0 && compareResult == 0;
                boolean bothLTZero = memCmpResult < 0 && compareResult < 0;
                boolean bl = bothGTZero = memCmpResult > 0 && compareResult > 0;
                boolean bl2 = bothZero || (j == 0 ? bothLTZero : bothGTZero) ? true : (testSucceeded = false);
                if (!testSucceeded) {
                    _logger.error("FAILURE for {} element: memCmpResult = {}, compareResult = {}!\n", new Object[]{k, memCmpResult, compareResult});
                    ((Nmbr)arr[k]).print();
                    ((Nmbr)arr[k + 1]).print();
                }
                Assert.assertTrue((boolean)testSucceeded);
            }
        }
    }

    @Test
    public void testMemcmparability() {
        for (int i = 0; i < 40; ++i) {
            this.run32K();
        }
    }

    private void hashIndexKeyVerifyKeyRange(IndexRowKeyEncoder encoder, Dbfilters.CompareOpProto op, int numHashPartitions, KeyValue value) {
        List partitionIds = HashedIndexUtil.GetHashedIndexPartitionIds((int)numHashPartitions);
        List ranges = encoder.getRowKeyRange(op, value, 0);
        Assert.assertEquals((long)partitionIds.size(), (long)ranges.size());
        for (int i = 0; i < partitionIds.size(); ++i) {
            ConditionNode.RowkeyRange range = (ConditionNode.RowkeyRange)ranges.get(i);
            byte[] startRow = range.getStartRow();
            byte[] stopRow = range.getStopRow();
            byte[] startRowPartition = Bytes.copy((byte[])startRow, (int)1, (int)2);
            byte[] stopRowPartition = null;
            if (op == Dbfilters.CompareOpProto.GREATER || op == Dbfilters.CompareOpProto.GREATER_OR_EQUAL) {
                if (i < partitionIds.size() - 1) {
                    stopRowPartition = Bytes.copy((byte[])stopRow, (int)1, (int)2);
                }
            } else {
                stopRowPartition = Bytes.copy((byte[])stopRow, (int)1, (int)2);
            }
            Assert.assertTrue((boolean)Arrays.equals(startRowPartition, (byte[])partitionIds.get(i)));
            if (op == Dbfilters.CompareOpProto.GREATER || op == Dbfilters.CompareOpProto.GREATER_OR_EQUAL) {
                if (i >= partitionIds.size() - 1) continue;
                Assert.assertTrue((boolean)Arrays.equals(stopRowPartition, (byte[])partitionIds.get(i + 1)));
                continue;
            }
            Assert.assertTrue((boolean)Arrays.equals(stopRowPartition, (byte[])partitionIds.get(i)));
        }
    }

    @Test
    public void testHashedIndexKeyEncoding() {
        boolean[] descendingOrder = new boolean[]{false};
        boolean nullFirst = false;
        int numHashPartitions = 15;
        IndexRowKeyEncoder encoder = new IndexRowKeyEncoder(descendingOrder, nullFirst, true, numHashPartitions);
        KeyValue value = KeyValueBuilder.initFrom((double)10.5);
        this.hashIndexKeyVerifyKeyRange(encoder, Dbfilters.CompareOpProto.LESS, numHashPartitions, value);
        this.hashIndexKeyVerifyKeyRange(encoder, Dbfilters.CompareOpProto.LESS_OR_EQUAL, numHashPartitions, value);
        this.hashIndexKeyVerifyKeyRange(encoder, Dbfilters.CompareOpProto.EQUAL, numHashPartitions, value);
        try {
            this.hashIndexKeyVerifyKeyRange(encoder, Dbfilters.CompareOpProto.NOT_EQUAL, numHashPartitions, value);
        }
        catch (IllegalArgumentException e) {
            _logger.debug("Received " + e.getMessage() + ":" + e.getCause() + " as expected.");
        }
        this.hashIndexKeyVerifyKeyRange(encoder, Dbfilters.CompareOpProto.GREATER, numHashPartitions, value);
        this.hashIndexKeyVerifyKeyRange(encoder, Dbfilters.CompareOpProto.GREATER_OR_EQUAL, numHashPartitions, value);
    }

    private void run32KperformanceNumeric(boolean descending, boolean runEncoder, boolean runDecoder) {
        long i64 = 8613303245920329198L;
        int i32 = 2005440938;
        byte[] encodedKey = new byte[32];
        boolean NUM_COMPONENTS = true;
        int NUMERIC_COUNT = 32768;
        boolean[] descendingOrder = new boolean[]{descending};
        boolean nullFirst = true;
        IndexRowKeyEncoder encoder = new IndexRowKeyEncoder(descendingOrder, nullFirst);
        int numEncoders = 1;
        if (runEncoder) {
            numEncoders = 32768;
        }
        for (int i = 0; i < numEncoders; ++i) {
            encoder.resetComponents();
            encoder.setComponent(0, 2005440938);
            encoder.setPrimaryKey(prk);
            int encodedKeySize = encoder.getRowKey(encodedKey);
        }
        IndexRowKeyDecoder decoder = new IndexRowKeyDecoder();
        if (runDecoder) {
            decoder.init(descendingOrder);
            for (int i = 0; i < 32768; ++i) {
                decoder.setRowKey(encodedKey);
                decoder.getComponent(0);
            }
        }
    }

    private void run32KperformanceNumericAsc(boolean runEncoder, boolean runDecoder) {
        this.run32KperformanceNumeric(false, runEncoder, runDecoder);
    }

    private void run32KperformanceNumericDesc(boolean runEncoder, boolean runDecoder) {
        this.run32KperformanceNumeric(true, runEncoder, runDecoder);
    }

    private void run32KperformanceString(boolean descending) {
        String sr = "abcdefghij";
        byte[] encodedKey = new byte[32];
        boolean NUM_COMPONENTS = true;
        int STRING_COUNT = 32768;
        boolean[] descendingOrder = new boolean[]{descending};
        boolean nullFirst = true;
        IndexRowKeyEncoder encoder = new IndexRowKeyEncoder(descendingOrder, nullFirst);
        for (int i = 0; i < 32768; ++i) {
            encoder.resetComponents();
            encoder.setComponent(0, "abcdefghij".getBytes());
            encoder.setPrimaryKey(prk);
            int encodedKeySize = encoder.getRowKey(encodedKey);
        }
        IndexRowKeyDecoder decoder = new IndexRowKeyDecoder();
        decoder.init(descendingOrder);
        for (int i = 0; i < 32768; ++i) {
            decoder.setRowKey(encodedKey);
            decoder.getComponent(0);
        }
    }

    private void run32KperformanceStringAsc() {
        this.run32KperformanceString(false);
    }

    private void run32KperformanceStringDesc() {
        this.run32KperformanceString(true);
    }

    @Test
    public void testPerformance() {
        long tstart = System.nanoTime();
        for (int i = 0; i < 1024; ++i) {
            boolean runEncoder = true;
            boolean runDecoder = false;
            this.run32KperformanceNumericAsc(runEncoder, runDecoder);
        }
        long tend = System.nanoTime();
        long elapsed = tend - tstart;
        _logger.info("int64 Encoding Asc of 32M rows took {} ms", (Object)(elapsed /= 1000L));
        tstart = System.nanoTime();
        for (int i = 0; i < 1024; ++i) {
            boolean runEncoder = true;
            boolean runDecoder = false;
            this.run32KperformanceNumericDesc(runEncoder, runDecoder);
        }
        tend = System.nanoTime();
        elapsed = tend - tstart;
        _logger.info("int64 Encoding Desc of 32M rows took {} ms", (Object)(elapsed /= 1000L));
    }
}

