/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.util;

import com.mapr.org.apache.hadoop.hbase.util.Bytes;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ByteBufs {
    private static final ByteOrder DB_BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;

    public static ByteBuffer ensurePreferred(ByteBuffer in) {
        ByteBuffer ret = !in.isDirect() ? in : Bytes.copyToByteBuffer((ByteBuffer)in);
        return ByteBufs.order(ret);
    }

    public static ByteBuffer wrap(byte[] array) {
        return ByteBufs.order(ByteBuffer.wrap(array));
    }

    public static ByteBuffer wrap(byte[] array, int offset, int length) {
        return ByteBufs.order(ByteBuffer.wrap(array, offset, length));
    }

    public static ByteBuffer allocate(int capacity) {
        return ByteBufs.order(ByteBuffer.allocate(capacity));
    }

    public static ByteBuffer allocateDirect(int capacity) {
        return ByteBufs.order(ByteBuffer.allocateDirect(capacity));
    }

    public static ByteBuffer allocatePreferred(int capacity) {
        return ByteBufs.order(ByteBuffer.allocate(capacity));
    }

    public static ByteBuffer order(ByteBuffer original) {
        return original.order(DB_BYTE_ORDER);
    }

    public static ByteBuffer allocateReadWrite(ByteBuffer original) {
        if (!original.isReadOnly()) {
            return ByteBufs.order(original);
        }
        return ByteBufs.order(Bytes.copyToByteBuffer((ByteBuffer)original));
    }
}

