/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.tests.tableops;

import com.mapr.db.MapRDB;
import com.mapr.db.Table;
import com.mapr.db.tests.utils.DBTests;
import com.mapr.db.tests.utils.Datasets;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.ClusterTest;
import java.io.IOException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;
import org.ojai.DocumentConstants;
import org.ojai.FieldPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ClusterTest.class})
public class TestTableOps
extends BaseTest {
    private static final Logger _logger = LoggerFactory.getLogger(TestTableOps.class);
    private static final String TABLE_NAME = "testtable-TestTableOps";
    private static Table table;

    @BeforeClass
    public static void startupBeforeClass() throws IOException {
        table = DBTests.createOrReplaceTable(TABLE_NAME);
        table.setOption(Table.TableOption.BUFFERWRITE, false);
        table.insertOrReplace(Datasets.SIMPLE_KEYS[0], Datasets.SIMPLE_RECORDS[0]);
    }

    @AfterClass
    public static void cleanupAfterClass() throws IOException, Exception {
        if (table != null) {
            table.close();
            DBTests.deleteTables(TABLE_NAME);
        }
    }

    @Test
    public void testSimpleGet() throws IOException {
        Document d = MapRDB.newDocument((String)"{ \"m\" : { \"a\" : 10, \"b\" : 20 } }");
        table.insertOrReplace("KEY", d);
        d = table.findById("KEY", new String[]{"m.c"});
        Assert.assertNotNull((Object)table.findById(Datasets.SIMPLE_KEYS[0]));
        Assert.assertNull((Object)table.findById(Datasets.SIMPLE_KEYS[1]));
    }

    @Test
    public void setWithUnicodeChar_Bug20501() throws Exception {
        FieldPath fp = FieldPath.parseFrom((String)"`\ud83c\udfda`");
        Document doc = MapRDB.newDocument();
        doc.set(DocumentConstants.ID_FIELD, "r1");
        doc.set(fp, 1);
        table.insertOrReplace(doc);
        Assert.assertEquals((Object)doc.toString(), (Object)table.findById("r1").toString());
    }
}

