/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.tests.tableops;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mapr.db.FamilyDescriptor;
import com.mapr.db.MapRDB;
import com.mapr.db.Table;
import com.mapr.db.TableDescriptor;
import com.mapr.db.exceptions.OpNotPermittedException;
import com.mapr.db.exceptions.TableClosedException;
import com.mapr.db.exceptions.TableExistsException;
import com.mapr.db.exceptions.TableNotFoundException;
import com.mapr.db.impl.AdminImpl;
import com.mapr.db.impl.IdCodec;
import com.mapr.db.impl.MapRDBTableImpl;
import com.mapr.db.impl.MapRDBTableImplHelper;
import com.mapr.db.ojai.DBDocumentBuilder;
import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.db.tests.utils.DBTests;
import com.mapr.db.util.ByteBufs;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.ClusterTest;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;
import org.ojai.DocumentStream;
import org.ojai.Value;
import org.ojai.exceptions.EncodingException;
import org.ojai.exceptions.StreamInUseException;
import org.ojai.store.DocumentMutation;
import org.ojai.store.OpListener;
import org.ojai.store.QueryCondition;
import org.ojai.store.exceptions.DocumentExistsException;
import org.ojai.store.exceptions.FailedOp;
import org.ojai.store.exceptions.MultiOpException;
import org.ojai.types.ODate;
import org.ojai.types.OTime;
import org.ojai.types.OTimestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ClusterTest.class})
public class TestMapRDBWithCluster
extends BaseTest {
    private static final Logger _logger = LoggerFactory.getLogger(TestMapRDBWithCluster.class);
    private static final String TABLE_NAME = "testtable-TestMapRDBWithCluster";
    private static final String TABLE_DEL = "testtable-myTableDel";
    private static final String TABLE_WRITER = "testtable-testwriter";
    public static final int MAP_CLIENT_FLUSH_INTERVAL = 3000;
    private static Table sharedStaticTable;
    static List<Object> values;
    QueryCondition condition = MapRDB.newCondition().and().exists("map.LIST").typeOf("map.LIST", Value.Type.ARRAY).is("map.int", QueryCondition.Op.EQUAL, 50000).close().build();
    int numAsyncIssued = 0;
    int numAsyncSucc = 0;
    int numAsyncFail = 0;
    private String alphabet = "abcdefghijklmnopqrstuvwxyz";

    @BeforeClass
    public static void startupBeforeClass() throws IOException {
        sharedStaticTable = DBTests.createOrReplaceTable(TABLE_NAME);
        Assert.assertEquals((Object)sharedStaticTable.getOption(Table.TableOption.EXCLUDEID).getBoolean(), (Object)false);
        Assert.assertEquals((Object)sharedStaticTable.getOption(Table.TableOption.BUFFERWRITE).getBoolean(), (Object)true);
        Assert.assertEquals((Object)sharedStaticTable.getOption(Table.TableOption.KEEPINSERTIONORDER).getBoolean(), (Object)true);
        sharedStaticTable.setOption(Table.TableOption.BUFFERWRITE, false);
        sharedStaticTable.setOption(Table.TableOption.EXCLUDEID, true);
        Assert.assertEquals((Object)sharedStaticTable.getOption(Table.TableOption.BUFFERWRITE).getBoolean(), (Object)false);
        Assert.assertEquals((Object)sharedStaticTable.getOption(Table.TableOption.EXCLUDEID).getBoolean(), (Object)true);
        Table getTbl = DBTests.getTable(TABLE_NAME);
        Assert.assertEquals((Object)sharedStaticTable.getName(), (Object)getTbl.getName());
    }

    @AfterClass
    public static void cleanupAfterClass() throws IOException, Exception {
        if (sharedStaticTable != null) {
            sharedStaticTable.close();
            DBTests.deleteTables(TABLE_NAME);
        }
    }

    private DBDocumentBuilder createAndPrepareWriter() {
        Document innerRecord = MapRDB.newDocument();
        innerRecord.set("val1", 144.21f);
        innerRecord.set("val2", (short)256);
        ArrayList<Object> l = new ArrayList<Object>();
        l.add(OTime.parse((String)"07:30:35.999"));
        l.add(new BigDecimal(4444.1928282));
        innerRecord.set("list", l);
        DBDocumentBuilder writer = new DBDocumentBuilder();
        writer.addNewMap();
        writer.put("a.x", "a string");
        writer.put("bool", true);
        writer.put("long", 999111666L);
        writer.putNewMap("map");
        writer.put("bool", true);
        writer.put("date", ODate.parse((String)"2013-12-12"));
        writer.putNewArray("array");
        writer.add(OTimestamp.parse((String)"2013-10-15T14:20:25.111-07:00"));
        writer.add((byte)111);
        writer.add(1234);
        writer.add(innerRecord);
        writer.endArray();
        writer.put("float", 123.456f);
        writer.endMap();
        writer.put("record.inner", innerRecord);
        writer.endMap();
        return writer;
    }

    public void testDBDocumentWriterCRUD() throws IOException, Exception {
        Table myTab = DBTests.createOrReplaceTable(TABLE_WRITER);
        DBDocumentBuilder writer = this.createAndPrepareWriter();
        Document r = writer.getDocument();
        Assert.assertEquals((Object)"a string", (Object)r.getString("`a.x`"));
        myTab.insertOrReplace("key1", r);
        myTab.insertOrReplace("key2", r);
        r.set("p.q", 333456700L);
        myTab.insertOrReplace("key3", r);
        myTab.flush();
        Document newRec = myTab.findById("key1");
        _logger.info("Checking with assert");
        Assert.assertEquals((Object)"a string", (Object)newRec.getString("`a.x`"));
        Assert.assertEquals((long)999111666L, (long)newRec.getLong("long"));
        Assert.assertEquals((Object)true, (Object)newRec.getBoolean("map.bool"));
        if (newRec.getBoolean("map.bool")) {
            _logger.info("Got boolean as true");
        }
        newRec = myTab.findById("key2");
        Assert.assertEquals((long)1234L, (long)newRec.getInt("map.array[2]"));
        Assert.assertEquals((Object)OTimestamp.parse((String)"2013-10-15T14:20:25.111-07:00"), (Object)newRec.getTimestamp("map.array[0]"));
        Assert.assertEquals((long)256L, (long)newRec.getShort("map.array[3].val2"));
        Assert.assertEquals((Object)OTime.parse((String)"07:30:35.999"), (Object)newRec.getTime("map.array[3].list[0]"));
        Assert.assertEquals((double)144.21, (double)newRec.getFloat("`record.inner`.val1"), (double)1.0E-5);
        _logger.info("All asserts with get() record passed");
        myTab.delete("key2");
        newRec = myTab.findById("key3");
        Assert.assertEquals((long)333456700L, (long)newRec.getLong("p.q"));
        Assert.assertEquals((long)111L, (long)newRec.getByte("map.array[1]"));
        newRec = myTab.findById("key2");
        DocumentStream stream = myTab.find();
        Iterator iter = stream.iterator();
        int count = 0;
        while (iter.hasNext()) {
            iter.next();
            ++count;
        }
        Assert.assertEquals((long)2L, (long)count);
        myTab.close();
        DBTests.deleteTables(TABLE_WRITER);
    }

    public void testIdWithRecordWriter() throws Exception {
        Table myTab = DBTests.createOrReplaceTable(TABLE_WRITER);
        myTab.setOption(Table.TableOption.EXCLUDEID, false);
        DBDocumentBuilder writer = this.createAndPrepareWriter();
        Document rec = writer.getDocument();
        rec.set("_id", "k1");
        myTab.insertOrReplace(rec);
        writer = this.createAndPrepareWriter();
        rec = writer.getDocument();
        rec.set("_id", "k2");
        myTab.insertOrReplace(rec);
        Document newRec = myTab.findById("k1");
        Assert.assertEquals((Object)true, (Object)newRec.getBoolean("bool"));
        newRec = myTab.findById("k2");
        Assert.assertEquals((Object)"k2", (Object)IdCodec.asString((Value)newRec.getValue("_id")));
        myTab.close();
        DBTests.deleteTables(TABLE_WRITER);
    }

    public void putRecords() throws IOException {
        Document putRec = TestMapRDBWithCluster.getMedRecord();
        sharedStaticTable.insertOrReplace("KEY1", putRec);
        sharedStaticTable.insertOrReplace("KEY2", putRec);
        sharedStaticTable.insertOrReplace("KEY3", putRec);
        sharedStaticTable.insertOrReplace("KEY4", putRec);
        sharedStaticTable.insertOrReplace("KEY5", putRec);
        sharedStaticTable.insertOrReplace("KEY6", putRec);
        sharedStaticTable.insertOrReplace("KEY7", putRec);
        sharedStaticTable.insertOrReplace("KEY8", putRec);
        sharedStaticTable.insertOrReplace("KEYa", putRec);
        putRec.set("office", "mapr");
        sharedStaticTable.insertOrReplace("KEYb", putRec);
        putRec = TestMapRDBWithCluster.getMedRecord();
        sharedStaticTable.insertOrReplace(putRec, "string");
        Document readRecord1 = sharedStaticTable.findById(putRec.getString("string"));
        Assert.assertNotNull((Object)readRecord1);
        try {
            sharedStaticTable.insertOrReplace(putRec, "map.int");
            Assert.fail();
        }
        catch (EncodingException encodingException) {
            // empty catch block
        }
    }

    void testGets() throws IOException {
        for (int i = 0; i < 1000; ++i) {
            DBDocumentImpl readRecord = (DBDocumentImpl)sharedStaticTable.findById("KEY1");
            Assert.assertEquals((Object)readRecord.getValue("map").getType(), (Object)Value.Type.MAP);
            Assert.assertEquals((Object)readRecord.getBoolean("map.boolean"), (Object)true);
            Assert.assertEquals((Object)readRecord.getString("map.string"), (Object)"string");
            Assert.assertEquals((long)readRecord.getByte("map.byte"), (long)100L);
            Assert.assertEquals((long)readRecord.getShort("map.short"), (long)10000L);
            Assert.assertEquals((long)readRecord.getInt("map.int"), (long)50000L);
            Assert.assertEquals((long)readRecord.getLong("map.long"), (long)12345678999L);
            Assert.assertEquals((double)readRecord.getFloat("map.float"), (double)10.1234f, (double)0.0);
            Assert.assertEquals((double)readRecord.getDouble("map.double"), (double)10.1234567891, (double)0.0);
            List l = readRecord.getValue("map.LIST").getList();
            Assert.assertEquals(values, (Object)l);
            Assert.assertEquals((Object)readRecord.getBoolean("boolean"), (Object)false);
            Assert.assertEquals((Object)readRecord.getValue("string").getType(), (Object)Value.Type.STRING);
            Assert.assertEquals((long)readRecord.getByte("byte"), (long)100L);
            Assert.assertEquals((Object)false, (Object)readRecord.getBoolean("map.boolarray[0]"));
            Assert.assertEquals((Object)true, (Object)readRecord.getBoolean("map.boolarray[2]"));
            Document readRecord1 = sharedStaticTable.findById("KEY1", this.condition, new String[]{"map", "byte"});
            Assert.assertNotNull((Object)readRecord1);
            readRecord1 = sharedStaticTable.findById("KEYb", this.condition, new String[]{"office"});
            Assert.assertNotNull((Object)readRecord1);
        }
        _logger.info("Get and cond get done.");
    }

    void testScans() throws IOException {
        Document readRecord;
        DocumentStream rs = sharedStaticTable.find();
        Iterator itrs = rs.iterator();
        int count = 0;
        while (itrs.hasNext()) {
            readRecord = (Document)itrs.next();
            ++count;
        }
        _logger.info("Scan completed - got " + count + " records.");
        sharedStaticTable.delete("KEY1");
        sharedStaticTable.delete("KEYa");
        rs = sharedStaticTable.find();
        itrs = rs.iterator();
        count = 0;
        while (itrs.hasNext()) {
            itrs.next();
            ++count;
        }
        _logger.info("Scan completed after 2 records delete - got " + count + " records.");
        rs = sharedStaticTable.find(new String[]{"office"});
        itrs = rs.iterator();
        count = 0;
        while (itrs.hasNext()) {
            readRecord = (Document)itrs.next();
            if (readRecord.getString("office") == null) {
                Assert.assertEquals((long)readRecord.size(), (long)0L);
                continue;
            }
            if (readRecord.getString("office").equals("mapr")) {
                Assert.assertEquals((long)readRecord.size(), (long)1L);
                ++count;
                continue;
            }
            _logger.info("Incorrect result for scan: " + readRecord);
            Assert.assertEquals((Object)true, (Object)false);
        }
        _logger.info("Scan with projection completed - got " + count + " records.");
        Assert.assertEquals((long)1L, (long)count);
        this.condition = MapRDB.newCondition().and().exists("_id").exists("map.LIST").typeOf("map.LIST", Value.Type.ARRAY).is("map.int", QueryCondition.Op.EQUAL, 50000).close().build();
        rs = sharedStaticTable.find(this.condition, new String[]{"boolean", "map.LIST"});
        itrs = rs.iterator();
        count = 0;
        while (itrs.hasNext()) {
            readRecord = (Document)itrs.next();
            Assert.assertEquals((Object)readRecord.getBoolean("boolean"), (Object)false);
            Assert.assertNull((Object)readRecord.getValue("Friends"));
            Assert.assertNull((Object)readRecord.getValue("map.int"));
            Assert.assertNotNull((Object)readRecord.getValue("map.LIST"));
            Assert.assertEquals((long)2L, (long)readRecord.size());
            ++count;
        }
        _logger.info("Scan with cond & projection completed - got " + count + " records.");
        this.condition = MapRDB.newCondition().and().exists("map.LIST").typeOf("map.LIST", Value.Type.ARRAY).is("map.int", QueryCondition.Op.EQUAL, 50000).close().build();
    }

    @Test
    public void testReducer() throws IOException, InterruptedException {
        DBDocumentImpl putRec = new DBDocumentImpl();
        putRec.set("a.b", 1).set("a.c", 2).set("a.d", 3).set("a.e", 4).set("a.f", 5);
        sharedStaticTable.insertOrReplace("KEYR", (Document)putRec);
        Thread.sleep(3000L);
        DocumentMutation mutRec = MapRDB.newMutation();
        mutRec.delete("a.c").delete("a.f");
        sharedStaticTable.update("KEYR", mutRec);
        Thread.sleep(3000L);
        Document readRecord = sharedStaticTable.findById("KEYR");
        Assert.assertEquals((long)readRecord.getInt("a.b"), (long)1L);
        Assert.assertEquals((long)readRecord.getInt("a.d"), (long)3L);
        Assert.assertEquals((long)readRecord.getInt("a.e"), (long)4L);
        Assert.assertNull((Object)readRecord.getValue("a.c"));
        Assert.assertNull((Object)readRecord.getValue("a.f"));
        sharedStaticTable.delete("KEYR");
    }

    void asyncReadTests() throws IOException {
        myOpListener myOp = new myOpListener();
        sharedStaticTable.findById((OpListener)myOp, "KEY1");
        sharedStaticTable.findById((OpListener)myOp, "KEY2", this.condition);
        sharedStaticTable.findById((OpListener)myOp, "KEY3", this.condition, new String[]{"map", "byte"});
        sharedStaticTable.findById((OpListener)myOp, "KEY4", new String[]{"string"});
        this.numAsyncIssued = 4;
    }

    @Test
    public void recordMutTest2() throws IOException {
        int i;
        Document r = TestMapRDBWithCluster.getMedRecord();
        sharedStaticTable.insertOrReplace("RecordMutKey", r);
        r = sharedStaticTable.findById("RecordMutKey");
        Assert.assertEquals((long)r.getInt("Scores[1]"), (long)20L);
        Assert.assertEquals((Object)r.getString("Friends[0]"), (Object)"Anurag");
        Assert.assertEquals((long)r.getByte("map.byte"), (long)100L);
        Assert.assertEquals((long)r.getShort("map.short"), (long)10000L);
        Assert.assertEquals((long)r.getLong("map.long"), (long)12345678999L);
        Assert.assertEquals((long)r.getInt("map.LIST2[3][2]"), (long)1500L);
        ByteBuffer buf = ByteBuffer.allocate(5000);
        for (int i2 = 0; i2 < 5000; ++i2) {
            buf.put((byte)55);
        }
        buf.rewind();
        DocumentMutation mutation = MapRDB.newMutation();
        mutation.increment("Scores[1]", 3.2).append("Friends[0]", " Choudhary").increment("map.byte", 5.5).increment("map.short", 20000.2).delete("map.int").delete("map.long").setOrReplace("map.newfield", "THIS IS NEW").increment("map.LIST2[3][2]", (byte)120).append("binary3", buf).increment("NewField.field1.bytefield", (byte)30).increment("NewField.field1.shortfield", (short)12345).increment("NewField.field1.intfield", 567890123).increment("NewField.field1.longfield", 7777777777777777L).increment("NewField.field1.floatfield", 10.12345f).increment("NewField.field1.doublefield", 111111.111111);
        sharedStaticTable.update("RecordMutKey", mutation);
        sharedStaticTable.flush();
        r = sharedStaticTable.findById("RecordMutKey");
        Assert.assertEquals((long)r.getInt("Scores[1]"), (long)23L);
        Assert.assertEquals((Object)r.getString("Friends[0]"), (Object)"Anurag Choudhary");
        Assert.assertEquals((long)r.getByte("map.byte"), (long)105L);
        Assert.assertEquals((long)r.getShort("map.short"), (long)30000L);
        Assert.assertEquals((Object)r.getValue("map.int"), null);
        Assert.assertEquals((Object)r.getValue("map.long"), null);
        Assert.assertEquals((Object)r.getString("map.newfield"), (Object)"THIS IS NEW");
        Assert.assertEquals((long)r.getInt("map.LIST2[3][2]"), (long)1620L);
        Assert.assertEquals((long)30L, (long)r.getByte("NewField.field1.bytefield"));
        Assert.assertEquals((long)12345L, (long)r.getShort("NewField.field1.shortfield"));
        Assert.assertEquals((long)567890123L, (long)r.getInt("NewField.field1.intfield"));
        Assert.assertEquals((long)7777777777777777L, (long)r.getLong("NewField.field1.longfield"));
        Assert.assertEquals((double)10.12345027923584, (double)r.getFloat("NewField.field1.floatfield"), (double)0.0);
        Assert.assertEquals((double)111111.111111, (double)r.getDouble("NewField.field1.doublefield"), (double)0.0);
        ByteBuffer b = r.getBinary("binary3");
        for (i = 0; i < 100; ++i) {
            Assert.assertEquals((long)b.get(i), (long)((byte)i));
        }
        for (i = 100; i < 5000; ++i) {
            Assert.assertEquals((long)b.get(i), (long)55L);
        }
        _logger.info("recordmutation test2 completed");
    }

    @Test
    public void testMultiCFGet() throws Exception {
        Table multiCFTable = DBTests.createOrReplaceTable("multiCFGet-TestMapRDBWithCluster", (Map<String, String>)ImmutableMap.of((Object)"f1", (Object)"a.b", (Object)"f2", (Object)"a.b.c.d", (Object)"f3", (Object)"a.b.c", (Object)"f4", (Object)"x.a.b.c"));
        multiCFTable.setOption(Table.TableOption.BUFFERWRITE, false);
        Document r = MapRDB.newDocument();
        r.set("b", 0);
        r.set("a.b.x", 5L);
        r.set("a.b.c.d.e", 10L);
        r.set("a.b.d", 2749).set("a.bb.d", "abd").set("a.b.c.e", "abce").set("x.a.b.c", "xabc").set("x.aa.b.c", "xabc").set("y.a.b.c", "yabc").set("c.d", 3021.0f);
        multiCFTable.insertOrReplace("key", r);
        r = multiCFTable.findById("key", new String[]{"a.b"});
        Assert.assertEquals((long)5L, (long)r.getLong("a.b.x"));
        Assert.assertEquals((long)10L, (long)r.getLong("a.b.c.d.e"));
        Assert.assertEquals((long)2749L, (long)r.getInt("a.b.d"));
        Assert.assertEquals((Object)"abce", (Object)r.getString("a.b.c.e"));
        Assert.assertNull((Object)r.getString("x.a.b.c"));
        Assert.assertNull((Object)r.getString("x.aa.b.c"));
        Assert.assertNull((Object)r.getString("y.a.b.c"));
        Assert.assertNull((Object)r.getValue("b"));
        Assert.assertNull((Object)r.getString("a.bb.d"));
        Assert.assertNull((Object)r.getValue("c.d"));
        r = multiCFTable.findById("key", new String[]{"a.b.c"});
        Assert.assertEquals((long)10L, (long)r.getLong("a.b.c.d.e"));
        Assert.assertEquals((Object)"abce", (Object)r.getString("a.b.c.e"));
        Assert.assertNull((Object)r.getValue("a.b.x"));
        Assert.assertNull((Object)r.getValue("b"));
        Assert.assertNull((Object)r.getString("x.a.b.c"));
        Assert.assertNull((Object)r.getString("x.aa.b.c"));
        Assert.assertNull((Object)r.getString("y.a.b.c"));
        Assert.assertNull((Object)r.getString("a.bb.d"));
        Assert.assertNull((Object)r.getValue("c.d"));
        r = multiCFTable.findById("key", new String[]{"c.d", "a.bb", "x.aa", "x.a.b"});
        Assert.assertEquals((float)3021.0f, (float)r.getFloat("c.d"), (float)0.0f);
        Assert.assertEquals((Object)"abd", (Object)r.getString("a.bb.d"));
        Assert.assertEquals((Object)"xabc", (Object)r.getString("x.aa.b.c"));
        Assert.assertEquals((Object)"xabc", (Object)r.getString("x.a.b.c"));
        Assert.assertNull((Object)r.getValue("b"));
        Assert.assertNull((Object)r.getValue("a.b.x"));
        Assert.assertNull((Object)r.getValue("a.b.c.d.e"));
        Assert.assertNull((Object)r.getValue("a.b.d"));
        Assert.assertNull((Object)r.getValue("a.b.c.e"));
        Assert.assertNull((Object)r.getValue("y.a.b.c"));
        r = multiCFTable.findById("key", new String[]{""});
        Assert.assertEquals((long)5L, (long)r.getLong("a.b.x"));
        Assert.assertEquals((long)10L, (long)r.getLong("a.b.c.d.e"));
        Assert.assertEquals((long)2749L, (long)r.getInt("a.b.d"));
        Assert.assertEquals((Object)"abce", (Object)r.getString("a.b.c.e"));
        Assert.assertEquals((long)0L, (long)r.getInt("b"));
        Assert.assertEquals((Object)"abd", (Object)r.getString("a.bb.d"));
        ((MapRDBTableImpl)multiCFTable).setExcludeEmbeddedFamily(true);
        r = multiCFTable.findById("key", new String[]{"a.b"});
        Assert.assertEquals((long)5L, (long)r.getLong("a.b.x"));
        Assert.assertNull((Object)r.getValue("a.b.c.d.e"));
        Assert.assertNull((Object)r.getValue("b"));
        multiCFTable.close();
        DBTests.deleteTables("multiCFGet-TestMapRDBWithCluster");
    }

    @Test(expected=Exception.class)
    public void mutateIncNonNumberTypes() throws IOException {
        Document r = MapRDB.newDocument();
        r.set("Name", "Anurag");
        sharedStaticTable.insertOrReplace("mutateIncNonNumberTypesKey", r);
        r = sharedStaticTable.findById("mutateIncNonNumberTypes");
        Assert.assertEquals((Object)r.getString("Name"), (Object)"Anurag");
        DocumentMutation mutation = MapRDB.newMutation();
        mutation.increment("Name", 3.2);
        sharedStaticTable.update("RecordMutKey", mutation);
        sharedStaticTable.flush();
    }

    @Test
    public void mutateIncConflictingPath() throws IOException {
        Document r = MapRDB.newDocument();
        String key = "key";
        r.set("field1.field2[0]", 50).set("field1.field2[1]", 100).set("field1.field2[2]", 150);
        sharedStaticTable.insertOrReplace(key, r);
        r = sharedStaticTable.findById("key");
        Assert.assertEquals((long)r.getInt("field1.field2[0]"), (long)50L);
        Assert.assertEquals((long)r.getInt("field1.field2[1]"), (long)100L);
        Assert.assertEquals((long)r.getInt("field1.field2[2]"), (long)150L);
        DocumentMutation mutation = MapRDB.newMutation();
        mutation.increment("field1.field2", 3.2);
        boolean opFailed = false;
        try {
            sharedStaticTable.update(key, mutation);
            sharedStaticTable.flush();
        }
        catch (Exception e) {
            opFailed = true;
        }
        Assert.assertEquals((Object)true, (Object)opFailed);
        mutation = MapRDB.newMutation();
        mutation.increment("field1.field2.field3.field4", 3.2);
        opFailed = false;
        try {
            sharedStaticTable.update(key, mutation);
            sharedStaticTable.flush();
        }
        catch (Exception e) {
            opFailed = true;
        }
        Assert.assertEquals((Object)true, (Object)opFailed);
        mutation = MapRDB.newMutation();
        mutation.increment("field1.field2[5]", 3.2);
        opFailed = false;
        try {
            sharedStaticTable.update(key, mutation);
            sharedStaticTable.flush();
        }
        catch (Exception e) {
            opFailed = true;
        }
        Assert.assertEquals((Object)false, (Object)opFailed);
    }

    @Test
    public void mutateIncLargeValue() throws IOException {
        Document r = MapRDB.newDocument();
        long v = 1165513391666352928L;
        int inc = 1001;
        String key = "key";
        r.set("A", v).set("B", v);
        sharedStaticTable.insertOrReplace(key, r);
        r = sharedStaticTable.findById("key");
        Assert.assertEquals((long)r.getLong("A"), (long)v);
        Assert.assertEquals((long)r.getLong("B"), (long)v);
        DocumentMutation mutation = MapRDB.newMutation();
        mutation.increment("A", inc).increment("B", inc);
        sharedStaticTable.update(key, mutation);
        sharedStaticTable.flush();
        r = sharedStaticTable.findById("key");
        Assert.assertEquals((long)r.getLong("A"), (long)(v + (long)inc));
        Assert.assertEquals((long)r.getLong("B"), (long)(v + (long)inc));
    }

    @Test
    public void mutateDecValues() throws IOException {
        Document r = MapRDB.newDocument();
        long v1 = 1165513391666352928L;
        byte v2 = 127;
        short v3 = 999;
        int v4 = 32700;
        double v5 = 1.838464645001E12;
        long decr1 = 1001L;
        byte decr2 = 7;
        short decr3 = 111;
        int decr4 = 11224;
        double decr5 = 1111.9999;
        String key = "key";
        r.set("long", v1).set("byte", v2).set("short", v3).set("int", v4).set("double", v5);
        sharedStaticTable.insertOrReplace(key, r);
        r = sharedStaticTable.findById("key");
        Assert.assertEquals((long)r.getLong("long"), (long)v1);
        Assert.assertEquals((long)r.getByte("byte"), (long)v2);
        Assert.assertEquals((long)r.getShort("short"), (long)v3);
        Assert.assertEquals((long)r.getInt("int"), (long)v4);
        Assert.assertEquals((double)r.getDouble("double"), (double)v5, (double)0.0);
        DocumentMutation mutation = MapRDB.newMutation();
        mutation.decrement("long", decr1).decrement("byte", decr2).decrement("short", decr3).decrement("int", decr4).decrement("double", decr5).decrement("x.y", decr1);
        sharedStaticTable.update(key, mutation);
        sharedStaticTable.flush();
        r = sharedStaticTable.findById("key");
        Assert.assertEquals((long)r.getLong("long"), (long)(v1 - decr1));
        Assert.assertEquals((long)r.getByte("byte"), (long)(v2 - decr2));
        Assert.assertEquals((long)r.getShort("short"), (long)(v3 - decr3));
        Assert.assertEquals((long)r.getInt("int"), (long)(v4 - decr4));
        Assert.assertEquals((double)r.getDouble("double"), (double)(v5 - decr5), (double)0.0);
        Assert.assertEquals((long)r.getLong("x.y"), (long)(-decr1));
    }

    @Test
    public void mutateIncLongMAX() throws IOException {
        Document r = MapRDB.newDocument();
        long v = 1165513391666352928L;
        long inc = Long.MAX_VALUE;
        String key = "key";
        r.set("byte", (byte)100).set("short", (short)12345).set("int", 12345678).set("long", v).set("float", 12345.123f).set("double", 1.111111111111111E8);
        sharedStaticTable.insertOrReplace(key, r);
        r = sharedStaticTable.findById("key");
        DocumentMutation mutation = MapRDB.newMutation();
        mutation.increment("byte", inc).increment("short", inc).increment("int", inc).increment("long", inc).increment("float", inc).increment("double", inc);
        sharedStaticTable.update(key, mutation);
        sharedStaticTable.flush();
        r = sharedStaticTable.findById("key");
        Assert.assertEquals((long)r.getByte("byte"), (long)((byte)(100L + inc)));
        Assert.assertEquals((long)r.getShort("short"), (long)((short)(12345L + inc)));
        Assert.assertEquals((long)r.getInt("int"), (long)((int)(12345678L + inc)));
        Assert.assertEquals((long)r.getLong("long"), (long)(v + inc));
        Assert.assertEquals((double)r.getFloat("float"), (double)(12345.123f + (float)inc), (double)0.0);
        Assert.assertEquals((double)r.getDouble("double"), (double)(1.111111111111111E8 + (double)inc), (double)0.0);
    }

    @Test
    public void mutateAppendTest() throws IOException {
        int i;
        Document r = MapRDB.newDocument();
        byte[] b = new byte[100];
        for (int i2 = 0; i2 < 100; ++i2) {
            b[i2] = (byte)i2;
        }
        String key = "key";
        r.set("bytes", b).set("string", "Hello ").set("double1", 50.505).set("double2", 50000.505).setArray("array", new int[]{10, 20, 30, 40}).setArray("array2", new int[]{10, 20, 30, 40});
        sharedStaticTable.insertOrReplace(key, r);
        r = sharedStaticTable.findById("key");
        Assert.assertEquals((Object)"Hello ", (Object)r.getString("string"));
        Assert.assertEquals((long)10L, (long)r.getInt("array[0]"));
        Assert.assertEquals((long)20L, (long)r.getInt("array[1]"));
        Assert.assertEquals((long)30L, (long)r.getInt("array[2]"));
        Assert.assertEquals((long)40L, (long)r.getInt("array[3]"));
        Assert.assertEquals((long)10L, (long)r.getInt("array2[0]"));
        Assert.assertEquals((long)20L, (long)r.getInt("array2[1]"));
        Assert.assertEquals((long)30L, (long)r.getInt("array2[2]"));
        Assert.assertEquals((long)40L, (long)r.getInt("array2[3]"));
        Assert.assertEquals((double)50.505, (double)r.getDouble("double1"), (double)0.0);
        Assert.assertEquals((double)50000.505, (double)r.getDouble("double2"), (double)0.0);
        ByteBuffer bread = r.getBinary("bytes");
        for (int i3 = 0; i3 < 100; ++i3) {
            Assert.assertEquals((long)((byte)i3), (long)bread.get());
        }
        DocumentMutation mutation = MapRDB.newMutation();
        byte[] newBytes = new byte[50];
        for (int i4 = 0; i4 < 50; ++i4) {
            newBytes[i4] = -52;
        }
        Value val = r.getValue("string");
        Value val2 = r.getValue("double1");
        mutation.append("bytes", newBytes).append("string", "world").append("array", Arrays.asList("W1", "W2", 500)).append("newpath.bytes", newBytes).append("newpath.string", "hello world").append("newpath.array", Arrays.asList("W1", "W2", 500)).setOrReplace("newpath2.string", val).set("double2", val2).setOrReplace("array2[1]", "NEW ARRAY ELEMENT").setOrReplace("array2[2]", 5000.0);
        sharedStaticTable.update(key, mutation);
        sharedStaticTable.flush();
        r = sharedStaticTable.findById("key");
        Assert.assertEquals((Object)"Hello world", (Object)r.getString("string"));
        Assert.assertEquals((long)10L, (long)r.getInt("array[0]"));
        Assert.assertEquals((long)20L, (long)r.getInt("array[1]"));
        Assert.assertEquals((long)30L, (long)r.getInt("array[2]"));
        Assert.assertEquals((long)40L, (long)r.getInt("array[3]"));
        Assert.assertEquals((Object)"W1", (Object)r.getString("array[4]"));
        Assert.assertEquals((Object)"W2", (Object)r.getString("array[5]"));
        Assert.assertEquals((long)500L, (long)r.getInt("array[6]"));
        Assert.assertEquals((long)10L, (long)r.getInt("array2[0]"));
        Assert.assertEquals((Object)"NEW ARRAY ELEMENT", (Object)r.getString("array2[1]"));
        Assert.assertEquals((double)5000.0, (double)r.getDouble("array2[2]"), (double)0.0);
        Assert.assertEquals((long)40L, (long)r.getInt("array[3]"));
        bread = r.getBinary("bytes");
        for (i = 0; i < 100; ++i) {
            Assert.assertEquals((long)((byte)i), (long)bread.get());
        }
        for (i = 0; i < 50; ++i) {
            Assert.assertEquals((long)-52L, (long)bread.get());
        }
        bread = r.getBinary("newpath.bytes");
        for (i = 0; i < 50; ++i) {
            Assert.assertEquals((long)-52L, (long)bread.get());
        }
        Assert.assertEquals((Object)"hello world", (Object)r.getString("newpath.string"));
        Assert.assertEquals((Object)"Hello ", (Object)r.getString("newpath2.string"));
        Assert.assertEquals((double)50.505, (double)r.getDouble("double1"), (double)0.0);
        Assert.assertEquals((double)50.505, (double)r.getDouble("double2"), (double)0.0);
        Assert.assertEquals((Object)"W1", (Object)r.getString("newpath.array[0]"));
        Assert.assertEquals((Object)"W2", (Object)r.getString("newpath.array[1]"));
        Assert.assertEquals((long)500L, (long)r.getInt("newpath.array[2]"));
        Assert.assertEquals((long)500L, (long)r.getInt("newpath.array[2]"));
    }

    @Test
    public void recordMutTests() throws IOException {
        sharedStaticTable.insertOrReplace("KEY2M", TestMapRDBWithCluster.getMedRecord());
        DBDocumentImpl readRecord = (DBDocumentImpl)sharedStaticTable.findById("KEY2M");
        Assert.assertEquals((long)readRecord.getInt("map.int"), (long)50000L);
        HashMap locations = Maps.newHashMap();
        locations.put("office", "111 abc");
        locations.put("school", "222 def");
        locations.put("vacation", "333 ghi");
        DocumentMutation mutRec = MapRDB.newMutation();
        mutRec.setOrReplace("a.int", 111).delete("binary3").delete("map.string").setOrReplace("map.string", "abcd").setOrReplace("map.boolean", true).setOrReplace("map.long", 123456789101112L).setOrReplace("map.time", new OTime(3600L)).setOrReplace("map.timestamp", new OTimestamp(50000000L));
        sharedStaticTable.update("KEY2M", mutRec);
        sharedStaticTable.flush();
        readRecord = (DBDocumentImpl)sharedStaticTable.findById("KEY2M");
        Assert.assertNotNull((Object)readRecord);
        Assert.assertNull((Object)readRecord.getValue("binary3"));
        Assert.assertEquals((long)readRecord.getInt("a.int"), (long)111L);
        Assert.assertEquals((long)readRecord.getInt("map.int"), (long)50000L);
        Assert.assertEquals((Object)readRecord.getString("map.string"), (Object)"abcd");
        Assert.assertEquals((long)readRecord.getLong("map.long"), (long)123456789101112L);
        Assert.assertEquals((Object)readRecord.getBoolean("map.boolean"), (Object)true);
        Assert.assertEquals((long)61203600L, (long)readRecord.getTime("map.time").toTimeInMillis());
        Assert.assertEquals((long)50000000L, (long)readRecord.getTimestamp("map.timestamp").getMillis());
        sharedStaticTable.delete("KEY2M");
    }

    @Test
    public void recordMutMergeTests() throws IOException {
        Document d = MapRDB.newDocument();
        d.set("a.b", 100).set("a.c", 200).set("a.d[0]", 1).set("a.d[1]", 2);
        sharedStaticTable.insertOrReplace("KEY1", d);
        Document d2 = MapRDB.newDocument();
        d2.set("d[0]", 3).set("d[1]", 4).set("e.e1", 300).set("f.f1", 400);
        sharedStaticTable.insertOrReplace("KEY2", d2);
        sharedStaticTable.flush();
        d2 = sharedStaticTable.findById("KEY2");
        DocumentMutation m = MapRDB.newMutation();
        m.merge("a", d2);
        sharedStaticTable.update("KEY1", m);
        sharedStaticTable.flush();
        d = sharedStaticTable.findById("KEY1");
        Assert.assertEquals((long)100L, (long)d.getInt("a.b"));
        Assert.assertEquals((long)200L, (long)d.getInt("a.c"));
        Assert.assertEquals((long)1L, (long)d.getInt("a.d[0]"));
        Assert.assertEquals((long)2L, (long)d.getInt("a.d[1]"));
        Assert.assertEquals((long)3L, (long)d.getInt("a.d[2]"));
        Assert.assertEquals((long)4L, (long)d.getInt("a.d[3]"));
        Assert.assertEquals((long)300L, (long)d.getInt("a.e.e1"));
        Assert.assertEquals((long)400L, (long)d.getInt("a.f.f1"));
    }

    @Test
    public void overlappingMutationTests() throws IOException {
        Document d2 = MapRDB.newDocument();
        d2.set("d[0]", 3).set("d[1]", 4).set("e.e1", 300).set("f.f1", 400);
        ArrayList<Integer> x = new ArrayList<Integer>();
        x.add(100);
        x.add(200);
        DocumentMutation m = MapRDB.newMutation();
        m.set("a.maptomap", d2).set("a.maptoarray", d2).set("a.maptoscalar", d2).set("a.arraytomap", x).set("a.arraytoarray", x).set("a.arraytoscalar", x).set("a.scalartomap", 10).set("a.scalartoarray", 10).set("a.scalartoscalar", 10);
        m.set("a.maptomap.x1", 100).set("a.maptoarray[5]", 100).set("a.maptoscalar", 100).set("a.arraytomap.x1", 200).set("a.arraytoarray[5]", 200).set("a.arraytoscalar", 200).set("a.scalartomap.x1", 300).set("a.scalartoarray[5]", 300).set("a.scalartoscalar", 300);
        sharedStaticTable.update("KEY1", m);
        sharedStaticTable.flush();
        Document d = sharedStaticTable.findById("KEY1");
        Assert.assertEquals((long)100L, (long)d.getInt("a.maptomap.x1"));
        Assert.assertEquals((long)100L, (long)d.getInt("a.maptoarray[0]"));
        Assert.assertEquals((long)100L, (long)d.getInt("a.maptoscalar"));
        Assert.assertEquals((long)200L, (long)d.getInt("a.arraytomap.x1"));
        Assert.assertEquals((long)200L, (long)d.getInt("a.arraytoarray[0]"));
        Assert.assertEquals((long)200L, (long)d.getInt("a.arraytoscalar"));
        Assert.assertEquals((long)300L, (long)d.getInt("a.scalartomap.x1"));
        Assert.assertEquals((long)300L, (long)d.getInt("a.scalartoarray[0]"));
        Assert.assertEquals((long)300L, (long)d.getInt("a.scalartoscalar"));
    }

    @Test
    public void nestedCFTest() throws IOException, Exception {
        LinkedHashMap<String, String> cfPath = new LinkedHashMap<String, String>();
        Table mcfTable = null;
        String mcfName = "multiCF-TestMapRDBWithCluster";
        cfPath.put("cf1", "`l1`");
        cfPath.put("cf2", "`l1`.l2");
        cfPath.put("cf3", "`l1`.l2.l3");
        cfPath.put("cf4", "`l1`.`l2`.l3.l4");
        cfPath.put("cf5", "`l1`.l2.l3.`l4`.l5");
        mcfTable = DBTests.createOrReplaceTable(mcfName, cfPath);
        MapRDBTableImplHelper.toRowConstraint((MapRDBTableImpl)((MapRDBTableImpl)mcfTable), (String[])new String[]{"l1.l2"});
        mcfTable.close();
        DBTests.deleteTables(mcfName);
    }

    @Test
    public void testInsOrderMapInsert() throws IOException, URISyntaxException {
        Table miaTable = DBTests.createOrReplaceTable("mi-TestMapRDBWithCluster");
        miaTable.setOption(Table.TableOption.BUFFERWRITE, false);
        miaTable.setOption(Table.TableOption.EXCLUDEID, true);
        URL resourceUrl = ((Object)((Object)this)).getClass().getResource("/ins.json");
        Path resourcePath = Paths.get(resourceUrl.toURI());
        List<String> lines = Files.readAllLines(resourcePath, Charsets.UTF_8);
        Document doc = MapRDB.newDocument((String)lines.get(0));
        miaTable.insertOrReplace("mirow", doc);
        Document readRecordi = miaTable.findById("mirow");
        Assert.assertNotNull((Object)readRecordi);
        Assert.assertEquals((Object)doc.toString(), (Object)readRecordi.toString());
        miaTable.close();
        DBTests.deleteTables("mi-TestMapRDBWithCluster");
    }

    @Test
    public void testInsOrderMapInArray() throws IOException {
        Table miaTable = DBTests.createOrReplaceTable("mia-TestMapRDBWithCluster");
        miaTable.setOption(Table.TableOption.BUFFERWRITE, false);
        miaTable.setOption(Table.TableOption.EXCLUDEID, true);
        DBDocumentImpl innerDoc = new DBDocumentImpl().set("z", "z").set("a", "a").set("d", "d").set("c", "c");
        ArrayList<String> avalues = new ArrayList<String>();
        avalues.add("Field1");
        avalues.add("Field2");
        avalues.add((String)innerDoc);
        Document putRec = new DBDocumentImpl().setArray("array", new Object[]{10, 20, 30, avalues});
        miaTable.insertOrReplace("miaRow", putRec);
        Document readRecordi = miaTable.findById("miaRow");
        Assert.assertNotNull((Object)readRecordi);
        Assert.assertEquals((Object)putRec.toString(), (Object)readRecordi.toString());
        miaTable.close();
        DBTests.deleteTables("mia-TestMapRDBWithCluster");
    }

    @Test
    public void testInsOrderWithMutInsertNestedMCF() throws IOException, Exception {
        String OrderTable = "orderWMIMCF-TestMapRDBWithCluster";
        Table orderTable = null;
        LinkedHashMap<String, String> cfPath = new LinkedHashMap<String, String>();
        cfPath.put("cf1", "x.y");
        cfPath.put("cf2", "p.q");
        cfPath.put("cf3", "a.b");
        cfPath.put("cf4", "a.b.c");
        orderTable = DBTests.createOrReplaceTable(OrderTable, cfPath);
        orderTable.setOption(Table.TableOption.BUFFERWRITE, false);
        orderTable.setOption(Table.TableOption.EXCLUDEID, true);
        Document readRecordi = null;
        Document putRec = MapRDB.newDocument().set("x.y", "xy").set("p.q", "pq").set("a.b.e", "abe").set("a.b.g", "abg").set("a.b.c.i", "abci").set("a.b.c.k", "abck").set("i", "root");
        orderTable.insertOrReplace("orderIns", putRec);
        String insField1 = "a.b.f";
        String insField2 = "a.b.c.j";
        DocumentMutation m = MapRDB.newMutation().setOrReplace(insField1, "abf").setOrReplace(insField2, "abcj");
        orderTable.update("orderIns", m);
        readRecordi = orderTable.findById("orderIns");
        int fi = ((DBDocumentImpl)readRecordi).getIndex(insField1);
        int ji = ((DBDocumentImpl)readRecordi).getIndex(insField2);
        int gi = ((DBDocumentImpl)readRecordi).getIndex("a.b.g");
        int ii = ((DBDocumentImpl)readRecordi).getIndex("a.b.c.i");
        Assert.assertEquals((long)2L, (long)fi);
        Assert.assertEquals((long)2L, (long)ji);
        Assert.assertEquals((long)1L, (long)gi);
        Assert.assertEquals((long)0L, (long)ii);
        orderTable.close();
        DBTests.deleteTables(OrderTable);
    }

    @Test
    public void testInsOrderWithMutInsert() throws IOException {
        Document r = null;
        DBDocumentImpl putRec = new DBDocumentImpl().set("m.n", (short)1).set("m.m", (short)2).set("m.q", (short)3).set("m.c", (short)31).set("m.d", (short)32).set("m.e", (short)33).set("m.f", (short)34).set("m.q", (short)35).set("m.x", (short)13).set("m.a", (short)7);
        sharedStaticTable.insertOrReplace("CheckAndMutateKey", (Document)putRec);
        DocumentMutation m = MapRDB.newMutation().setOrReplace("m.j", (short)8).delete("m.q").delete("m.x");
        QueryCondition c = MapRDB.newCondition().is("m.n", QueryCondition.Op.EQUAL, (short)1).build();
        boolean conditionSuccess = sharedStaticTable.checkAndMutate("CheckAndMutateKey", c, m);
        Assert.assertEquals((Object)true, (Object)conditionSuccess);
        r = sharedStaticTable.findById("CheckAndMutateKey");
        Assert.assertNotNull((Object)r);
        m = MapRDB.newMutation().increment("m.a", (short)8);
        c = MapRDB.newCondition().is("m.m", QueryCondition.Op.EQUAL, (short)2).build();
        conditionSuccess = sharedStaticTable.checkAndMutate("CheckAndMutateKey", c, m);
        Assert.assertEquals((Object)true, (Object)conditionSuccess);
        r = sharedStaticTable.findById("CheckAndMutateKey");
        Assert.assertNotNull((Object)r);
    }

    @Test
    public void checkAndMutateTest() throws IOException {
        int i;
        Document r = TestMapRDBWithCluster.getMedRecord();
        sharedStaticTable.insertOrReplace("CheckAndMutateKey", r);
        r = sharedStaticTable.findById("CheckAndMutateKey");
        Assert.assertEquals((long)r.getInt("Scores[1]"), (long)20L);
        Assert.assertEquals((Object)r.getString("Friends[0]"), (Object)"Anurag");
        Assert.assertEquals((long)r.getByte("map.byte"), (long)100L);
        Assert.assertEquals((long)r.getShort("map.short"), (long)10000L);
        Assert.assertEquals((long)r.getLong("map.long"), (long)12345678999L);
        Assert.assertEquals((long)r.getInt("map.LIST2[3][2]"), (long)1500L);
        ByteBuffer buf = ByteBuffer.allocate(5000);
        for (int i2 = 0; i2 < 5000; ++i2) {
            buf.put((byte)55);
        }
        buf.rewind();
        DocumentMutation mutation = MapRDB.newMutation();
        mutation.increment("Scores[1]", 3.2).append("Friends[0]", " Choudhary").increment("map.byte", 5.5).increment("map.short", 20000.2).delete("map.int").delete("map.long").setOrReplace("map.newfield", "THIS IS NEW").increment("map.LIST2[3][2]", (byte)120).append("binary3", buf).increment("NewField.field1.field2", 50000L);
        QueryCondition c = MapRDB.newCondition();
        c.and().is("Friends[0]", QueryCondition.Op.EQUAL, "Anurag").is("map.long", QueryCondition.Op.LESS, 5).close().build();
        boolean conditionSuccess = sharedStaticTable.checkAndMutate("CheckAndMutateKey", c, mutation);
        Assert.assertEquals((Object)false, (Object)conditionSuccess);
        r = sharedStaticTable.findById("CheckAndMutateKey");
        Assert.assertEquals((long)r.getInt("Scores[1]"), (long)20L);
        Assert.assertEquals((Object)r.getString("Friends[0]"), (Object)"Anurag");
        Assert.assertEquals((long)r.getByte("map.byte"), (long)100L);
        Assert.assertEquals((long)r.getShort("map.short"), (long)10000L);
        Assert.assertEquals((long)r.getLong("map.long"), (long)12345678999L);
        Assert.assertEquals((long)r.getInt("map.LIST2[3][2]"), (long)1500L);
        c = MapRDB.newCondition();
        c.and().is("Friends[0]", QueryCondition.Op.EQUAL, "Anurag").is("map.long", QueryCondition.Op.GREATER, 5).close().build();
        conditionSuccess = sharedStaticTable.checkAndMutate("CheckAndMutateKey", c, mutation);
        Assert.assertEquals((Object)true, (Object)conditionSuccess);
        r = sharedStaticTable.findById("CheckAndMutateKey");
        Assert.assertEquals((long)r.getInt("Scores[1]"), (long)23L);
        Assert.assertEquals((Object)r.getString("Friends[0]"), (Object)"Anurag Choudhary");
        Assert.assertEquals((long)r.getByte("map.byte"), (long)105L);
        Assert.assertEquals((long)r.getShort("map.short"), (long)30000L);
        Assert.assertEquals((Object)r.getValue("map.int"), null);
        Assert.assertEquals((Object)r.getValue("map.long"), null);
        Assert.assertEquals((Object)r.getString("map.newfield"), (Object)"THIS IS NEW");
        Assert.assertEquals((long)r.getInt("map.LIST2[3][2]"), (long)1620L);
        ByteBuffer b = r.getBinary("binary3");
        for (i = 0; i < 100; ++i) {
            Assert.assertEquals((long)b.get(i), (long)((byte)i));
        }
        for (i = 100; i < 5000; ++i) {
            Assert.assertEquals((long)b.get(i), (long)55L);
        }
        mutation = MapRDB.newMutation();
        mutation.increment("Scores[1]", 3.2).set("Friends[0]", "Bharat").increment("map.byte", 5000);
        c = MapRDB.newCondition();
        c.and().is("Friends[0]", QueryCondition.Op.EQUAL, "Anurag Choudhary").is("map.short", QueryCondition.Op.GREATER, 5000).close().build();
        conditionSuccess = sharedStaticTable.checkAndMutate("CheckAndMutateKey", c, mutation);
        Assert.assertEquals((Object)true, (Object)conditionSuccess);
        r = sharedStaticTable.findById("CheckAndMutateKey");
        Assert.assertEquals((long)r.getInt("Scores[1]"), (long)26L);
        Assert.assertEquals((Object)r.getString("Friends[0]"), (Object)"Bharat");
        Assert.assertEquals((long)r.getShort("map.short"), (long)30000L);
        Assert.assertEquals((Object)r.getValue("map.int"), null);
        Assert.assertEquals((Object)r.getValue("map.long"), null);
        Assert.assertEquals((Object)r.getString("map.newfield"), (Object)"THIS IS NEW");
        Assert.assertEquals((long)r.getInt("map.LIST2[3][2]"), (long)1620L);
        b = r.getBinary("binary3");
        for (i = 0; i < 100; ++i) {
            Assert.assertEquals((long)b.get(i), (long)((byte)i));
        }
        for (i = 100; i < 5000; ++i) {
            Assert.assertEquals((long)b.get(i), (long)55L);
        }
    }

    @Test
    public void checkAndDeleteTestBug19227() throws IOException {
        DBDocumentImpl r = new DBDocumentImpl().set("stairway_to_level1.stairway_to_level2.stairway_to_level3.stairway_to_level4.stairway_to_level5.stairway_to_level6.stairway_to_level7.stairway_to_level8.stairway_to_level9.stairway_to_level10.level10_a174_string.r1stringpath", "r1string");
        sharedStaticTable.insertOrReplace("CheckAndDeleteKey", (Document)r);
        r = sharedStaticTable.findById("CheckAndDeleteKey");
        Assert.assertEquals((Object)r.getString("stairway_to_level1.stairway_to_level2.stairway_to_level3.stairway_to_level4.stairway_to_level5.stairway_to_level6.stairway_to_level7.stairway_to_level8.stairway_to_level9.stairway_to_level10.level10_a174_string.r1stringpath"), (Object)"r1string");
        QueryCondition c = MapRDB.newCondition().is("stairway_to_level1.stairway_to_level2.stairway_to_level3.stairway_to_level4.stairway_to_level5.stairway_to_level6.stairway_to_level7.stairway_to_level8.stairway_to_level9.stairway_to_level10.level10_a174_string.r1stringpath", QueryCondition.Op.NOT_EQUAL, "r1string").build();
        boolean conditionSuccess = sharedStaticTable.checkAndDelete("CheckAndDeleteKey", c);
        Assert.assertEquals((Object)false, (Object)conditionSuccess);
        r = sharedStaticTable.findById("CheckAndDeleteKey");
        Assert.assertEquals((Object)r.getString("stairway_to_level1.stairway_to_level2.stairway_to_level3.stairway_to_level4.stairway_to_level5.stairway_to_level6.stairway_to_level7.stairway_to_level8.stairway_to_level9.stairway_to_level10.level10_a174_string.r1stringpath"), (Object)"r1string");
        conditionSuccess = sharedStaticTable.checkAndDelete("CheckAndDeleteKey1111", c);
        Assert.assertEquals((Object)false, (Object)conditionSuccess);
        r = sharedStaticTable.findById("CheckAndDeleteKey");
        Assert.assertEquals((Object)r.getString("stairway_to_level1.stairway_to_level2.stairway_to_level3.stairway_to_level4.stairway_to_level5.stairway_to_level6.stairway_to_level7.stairway_to_level8.stairway_to_level9.stairway_to_level10.level10_a174_string.r1stringpath"), (Object)"r1string");
        c = MapRDB.newCondition().is("stairway_to_level1.stairway_to_level2.stairway_to_level3.stairway_to_level4.stairway_to_level5.stairway_to_level6.stairway_to_level7.stairway_to_level8.stairway_to_level9.stairway_to_level10.level10_a174_string.r1stringpath", QueryCondition.Op.EQUAL, "r1string").build();
        conditionSuccess = sharedStaticTable.checkAndDelete("CheckAndDeleteKeyKKKK", c);
        Assert.assertEquals((Object)false, (Object)conditionSuccess);
        conditionSuccess = sharedStaticTable.checkAndDelete("CheckAndDeleteKey", c);
        Assert.assertEquals((Object)true, (Object)conditionSuccess);
        r = sharedStaticTable.findById("CheckAndDeleteKey");
        Assert.assertEquals(null, (Object)r);
    }

    @Test
    public void checkAndDeleteTest() throws IOException {
        Document r = TestMapRDBWithCluster.getMedRecord();
        sharedStaticTable.insertOrReplace("CheckAndDeleteKey", r);
        r = sharedStaticTable.findById("CheckAndDeleteKey");
        Assert.assertEquals((long)r.getInt("Scores[1]"), (long)20L);
        Assert.assertEquals((Object)r.getString("Friends[0]"), (Object)"Anurag");
        Assert.assertEquals((long)r.getByte("map.byte"), (long)100L);
        Assert.assertEquals((long)r.getShort("map.short"), (long)10000L);
        Assert.assertEquals((long)r.getLong("map.long"), (long)12345678999L);
        Assert.assertEquals((long)r.getInt("map.LIST2[3][2]"), (long)1500L);
        ByteBuffer buf = ByteBuffer.allocate(5000);
        for (int i = 0; i < 5000; ++i) {
            buf.put((byte)55);
        }
        QueryCondition c = MapRDB.newCondition();
        c.and().is("Friends[0]", QueryCondition.Op.EQUAL, "Anurag").is("map.long", QueryCondition.Op.LESS, 5).close().build();
        boolean conditionSuccess = sharedStaticTable.checkAndDelete("CheckAndDeleteKey", c);
        Assert.assertEquals((Object)false, (Object)conditionSuccess);
        r = sharedStaticTable.findById("CheckAndDeleteKey");
        Assert.assertEquals((long)r.getInt("Scores[1]"), (long)20L);
        Assert.assertEquals((Object)r.getString("Friends[0]"), (Object)"Anurag");
        Assert.assertEquals((long)r.getByte("map.byte"), (long)100L);
        Assert.assertEquals((long)r.getShort("map.short"), (long)10000L);
        Assert.assertEquals((long)r.getLong("map.long"), (long)12345678999L);
        Assert.assertEquals((long)r.getInt("map.LIST2[3][2]"), (long)1500L);
        c = MapRDB.newCondition();
        c.and().is("Friends[0]", QueryCondition.Op.EQUAL, "Anurag").is("map.long", QueryCondition.Op.GREATER, 5).close().build();
        conditionSuccess = sharedStaticTable.checkAndDelete("CheckAndDeleteKey", c);
        Assert.assertEquals((Object)true, (Object)conditionSuccess);
        r = sharedStaticTable.findById("CheckAndDeleteKey");
        Assert.assertEquals((Object)r, null);
    }

    @Test
    public void checkAndReplaceTest() throws IOException {
        Document r = MapRDB.newDocument().set("seq", 100).setArray("array", new int[]{1, 2, 3});
        sharedStaticTable.insertOrReplace("CheckAndReplaceKey", r);
        sharedStaticTable.flush();
        QueryCondition c = MapRDB.newCondition().is("seq", QueryCondition.Op.EQUAL, 100).build();
        r = MapRDB.newDocument().set("seq", 101).setArray("array", new int[]{3, 4, 5});
        boolean conditionSuccess = sharedStaticTable.checkAndReplace("CheckAndReplaceKey", c, r);
        Assert.assertEquals((Object)true, (Object)conditionSuccess);
        r = sharedStaticTable.findById("CheckAndReplaceKey");
        Assert.assertEquals((long)r.getInt("array[1]"), (long)4L);
        r = TestMapRDBWithCluster.getMedRecord();
        sharedStaticTable.insertOrReplace("CheckAndReplaceKey", r);
        r = sharedStaticTable.findById("CheckAndReplaceKey");
        Assert.assertEquals((long)r.getInt("Scores[1]"), (long)20L);
        Assert.assertEquals((Object)r.getString("Friends[0]"), (Object)"Anurag");
        Assert.assertEquals((long)r.getByte("map.byte"), (long)100L);
        Assert.assertEquals((long)r.getShort("map.short"), (long)10000L);
        Assert.assertEquals((long)r.getLong("map.long"), (long)12345678999L);
        Assert.assertEquals((long)r.getInt("map.LIST2[3][2]"), (long)1500L);
        ByteBuffer buf = ByteBuffer.allocate(5000);
        for (int i = 0; i < 5000; ++i) {
            buf.put((byte)55);
        }
        Document newRecord = MapRDB.newDocument();
        newRecord.set("user", "bill").set("address", "mountain view");
        c = MapRDB.newCondition();
        c.and().is("Friends[0]", QueryCondition.Op.EQUAL, "Anurag").is("map.long", QueryCondition.Op.LESS, 5).close().build();
        conditionSuccess = sharedStaticTable.checkAndReplace("CheckAndReplaceKey", c, newRecord);
        Assert.assertEquals((Object)false, (Object)conditionSuccess);
        r = sharedStaticTable.findById("CheckAndReplaceKey");
        Assert.assertEquals((long)r.getInt("Scores[1]"), (long)20L);
        Assert.assertEquals((Object)r.getString("Friends[0]"), (Object)"Anurag");
        Assert.assertEquals((long)r.getByte("map.byte"), (long)100L);
        Assert.assertEquals((long)r.getShort("map.short"), (long)10000L);
        Assert.assertEquals((long)r.getLong("map.long"), (long)12345678999L);
        Assert.assertEquals((long)r.getInt("map.LIST2[3][2]"), (long)1500L);
        c = MapRDB.newCondition();
        c.and().is("Friends[0]", QueryCondition.Op.EQUAL, "Anurag").is("map.long", QueryCondition.Op.GREATER, 5).close().build();
        conditionSuccess = sharedStaticTable.checkAndReplace("CheckAndReplaceKey", c, newRecord);
        Assert.assertEquals((Object)true, (Object)conditionSuccess);
        r = sharedStaticTable.findById("CheckAndReplaceKey");
        Assert.assertEquals((Object)r.getString("user"), (Object)"bill");
        Assert.assertEquals((Object)r.getString("address"), (Object)"mountain view");
    }

    @Test
    public void streamTests() throws IOException {
        this.putRecords();
        DocumentStream rs = sharedStaticTable.find();
        int count = 0;
        Iterator itrs = rs.iterator();
        while (itrs.hasNext()) {
            itrs.next();
            ++count;
        }
        int init_count = count;
        Assert.assertTrue((init_count != 0 ? 1 : 0) != 0);
        rs = sharedStaticTable.find();
        sharedStaticTable.insertOrReplace(rs);
        rs = sharedStaticTable.find();
        itrs = rs.iterator();
        count = 0;
        while (itrs.hasNext()) {
            itrs.next();
            ++count;
        }
        Assert.assertEquals((long)init_count, (long)count);
        ((MapRDBTableImpl)TestMapRDBWithCluster.sharedStaticTable).testMulitOpExIdx = 4;
        rs = sharedStaticTable.find();
        try {
            sharedStaticTable.insertOrReplace(rs);
        }
        catch (MultiOpException mope) {
            Iterator failedRecItr = mope.iterator();
            while (failedRecItr.hasNext()) {
                FailedOp frec = (FailedOp)failedRecItr.next();
                Document rec = frec.getDocument();
                Exception exc = frec.getException();
                _logger.info("Got failed record: key=" + ((DBDocumentImpl)rec).getIdAsString() + ", msg='" + exc.getMessage() + "'");
            }
            count = 0;
            itrs = rs.iterator();
            while (itrs.hasNext()) {
                itrs.next();
                ++count;
            }
            Assert.assertEquals((long)(init_count - 8), (long)count);
        }
        ((MapRDBTableImpl)TestMapRDBWithCluster.sharedStaticTable).testMulitOpExIdx = 0;
        Document putRec = TestMapRDBWithCluster.getMedRecord();
        sharedStaticTable.insert("KEYb1", putRec);
        Document readRecord1 = sharedStaticTable.findById("KEYb1");
        Assert.assertNotNull((Object)readRecord1);
        try {
            sharedStaticTable.insert("KEYb", putRec);
            Assert.fail((String)"Should get error that KEYb already exists.");
        }
        catch (DocumentExistsException documentExistsException) {
            // empty catch block
        }
        readRecord1 = sharedStaticTable.findById("KEYb");
        Assert.assertNotNull((Object)readRecord1);
        putRec.set("month", "may");
        sharedStaticTable.replace("KEYa", putRec);
        readRecord1 = sharedStaticTable.findById("KEYa", new String[]{"month"});
        Assert.assertNotNull((Object)readRecord1);
        rs = sharedStaticTable.find();
        sharedStaticTable.insert(rs);
        count = 0;
        rs = sharedStaticTable.find();
        itrs = rs.iterator();
        while (itrs.hasNext()) {
            itrs.next();
            ++count;
        }
        Assert.assertEquals((long)(init_count + 1), (long)count);
        rs = sharedStaticTable.find();
        sharedStaticTable.replace(rs);
        count = 0;
        rs = sharedStaticTable.find();
        itrs = rs.iterator();
        while (itrs.hasNext()) {
            itrs.next();
            ++count;
        }
        Assert.assertEquals((long)(init_count + 1), (long)count);
        rs = sharedStaticTable.find();
        sharedStaticTable.delete(rs);
        count = 0;
        rs = sharedStaticTable.find();
        itrs = rs.iterator();
        while (itrs.hasNext()) {
            itrs.next();
            ++count;
        }
        Assert.assertEquals((long)0L, (long)count);
        _logger.info("Streaming API tests completed.");
    }

    @Test
    public void projectionTest() throws IOException, Exception {
        String PROJ_TEST_TABLE_NAME = "/tmp/testtable-TestMapRDBWithCluster-ProjectionTest";
        Table table = null;
        DBTests.admin().deleteTable("/tmp/testtable-TestMapRDBWithCluster-ProjectionTest");
        table = MapRDB.createTable((String)"/tmp/testtable-TestMapRDBWithCluster-ProjectionTest");
        table.setOption(Table.TableOption.BUFFERWRITE, false);
        DBDocumentImpl rec = new DBDocumentImpl().set("a", "val-a").set("b.a", "val-b.a").set("b.b.a", "val-b.b.a").set("b.b.b.a", "val-b.b.b.a");
        table.insert("row-1", (Document)rec);
        table.flush();
        QueryCondition c = MapRDB.newCondition().is("b.b.b.a", QueryCondition.Op.EQUAL, "val-b.b.b.a").build();
        Document d = table.findById("row-1", c, new String[]{"a", "b.a", "b.b.a"});
        Assert.assertEquals((Object)"row-1", (Object)((DBDocumentImpl)d).getIdAsString());
        Assert.assertEquals((Object)"val-a", (Object)d.getString("a"));
        Assert.assertEquals((Object)"val-b.a", (Object)d.getString("b.a"));
        Assert.assertEquals((Object)"val-b.b.a", (Object)d.getString("b.b.a"));
        Assert.assertNull((Object)d.getString("b.b.b.a"));
        c = MapRDB.newCondition().exists("b.b").build();
        d = table.findById("row-1", c, new String[]{"b.b.b.a"});
        Assert.assertEquals((Object)"row-1", (Object)((DBDocumentImpl)d).getIdAsString());
        Assert.assertNull((Object)d.getString("a"));
        Assert.assertNull((Object)d.getString("b.a"));
        Assert.assertNull((Object)d.getString("b.b.a"));
        Assert.assertEquals((Object)"val-b.b.b.a", (Object)d.getString("b.b.b.a"));
    }

    @Test
    public void excepTests() throws IOException, Exception {
        DBDocumentImpl putRec;
        String EXCEP_TABLE_NAME = "/tmp/testtable-TestMapRDBWithCluster1";
        Table table = null;
        try {
            table = MapRDB.createTable((String)"/tmp/testtable-TestMapRDBWithCluster1");
            table.setOption(Table.TableOption.BUFFERWRITE, false);
            table = MapRDB.createTable((String)"/tmp/testtable-TestMapRDBWithCluster1");
            Assert.fail((String)"No TableExistsException!");
        }
        catch (TableExistsException e) {
            _logger.info("TableExistsException - done");
            table.close();
            DBTests.admin().deleteTable("/tmp/testtable-TestMapRDBWithCluster1");
        }
        Assert.assertFalse((boolean)DBTests.admin().deleteTable("/tmp/testtable-TestMapRDBWithCluster1"));
        try {
            table = MapRDB.createTable((String)"/tmp/testtable-TestMapRDBWithCluster1");
            table.setOption(Table.TableOption.BUFFERWRITE, false);
            table.close();
            DBTests.admin().deleteTable("/tmp/testtable-TestMapRDBWithCluster1");
            table.findById("KEY1");
            Assert.fail((String)"No TableNotFoundException for get!");
        }
        catch (TableNotFoundException e) {
            _logger.info("TableNotFoundException for get - done");
        }
        catch (TableClosedException e) {
            _logger.info("TableNotFoundException for get - done");
        }
        try {
            table = MapRDB.createTable((String)"/tmp/testtable-TestMapRDBWithCluster1");
            table.setOption(Table.TableOption.BUFFERWRITE, false);
            table.close();
            DBTests.admin().deleteTable("/tmp/testtable-TestMapRDBWithCluster1");
            DocumentStream rs = table.find();
            Iterator itrs = rs.iterator();
            while (itrs.hasNext()) {
                itrs.next();
            }
            Assert.fail((String)"No TableNotFoundException for scan!");
        }
        catch (TableNotFoundException e) {
            _logger.info("TableNotFoundException for scan - done");
        }
        catch (TableClosedException e) {
            _logger.info("TableNotFoundException for scan - done");
        }
        QueryCondition c = MapRDB.newCondition().is("map.long", QueryCondition.Op.LESS, 5).build();
        DocumentMutation m = MapRDB.newMutation().increment("Scores[1]", 3);
        try {
            table = MapRDB.createTable((String)"/tmp/testtable-TestMapRDBWithCluster1");
            table.setOption(Table.TableOption.BUFFERWRITE, false);
            table.close();
            DBTests.admin().deleteTable("/tmp/testtable-TestMapRDBWithCluster1");
            putRec = new DBDocumentImpl();
            putRec.set("onlyone", 1);
            table.checkAndMutate("OO1", c, m);
            Assert.fail((String)"No TableNotFoundException for CaM!");
        }
        catch (TableNotFoundException e) {
            _logger.info("TableNotFoundException for CheckAndMutate - done");
        }
        catch (TableClosedException e) {
            _logger.info("TableNotFoundException for CheckAndMutate - done");
        }
        try {
            table = MapRDB.createTable((String)"/tmp/testtable-TestMapRDBWithCluster1");
            table.setOption(Table.TableOption.BUFFERWRITE, false);
            table.close();
            DBTests.admin().deleteTable("/tmp/testtable-TestMapRDBWithCluster1");
            putRec = new DBDocumentImpl();
            putRec.set("onlyone", 1);
            table.insertOrReplace("OO", (Document)putRec);
            Assert.fail((String)"No TableNotFoundException for put!");
        }
        catch (TableNotFoundException e) {
            _logger.info("TableNotFoundException for put - done");
        }
        catch (TableClosedException e) {
            _logger.info("TableNotFoundException for put - done");
        }
    }

    public static Document getMedRecord() {
        DBDocumentImpl rec = new DBDocumentImpl();
        rec.setArray("Scores", new int[]{10, 20, 30}).setArray("Friends", new Object[]{"Anurag", "Bharat", new Integer(10)}).set("map.boolean", true).set("map.string", "string").set("map.byte", (byte)100).set("map.short", (short)10000).set("map.int", 50000).set("map.long", 12345678999L).set("map.float", 10.1234f).set("map.double", 10.1234567891).setArray("map.Array2", new Object[]{new Double("-2321232.1234312"), new Long(-50000L), new Integer(10)}).setNull("NULL");
        ByteBuffer bbuf = ByteBuffer.allocate(100);
        for (int i = 0; i < bbuf.capacity(); ++i) {
            bbuf.put((byte)i);
        }
        bbuf.rewind();
        rec.set("binary3", bbuf).set("Time", new OTime(10000000L)).set("Date", new ODate(432000000L));
        rec.set("boolean", false);
        rec.set("string", "stringstrinstringstring");
        rec.set("byte", (byte)100);
        values = new ArrayList<Object>();
        values.add("Field1");
        values.add(new Integer(500));
        values.add(new Double(5555.5555));
        rec.set("map.LIST", values);
        ArrayList<Object> values2 = new ArrayList<Object>();
        values2.add("Field1");
        values2.add(new Integer(500));
        values2.add(new Double(5555.5555));
        values2.add(new int[]{500, 1000, 1500, 2000});
        rec.set("map.LIST2", values2);
        rec.set("NAME", "ANURAG");
        boolean[] ba = new boolean[]{false, true, true};
        rec.setArray("map.boolarray", ba);
        return rec;
    }

    @Test
    public void put513() throws IOException {
        int[] ia = new int[513];
        for (int i = 0; i < 513; ++i) {
            ia[i] = i;
        }
        Document rec = new DBDocumentImpl().setArray("513array", ia);
        sharedStaticTable.insertOrReplace("put513", rec);
        Document readRecordi = sharedStaticTable.findById("put513");
        sharedStaticTable.delete("put513");
        List a = readRecordi.getList("513array");
        Assert.assertNotNull((Object)a);
        Assert.assertEquals((Object)1, a.get(1));
        Assert.assertEquals((Object)512, a.get(512));
        Assert.assertEquals((Object)0, a.get(0));
    }

    @Test
    public void putLargeArrayField() throws IOException {
        String key = "largeArrayField";
        DBDocumentImpl rec = new DBDocumentImpl();
        rec.set("Segment[0][1][2][3][4][5][6][7][8][9][10][11][12][13][14][15][16][17]", 100);
        sharedStaticTable.insertOrReplace(key, (Document)rec);
        sharedStaticTable.flush();
        Document readRecord = sharedStaticTable.findById(key);
        Assert.assertEquals((long)100L, (long)readRecord.getInt("Segment[0][1][2][3][4][5][6][7][8][9][10][11][12][13][14][15][16][17]"));
    }

    @Test
    public void testBinaryIdOps() throws IOException {
        Document r1 = MapRDB.newDocument().set("short", (short)30);
        byte[] byts = new byte[]{65, 66, 67, 68, 69};
        ByteBuffer robb = ByteBuffer.wrap(byts).asReadOnlyBuffer();
        sharedStaticTable.insertOrReplace(robb, r1);
        try {
            DocumentStream rs = sharedStaticTable.find();
            Iterator itrs = rs.iterator();
            boolean has = rs.iterator().hasNext();
            Assert.fail((String)"Should have reported error multiple iters on stream.");
        }
        catch (StreamInUseException rs) {
            // empty catch block
        }
        byte[] bytes = "binaryId".getBytes(Charsets.UTF_8);
        ByteBuffer bb = (ByteBuffer)ByteBufs.wrap((byte[])bytes).rewind();
        sharedStaticTable.insertOrReplace(bb, r1);
        sharedStaticTable.increment(bb, "short", (short)5);
        Document r = sharedStaticTable.findById(bb);
        Assert.assertNotNull((Object)r);
        Assert.assertEquals((long)35L, (long)r.getShort("short"));
        sharedStaticTable.delete(bb);
        r1 = MapRDB.newDocument().set("short", (short)30).set("_id", "abc");
        try {
            sharedStaticTable.insertOrReplace("binaryId", r1);
            Assert.fail((String)"Should have reported error for mismatched '_id' values.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        r = sharedStaticTable.findById("binaryId");
        Assert.assertNull((Object)r);
        r1 = MapRDB.newDocument().set("short", (short)30).set("_id", "binaryId");
        try {
            sharedStaticTable.insertOrReplace("binaryId", r1);
        }
        catch (IllegalArgumentException ie) {
            Assert.fail((String)"Should not report error for matching '_id' values.");
        }
        r = sharedStaticTable.findById("binaryId");
        Assert.assertNotNull((Object)r);
        sharedStaticTable.delete("binaryId");
        try {
            String id = this.randomAlphanumeric(100000);
            sharedStaticTable.insertOrReplace(id, r1);
            sharedStaticTable.flush();
            Assert.fail((String)"No IllegalArgumentException for large row key!");
        }
        catch (IllegalArgumentException iae) {
            _logger.info("32K rowkey size check - done");
        }
    }

    @Ignore
    public void testUseField() throws IOException, Exception {
        String OrderTable = "useField-TestMapRDBWithCluster";
        Table orderTable = null;
        orderTable = DBTests.createOrReplaceTable(OrderTable);
        orderTable.setOption(Table.TableOption.BUFFERWRITE, false);
        orderTable.setOption(Table.TableOption.EXCLUDEID, true);
        for (int i = 0; i < 1; ++i) {
            DBDocumentImpl doc = new DBDocumentImpl().set("abc", "aaa").set("int", Integer.toString(i));
            orderTable.insertOrReplace("KEY" + i, (Document)doc);
        }
        Table useTable = DBTests.createOrReplaceTable(OrderTable + 1);
        useTable.setOption(Table.TableOption.BUFFERWRITE, false);
        useTable.setOption(Table.TableOption.EXCLUDEID, true);
        DocumentStream ds = orderTable.find();
        try {
            useTable.insertOrReplace(ds, "int");
            Assert.fail((String)"Expected IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        orderTable.close();
        DBTests.deleteTables(OrderTable);
        useTable.close();
        DBTests.deleteTables(OrderTable + 1);
    }

    private String getDeepField(int depth) {
        String field = "";
        int start = depth % 5;
        int count = 0;
        boolean rev = (int)Math.random() % 22 < 10;
        for (int i = start; i < (start + depth) % 26; ++i) {
            int idx = (i + (int)Math.random()) % 26;
            field = count == 0 ? field + this.alphabet.charAt(rev ? 25 - idx : idx) : field + "." + this.alphabet.charAt(rev ? idx : 25 - idx);
            ++count;
        }
        if (field.equals("")) {
            field = "z.y.u." + (depth + (int)Math.random() % 111);
        }
        return field;
    }

    @Test
    public void testRowIndexOrderDeepDocs() throws IOException {
        String riTabName = "ri3-TestMapRDBWithCluster";
        Table riTable = DBTests.createOrReplaceTable(riTabName);
        riTable.setOption(Table.TableOption.BUFFERWRITE, false);
        riTable.setOption(Table.TableOption.EXCLUDEID, true);
        DBDocumentImpl rec = new DBDocumentImpl();
        String bigStr = "";
        for (int j = 0; j < 65536; ++j) {
            bigStr = bigStr + "s";
        }
        String[] fields = new String[100];
        for (int i = 0; i < 100; ++i) {
            String field;
            fields[i] = field = this.getDeepField((i + (int)Math.random()) % 26);
            rec.set(field, bigStr);
        }
        riTable.insertOrReplace("KEYRI", (Document)rec);
        riTable.flush();
        try {
            Thread.sleep(9000L);
        }
        catch (InterruptedException i) {
            // empty catch block
        }
        Document readRecordi = riTable.findById("KEYRI", new String[]{fields[0], fields[20], fields[21], fields[30], fields[31], fields[50], fields[99]});
        Assert.assertEquals((long)readRecordi.size(), (long)3L);
        riTable.close();
        DBTests.deleteTables(riTabName);
    }

    @Test
    public void testRowIndexOrder() throws IOException {
        String riTabName = "ri2-TestMapRDBWithCluster";
        Table riTable = DBTests.createOrReplaceTable(riTabName);
        riTable.setOption(Table.TableOption.BUFFERWRITE, false);
        riTable.setOption(Table.TableOption.EXCLUDEID, true);
        DBDocumentImpl rec = new DBDocumentImpl();
        String bigStr = "";
        for (int j = 0; j < 65536; ++j) {
            bigStr = bigStr + "s";
        }
        rec.set("z", bigStr).set("q", bigStr).set("m", bigStr).set("d", bigStr).set("e", bigStr).set("a", bigStr).set("r", bigStr);
        riTable.insertOrReplace("KEYRI", (Document)rec);
        riTable.flush();
        try {
            Thread.sleep(9000L);
        }
        catch (InterruptedException j) {
            // empty catch block
        }
        Document readRecordi = riTable.findById("KEYRI", new String[]{"r", "a", "d", "z"});
        int ai = ((DBDocumentImpl)readRecordi).getIndex("a");
        int ri = ((DBDocumentImpl)readRecordi).getIndex("r");
        int di = ((DBDocumentImpl)readRecordi).getIndex("d");
        int zi = ((DBDocumentImpl)readRecordi).getIndex("z");
        Assert.assertEquals((long)0L, (long)zi);
        Assert.assertEquals((long)1L, (long)di);
        Assert.assertEquals((long)2L, (long)ai);
        Assert.assertEquals((long)3L, (long)ri);
        riTable.close();
        DBTests.deleteTables(riTabName);
    }

    @Test
    public void testRowIndex() throws IOException {
        int j;
        String riTabName = "ri-TestMapRDBWithCluster";
        Table riTable = DBTests.createOrReplaceTable(riTabName);
        riTable.setOption(Table.TableOption.BUFFERWRITE, false);
        riTable.setOption(Table.TableOption.EXCLUDEID, true);
        DBDocumentImpl rec = new DBDocumentImpl();
        String bigStr = "";
        for (j = 0; j < 1000; ++j) {
            bigStr = bigStr + "string";
        }
        for (j = 0; j < 2500; ++j) {
            rec.set("Scores" + j, 1020304050607080L + (long)j).set("Friends", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz").set("map.boolean", false).set("map.string", "string").set("map.byte", (byte)100).set("map.short", (short)10000).set("map.int", 50000).set("map.long", 12345678999L).set("map.float", 10.1234f).set("map.double", 10.1234567891).set("map.Array2", "000000000.11111111111111111111avbdfgsderwe");
            ByteBuffer bbuf = ByteBuffer.allocate(1000);
            for (int i = 0; i < bbuf.capacity(); ++i) {
                bbuf.put((byte)i);
            }
            ArrayList<Object> values = new ArrayList<Object>();
            values.add("Field1");
            values.add(new Integer(500));
            values.add(new Double(5555.5555));
            ArrayList<Object> values2 = new ArrayList<Object>();
            values2.add("Field1");
            values2.add(new Integer(500));
            values2.add(new Double(5555.5555));
            values2.add(new int[]{500, 1000, 1500, 2000});
            bbuf.rewind();
            rec.set("binary3", bbuf).set("Time", new OTime(10000000L)).set("Date", new ODate(432000000L)).set("boolean", false).set("string", bigStr).set("byte", (byte)100).set("map.LIST", "values").set("map.LIST2", 500100015002000L).set("NAME" + j, "A" + j).setArray("ScoresA" + j, new int[]{10, 20, 30, 40, 50, 60}).setArray("FriendsA", new Object[]{"AA", "BB", "CC", "DD", new Integer(10)}).set("mapA.LIST", values).set("mapA.LIST2", values2);
        }
        riTable.insertOrReplace("KEYRI", (Document)rec);
        riTable.flush();
        try {
            Thread.sleep(9000L);
        }
        catch (InterruptedException j2) {
            // empty catch block
        }
        this.condition = MapRDB.newCondition().is("byte", QueryCondition.Op.EQUAL, (byte)100).build();
        Document readRecord1 = riTable.findById("KEYRI", this.condition, new String[]{"booleAAn", "FriendsA", "boolean", "Scores18", "byte", "Scores12", "Scores33", "NAME31", "NAME14", "NAME42", "Scores44", "map.LIST2", "ScoresA18", "ScoresA22[1]", "mapA.LIST2[1]"});
        Assert.assertNotNull((Object)readRecord1);
        Assert.assertEquals((long)readRecord1.getLong("Scores18"), (long)1020304050607098L);
        Assert.assertEquals((long)readRecord1.getLong("Scores12"), (long)1020304050607092L);
        Assert.assertEquals((long)readRecord1.getLong("Scores33"), (long)1020304050607113L);
        Assert.assertEquals((Object)readRecord1.getString("NAME42"), (Object)"A42");
        Assert.assertEquals((long)readRecord1.getLong("map.LIST2"), (long)500100015002000L);
        Assert.assertNull((Object)readRecord1.getValue("NAME4"));
        Assert.assertNull((Object)readRecord1.getValue("Scores11"));
        Assert.assertNotNull((Object)readRecord1.getList("mapA.LIST2"));
        Assert.assertNull((Object)readRecord1.getValue("NAME4"));
        List s18 = readRecord1.getList("ScoresA18");
        Assert.assertNotNull((Object)s18);
        Assert.assertEquals((Object)10, s18.get(0));
        Assert.assertEquals((Object)20, s18.get(1));
        Assert.assertEquals((Object)30, s18.get(2));
        Assert.assertNull((Object)readRecord1.getList("ScoresA17"));
        Assert.assertNotNull((Object)readRecord1.getList("FriendsA"));
        Assert.assertEquals((long)100L, (long)readRecord1.getByte("byte"));
        Assert.assertEquals((Object)"A14", (Object)readRecord1.getString("NAME14"));
        Assert.assertNull((Object)readRecord1.getString("NAME30"));
        riTable.close();
        DBTests.deleteTables(riTabName);
    }

    private String randomAlphanumeric(int size) {
        String ret = "";
        for (int i = 0; i < size; ++i) {
            ret = ret + i;
        }
        return ret;
    }

    @Test
    public void testCheckAndReplaceMCF() throws IOException, Exception {
        String capmcfName = "cApMCF-TestMapRDBWithCluster";
        Table capmcfTable = null;
        String field1 = "x.y.z";
        String field2 = "a.b.c.d.e";
        if (DBTests.admin().tableExists(capmcfName)) {
            DBTests.admin().deleteTable(capmcfName);
        }
        HashMap<String, String> cfNamePaths = new HashMap<String, String>();
        cfNamePaths.put("cf1", field1);
        cfNamePaths.put("cf2", field2);
        capmcfTable = DBTests.createOrReplaceTable(capmcfName, cfNamePaths);
        capmcfTable.setOption(Table.TableOption.BUFFERWRITE, false);
        capmcfTable.setOption(Table.TableOption.EXCLUDEID, true);
        Document subRecord = MapRDB.newDocument().set("c", MapRDB.newDocument().set("d", MapRDB.newDocument().set("e", 1024)).set("f", "a.b.c")).set("g", "a.b");
        Document record1 = MapRDB.newDocument().set("a", MapRDB.newDocument().set("b", subRecord).set("h", "a")).set("i", "root");
        capmcfTable.insertOrReplace("record1", record1);
        _logger.debug("Found record: {}", (Object)capmcfTable.findById("record1"));
        QueryCondition condition = MapRDB.newCondition().and().notExists("x.y.z").is("a.b.c.d.e", QueryCondition.Op.NOT_EQUAL, 1023).close().build();
        Document newRecord = MapRDB.newDocument().set("x.y.z", "x.y");
        Assert.assertTrue((boolean)capmcfTable.checkAndReplace("record1", condition, newRecord));
        capmcfTable.close();
        DBTests.admin().deleteTable(capmcfName);
    }

    @Test
    public void testInsOrderWithMutDelete() throws IOException, Exception {
        String OrderTable = "orderWMD-TestMapRDBWithCluster";
        Table orderTable = null;
        orderTable = DBTests.createOrReplaceTable(OrderTable);
        orderTable.setOption(Table.TableOption.BUFFERWRITE, false);
        orderTable.setOption(Table.TableOption.EXCLUDEID, true);
        Document readRecordi = null;
        DBDocumentImpl putRec = new DBDocumentImpl().set("n", (short)1).set("m", (short)2).set("q", (short)3).set("a", (short)7);
        orderTable.insertOrReplace("orderIns", (Document)putRec);
        readRecordi = orderTable.findById("orderIns");
        Assert.assertNotNull((Object)readRecordi);
        DocumentMutation m = MapRDB.newMutation().set("j", (short)101).delete("a");
        orderTable.update("orderIns", m);
        readRecordi = orderTable.findById("orderIns");
        orderTable.close();
        DBTests.deleteTables(OrderTable);
    }

    @Test
    public void testInsertionOrderMCF() throws IOException, Exception {
        String OrderTable = "order-TestMapRDBWithClusterMCF";
        Table orderTable = null;
        LinkedHashMap<String, String> cfPath = new LinkedHashMap<String, String>();
        cfPath.put("cf1", "a.b");
        cfPath.put("cf2", "`l1`");
        cfPath.put("cf3", "l1.`l2`");
        orderTable = DBTests.createOrReplaceTable(OrderTable, cfPath);
        orderTable.setOption(Table.TableOption.BUFFERWRITE, false);
        orderTable.setOption(Table.TableOption.EXCLUDEID, true);
        Document readRecordi = null;
        DBDocumentImpl putRec = new DBDocumentImpl().set("a.b", (short)1).set("l1.b1", (short)2).set("l1.l2.b2", (short)3);
        orderTable.insertOrReplace("orderIns", (Document)putRec);
        readRecordi = orderTable.findById("orderIns");
        Assert.assertNotNull((Object)readRecordi);
        int abi = ((DBDocumentImpl)readRecordi).getIndex("a.b");
        int lbi = ((DBDocumentImpl)readRecordi).getIndex("l1.b1");
        int lli = ((DBDocumentImpl)readRecordi).getIndex("l1.l2");
        Assert.assertEquals((long)0L, (long)abi);
        Assert.assertEquals((long)0L, (long)lbi);
        Assert.assertEquals((long)1L, (long)lli);
        orderTable.close();
        DBTests.deleteTables(OrderTable);
    }

    @Test
    public void testInsOrderWithNestedMCF() throws IOException, Exception {
        String OrderTable = "orderWMDMCF-TestMapRDBWithCluster";
        Table orderTable = null;
        LinkedHashMap<String, String> cfPath = new LinkedHashMap<String, String>();
        cfPath.put("cf1", "a.b");
        cfPath.put("cf2", "a.b.c");
        orderTable = DBTests.createOrReplaceTable(OrderTable, cfPath);
        orderTable.setOption(Table.TableOption.BUFFERWRITE, false);
        orderTable.setOption(Table.TableOption.EXCLUDEID, true);
        Document readRecordi = null;
        Document putRec = MapRDB.newDocument().set("a", MapRDB.newDocument().set("b", MapRDB.newDocument().set("e", "a.b.e").set("d", "a.b.d").set("c", "a.b.c")).set("e", "a.e")).set("g", "g");
        orderTable.insertOrReplace("orderIns", putRec);
        readRecordi = orderTable.findById("orderIns");
        int di = ((DBDocumentImpl)readRecordi).getIndex("a.b.d");
        int ei = ((DBDocumentImpl)readRecordi).getIndex("a.b.e");
        int ci = ((DBDocumentImpl)readRecordi).getIndex("a.b.c");
        Assert.assertEquals((long)0L, (long)ei);
        Assert.assertEquals((long)1L, (long)di);
        Assert.assertEquals((long)2L, (long)ci);
        orderTable.close();
        DBTests.deleteTables(OrderTable);
    }

    @Test
    public void testInsOrderWithMutDeleteMCF() throws IOException, Exception {
        String OrderTable = "orderWMDMCF-TestMapRDBWithCluster";
        Table orderTable = null;
        LinkedHashMap<String, String> cfPath = new LinkedHashMap<String, String>();
        cfPath.put("cf1", "a.b");
        orderTable = DBTests.createOrReplaceTable(OrderTable, cfPath);
        orderTable.setOption(Table.TableOption.BUFFERWRITE, false);
        orderTable.setOption(Table.TableOption.EXCLUDEID, true);
        Document readRecordi = null;
        Document subRecord = MapRDB.newDocument().set("c", MapRDB.newDocument().set("d", MapRDB.newDocument().set("e", "a.b.c.d")).set("f", "a.b.c")).set("g", "a.b");
        Document putRec = MapRDB.newDocument().set("a", MapRDB.newDocument().set("b", subRecord).set("h", "a")).set("i", "root");
        orderTable.insertOrReplace("orderIns", putRec);
        String deleteField1 = "a.b.c.d";
        String deleteField2 = "a.b.c.f";
        DocumentMutation m = MapRDB.newMutation().delete(deleteField1).delete(deleteField2);
        orderTable.update("orderIns", m);
        readRecordi = orderTable.findById("orderIns");
        DocumentMutation sm = MapRDB.newMutation().setOrReplace(deleteField1, (Map)MapRDB.newDocument().set("e", "a.b.c.d new")).setOrReplace(deleteField2, "a.b.c new");
        orderTable.update("orderIns", sm);
        readRecordi = orderTable.findById("orderIns");
        orderTable.close();
        DBTests.deleteTables(OrderTable);
    }

    @Test
    public void testInsO() throws IOException, Exception {
        String OrderTable = "order-TestMapRDBWithCluster";
        Table orderTable = null;
        orderTable = DBTests.createOrReplaceTable(OrderTable);
        orderTable.setOption(Table.TableOption.BUFFERWRITE, false);
        orderTable.setOption(Table.TableOption.EXCLUDEID, true);
        DBDocumentImpl putRec = new DBDocumentImpl().set("a", (short)100).set("z.a", (short)1).set("z.z", (short)2).set("z.x", (short)3).set("z.l", (short)4);
        orderTable.insertOrReplace("orderIns", (Document)putRec);
        DocumentMutation m = MapRDB.newMutation().setOrReplace("a", "string").set("z.x", (short)999);
        orderTable.update("orderIns", m);
        Document readRecordi = orderTable.findById("orderIns");
        int mzxi = ((DBDocumentImpl)readRecordi).getIndex("z.x");
        Assert.assertEquals((long)3L, (long)mzxi);
        orderTable.close();
        DBTests.deleteTables(OrderTable);
    }

    @Test
    public void testInsertionOrder() throws IOException, Exception {
        String OrderTable = "order-TestMapRDBWithCluster";
        Table orderTable = null;
        orderTable = DBTests.createOrReplaceTable(OrderTable);
        orderTable.setOption(Table.TableOption.BUFFERWRITE, false);
        orderTable.setOption(Table.TableOption.EXCLUDEID, true);
        DBDocumentImpl mDoc = new DBDocumentImpl().set("ma", "mma");
        Document readRecordi = null;
        Document putRec = new DBDocumentImpl().set("n", (short)1).set("m", (short)2).set("q", (short)3).set("d", (short)4).set("c", (short)5).set("b", (short)6).set("a", (short)7).setArray("g.arr", new Object[]{Arrays.asList(0)}).set("f", (short)111).set("jj", (Document)mDoc).set("z.a", (short)1).set("z.z", (short)2).set("z.x", (short)3).set("z.l", (short)4).set("z.q.n", (short)1).set("z.q.m", (short)2);
        orderTable.insertOrReplace("orderIns", putRec);
        readRecordi = orderTable.findById("orderIns");
        Assert.assertNotNull((Object)readRecordi);
        Assert.assertEquals((long)5L, (long)readRecordi.getShort("c"));
        Assert.assertEquals((long)3L, (long)readRecordi.getShort("z.x"));
        Assert.assertEquals((long)1L, (long)readRecordi.getShort("z.q.n"));
        Assert.assertEquals((long)2L, (long)readRecordi.getShort("z.q.m"));
        Assert.assertEquals((long)4L, (long)readRecordi.getShort("d"));
        int ni = ((DBDocumentImpl)readRecordi).getIndex("n");
        int mi = ((DBDocumentImpl)readRecordi).getIndex("m");
        int ai = ((DBDocumentImpl)readRecordi).getIndex("a");
        int zzi = ((DBDocumentImpl)readRecordi).getIndex("z.z");
        int zli = ((DBDocumentImpl)readRecordi).getIndex("z.l");
        int zqmi = ((DBDocumentImpl)readRecordi).getIndex("z.q.m");
        Assert.assertEquals((long)1L, (long)mi);
        Assert.assertEquals((long)6L, (long)ai);
        Assert.assertEquals((long)1L, (long)zzi);
        Assert.assertEquals((long)3L, (long)zli);
        Assert.assertEquals((long)1L, (long)zqmi);
        Assert.assertEquals((long)1L, (long)readRecordi.getShort("z.a"));
        Assert.assertEquals((long)1L, (long)readRecordi.getShort("n"));
        Assert.assertEquals((long)0L, (long)ni);
        Map map = readRecordi.getMap("");
        Map putMap = putRec.getMap("");
        Assert.assertEquals((Object)true, (Object)putMap.equals(map));
        readRecordi = orderTable.findById("orderIns", new String[]{"a", "z.x", "n", "m", "z.q.m", "z.l", "q"});
        ni = ((DBDocumentImpl)readRecordi).getIndex("n");
        mi = ((DBDocumentImpl)readRecordi).getIndex("m");
        ai = ((DBDocumentImpl)readRecordi).getIndex("a");
        zqmi = ((DBDocumentImpl)readRecordi).getIndex("z.q.m");
        int zxi = ((DBDocumentImpl)readRecordi).getIndex("z.x");
        int qi = ((DBDocumentImpl)readRecordi).getIndex("q");
        zzi = ((DBDocumentImpl)readRecordi).getIndex("z.z");
        Assert.assertEquals((long)1L, (long)mi);
        Assert.assertEquals((long)0L, (long)ni);
        Assert.assertEquals((long)3L, (long)ai);
        Assert.assertEquals((long)0L, (long)zxi);
        Assert.assertEquals((long)0L, (long)zqmi);
        Assert.assertEquals((long)2L, (long)qi);
        Assert.assertEquals((long)-1L, (long)zzi);
        readRecordi = orderTable.findById("orderIns");
        zxi = ((DBDocumentImpl)readRecordi).getIndex("z.x");
        mDoc = new DBDocumentImpl().set("mb", "mmb");
        DocumentMutation m = MapRDB.newMutation().set("r", (short)0).set("x", (short)11).increment("a", (short)77).set("i.l", (short)11).set("j", (short)101).set("z.q.o", (short)3).set("z.q.z", (short)4).set("z.x", (short)999).append("g.arr", Arrays.asList(10)).merge("jj", (Document)mDoc).setNull("t").setOrReplaceNull("f");
        orderTable.update("orderIns", m);
        readRecordi = orderTable.findById("orderIns");
        int mai = ((DBDocumentImpl)readRecordi).getIndex("a");
        int ri = ((DBDocumentImpl)readRecordi).getIndex("r");
        int xi = ((DBDocumentImpl)readRecordi).getIndex("x");
        int ji = ((DBDocumentImpl)readRecordi).getIndex("j");
        int ili = ((DBDocumentImpl)readRecordi).getIndex("i.l");
        int mzxi = ((DBDocumentImpl)readRecordi).getIndex("z.x");
        int zqoi = ((DBDocumentImpl)readRecordi).getIndex("z.q.o");
        int zqni = ((DBDocumentImpl)readRecordi).getIndex("z.q.n");
        ni = ((DBDocumentImpl)readRecordi).getIndex("n");
        mi = ((DBDocumentImpl)readRecordi).getIndex("m");
        ai = ((DBDocumentImpl)readRecordi).getIndex("a");
        Assert.assertEquals((long)10L, (long)ri);
        Assert.assertEquals((long)11L, (long)xi);
        Assert.assertEquals((long)13L, (long)ji);
        Assert.assertEquals((long)0L, (long)ili);
        Assert.assertEquals((long)1L, (long)mi);
        Assert.assertEquals((long)0L, (long)ni);
        Assert.assertEquals((long)6L, (long)ai);
        Assert.assertEquals((long)6L, (long)mai);
        Assert.assertEquals((long)2L, (long)zqoi);
        Assert.assertEquals((long)0L, (long)zqni);
        Assert.assertEquals((long)4L, (long)mzxi);
        DBDocumentImpl rec = new DBDocumentImpl();
        Document map1 = MapRDB.newDocument().set("z", 1).set("y", 2).set("x", 3);
        Document map2 = MapRDB.newDocument().set("m", 11).set("o", 22).set("n", 33);
        Document map3 = MapRDB.newDocument().set("p", 111).set("q", 222).set("a", 333);
        rec.setArray("Maps", new Object[]{map1, map2, map3});
        orderTable.insertOrReplace("arrmap", (Document)rec);
        readRecordi = orderTable.findById("arrmap");
        Assert.assertNotNull((Object)readRecordi);
        map = readRecordi.getMap("");
        putMap = rec.getMap("");
        putMap.equals(map);
        orderTable.close();
        DBTests.deleteTables(OrderTable);
    }

    @Test
    public void testMultiCFGetWithEmptyCF() throws Exception {
        Table multiCFTable = DBTests.createOrReplaceTable("multiCFEmpty-TestMapRDBWithCluster", (Map<String, String>)ImmutableMap.of((Object)"f1", (Object)"a.b.c.d"));
        multiCFTable.setOption(Table.TableOption.BUFFERWRITE, false);
        Document r3 = MapRDB.newDocument();
        r3.set("a.b.c", 5);
        r3.set("a.x", "aaa");
        r3.set("a.b.x", "a.b.x");
        r3.set("a.b.c.x", "a.b.c.x");
        multiCFTable.insertOrReplace("key", r3);
        r3 = multiCFTable.findById("key");
        Assert.assertEquals((Object)"a.b.c.x", (Object)r3.getString("a.b.c.x"));
        Assert.assertEquals((Object)"a.b.x", (Object)r3.getString("a.b.x"));
        Assert.assertEquals((Object)"aaa", (Object)r3.getString("a.x"));
        DocumentStream r2 = multiCFTable.find();
        for (Document r3 : r2) {
            Assert.assertEquals((Object)"a.b.c.x", (Object)r3.getString("a.b.c.x"));
            Assert.assertEquals((Object)"a.b.x", (Object)r3.getString("a.b.x"));
            Assert.assertEquals((Object)"aaa", (Object)r3.getString("a.x"));
        }
        multiCFTable.close();
        DBTests.deleteTables("multiCFEmpty-TestMapRDBWithCluster");
    }

    @Test
    public void testProjAndCond() throws IOException, Exception {
        Document record;
        Table tablepc = DBTests.createOrReplaceTable("projCond");
        tablepc.setOption(Table.TableOption.EXCLUDEID, true);
        tablepc.setOption(Table.TableOption.BUFFERWRITE, false);
        String newStr = "newstr";
        for (int i = 0; i < 10; ++i) {
            record = MapRDB.newDocument();
            record.set("a.b", 1);
            if (i > 6) {
                record.set(newStr, newStr);
            }
            tablepc.insertOrReplace("recId" + i, record);
        }
        QueryCondition cpc = MapRDB.newCondition().is("a.b", QueryCondition.Op.EQUAL, 1).build();
        Document readRecordi = null;
        DocumentStream rs = tablepc.find(cpc, new String[]{newStr});
        Iterator itrs = rs.iterator();
        int count = 0;
        while (itrs.hasNext()) {
            ++count;
            readRecordi = (Document)itrs.next();
        }
        Assert.assertEquals((long)3L, (long)count);
        Document rr = tablepc.findById("recId1", cpc, new String[]{newStr});
        Assert.assertNull((Object)rr);
        rr = tablepc.findById("recId7", cpc, new String[]{newStr});
        Assert.assertNotNull((Object)rr);
        record = MapRDB.newDocument().set("a.b.c.d", 1).set("a.b.c.q", 2);
        tablepc.insertOrReplace("recId", record);
        cpc = MapRDB.newCondition().is("a.b.c.q", QueryCondition.Op.EQUAL, 2).build();
        rr = tablepc.findById("recId", cpc, new String[]{"a.b.c.d"});
        Assert.assertNotNull((Object)rr);
        Assert.assertEquals((long)1L, (long)rr.getInt("a.b.c.d"));
        Assert.assertNull((Object)rr.getValue("a.b.c.q"));
        rr = tablepc.findById("recId", cpc, new String[]{"a.b.c.q"});
        Assert.assertNotNull((Object)rr);
        Assert.assertEquals((long)2L, (long)rr.getInt("a.b.c.q"));
        Assert.assertNull((Object)rr.getValue("a.b.c.d"));
        record = MapRDB.newDocument().set("a.b.c[0]", 1).set("a.b.c[1]", 2).set("a.b.q.e", 3);
        tablepc.insertOrReplace("recId", record);
        cpc = MapRDB.newCondition().is("a.b.q.e", QueryCondition.Op.EQUAL, 3).build();
        rr = tablepc.findById("recId", cpc, new String[]{"a.b.c"});
        Assert.assertNotNull((Object)rr);
        Assert.assertNull((Object)rr.getValue("a.b.q.e"));
        cpc = MapRDB.newCondition().is("a.b.c[1]", QueryCondition.Op.EQUAL, 2).build();
        rr = tablepc.findById("recId", cpc, new String[]{"a.b.c"});
        Assert.assertNotNull((Object)rr);
        Assert.assertEquals((long)2L, (long)rr.getInt("a.b.c[1]"));
        Assert.assertEquals((long)1L, (long)rr.getInt("a.b.c[0]"));
        tablepc.close();
        DBTests.deleteTables("projCond");
    }

    @Test
    public void testArrayDeletes() throws IOException, Exception {
        Table table = DBTests.createOrReplaceTable("arrayDelete-TMWC");
        table.setOption(Table.TableOption.EXCLUDEID, true);
        table.setOption(Table.TableOption.BUFFERWRITE, false);
        Document record = MapRDB.newDocument();
        ArrayList<Object> o1 = new ArrayList<Object>();
        o1.add(1);
        o1.add("2");
        o1.add(3);
        ArrayList<String> o2 = new ArrayList<String>();
        o2.add("A");
        o2.add("B");
        o1.add(o2);
        record.set("a.b", o1);
        record.set("a.c", "hello");
        table.insertOrReplace("recId", record);
        table.flush();
        DocumentMutation mutation = MapRDB.newMutation();
        mutation.delete("a.b[0]");
        mutation.delete("a.b[1]");
        mutation.delete("a.b[2]");
        table.update("recId", mutation);
        Document record1 = table.findById("recId");
    }

    @Test
    public void testMultiCF() throws IOException, Exception {
        DBDocumentImpl putRec = null;
        Document readRecordi2 = null;
        HashMap<String, String> cfPath = new HashMap<String, String>();
        Table mcfTable = null;
        DocumentStream rs = null;
        Iterator itrs = null;
        String mcfName = "multiCF-TestMapRDBWithCluster";
        DocumentMutation m = null;
        cfPath.put("cf1", "a.b");
        cfPath.put("cf2", "a.b.c");
        cfPath.put("cf3", "a");
        cfPath.put("cf4", "a.b.c.d");
        mcfTable = DBTests.createOrReplaceTable(mcfName, cfPath);
        mcfTable.setOption(Table.TableOption.BUFFERWRITE, false);
        Document record1 = MapRDB.newDocument().set("a", MapRDB.newDocument().set("b", MapRDB.newDocument().set("c", MapRDB.newDocument().set("d", MapRDB.newDocument().set("e", "a.b.c.d")).set("f", "a.b.c")).set("g", "a.b")).set("h", "a")).set("i", "root");
        mcfTable.insertOrReplace("record1", record1);
        mcfTable.flush();
        readRecordi2 = mcfTable.findById("record1");
        Assert.assertNotNull((Object)readRecordi2);
        Assert.assertEquals((Object)"root", (Object)readRecordi2.getString("i"));
        Assert.assertEquals((Object)"a.b.c.d", (Object)readRecordi2.getString("a.b.c.d.e"));
        int ii = ((DBDocumentImpl)readRecordi2).getIndex("i");
        Assert.assertEquals((long)1L, (long)ii);
        int aid = ((DBDocumentImpl)readRecordi2).getIndex("a");
        Assert.assertEquals((long)0L, (long)aid);
        rs = mcfTable.find();
        for (Document readRecordi2 : rs) {
            Assert.assertNotNull((Object)readRecordi2);
            Assert.assertEquals((Object)"root", (Object)readRecordi2.getString("i"));
            Assert.assertEquals((Object)"a.b.c.d", (Object)readRecordi2.getString("a.b.c.d.e"));
        }
        mcfTable.close();
        cfPath = new HashMap();
        cfPath.put("cf1", "a");
        cfPath.put("cf2", "c");
        cfPath.put("ef3", "b");
        cfPath.put("ef4", "d");
        mcfTable = DBTests.createOrReplaceTable(mcfName, cfPath);
        mcfTable.setOption(Table.TableOption.BUFFERWRITE, false);
        record1 = MapRDB.newDocument().set("a", 1).set("b", 2).set("c", 3).set("d", 4).set("e", 5);
        mcfTable.insertOrReplace("MultiCF", record1);
        readRecordi2 = mcfTable.findById("MultiCF");
        Assert.assertNotNull((Object)readRecordi2);
        int ai = ((DBDocumentImpl)readRecordi2).getIndex("a");
        int bi = ((DBDocumentImpl)readRecordi2).getIndex("b");
        int ci = ((DBDocumentImpl)readRecordi2).getIndex("c");
        int di = ((DBDocumentImpl)readRecordi2).getIndex("d");
        int ei = ((DBDocumentImpl)readRecordi2).getIndex("e");
        Assert.assertEquals((long)0L, (long)ai);
        Assert.assertEquals((long)3L, (long)bi);
        Assert.assertEquals((long)1L, (long)ci);
        Assert.assertEquals((long)4L, (long)di);
        Assert.assertEquals((long)2L, (long)ei);
        mcfTable.close();
        cfPath = new HashMap();
        cfPath.put("f1", "l1");
        cfPath.put("f5", "l1.l2.l3.l4.l5");
        cfPath.put("f2", "l1.l2");
        cfPath.put("f3", "l1.l2.l3");
        cfPath.put("f4", "l1.l2.l3.l4");
        mcfTable = DBTests.createOrReplaceTable(mcfName, cfPath);
        mcfTable.setOption(Table.TableOption.BUFFERWRITE, false);
        putRec = new DBDocumentImpl().set("bool", true).set("l1.bool", true).set("l1.l2.bool", false).set("l1.l2.l3.bool", true).set("l1.l2.l3.l4.bool", false).set("l1.l2.l3.l4.l5.bool", false).set("l1.l2.l3.l4.l5.l6.l7.bool", true).set("l1.l2.l3.l4.l5.l6.l7.l8.bool", false).set("l1.l2.l3.l4.l5.l6.l7.l8.l9.bool", true);
        mcfTable.insertOrReplace("MultiCF", (Document)putRec);
        readRecordi2 = mcfTable.findById("MultiCF");
        Assert.assertNotNull((Object)readRecordi2);
        Assert.assertEquals((Object)true, (Object)readRecordi2.getBoolean("bool"));
        Assert.assertEquals((Object)true, (Object)readRecordi2.getBoolean("l1.bool"));
        Assert.assertEquals((Object)false, (Object)readRecordi2.getBoolean("l1.l2.bool"));
        Assert.assertEquals((Object)true, (Object)readRecordi2.getBoolean("l1.l2.l3.bool"));
        Assert.assertEquals((Object)false, (Object)readRecordi2.getBoolean("l1.l2.l3.l4.bool"));
        putRec = new DBDocumentImpl().set("a.b.c", "abc");
        mcfTable.insertOrReplace("MultiCF", (Document)putRec);
        m = MapRDB.newMutation().set("a.b.c", "cba");
        mcfTable.update("MultiCF", m);
        readRecordi2 = mcfTable.findById("MultiCF");
        Assert.assertNotNull((Object)readRecordi2);
        Assert.assertEquals((Object)"cba", (Object)readRecordi2.getString("a.b.c"));
        m = MapRDB.newMutation().setOrReplace("a.b.c", "zyxcba");
        mcfTable.update("MultiCF", m);
        readRecordi2 = mcfTable.findById("MultiCF");
        Assert.assertNotNull((Object)readRecordi2);
        Assert.assertEquals((Object)"zyxcba", (Object)readRecordi2.getString("a.b.c"));
        cfPath = new HashMap();
        cfPath.put("f1", "p.q");
        cfPath.put("f2", "d.e");
        cfPath.put("f3", "a.b.c");
        mcfTable = DBTests.createOrReplaceTable(mcfName, cfPath);
        mcfTable.setOption(Table.TableOption.BUFFERWRITE, false);
        _logger.info(" MAP: " + ((MapRDBTableImpl)mcfTable).idPathMap());
        putRec = new DBDocumentImpl().set("a.b.c", "abc").set("m.n", "mn").set("d.e", "de").set("p.q", "pq");
        mcfTable.insertOrReplace("MultiCF", (Document)putRec);
        readRecordi2 = mcfTable.findById("MultiCF");
        Assert.assertNotNull((Object)readRecordi2);
        Assert.assertEquals((Object)Value.Type.MAP, (Object)readRecordi2.getValue("a.b").getType());
        Assert.assertEquals((Object)"mn", (Object)readRecordi2.getString("m.n"));
        Assert.assertEquals((Object)"pq", (Object)readRecordi2.getString("p.q"));
        Assert.assertEquals((Object)"abc", (Object)readRecordi2.getString("a.b.c"));
        readRecordi2 = mcfTable.findById("MultiCF", new String[]{"m.n", "a", "p.q", "a.b", "a.b.c", "d", "p"});
        Assert.assertNotNull((Object)readRecordi2);
        Assert.assertNotNull((Object)readRecordi2.getValue("d.e"));
        Assert.assertNotNull((Object)readRecordi2.getValue("p.q"));
        Assert.assertEquals((Object)"de", (Object)readRecordi2.getString("d.e"));
        Assert.assertEquals((Object)"mn", (Object)readRecordi2.getString("m.n"));
        Assert.assertEquals((Object)"pq", (Object)readRecordi2.getString("p.q"));
        rs = mcfTable.find();
        itrs = rs.iterator();
        int count = 0;
        while (itrs.hasNext()) {
            readRecordi2 = (Document)itrs.next();
            Assert.assertEquals((Object)"pq", (Object)readRecordi2.getString("p.q"));
            Assert.assertEquals((Object)"mn", (Object)readRecordi2.getString("m.n"));
            Assert.assertEquals((Object)"abc", (Object)readRecordi2.getString("a.b.c"));
            ++count;
        }
        Assert.assertEquals((long)1L, (long)count);
        cfPath.clear();
        cfPath = new HashMap();
        cfPath.put("f1", "a.b");
        cfPath.put("f2", "a.b.c.d");
        mcfTable.close();
        mcfTable = DBTests.createOrReplaceTable(mcfName, cfPath);
        mcfTable.setOption(Table.TableOption.BUFFERWRITE, false);
        putRec = new DBDocumentImpl().set("a.b.c.d.e", "abcde");
        mcfTable.insertOrReplace("MultiCF", (Document)putRec);
        readRecordi2 = mcfTable.findById("MultiCF", new String[]{"a.b", "a.b.c", "a.b.c.d.e"});
        Assert.assertNotNull((Object)readRecordi2);
        Assert.assertEquals((Object)Value.Type.MAP, (Object)readRecordi2.getValue("a.b").getType());
        Assert.assertEquals((Object)"abcde", (Object)readRecordi2.getString("a.b.c.d.e"));
        cfPath = new HashMap();
        cfPath.put("f1", "p.q");
        cfPath.put("f2", "d.e");
        cfPath.put("f3", "a.b.c");
        mcfTable.close();
        mcfTable = DBTests.createOrReplaceTable(mcfName, cfPath);
        mcfTable.setOption(Table.TableOption.BUFFERWRITE, false);
        putRec = new DBDocumentImpl().set("a.b.c", "abc").set("m.n", "mn").set("d.e", "de").set("p.q", "pq");
        mcfTable.insertOrReplace("MultiCF", (Document)putRec);
        m = MapRDB.newMutation().set("a.b.c", "cba").set("a.b.x", "xba").set("p.q", "qp");
        mcfTable.update("MultiCF", m);
        readRecordi2 = mcfTable.findById("MultiCF", new String[]{"a.b.c", "a.b.x"});
        Assert.assertNotNull((Object)readRecordi2);
        Assert.assertEquals((Object)"cba", (Object)readRecordi2.getString("a.b.c"));
        Assert.assertEquals((Object)"xba", (Object)readRecordi2.getString("a.b.x"));
        m = MapRDB.newMutation().setOrReplace("a.b.c", (short)1111).setOrReplace("a.b.x", (short)222).setOrReplace("p.q", (short)-32203);
        mcfTable.update("MultiCF", m);
        readRecordi2 = mcfTable.findById("MultiCF", new String[]{"a.b.c", "a.b.x"});
        Assert.assertNotNull((Object)readRecordi2);
        Assert.assertEquals((long)1111L, (long)readRecordi2.getShort("a.b.c"));
        Assert.assertEquals((long)222L, (long)readRecordi2.getShort("a.b.x"));
        cfPath = new HashMap();
        cfPath.put("f1", "p.q");
        cfPath.put("f2", "d.e");
        cfPath.put("c3", "a.b.c");
        mcfTable = DBTests.createOrReplaceTable(mcfName, cfPath);
        mcfTable.setOption(Table.TableOption.BUFFERWRITE, false);
        putRec = new DBDocumentImpl().set("d.e", (short)33).set("p.q", (short)44).set("a.m", (short)55).set("a.b.c", (short)11).set("a.b.x", (short)22);
        mcfTable.insertOrReplace("MultiCF", (Document)putRec);
        readRecordi2 = mcfTable.findById("MultiCF", new String[]{"p.q", "a.b"});
        Assert.assertNotNull((Object)readRecordi2);
        Assert.assertEquals((long)22L, (long)readRecordi2.getShort("a.b.x"));
        Assert.assertEquals((long)44L, (long)readRecordi2.getShort("p.q"));
        m = MapRDB.newMutation().increment("a.b.c", (short)11).increment("a.b.x", (short)22).increment("p.q", (short)44);
        mcfTable.update("MultiCF", m);
        readRecordi2 = mcfTable.findById("MultiCF", new String[]{"a.b.c", "a.b.x", "a.m"});
        Assert.assertNotNull((Object)readRecordi2);
        Assert.assertEquals((long)22L, (long)readRecordi2.getShort("a.b.c"));
        Assert.assertEquals((long)44L, (long)readRecordi2.getShort("a.b.x"));
        mcfTable.close();
        mcfTable = DBTests.createOrReplaceTable(mcfName, cfPath);
        mcfTable.setOption(Table.TableOption.BUFFERWRITE, false);
        putRec = new DBDocumentImpl().set("a.b", (short)11).set("p.q", (short)-32203);
        mcfTable.insertOrReplace("MultiCF", (Document)putRec);
        readRecordi2 = mcfTable.findById("MultiCF", new String[]{"a.b.c", "a.b"});
        Assert.assertNotNull((Object)readRecordi2);
        Assert.assertNull((Object)readRecordi2.getValue("a.b.c"));
        Assert.assertEquals((long)11L, (long)readRecordi2.getShort("a.b"));
        cfPath = new HashMap();
        cfPath.put("f1", "p.q");
        cfPath.put("f2", "d.e");
        cfPath.put("f3", "a.b.c");
        mcfTable.close();
        mcfTable = DBTests.createOrReplaceTable(mcfName, cfPath);
        mcfTable.setOption(Table.TableOption.BUFFERWRITE, false);
        putRec = new DBDocumentImpl().set("a.b.c", (short)111).set("p.q", (short)222).set("d.e", (short)333).set("a.b.x", (short)444);
        mcfTable.insertOrReplace("MultiCF", (Document)putRec);
        QueryCondition condition = MapRDB.newCondition().and().notExists("x.y.z").is("d.e", QueryCondition.Op.EQUAL, 333).close().build();
        rs = mcfTable.find(condition, new String[]{"a.b.x", "a.b.c", "d"});
        itrs = rs.iterator();
        count = 0;
        while (itrs.hasNext()) {
            readRecordi2 = (Document)itrs.next();
            Assert.assertEquals((long)111L, (long)readRecordi2.getShort("a.b.c"));
            Assert.assertEquals((long)444L, (long)readRecordi2.getShort("a.b.x"));
            Assert.assertEquals((Object)Value.Type.MAP, (Object)readRecordi2.getValue("d").getType());
            ++count;
        }
        Assert.assertEquals((long)1L, (long)count);
        readRecordi2 = mcfTable.findById("MultiCF", condition, new String[]{"a.b.x", "a.b.c", "d"});
        Assert.assertEquals((long)111L, (long)readRecordi2.getShort("a.b.c"));
        Assert.assertEquals((long)444L, (long)readRecordi2.getShort("a.b.x"));
        Assert.assertEquals((Object)Value.Type.MAP, (Object)readRecordi2.getValue("d").getType());
        mcfTable.close();
        DBTests.deleteTables(mcfName);
    }

    @Test
    public void testMultiCF2() throws IOException, Exception {
        HashMap<String, String> cfPath = new HashMap<String, String>();
        cfPath.put("f1", "a.b");
        cfPath.put("f2", "b.c");
        Table mcfTable = DBTests.createOrReplaceTable("multiCF-TestMapRDBWithCluster2", cfPath);
        mcfTable.setOption(Table.TableOption.BUFFERWRITE, false);
        Document r = MapRDB.newDocument();
        r.set("a.h", "a").set("a.b.c.d.e", "a.b.c.d").set("a.b.c.f", "a.b.c").set("a.b.g", "a.b").set("b.c.f1", "f1").set("b.c.f2", "f2").set("i", "root");
        mcfTable.insertOrReplace("key", r);
        mcfTable.flush();
        r = mcfTable.findById("key");
        DocumentMutation m = MapRDB.newMutation();
        m.delete("a.b.c.d").delete("b.c");
        mcfTable.update("key", m);
        mcfTable.flush();
        r = mcfTable.findById("key");
        Assert.assertEquals((Object)"a", (Object)r.getString("a.h"));
        Assert.assertEquals((Object)"a.b.c", (Object)r.getString("a.b.c.f"));
        Assert.assertEquals((Object)"a.b", (Object)r.getString("a.b.g"));
        Assert.assertEquals((Object)"root", (Object)r.getString("i"));
        Assert.assertNull((Object)r.getValue("b.c"));
        Assert.assertNull((Object)r.getValue("a.b.c.d"));
    }

    @Test
    public void testMapRDB() throws IOException, InterruptedException, Exception {
        this.putRecords();
        this.asyncReadTests();
        this.testGets();
        this.testScans();
        Assert.assertEquals((long)this.numAsyncIssued, (long)this.numAsyncSucc);
        Assert.assertEquals((long)0L, (long)this.numAsyncFail);
    }

    @Test
    public void testRecordWriterWithTable() throws Exception {
        this.testDBDocumentWriterCRUD();
        this.testIdWithRecordWriter();
    }

    @Test
    public void testEmptyRecord() throws IOException, InterruptedException, Exception {
        Table table = DBTests.createOrReplaceTable("emptyrecord-table");
        table.setOption(Table.TableOption.EXCLUDEID, true);
        table.setOption(Table.TableOption.BUFFERWRITE, false);
        Document putRec = MapRDB.newDocument();
        table.insertOrReplace("key", putRec);
        table.flush();
        Document r2 = table.findById("key");
        Assert.assertNotNull((Object)r2);
        Map m = r2.getMap("");
        Assert.assertEquals((long)0L, (long)m.size());
    }

    @Test
    public void testIdRemoval() throws IOException, InterruptedException, Exception {
        Table table = DBTests.createOrReplaceTable("table");
        table.setOption(Table.TableOption.EXCLUDEID, false);
        table.setOption(Table.TableOption.BUFFERWRITE, false);
        Document putRec = MapRDB.newDocument();
        table.insertOrReplace("key", putRec);
        table.flush();
        Document r2 = table.findById("key");
        Assert.assertEquals((Object)"key", (Object)IdCodec.asString((Value)r2.getId()));
        r2.delete("_id");
        Assert.assertNull((Object)r2.getId());
        Assert.assertNull((Object)r2.getValue("_id"));
    }

    @Test
    public void testMapRDBWithProjectionAndDeletes() throws Exception {
        Table tableDel = DBTests.createOrReplaceTable(TABLE_DEL);
        tableDel.setOption(Table.TableOption.BUFFERWRITE, false);
        Document putRec = TestMapRDBWithCluster.getMedRecord();
        tableDel.insertOrReplace("KEY1a", putRec);
        tableDel.insertOrReplace("KEY2a", putRec);
        tableDel.insertOrReplace("KEY3a", putRec);
        DBDocumentImpl readRecord = (DBDocumentImpl)tableDel.findById("KEY1a");
        assert (readRecord != null);
        tableDel.delete("KEY1a");
        readRecord = (DBDocumentImpl)tableDel.findById("KEY1a");
        assert (readRecord == null);
        readRecord = (DBDocumentImpl)tableDel.findById("KEY2a", new String[]{"decimal", "map.long", "Friends", "map.Array2[1]"});
        Assert.assertEquals((Object)readRecord.getIdAsString(), (Object)"KEY2a");
        Map map = readRecord.getMap();
        Set keySet = map.keySet();
        Iterator i = keySet.iterator();
        Assert.assertEquals(i.next(), (Object)"_id");
        Assert.assertEquals((long)readRecord.getLong("map.long"), (long)12345678999L);
        Assert.assertEquals((Object)readRecord.getString("Friends[0]"), (Object)"Anurag");
        Assert.assertEquals((Object)readRecord.getString("Friends[1]"), (Object)"Bharat");
        Assert.assertEquals((long)readRecord.getInt("Friends[2]"), (long)10L);
        Assert.assertEquals((long)readRecord.getLong("map.Array2[1]"), (long)-50000L);
        assert (readRecord.getValue("internal") == null);
        readRecord.setId("KEY4a");
        tableDel.insertOrReplace("KEY4a", (Document)readRecord);
        readRecord = (DBDocumentImpl)tableDel.findById("KEY4a");
        Assert.assertEquals((long)readRecord.getLong("map.long"), (long)12345678999L);
        Assert.assertEquals((Object)readRecord.getString("Friends[0]"), (Object)"Anurag");
        Assert.assertEquals((Object)readRecord.getString("Friends[1]"), (Object)"Bharat");
        Assert.assertEquals((long)readRecord.getInt("Friends[2]"), (long)10L);
        Assert.assertEquals((long)readRecord.getLong("map.Array2[0]"), (long)-50000L);
        tableDel.delete("KEY2a");
        tableDel.delete("KEY3a");
        tableDel.delete("KEY4a");
        tableDel.close();
        DBTests.deleteTables(TABLE_DEL);
    }

    @Test
    public void readModifyWriteTest() throws Exception {
        String TableName = "testtable-readmodifywrite";
        String TableName2 = "testtable-readmodifywrite2";
        Table table = DBTests.createOrReplaceTable(TableName);
        Table table2 = DBTests.createOrReplaceTable(TableName2);
        table.setOption(Table.TableOption.BUFFERWRITE, true);
        Document putRec = TestMapRDBWithCluster.getMedRecord();
        for (int i = 0; i < 1000; ++i) {
            String key = "KEY-" + i;
            table.insertOrReplace(key, putRec);
        }
        table.flush();
        Iterator iter = table.find().iterator();
        int getCount = 0;
        while (iter.hasNext()) {
            Document r = (Document)iter.next();
            r.set("_id", "NEWKEY" + getCount);
            ++getCount;
            r.delete("map.int").delete("map.LIST[1]").set("NEWFIELD", "THIS IS REALLY A NEW FIELD BELIEVE ME");
            table2.insertOrReplace(r);
        }
        Assert.assertEquals((long)1000L, (long)getCount);
        table.flush();
        table2.flush();
        QueryCondition condition = MapRDB.newCondition().and().is("_id", QueryCondition.Op.GREATER, "NEWKEY").is("_id", QueryCondition.Op.LESS, "NEWKEZ").close().build();
        iter = table2.find(condition).iterator();
        getCount = 0;
        while (iter.hasNext()) {
            Document r = (Document)iter.next();
            ++getCount;
            Assert.assertNull((Object)r.getValue("map.int"));
            Assert.assertEquals((double)r.getDouble("map.LIST[1]"), (double)new Double(5555.5555), (double)0.0);
            Assert.assertEquals((Object)r.getString("NEWFIELD"), (Object)"THIS IS REALLY A NEW FIELD BELIEVE ME");
        }
        Assert.assertEquals((long)1000L, (long)getCount);
        DBTests.deleteTables(TableName);
        DBTests.deleteTables(TableName2);
    }

    @Test
    public void booleanValueTest() throws Exception {
        String TableName = "testtable-booleanvalue";
        Table table = DBTests.createOrReplaceTable(TableName);
        table.setOption(Table.TableOption.BUFFERWRITE, false);
        Document r1 = MapRDB.newDocument().set("true", true).set("false", false).set("booleanarray[0]", false).set("booleanarray[1]", true).set("booleanarray[2]", true).set("booleanarray[3]", false);
        table.insertOrReplace("r1", r1);
        Document r1get = table.findById("r1");
        _logger.info("Document is " + r1get);
        Assert.assertEquals((Object)true, (Object)r1get.getBoolean("true"));
        Assert.assertEquals((Object)false, (Object)r1get.getBoolean("false"));
        Assert.assertEquals((Object)false, (Object)r1get.getBoolean("booleanarray[0]"));
        Assert.assertEquals((Object)true, (Object)r1get.getBoolean("booleanarray[1]"));
        Assert.assertEquals((Object)true, (Object)r1get.getBoolean("booleanarray[2]"));
        Assert.assertEquals((Object)false, (Object)r1get.getBoolean("booleanarray[3]"));
        DBTests.deleteTables(TableName);
    }

    @Test
    public void nullValueTest() throws Exception {
        String TableName = "nullvaluetest-table";
        Table table = DBTests.createOrReplaceTable(TableName);
        table.setOption(Table.TableOption.BUFFERWRITE, false);
        Document r1 = MapRDB.newDocument().set("level0_a3_array", Arrays.asList(null, "A")).setNull("level0_a4_long");
        table.insertOrReplace("r1", r1);
        Document r1get = table.findById("r1");
        Assert.assertEquals((Object)Value.Type.NULL, (Object)r1get.getValue("level0_a3_array[0]").getType());
        Assert.assertEquals((Object)"A", (Object)r1get.getString("level0_a3_array[1]"));
        Assert.assertEquals((Object)Value.Type.NULL, (Object)r1get.getValue("level0_a4_long").getType());
        _logger.info("Document is " + r1get);
        DBTests.deleteTables(TableName);
    }

    @Test
    public void nestedRecordTest() throws Exception {
        Document r = MapRDB.newDocument();
        r.setNull("a").set("A", Arrays.asList("A", "B", "C"));
        Document r2 = MapRDB.newDocument();
        r2.setNull("a").set("A[0]", Arrays.asList("C", "B", "A"));
        sharedStaticTable.insertOrReplace("record1", r);
        DocumentMutation m = MapRDB.newMutation();
        m.set("A", r2.getList("A[0]"));
        sharedStaticTable.update("record1", m);
    }

    @Test
    public void testIncrement() throws Exception {
        sharedStaticTable.increment("K1", "a.byte", (byte)100);
        sharedStaticTable.increment("K1", "a.short", (short)100);
        sharedStaticTable.increment("K1", "a.int", 100);
        sharedStaticTable.increment("K1", "a.long", 100L);
        sharedStaticTable.increment("K1", "a.float", 100.1f);
        sharedStaticTable.increment("K1", "a.double", 100.1);
        sharedStaticTable.flush();
        Document r = sharedStaticTable.findById("K1");
        Assert.assertEquals((long)100L, (long)r.getByte("a.byte"));
        Assert.assertEquals((long)100L, (long)r.getShort("a.short"));
        Assert.assertEquals((long)100L, (long)r.getInt("a.int"));
        Assert.assertEquals((long)100L, (long)r.getLong("a.long"));
        Assert.assertEquals((double)100.1f, (double)r.getFloat("a.float"), (double)0.0);
        Assert.assertEquals((double)100.1, (double)r.getDouble("a.double"), (double)0.0);
    }

    @Test
    public void wideRecordTest() throws Exception {
        Document r = MapRDB.newDocument();
        for (int i = 0; i < 50000; ++i) {
            r.set("field" + i, "a");
        }
        sharedStaticTable.insertOrReplace("widerowkey", r);
        sharedStaticTable.flush();
        Document r2 = sharedStaticTable.findById("widerowkey");
        for (int i = 0; i < 50000; ++i) {
            Assert.assertEquals((Object)"a", (Object)r2.getString("field" + i));
        }
    }

    @Test
    public void arrayDeleteTest() throws Exception {
        Document r = MapRDB.newDocument();
        r.set("a.b[0]", 1).set("a.b[1]", "2").set("a.b[2]", 3).set("a.b[3][0]", "A").set("a.b[3][1]", "B").set("a.b[3][2]", "C");
        sharedStaticTable.setOption(Table.TableOption.EXCLUDEID, true);
        sharedStaticTable.insertOrReplace("arraydeletekey", r);
        sharedStaticTable.flush();
        Document r2 = sharedStaticTable.findById("arraydeletekey");
        Assert.assertEquals((Object)r, (Object)r2);
        DocumentMutation m = MapRDB.newMutation();
        m.append("a.b[1]", "dummystring1");
        m.append("a.b[3][0]", "dummystring2");
        m.append("a.b[3][1]", "dummystring3");
        sharedStaticTable.update("arraydeletekey", m);
        Document r3 = sharedStaticTable.findById("arraydeletekey");
        Assert.assertEquals((Object)"2dummystring1", (Object)r3.getString("a.b[1]"));
        Assert.assertEquals((Object)"Adummystring2", (Object)r3.getString("a.b[3][0]"));
        Assert.assertEquals((Object)"Bdummystring3", (Object)r3.getString("a.b[3][1]"));
    }

    @Test
    public void docAsValueTest() throws Exception {
        Document r = MapRDB.newDocument();
        r.set("Name", "XXX");
        sharedStaticTable.insertOrReplace("key", r);
        sharedStaticTable.flush();
        Document r2 = MapRDB.newDocument().set("type", "Home").set("street", "350 River Oaks").set("city", "sanjose");
        DocumentMutation m = MapRDB.newMutation();
        m.setOrReplace("address", r2);
        m.append("addresses", Arrays.asList(r2));
        sharedStaticTable.update("key", m);
        Document d3 = sharedStaticTable.findById("key");
        Assert.assertEquals((Object)"Home", (Object)d3.getString("address.type"));
        Assert.assertEquals((Object)"350 River Oaks", (Object)d3.getString("address.street"));
        Assert.assertEquals((Object)"sanjose", (Object)d3.getString("address.city"));
        Assert.assertEquals((Object)"Home", (Object)d3.getString("addresses[0].type"));
        Assert.assertEquals((Object)"350 River Oaks", (Object)d3.getString("addresses[0].street"));
        Assert.assertEquals((Object)"sanjose", (Object)d3.getString("addresses[0].city"));
    }

    @Test
    public void setNullTest() throws Exception {
        Document r = MapRDB.newDocument();
        r.set("f1", "abc");
        sharedStaticTable.insertOrReplace("nullkey1", r);
        sharedStaticTable.flush();
        DocumentMutation m = MapRDB.newMutation();
        m.set("f2", 1000).setNull("f3");
        sharedStaticTable.update("nullkey1", m);
        sharedStaticTable.flush();
        Document d = sharedStaticTable.findById("nullkey1");
        Assert.assertEquals((long)1000L, (long)d.getInt("f2"));
        Assert.assertEquals((Object)Value.Type.NULL, (Object)d.getValue("f3").getType());
    }

    @Test
    public void incNonExistingRow() throws Exception {
        String key1 = "inc-non-existing-row1";
        String key2 = "inc-non-existing-row2";
        sharedStaticTable.delete(key1);
        sharedStaticTable.delete(key2);
        sharedStaticTable.flush();
        DocumentMutation m = MapRDB.newMutation();
        m.increment("a.b.c.inc", 100);
        sharedStaticTable.update(key1, m);
        sharedStaticTable.flush();
        Document d = sharedStaticTable.findById(key1);
        Assert.assertEquals((long)100L, (long)d.getInt("a.b.c.inc"));
        sharedStaticTable.increment(key2, "a.b.c.inc", 200);
        sharedStaticTable.flush();
        d = sharedStaticTable.findById(key2);
        Assert.assertEquals((long)200L, (long)d.getInt("a.b.c.inc"));
    }

    @Test
    public void setIDJsonStringTest() throws Exception {
        String jsonString = "{ \"_id\": \"a\", \"f1\" :30}";
        Document r = MapRDB.newDocument((String)jsonString);
        sharedStaticTable.insertOrReplace(r);
        sharedStaticTable.flush();
        Document d = sharedStaticTable.findById("a");
        Assert.assertEquals((double)30.0, (double)d.getDouble("f1"), (double)0.0);
    }

    @Test
    public void nonAsciiStringTest() throws Exception {
        String k1 = "`\u0900\u0901\u0902\u0903`";
        String v1 = "\u0420\u0421\u0422";
        String k2 = "`\u0500\u0501\u0502\u0503`";
        String v2 = "\u0720\u0471\u0722";
        Document r = MapRDB.newDocument();
        r.set(k1, v1);
        r.set(k2 + "[0]", v2);
        r.set(k2 + "[1]", v1);
        sharedStaticTable.insertOrReplace("nonascii", r);
        sharedStaticTable.flush();
        Document d = sharedStaticTable.findById("nonascii");
        Assert.assertEquals((Object)v1, (Object)d.getString(k1));
        Assert.assertEquals((Object)v2, (Object)d.getString(k2 + "[0]"));
        Assert.assertEquals((Object)v1, (Object)d.getString(k2 + "[1]"));
    }

    @Test
    public void arrayMutationTest() throws Exception {
        String key = "arrayMutationKey";
        Document r = MapRDB.newDocument();
        r.set("string", "str").set("f0", 10).set("f1", Arrays.asList("a", "b"));
        sharedStaticTable.insertOrReplace(key, r);
        sharedStaticTable.flush();
        DocumentMutation m = MapRDB.newMutation();
        m.setOrReplace("string.a.b.c", "newstring");
        m.setOrReplace("f1[0]", "new field");
        m.setOrReplace("f1[5]", "append to array");
        m.setOrReplace("f1[5000]", 5000);
        m.increment("a.b[100][200].c[300]", 100);
        m.increment("a.b[100][2500000].c[30]", 101);
        sharedStaticTable.update(key, m);
        Document d = sharedStaticTable.findById(key);
        Assert.assertEquals((Object)"newstring", (Object)d.getString("string.a.b.c"));
        Assert.assertEquals((long)10L, (long)d.getInt("f0"));
        Assert.assertEquals((Object)"new field", (Object)d.getString("f1[0]"));
        Assert.assertEquals((Object)"b", (Object)d.getString("f1[1]"));
        Assert.assertEquals((Object)"append to array", (Object)d.getString("f1[2]"));
        Assert.assertEquals((long)5000L, (long)d.getInt("f1[3]"));
        Assert.assertEquals((long)100L, (long)d.getInt("a.b[0][0].c[0]"));
        Assert.assertEquals((long)101L, (long)d.getInt("a.b[0][1].c[0]"));
    }

    @Test
    public void MFarrayMutationTest() throws Exception {
        Table multiCFTable = DBTests.createOrReplaceTable("multiCF-TestArrayMutation", (Map<String, String>)ImmutableMap.of((Object)"f1", (Object)"f1"));
        String key = "arrayMutationKey";
        Document r = MapRDB.newDocument();
        r.set("string", "str").set("f1", Arrays.asList("a", "b"));
        multiCFTable.insertOrReplace(key, r);
        multiCFTable.flush();
        DocumentMutation m = MapRDB.newMutation();
        m.setOrReplace("string.a.b.c", "newstring");
        m.setOrReplace("f1[0]", "new field");
        m.setOrReplace("f1[5]", "append to array");
        m.setOrReplace("f1[5000]", 5000);
        m.increment("a.b[100][200].c[300]", 100);
        m.increment("a.b[100][2500000].c[30]", 101);
        multiCFTable.update(key, m);
        Document d = multiCFTable.findById(key);
        Assert.assertEquals((Object)"newstring", (Object)d.getString("string.a.b.c"));
        Assert.assertEquals((Object)"new field", (Object)d.getString("f1[0]"));
        Assert.assertEquals((Object)"b", (Object)d.getString("f1[1]"));
        Assert.assertEquals((Object)"append to array", (Object)d.getString("f1[2]"));
        Assert.assertEquals((long)5000L, (long)d.getInt("f1[3]"));
        Assert.assertEquals((long)100L, (long)d.getInt("a.b[0][0].c[0]"));
        Assert.assertEquals((long)101L, (long)d.getInt("a.b[0][1].c[0]"));
    }

    @Test
    public void veryLargeRow() throws Exception {
        String rowKey = "veryLargeRow";
        byte[] value = new byte[0x1E00000];
        for (int i = 0; i < value.length; ++i) {
            value[i] = 16;
        }
        Document r = MapRDB.newDocument();
        r.set("k", value);
        sharedStaticTable.insertOrReplace(rowKey, r);
        sharedStaticTable.flush();
        Document d = sharedStaticTable.findById(rowKey);
        ByteBuffer b = d.getBinary("k");
        byte[] v = b.array();
        Assert.assertEquals((long)v.length, (long)value.length);
        for (int i = 0; i < v.length; ++i) {
            Assert.assertEquals((long)v[i], (long)value[i]);
        }
        sharedStaticTable.delete(rowKey);
        sharedStaticTable.flush();
    }

    @Test
    public void arrayUpdateTest() throws Exception {
        String rowKey = "arrayUpdateRow";
        Document r = MapRDB.newDocument();
        r.set("Array[10][20][30]", 100);
        sharedStaticTable.insertOrReplace(rowKey, r);
        sharedStaticTable.flush();
        DocumentMutation m = MapRDB.newMutation();
        m.set("A", 200);
        sharedStaticTable.update(rowKey, m);
        sharedStaticTable.flush();
        Document d = sharedStaticTable.findById(rowKey);
        Assert.assertEquals((long)100L, (long)d.getInt("Array[10][20][30]"));
        Assert.assertEquals((long)200L, (long)d.getInt("A"));
        sharedStaticTable.delete(rowKey);
        sharedStaticTable.flush();
    }

    @Test
    public void fieldNameWithSpaceTest() throws Exception {
        String k1 = "Field 1 2 3 4 ";
        String v1 = "Value 1 2 3 4 ";
        String k2 = "Field 2.Field 3";
        String v2 = "V2";
        Document r = MapRDB.newDocument();
        r.set(k1, v1);
        r.set(k2 + "[0]", v2);
        r.set(k2 + "[1]", v1);
        sharedStaticTable.insertOrReplace("nonascii", r);
        sharedStaticTable.flush();
        Document d = sharedStaticTable.findById("nonascii");
        Assert.assertEquals((Object)v1, (Object)d.getString(k1));
        Assert.assertEquals((Object)v2, (Object)d.getString(k2 + "[0]"));
        Assert.assertEquals((Object)v1, (Object)d.getString(k2 + "[1]"));
    }

    @Test
    public void tableReadWriteBackTest() throws Exception {
        sharedStaticTable.setOption(Table.TableOption.BUFFERWRITE, false);
        for (int i = 0; i < 10000; ++i) {
            String key = "readwritebackkey";
            DocumentMutation m = MapRDB.newMutation();
            m.setOrReplace("field1", 100);
            m.setOrReplace("field2", 200);
            sharedStaticTable.update(key, m);
            m = MapRDB.newMutation();
            m.setOrReplace("field3", 300);
            m.setOrReplace("field4", 400);
            sharedStaticTable.update(key, m);
        }
        sharedStaticTable.flush();
        DBTests.admin().deleteTable("/tmp/readwritebacktable");
        Table destTable = DBTests.admin().createTable("/tmp/readwritebacktable");
        destTable.insertOrReplace(sharedStaticTable.find());
        destTable.flush();
    }

    @Test
    public void adminCRUDTest() throws Exception {
        String admTbl = "/AdminTABLE";
        TableDescriptor td = MapRDB.newTableDescriptor((String)admTbl).setSplitSize(512L).setAutoSplit(false).setBulkLoad(false);
        FamilyDescriptor familyDesc = MapRDB.newDefaultFamilyDescriptor().setCompression(FamilyDescriptor.Compression.ZLIB).setTTL(3600L);
        td.addFamily(familyDesc);
        FamilyDescriptor familyDesc2 = MapRDB.newFamilyDescriptor().setName("cf1").setJsonFieldPath("a").setInMemory(true).setCompression(FamilyDescriptor.Compression.None).setTTL(86400L);
        td.addFamily(familyDesc2);
        AdminImpl testAdmin = (AdminImpl)MapRDB.newAdmin();
        if (testAdmin.tableExists(admTbl)) {
            testAdmin.deleteTable(admTbl);
        }
        Table ctable = null;
        try {
            ctable = testAdmin.createTable(td);
            Assert.fail((String)"Should get error that TTL cannot be used with  multi family.");
        }
        catch (OpNotPermittedException opNotPermittedException) {
            // empty catch block
        }
        td = MapRDB.newTableDescriptor((String)admTbl).setSplitSize(512L).setAutoSplit(false).setBulkLoad(false);
        familyDesc = MapRDB.newDefaultFamilyDescriptor().setCompression(FamilyDescriptor.Compression.ZLIB);
        familyDesc2 = MapRDB.newFamilyDescriptor().setName("cf1").setJsonFieldPath("a").setInMemory(true).setCompression(FamilyDescriptor.Compression.None);
        td.addFamily(familyDesc);
        td.addFamily(familyDesc2);
        ctable = testAdmin.createTable(td);
        FamilyDescriptor familyDesc21 = MapRDB.newFamilyDescriptor().setName("cf11").setJsonFieldPath("a.c").setInMemory(true).setCompression(FamilyDescriptor.Compression.None).setTTL(86400L);
        TableDescriptor t1 = testAdmin.getTableDescriptor(admTbl);
        t1.addFamily(familyDesc21);
        try {
            testAdmin.alterTable(t1);
            Assert.fail((String)"Should get error that alterTable cannot be used to alter family.");
        }
        catch (OpNotPermittedException opNotPermittedException) {
            // empty catch block
        }
        try {
            FamilyDescriptor familyDesc3 = MapRDB.newFamilyDescriptor().setName("default1").setTTL(100L);
            testAdmin.alterFamily(admTbl, "default", familyDesc3);
            Assert.fail((String)"Should get error that default cannot be altered.");
        }
        catch (OpNotPermittedException familyDesc3) {
            // empty catch block
        }
        try {
            boolean ret = testAdmin.deleteFamily(admTbl, "default");
            Assert.fail((String)"Should get error that default cannot be deleted.");
        }
        catch (OpNotPermittedException ret) {
            // empty catch block
        }
        Document r = MapRDB.newDocument();
        r.set("a.b", "ab");
        ctable.insertOrReplace("admKey", r);
        ctable.flush();
        Document d = ctable.findById("admKey");
        Assert.assertEquals((Object)"ab", (Object)d.getString("a.b"));
        Assert.assertNull((Object)d.getValue("f3"));
        td = MapRDB.newTableDescriptor((String)admTbl).setSplitSize(512L).setAutoSplit(false).setBulkLoad(false);
        familyDesc = MapRDB.newDefaultFamilyDescriptor().setCompression(FamilyDescriptor.Compression.ZLIB);
        td.addFamily(familyDesc);
        familyDesc = MapRDB.newFamilyDescriptor().setName("f1").setJsonFieldPath("a.b.c");
        td.addFamily(familyDesc);
        testAdmin = (AdminImpl)MapRDB.newAdmin();
        if (testAdmin.tableExists(admTbl)) {
            testAdmin.deleteTable(admTbl);
        }
        ctable = testAdmin.createTable(td);
        r = MapRDB.newDocument().set("a.b.c", "abc").set("def", "def");
        ctable.insertOrReplace("admKey", r);
        ctable.flush();
        testAdmin.deleteFamily(ctable.getPath(), "f1");
        d = ctable.findById("admKey");
        Assert.assertNotNull((Object)d);
        Assert.assertEquals((Object)"def", (Object)d.getString("def"));
        ctable.close();
        testAdmin.deleteTable(admTbl);
        ctable = testAdmin.createTable(td);
        ctable.insertOrReplace("admKey", r);
        ctable.flush();
        testAdmin.deleteFamily(ctable.getPath(), "f1");
        DocumentStream stream = ctable.find();
        Iterator iter = stream.iterator();
        int count = 0;
        while (iter.hasNext()) {
            d = (Document)iter.next();
            Assert.assertEquals((Object)"def", (Object)d.getString("def"));
            ++count;
        }
        Assert.assertEquals((long)1L, (long)count);
        ctable.close();
        testAdmin.deleteTable(admTbl);
    }

    @Test
    public void testNestedCFProj() throws Exception {
        Table mcfOrderTable = null;
        String mcfOrderName = "multiCFProj-TestMapRDBWithCluster";
        HashMap<String, String> cfPath = new HashMap<String, String>();
        cfPath.put("cf1", "a.b.c.d");
        cfPath.put("cf2", "a.b");
        Document doc = MapRDB.newDocument();
        doc.set("a.b.h", "abh").set("a.b.c.g", "abcg").set("a.b.c.d.e", "abcde").set("a.b.c.d.f", "abcdf").set("a.b.i", "abi").set("i", "i");
        mcfOrderTable = DBTests.createOrReplaceTable(mcfOrderName, cfPath);
        mcfOrderTable.setOption(Table.TableOption.BUFFERWRITE, false);
        mcfOrderTable.setOption(Table.TableOption.EXCLUDEID, true);
        mcfOrderTable.insertOrReplace("order", doc);
        Document readDoc = null;
        readDoc = mcfOrderTable.findById("order", new String[]{"a.b.c.g"});
        Assert.assertEquals((Object)"abcg", (Object)readDoc.getString("a.b.c.g"));
        Assert.assertNull((Object)readDoc.getValue("a.b.c.d"));
        readDoc = mcfOrderTable.findById("order", new String[]{"a.b.h"});
        Assert.assertEquals((Object)"abh", (Object)readDoc.getString("a.b.h"));
        Assert.assertNull((Object)readDoc.getValue("a.b.c.d"));
        readDoc = mcfOrderTable.findById("order", new String[]{"a.b"});
        Assert.assertNull((Object)readDoc.getValue("i"));
        Assert.assertEquals((Object)"abcg", (Object)readDoc.getString("a.b.c.g"));
        Assert.assertEquals((Object)"abcde", (Object)readDoc.getString("a.b.c.d.e"));
        readDoc = mcfOrderTable.findById("order", new String[]{"a.b.c.d.e"});
        Assert.assertNull((Object)readDoc.getValue("a.b.c.g"));
        Assert.assertEquals((Object)"abcde", (Object)readDoc.getString("a.b.c.d.e"));
        Assert.assertNull((Object)readDoc.getValue("a.b.h"));
        readDoc = mcfOrderTable.findById("order", new String[]{"a.b.c"});
        Assert.assertEquals((Object)"abcg", (Object)readDoc.getString("a.b.c.g"));
        Assert.assertEquals((Object)"abcde", (Object)readDoc.getString("a.b.c.d.e"));
        Assert.assertNull((Object)readDoc.getValue("a.b.i"));
        Assert.assertNull((Object)readDoc.getValue("a.b.h"));
        Assert.assertNull((Object)readDoc.getValue("i"));
        readDoc = mcfOrderTable.findById("order", new String[]{""});
        Assert.assertEquals((Object)"abcg", (Object)readDoc.getString("a.b.c.g"));
        Assert.assertEquals((Object)"abcde", (Object)readDoc.getString("a.b.c.d.e"));
        Assert.assertEquals((Object)"abi", (Object)readDoc.getString("a.b.i"));
        Assert.assertEquals((Object)"i", (Object)readDoc.getString("i"));
        mcfOrderTable.close();
        DBTests.deleteTables(mcfOrderName);
    }

    private String getStr() {
        String str = "";
        for (int i = 0; i < 1024; ++i) {
            str = str + "a";
        }
        return str;
    }

    @Ignore
    public void loopTest() throws Exception {
        String mcfOrderName = "/loopTest-TestMapRDBWithCluster";
        Table mcfOrderTable = MapRDB.createTable((String)mcfOrderName);
        mcfOrderTable.setOption(Table.TableOption.BUFFERWRITE, false);
        int num = 10000000;
        int per = 100000;
        Document putRec = TestMapRDBWithCluster.getMedRecord();
        for (int i = 0; i < num; ++i) {
            mcfOrderTable.insertOrReplace("KEY" + i, putRec);
            if (i == 0 || i % per != 0) continue;
            System.out.println("Put iter " + i);
        }
        DocumentStream stream = mcfOrderTable.find();
        Iterator iter = stream.iterator();
        int count = 0;
        while (count < num * 10) {
            if (count != 0 && count % num == 0) {
                stream = mcfOrderTable.find();
                iter = stream.iterator();
            }
            while (iter.hasNext()) {
                iter.next();
                if (count != 0 && count % per == 0) {
                    System.out.println("Scan iter " + count);
                }
                ++count;
            }
        }
        mcfOrderTable.close();
    }

    @Test
    public void testFieldOrderMultiCF() throws Exception {
        Table mcfOrderTable = null;
        String mcfOrderName = "multiCFOrder-TestMapRDBWithCluster";
        HashMap<String, String> cfPath = new HashMap<String, String>();
        cfPath.put("cf1", "a.b");
        cfPath.put("cf2", "x.y");
        cfPath.put("cf3", "stairway_to_level1.stairway_to_level2");
        mcfOrderTable = DBTests.createOrReplaceTable(mcfOrderName, cfPath);
        mcfOrderTable.setOption(Table.TableOption.BUFFERWRITE, false);
        mcfOrderTable.setOption(Table.TableOption.EXCLUDEID, true);
        Document doc = MapRDB.newDocument();
        doc.set("a.b.l1", "1").set("a.b.l4.a", "11").set("a.b.l4.b", "12").set("a.b.l5", "5");
        mcfOrderTable.insertOrReplace("order", doc);
        Document readDoc = mcfOrderTable.findById("order");
        Map map = readDoc.getMap("");
        Map putMap = doc.getMap("");
        Assert.assertEquals((Object)true, (Object)putMap.equals(map));
        mcfOrderTable.close();
        DBTests.deleteTables(mcfOrderName);
    }

    @Test
    public void testPeriodicFlusher() throws Exception {
        int cnt;
        String tableName = "/periodicFlusher-TestMapRDBWithCluster-" + System.currentTimeMillis();
        AdminImpl testAdmin = (AdminImpl)MapRDB.newAdmin();
        TableDescriptor td = MapRDB.newTableDescriptor((String)tableName).setAutoSplit(false).setBulkLoad(false);
        FamilyDescriptor familyDesc = MapRDB.newDefaultFamilyDescriptor().setCompression(FamilyDescriptor.Compression.ZLIB);
        td.addFamily(familyDesc);
        FamilyDescriptor familyDesc2 = MapRDB.newFamilyDescriptor().setName("cf1").setJsonFieldPath("a");
        td.addFamily(familyDesc2);
        String[] splitKeyString = new String[]{"key11", "key21", "key31", "key41", "key51", "key61", "key71", "key81", "key91"};
        Table table = testAdmin.createTable(td, splitKeyString);
        table.setOption(Table.TableOption.BUFFERWRITE, true);
        Document doc = MapRDB.newDocument().set("a.b", "String1").set("x.y.z", "String2").set("a.c.d.e.f", true).setArray("a.c.d.arr1", new Object[]{"String1", 2, "Three", false});
        for (cnt = 1; cnt < 10; ++cnt) {
            String key = "key" + cnt * 10 + 2;
            table.insertOrReplace(key, doc);
        }
        Thread.sleep(3000L);
        _logger.info("Sleeping for 3000 milliseconds for flusher to run.");
        Table table2 = MapRDB.getTable((String)tableName);
        --cnt;
        while (cnt > 0) {
            String key = "key" + cnt * 10 + 2;
            Document readDoc = table2.findById(key);
            Assert.assertNotNull((Object)readDoc);
            Assert.assertEquals((Object)"String1", (Object)readDoc.getString("a.b"));
            Assert.assertEquals((Object)"String2", (Object)readDoc.getString("x.y.z"));
            Assert.assertEquals((Object)true, (Object)readDoc.getBoolean("a.c.d.e.f"));
            Assert.assertEquals((Object)"String1", (Object)readDoc.getString("a.c.d.arr1[0]"));
            Assert.assertEquals((long)2L, (long)readDoc.getInt("a.c.d.arr1[1]"));
            Assert.assertEquals((Object)"Three", (Object)readDoc.getString("a.c.d.arr1[2]"));
            Assert.assertEquals((Object)false, (Object)readDoc.getBoolean("a.c.d.arr1[3]"));
            --cnt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBug19105() throws Exception {
        String tableName = "testBug19105-TestMapRDBWithCluster";
        try (Table table = null;){
            table = DBTests.createOrReplaceTable(tableName);
            ByteBuffer bb = ByteBuffer.allocate(4).putInt(300);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("A", "AA");
            map.put("BB", ByteBuffer.allocate(4).putInt(500));
            table.insertOrReplace("record1", MapRDB.newDocument().set("bb", bb).set("bbmap", map).set("other", 1000));
            table.insertOrReplace("record2", MapRDB.newDocument().set("bb", bb).set("bbmap", map).set("other", 1000));
            table.flush();
            QueryCondition condition = MapRDB.newCondition().and().is("bb", QueryCondition.Op.EQUAL, bb).equals("bbmap", map).close().build();
            DocumentStream results = table.find(condition);
            int nresults = 0;
            for (Document record : results) {
                ++nresults;
            }
            Assert.assertEquals((long)nresults, (long)2L);
        }
    }

    @Test
    public void test26338_ascii() throws Exception {
        String tableName = "testBug26338-ascii-TestMapRDBWithCluster";
        Table table = DBTests.createOrReplaceTable(tableName);
        table.setOption(Table.TableOption.BUFFERWRITE, false);
        Document r1 = MapRDB.newDocument();
        r1.set("v", 1);
        table.insertOrReplace("a", r1);
        Document r2 = MapRDB.newDocument();
        r2.set("v", 2);
        table.insertOrReplace("b", r2);
        Document r3 = MapRDB.newDocument();
        r3.set("v", 3);
        table.insertOrReplace("c", r3);
        Document r4 = MapRDB.newDocument();
        r4.set("v", 4);
        table.insertOrReplace("cc", r4);
        Document r5 = MapRDB.newDocument();
        r4.set("v", 5);
        table.insertOrReplace("bd", r5);
        Document r6 = MapRDB.newDocument();
        r6.set("v", 6);
        table.insertOrReplace("cc0", r5);
        table.flush();
        QueryCondition condition = MapRDB.newCondition().or().is("_id", QueryCondition.Op.EQUAL, "a").is("_id", QueryCondition.Op.EQUAL, "b").is("_id", QueryCondition.Op.EQUAL, "c").is("_id", QueryCondition.Op.EQUAL, "cc").close().build();
        DocumentStream results = table.find(condition);
        int nresults = 0;
        for (Document record : results) {
            switch (++nresults) {
                case 1: {
                    Assert.assertEquals((Object)record.getIdString(), (Object)"a");
                    Assert.assertEquals((long)record.getInt("v"), (long)1L);
                    break;
                }
                case 2: {
                    Assert.assertEquals((Object)record.getIdString(), (Object)"b");
                    Assert.assertEquals((long)record.getInt("v"), (long)2L);
                    break;
                }
                case 3: {
                    Assert.assertEquals((Object)record.getIdString(), (Object)"c");
                    Assert.assertEquals((long)record.getInt("v"), (long)3L);
                    break;
                }
                case 4: {
                    Assert.assertEquals((Object)record.getIdString(), (Object)"cc");
                    Assert.assertEquals((long)record.getInt("v"), (long)4L);
                }
            }
        }
        Assert.assertEquals((long)nresults, (long)4L);
        table.close();
    }

    @Test
    public void test26338_binary() throws Exception {
        String tableName = "testBug26338-binary-TestMapRDBWithCluster";
        Table table = DBTests.createOrReplaceTable(tableName);
        table.setOption(Table.TableOption.BUFFERWRITE, false);
        ByteBuffer id1 = ByteBuffer.allocate(4);
        id1.put((byte)12).put((byte)13).put((byte)14).put((byte)15);
        id1.rewind();
        Document r1 = MapRDB.newDocument();
        r1.set("v", 1);
        table.insertOrReplace(id1, r1);
        ByteBuffer id2 = ByteBuffer.allocate(4);
        id2.put((byte)12).put((byte)13).put((byte)14).put((byte)17);
        id2.rewind();
        Document r2 = MapRDB.newDocument();
        r2.set("v", 2);
        table.insertOrReplace(id2, r2);
        ByteBuffer id3 = ByteBuffer.allocate(4);
        id3.put((byte)12).put((byte)13).put((byte)14).put((byte)19);
        id3.rewind();
        Document r3 = MapRDB.newDocument();
        r3.set("v", 3);
        table.insertOrReplace(id3, r3);
        ByteBuffer id4 = ByteBuffer.allocate(4);
        id4.put((byte)12).put((byte)13).put((byte)14).put((byte)-1);
        id4.rewind();
        Document r4 = MapRDB.newDocument();
        r4.set("v", 4);
        table.insertOrReplace(id4, r4);
        ByteBuffer id5 = ByteBuffer.allocate(5);
        id5.put((byte)12).put((byte)13).put((byte)14).put((byte)-1).put((byte)0);
        id5.rewind();
        Document r5 = MapRDB.newDocument();
        r5.set("e", 5);
        table.insertOrReplace(id5, r5);
        ByteBuffer id6 = ByteBuffer.allocate(4);
        id6.put((byte)12).put((byte)13).put((byte)14).put((byte)18);
        id6.rewind();
        Document r6 = MapRDB.newDocument();
        r6.set("v", 6);
        table.insertOrReplace(id6, r6);
        table.flush();
        QueryCondition condition = MapRDB.newCondition().or().is("_id", QueryCondition.Op.EQUAL, id1).is("_id", QueryCondition.Op.EQUAL, id2).is("_id", QueryCondition.Op.EQUAL, id3).is("_id", QueryCondition.Op.EQUAL, id4).close().build();
        DocumentStream results = table.find(condition);
        int nresults = 0;
        for (Document record : results) {
            switch (++nresults) {
                case 1: {
                    Assert.assertEquals((long)record.getInt("v"), (long)1L);
                    break;
                }
                case 2: {
                    Assert.assertEquals((long)record.getInt("v"), (long)2L);
                    break;
                }
                case 3: {
                    Assert.assertEquals((long)record.getInt("v"), (long)3L);
                    break;
                }
                case 4: {
                    Assert.assertEquals((long)record.getInt("v"), (long)4L);
                }
            }
        }
        Assert.assertEquals((long)nresults, (long)4L);
        table.close();
    }

    public static void main(String[] args) throws Exception {
        _logger.info("Testing");
        TestMapRDBWithCluster t = new TestMapRDBWithCluster();
        t.testMapRDB();
        t.testMapRDBWithProjectionAndDeletes();
    }

    class myOpListener
    implements OpListener {
        myOpListener() {
        }

        public void onSuccess(Document record) {
            if (record != null) {
                _logger.info("Async read success: " + ((DBDocumentImpl)record).getIdAsString());
                ++TestMapRDBWithCluster.this.numAsyncSucc;
            } else {
                _logger.info("Async read: no record found");
                ++TestMapRDBWithCluster.this.numAsyncFail;
            }
        }

        public void onFailure(Exception e) {
            _logger.info("Async read fail : " + e.getMessage());
            ++TestMapRDBWithCluster.this.numAsyncFail;
        }
    }
}

