/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.tests.audit;

import com.mapr.db.MapRDB;
import com.mapr.db.Table;
import com.mapr.db.tests.utils.DBTests;
import com.mapr.fs.proto.Dbserver;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.IntegrationTest;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;
import org.ojai.DocumentStream;
import org.ojai.json.Json;
import org.ojai.store.DocumentMutation;
import org.ojai.store.QueryCondition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={IntegrationTest.class})
public class TestJSONAuditSupportWithCluster
extends BaseTest {
    private static final Logger _logger = LoggerFactory.getLogger(TestJSONAuditSupportWithCluster.class);
    private static final String TABLE_NAME = "testtable-TestJSONAuditSupport";
    private static Table table;
    private static Path tablePath;
    private static String nodeName;
    private static int AUDIT_FLUSH_SLEEP;

    @Before
    public void setupTestJSONAuditSupportWithCluster() throws Exception {
        try {
            table = DBTests.createOrReplaceTable(TABLE_NAME);
            table.setOption(Table.TableOption.BUFFERWRITE, false);
            table.setOption(Table.TableOption.EXCLUDEID, true);
            nodeName = this.getHostName();
            System.out.println("Nodename: " + nodeName);
        }
        catch (Exception e) {
            _logger.info("Failed to create a new table '{}'.", (Object)tablePath);
            throw e;
        }
        String cmd = "hadoop fs -rm /var/mapr/local/" + nodeName + "/audit/5660/DBAudit*";
        String output = DBTests.ExecuteShellCmd(cmd);
    }

    @After
    public void cleanupTestJSONAuditSupportWithCluster() throws Exception {
        if (table != null) {
            table.close();
        }
    }

    public String getHostName() throws UnknownHostException {
        Map<String, String> env = System.getenv();
        if (env.containsKey("COMPUTERNAME")) {
            return env.get("COMPUTERNAME");
        }
        if (env.containsKey("HOSTNAME")) {
            return env.get("HOSTNAME");
        }
        return InetAddress.getLocalHost().getCanonicalHostName();
    }

    private void flushAuditLogs() throws Exception {
        String cmd = "/opt/mapr/server/mrconfig -h " + this.getHostName() + " audit setaudittestparams 1";
        DBTests.ExecuteShellCmd(cmd);
        Thread.sleep(AUDIT_FLUSH_SLEEP);
    }

    @Test
    public void testJSONAuditPutNoError() throws Exception {
        String mcfTableName = "test_json_multicf";
        Path mcfTablePath = DBTests.getTablePath(mcfTableName);
        Table mcfTable = null;
        HashMap<String, String> cfMap = new HashMap<String, String>();
        cfMap.put("cf1", "a.b");
        cfMap.put("cf2", "x.y");
        cfMap.put("cf3", "x.y.z");
        try {
            mcfTable = DBTests.createOrReplaceTable(mcfTableName, cfMap);
        }
        catch (Exception e) {
            _logger.error("Failed to create table " + mcfTablePath);
            throw e;
        }
        DBTests.EnableJSONTableAuditing(mcfTablePath.toString());
        Document putRec = MapRDB.newDocument();
        putRec.set("a.b.c", "Value1").set("a.b.d", 15).set("c.d", "Value2").set("x.y.z.a", "Value3").set("x.y.w", 20).set("x.y.a", true).setArray("x.y.b", new Object[]{1, 2, 3});
        mcfTable.insertOrReplace("r1", putRec);
        mcfTable.flush();
        System.out.println("Put r1 succeeded");
        this.flushAuditLogs();
        String cmd = "hadoop fs -cat /var/mapr/local/" + nodeName + "/audit/5660/DBAudit*.json";
        String output = DBTests.ExecuteShellCmd(cmd);
        String[] auditDocs = output.split("\n");
        ArrayList<Document> auditList = new ArrayList<Document>();
        for (String auditDoc : auditDocs) {
            Document auditDocument = Json.newDocument((String)auditDoc);
            if (!auditDocument.getString("operation").equals("DB_PUT")) continue;
            auditList.add(auditDocument);
        }
        int cnt = 0;
        block15: for (Document d : auditList) {
            String cf = d.getString("columnFamily");
            String qual = d.getString("columnQualifier");
            switch (cf) {
                case "cf1": {
                    assert (qual.equals("c") || qual.equals("d"));
                    ++cnt;
                    continue block15;
                }
                case "cf2": {
                    assert (qual.equals("w") || qual.equals("a") || qual.equals("b[]"));
                    ++cnt;
                    continue block15;
                }
                case "cf3": {
                    assert (qual.equals("a"));
                    ++cnt;
                    continue block15;
                }
                case "default": {
                    assert (qual.equals("c.d"));
                    ++cnt;
                    continue block15;
                }
            }
            _logger.error("Invalid CF: " + cf + ", invalid Qualifier: " + qual);
            assert (false);
        }
        assert (cnt == 7);
    }

    @Test
    public void testJSONAuditPutWithError() throws Exception {
        String mcfTableName = "test_json_multicf";
        Path mcfTablePath = DBTests.getTablePath(mcfTableName);
        Table mcfTable = null;
        HashMap<String, String> cfMap = new HashMap<String, String>();
        cfMap.put("cf1", "a.b");
        cfMap.put("cf2", "x.y");
        cfMap.put("cf3", "x.y.z");
        try {
            mcfTable = DBTests.createOrReplaceTable(mcfTableName, cfMap);
        }
        catch (Exception e) {
            _logger.error("Failed to create table " + mcfTablePath);
            throw e;
        }
        DBTests.EnableJSONTableAuditing(mcfTablePath.toString());
        DBTests.setCFAce(mcfTablePath, "default", Dbserver.DBAccessType.FamilyWriteData, "!u:root");
        DBTests.setFieldAce(mcfTablePath, "cf1", "d", Dbserver.DBAccessType.ColumnWriteData, "!u:root");
        Document putRec = MapRDB.newDocument();
        putRec.set("c.d", "Value2").set("x.y.z.a", "Value3").set("x.y.w", 20).set("x.y.a", true);
        try {
            mcfTable.insertOrReplace("r1", putRec);
            mcfTable.flush();
            Assert.fail();
        }
        catch (Exception e) {
            _logger.error("Put failed: " + e.getMessage());
        }
        DocumentMutation mutRec = MapRDB.newMutation();
        mutRec.setOrReplace("a.b.c", 15).setOrReplace("a.b.d", "Value1");
        try {
            mcfTable.update("r1", mutRec);
            mcfTable.flush();
            Assert.fail();
        }
        catch (Exception e) {
            _logger.error("Update failed: " + e.getMessage());
        }
        this.flushAuditLogs();
        String cmd = "hadoop fs -cat /var/mapr/local/" + nodeName + "/audit/5660/DBAudit*.json";
        String output = DBTests.ExecuteShellCmd(cmd);
        String[] auditDocs = output.split("\n");
        ArrayList<Document> auditList = new ArrayList<Document>();
        for (String auditDoc : auditDocs) {
            Document auditDocument = Json.newDocument((String)auditDoc);
            if (!auditDocument.getString("operation").equals("DB_PUT")) continue;
            auditList.add(auditDocument);
        }
        int cnt = 0;
        for (Document d : auditList) {
            String cf = d.getString("columnFamily");
            String qual = d.getString("columnQualifier");
            Double status = d.getDouble("status");
            switch (cf) {
                case "cf1": {
                    if (!qual.equals("d")) break;
                    assert (status == 13.0);
                    ++cnt;
                    break;
                }
                case "default": {
                    Assert.assertNull((Object)qual);
                    assert (status == 13.0);
                    ++cnt;
                    break;
                }
            }
        }
        assert (cnt == 2);
    }

    @Test
    public void testJSONAuditGetNoProjection() throws Exception {
        String mcfTableName = "test_json_multicf";
        Path mcfTablePath = DBTests.getTablePath(mcfTableName);
        Table mcfTable = null;
        HashMap<String, String> cfMap = new HashMap<String, String>();
        cfMap.put("cf1", "a.b");
        cfMap.put("cf2", "x.y");
        cfMap.put("cf3", "x.y.z");
        try {
            mcfTable = DBTests.createOrReplaceTable(mcfTableName, cfMap);
        }
        catch (Exception e) {
            _logger.error("Failed to create table " + mcfTablePath);
            throw e;
        }
        DBTests.EnableJSONTableAuditing(mcfTablePath.toString());
        Document putRec = MapRDB.newDocument();
        putRec.set("a.b.c", "Value1").set("a.b.d", 15).set("c.d", "Value2").set("x.y.z.a", "Value3").set("x.y.w", 20).set("x.y.a", true).setArray("x.y.b", new Object[]{1, 2, 3});
        mcfTable.insertOrReplace("r1", putRec);
        mcfTable.flush();
        System.out.println("Put r1 succeeded");
        Document readRecord = null;
        readRecord = mcfTable.findById("r1");
        Assert.assertNotNull((Object)readRecord);
        this.flushAuditLogs();
        String cmd = "hadoop fs -cat /var/mapr/local/" + nodeName + "/audit/5660/DBAudit*.json";
        String output = DBTests.ExecuteShellCmd(cmd);
        String[] auditDocs = output.split("\n");
        ArrayList<Document> auditList = new ArrayList<Document>();
        for (String auditDoc : auditDocs) {
            Document auditDocument = Json.newDocument((String)auditDoc);
            if (!auditDocument.getString("operation").equals("DB_GET")) continue;
            auditList.add(auditDocument);
        }
        for (Document d : auditList) {
            String cf = d.getString("columnFamily");
            String qual = d.getString("columnQualifier");
            Assert.assertNull((Object)cf);
            Assert.assertNull((Object)qual);
        }
        Assert.assertEquals((long)1L, (long)auditList.size());
    }

    @Test
    public void testJSONAuditGetWithProjection() throws Exception {
        String mcfTableName = "test_json_multicf";
        Path mcfTablePath = DBTests.getTablePath(mcfTableName);
        Table mcfTable = null;
        HashMap<String, String> cfMap = new HashMap<String, String>();
        cfMap.put("cf1", "a.b");
        cfMap.put("cf2", "x.y");
        cfMap.put("cf3", "x.y.z");
        try {
            mcfTable = DBTests.createOrReplaceTable(mcfTableName, cfMap);
        }
        catch (Exception e) {
            _logger.error("Failed to create table " + mcfTablePath);
            throw e;
        }
        DBTests.EnableJSONTableAuditing(mcfTablePath.toString());
        Document putRec = MapRDB.newDocument();
        putRec.set("a.b.c", "Value1").set("a.b.d", 15).set("c.d", "Value2").set("x.y.z.a", "Value3").set("x.y.w", 20).set("x.y.a", true).setArray("x.y.b", new Object[]{1, 2, 3});
        mcfTable.insertOrReplace("r1", putRec);
        mcfTable.flush();
        System.out.println("Put r1 succeeded");
        Document readRecord = null;
        readRecord = mcfTable.findById("r1", new String[]{"a.b", "x.y.z.a", "x.y.b[1]"});
        this.flushAuditLogs();
        String cmd = "hadoop fs -cat /var/mapr/local/" + nodeName + "/audit/5660/DBAudit*.json";
        String output = DBTests.ExecuteShellCmd(cmd);
        String[] auditDocs = output.split("\n");
        ArrayList<Document> auditList = new ArrayList<Document>();
        for (String auditDoc : auditDocs) {
            Document auditDocument = Json.newDocument((String)auditDoc);
            if (!auditDocument.getString("operation").equals("DB_GET")) continue;
            auditList.add(auditDocument);
        }
        int cnt = 0;
        block14: for (Document d : auditList) {
            String cf = d.getString("columnFamily");
            String qual = d.getString("columnQualifier");
            switch (cf) {
                case "cf1": {
                    Assert.assertNull((Object)qual);
                    ++cnt;
                    continue block14;
                }
                case "cf2": {
                    Assert.assertEquals((Object)"b[1]", (Object)qual);
                    ++cnt;
                    continue block14;
                }
                case "cf3": {
                    Assert.assertEquals((Object)"a", (Object)qual);
                    ++cnt;
                    continue block14;
                }
            }
            _logger.error("Invalid CF: " + cf + ", invalid Qualifier: " + qual);
            assert (false);
        }
        assert (cnt == 3);
    }

    @Test
    public void testJSONAuditGetNoProjectionWithError() throws Exception {
        String mcfTableName = "test_json_multicf";
        Path mcfTablePath = DBTests.getTablePath(mcfTableName);
        Table mcfTable = null;
        HashMap<String, String> cfMap = new HashMap<String, String>();
        cfMap.put("cf1", "a.b");
        cfMap.put("cf2", "x.y");
        cfMap.put("cf3", "x.y.z");
        try {
            mcfTable = DBTests.createOrReplaceTable(mcfTableName, cfMap);
        }
        catch (Exception e) {
            _logger.error("Failed to create table " + mcfTablePath);
            throw e;
        }
        DBTests.EnableJSONTableAuditing(mcfTablePath.toString());
        DBTests.setCFAce(mcfTablePath, "cf1", Dbserver.DBAccessType.FamilyReadData, "!u:root");
        DBTests.setFieldAce(mcfTablePath, "cf3", "a", Dbserver.DBAccessType.ColumnReadData, "!u:root");
        Document putRec = MapRDB.newDocument();
        putRec.set("a.b.c", "Value1").set("a.b.d", 15).set("c.d", "Value2").set("x.y.z.a", "Value3").set("x.y.w", 20).set("x.y.a", true).setArray("x.y.b", new Object[]{1, 2, 3});
        mcfTable.insertOrReplace("r1", putRec);
        mcfTable.flush();
        System.out.println("Put r1 succeeded");
        Document readRecord = null;
        readRecord = mcfTable.findById("r1");
        this.flushAuditLogs();
        Assert.assertNotNull((Object)readRecord);
        Assert.assertNull((Object)readRecord.getValue("a.b"));
        Assert.assertNull((Object)readRecord.getString("x.y.z.a"));
        Assert.assertEquals((long)20L, (long)readRecord.getInt("x.y.w"));
        String cmd = "hadoop fs -cat /var/mapr/local/" + nodeName + "/audit/5660/DBAudit*.json";
        String output = DBTests.ExecuteShellCmd(cmd);
        String[] auditDocs = output.split("\n");
        ArrayList<Document> auditList = new ArrayList<Document>();
        for (String auditDoc : auditDocs) {
            Document auditDocument = Json.newDocument((String)auditDoc);
            if (!auditDocument.getString("operation").equals("DB_GET")) continue;
            auditList.add(auditDocument);
        }
        for (Document d : auditList) {
            String cf = d.getString("columnFamily");
            String qual = d.getString("columnQualifier");
            double status = d.getDouble("status");
            Assert.assertNull((Object)cf);
            Assert.assertNull((Object)qual);
            Assert.assertEquals((String)"status != 0", (double)status, (double)0.0, (double)0.0);
        }
        Assert.assertEquals((long)1L, (long)auditList.size());
    }

    @Test
    public void testJSONAuditGetWithProjectionWithError() throws Exception {
        String mcfTableName = "test_json_multicf";
        Path mcfTablePath = DBTests.getTablePath(mcfTableName);
        Table mcfTable = null;
        HashMap<String, String> cfMap = new HashMap<String, String>();
        cfMap.put("cf1", "a.b");
        cfMap.put("cf2", "x.y");
        cfMap.put("cf3", "x.y.z");
        try {
            mcfTable = DBTests.createOrReplaceTable(mcfTableName, cfMap);
        }
        catch (Exception e) {
            _logger.error("Failed to create table " + mcfTablePath);
            throw e;
        }
        DBTests.EnableJSONTableAuditing(mcfTablePath.toString());
        DBTests.setCFAce(mcfTablePath, "cf1", Dbserver.DBAccessType.FamilyReadData, "!u:root");
        DBTests.setFieldAce(mcfTablePath, "cf3", "a", Dbserver.DBAccessType.ColumnReadData, "!u:root");
        Document putRec = MapRDB.newDocument();
        putRec.set("a.b.c.d.e", "Value1").set("a.b.d", 15).set("c.d", "Value2").set("x.y.z.a.b.c", "Value3").set("x.y.w", 20).set("x.y.a", true).setArray("x.y.b", new Object[]{1, 2, 3});
        mcfTable.insertOrReplace("r1", putRec);
        mcfTable.flush();
        System.out.println("Put r1 succeeded");
        Document readRecord = null;
        readRecord = mcfTable.findById("r1", new String[]{"a.b.c.d.e", "x.y.a", "x.y.z.a.b.c"});
        this.flushAuditLogs();
        Assert.assertNotNull((Object)readRecord);
        Assert.assertNull((Object)readRecord.getValue("a.b.c.d.e"));
        Assert.assertTrue((boolean)readRecord.getBoolean("x.y.a"));
        Assert.assertNull((Object)readRecord.getValue("x.y.z.a.b.c"));
        String cmd = "hadoop fs -cat /var/mapr/local/" + nodeName + "/audit/5660/DBAudit*.json";
        String output = DBTests.ExecuteShellCmd(cmd);
        String[] auditDocs = output.split("\n");
        ArrayList<Document> auditList = new ArrayList<Document>();
        for (String auditDoc : auditDocs) {
            Document auditDocument = Json.newDocument((String)auditDoc);
            if (!auditDocument.getString("operation").equals("DB_GET")) continue;
            auditList.add(auditDocument);
        }
        block13: for (Document d : auditList) {
            String cf = d.getString("columnFamily");
            String qual = d.getString("columnQualifier");
            double status = d.getDouble("status");
            switch (cf) {
                case "cf1": {
                    Assert.assertNull((Object)qual);
                    Assert.assertEquals((String)"status != 13", (double)status, (double)13.0, (double)0.0);
                    continue block13;
                }
                case "cf3": {
                    Assert.assertEquals((Object)"a.b.c", (Object)qual);
                    Assert.assertEquals((String)"status != 13", (double)status, (double)13.0, (double)0.0);
                    continue block13;
                }
                case "cf2": {
                    Assert.assertEquals((Object)"a", (Object)qual);
                    Assert.assertEquals((String)"status != 0", (double)status, (double)0.0, (double)0.0);
                    continue block13;
                }
            }
            assert ("Invalid CF" == null);
        }
        Assert.assertEquals((long)3L, (long)auditList.size());
    }

    @Test
    public void testJSONAuditScanNoProjection() throws Exception {
        String mcfTableName = "test_json_multicf";
        Path mcfTablePath = DBTests.getTablePath(mcfTableName);
        Table mcfTable = null;
        HashMap<String, String> cfMap = new HashMap<String, String>();
        cfMap.put("cf1", "a.b");
        cfMap.put("cf2", "x.y");
        cfMap.put("cf3", "x.y.z");
        try {
            mcfTable = DBTests.createOrReplaceTable(mcfTableName, cfMap);
        }
        catch (Exception e) {
            _logger.error("Failed to create table " + mcfTablePath);
            throw e;
        }
        DBTests.EnableJSONTableAuditing(mcfTablePath.toString());
        Document putRec = MapRDB.newDocument();
        putRec.set("a.b.c", "Value1").set("a.b.d", 15).set("c.d", "Value2").set("x.y.z.a", "Value3").set("x.y.w", 20).set("x.y.a", true).setArray("x.y.b", new Object[]{1, 2, 3});
        mcfTable.insertOrReplace("r1", putRec);
        mcfTable.flush();
        System.out.println("Put r1 succeeded");
        DocumentStream ds = null;
        Iterator itrs = null;
        ds = mcfTable.find();
        itrs = ds.iterator();
        assert (itrs.hasNext());
        this.flushAuditLogs();
        String cmd = "hadoop fs -cat /var/mapr/local/" + nodeName + "/audit/5660/DBAudit*.json";
        String output = DBTests.ExecuteShellCmd(cmd);
        String[] auditDocs = output.split("\n");
        ArrayList<Document> auditList = new ArrayList<Document>();
        for (String auditDoc : auditDocs) {
            Document auditDocument = Json.newDocument((String)auditDoc);
            if (!auditDocument.getString("operation").equals("DB_SCAN")) continue;
            auditList.add(auditDocument);
        }
        for (Document d : auditList) {
            String cf = d.getString("columnFamily");
            String qual = d.getString("columnQualifier");
            Assert.assertNull((Object)qual);
            Assert.assertNull((Object)cf);
        }
        Assert.assertEquals((long)1L, (long)auditList.size());
    }

    @Test
    public void testJSONAuditScanNoProjectionWithError() throws Exception {
        String mcfTableName = "test_json_multicf";
        Path mcfTablePath = DBTests.getTablePath(mcfTableName);
        Table mcfTable = null;
        HashMap<String, String> cfMap = new HashMap<String, String>();
        cfMap.put("cf1", "a.b");
        cfMap.put("cf2", "x.y");
        cfMap.put("cf3", "x.y.z");
        try {
            mcfTable = DBTests.createOrReplaceTable(mcfTableName, cfMap);
        }
        catch (Exception e) {
            _logger.error("Failed to create table " + mcfTablePath);
            throw e;
        }
        DBTests.EnableJSONTableAuditing(mcfTablePath.toString());
        Document putRec = MapRDB.newDocument();
        putRec.set("a.b.c", "Value1").set("a.b.d", 15).set("c.d", "Value2").set("x.y.z.a", "Value3").set("x.y.w", 20).set("x.y.a", true).setArray("x.y.b", new Object[]{1, 2, 3});
        mcfTable.insertOrReplace("r1", putRec);
        mcfTable.flush();
        System.out.println("Put r1 succeeded");
        DocumentStream ds = null;
        Iterator itrs = null;
        ds = mcfTable.find();
        itrs = ds.iterator();
        this.flushAuditLogs();
        while (itrs.hasNext()) {
            Document readRecord = (Document)itrs.next();
            Assert.assertEquals((Object)"Value1", (Object)readRecord.getString("a.b.c"));
            Assert.assertEquals((long)20L, (long)readRecord.getInt("x.y.w"));
            Assert.assertEquals((Object)"Value3", (Object)readRecord.getString("x.y.z.a"));
            Assert.assertEquals((Object)"Value2", (Object)readRecord.getString("c.d"));
        }
        String cmd = "hadoop fs -cat /var/mapr/local/" + nodeName + "/audit/5660/DBAudit*.json";
        String output = DBTests.ExecuteShellCmd(cmd);
        String[] auditDocs = output.split("\n");
        ArrayList<Document> auditList = new ArrayList<Document>();
        for (String auditDoc : auditDocs) {
            Document auditDocument = Json.newDocument((String)auditDoc);
            if (!auditDocument.getString("operation").equals("DB_SCAN")) continue;
            auditList.add(auditDocument);
        }
        for (Document d : auditList) {
            String cf = d.getString("columnFamily");
            String qual = d.getString("columnQualifier");
            Double status = d.getDouble("status");
            Assert.assertNull((Object)qual);
            Assert.assertNull((Object)cf);
            Assert.assertEquals((String)"status != 0", (double)status, (double)0.0, (double)0.0);
        }
        Assert.assertEquals((long)1L, (long)auditList.size());
    }

    @Test
    public void testJSONAuditScanWithProjectionWithError() throws Exception {
        String mcfTableName = "test_json_multicf";
        Path mcfTablePath = DBTests.getTablePath(mcfTableName);
        Table mcfTable = null;
        HashMap<String, String> cfMap = new HashMap<String, String>();
        cfMap.put("cf1", "a.b");
        cfMap.put("cf2", "x.y");
        cfMap.put("cf3", "x.y.z");
        try {
            mcfTable = DBTests.createOrReplaceTable(mcfTableName, cfMap);
        }
        catch (Exception e) {
            _logger.error("Failed to create table " + mcfTablePath);
            throw e;
        }
        DBTests.EnableJSONTableAuditing(mcfTablePath.toString());
        DBTests.setCFAce(mcfTablePath, "cf1", Dbserver.DBAccessType.FamilyReadData, "!u:root");
        DBTests.setFieldAce(mcfTablePath, "cf2", "w", Dbserver.DBAccessType.ColumnReadData, "!u:root");
        Document putRec = MapRDB.newDocument();
        putRec.set("a.b.c", "Value1").set("a.b.d", 15).set("c.d", "Value2").set("x.y.z.a", "Value3").set("x.y.w.a.b.c", 20).set("x.y.a", true).setArray("x.y.b", new Object[]{1, 2, 3});
        mcfTable.insertOrReplace("r1", putRec);
        mcfTable.flush();
        System.out.println("Put r1 succeeded");
        DocumentStream ds = null;
        Iterator itrs = null;
        ds = mcfTable.find(new String[]{"a.b.c", "x.y.w.a.b.c", "x.y.z", "c.d"});
        itrs = ds.iterator();
        this.flushAuditLogs();
        while (itrs.hasNext()) {
            Document readRecord = (Document)itrs.next();
            Assert.assertNull((Object)readRecord.getString("a.b.c"));
            Assert.assertNull((Object)readRecord.getValue("x.y.w.a.b.c"));
        }
        String cmd = "hadoop fs -cat /var/mapr/local/" + nodeName + "/audit/5660/DBAudit*.json";
        String output = DBTests.ExecuteShellCmd(cmd);
        String[] auditDocs = output.split("\n");
        ArrayList<Document> auditList = new ArrayList<Document>();
        for (String auditDoc : auditDocs) {
            Document auditDocument = Json.newDocument((String)auditDoc);
            if (!auditDocument.getString("operation").equals("DB_SCAN")) continue;
            auditList.add(auditDocument);
        }
        int cnt = 0;
        block16: for (Document d : auditList) {
            String cf = d.getString("columnFamily");
            String qual = d.getString("columnQualifier");
            Double status = d.getDouble("status");
            switch (cf) {
                case "cf1": {
                    Assert.assertEquals((String)"status != 13", (double)status, (double)13.0, (double)0.0);
                    ++cnt;
                    continue block16;
                }
                case "cf2": {
                    Assert.assertEquals((Object)"w.a.b.c", (Object)qual);
                    Assert.assertEquals((String)"status != 13", (double)status, (double)13.0, (double)0.0);
                    ++cnt;
                    continue block16;
                }
                case "cf3": {
                    Assert.assertNull((Object)qual);
                    Assert.assertEquals((String)"status != 0", (double)status, (double)0.0, (double)0.0);
                    ++cnt;
                    continue block16;
                }
                case "default": {
                    Assert.assertEquals((Object)"c.d", (Object)qual);
                    Assert.assertEquals((String)"status != 0", (double)status, (double)0.0, (double)0.0);
                    ++cnt;
                    continue block16;
                }
            }
            assert ("Invalid CF" == null);
        }
        Assert.assertEquals((long)4L, (long)auditList.size());
    }

    @Test
    public void testJSONAuditScanWithProjection() throws Exception {
        String mcfTableName = "test_json_multicf";
        Path mcfTablePath = DBTests.getTablePath(mcfTableName);
        Table mcfTable = null;
        HashMap<String, String> cfMap = new HashMap<String, String>();
        cfMap.put("cf1", "a.b");
        cfMap.put("cf2", "x.y");
        cfMap.put("cf3", "x.y.z");
        try {
            mcfTable = DBTests.createOrReplaceTable(mcfTableName, cfMap);
        }
        catch (Exception e) {
            _logger.error("Failed to create table " + mcfTablePath);
            throw e;
        }
        DBTests.EnableJSONTableAuditing(mcfTablePath.toString());
        Document putRec = MapRDB.newDocument();
        putRec.set("a.b.c", "Value1").set("a.b.d", 15).set("c.d", "Value2").set("x.y.z.a", "Value3").set("x.y.w", 20).set("x.y.a", true).setArray("x.y.b", new Object[]{1, 2, 3});
        mcfTable.insertOrReplace("r1", putRec);
        mcfTable.flush();
        System.out.println("Put r1 succeeded");
        Document readRecord2 = null;
        DocumentStream ds = null;
        Iterator itrs = null;
        ds = mcfTable.find(new String[]{"a.b", "x.y.z.a", "x.y.b[2]"});
        for (Document readRecord2 : ds) {
            this.flushAuditLogs();
            String cmd = "hadoop fs -cat /var/mapr/local/" + nodeName + "/audit/5660/DBAudit*.json";
            String output = DBTests.ExecuteShellCmd(cmd);
            String[] auditDocs = output.split("\n");
            ArrayList<Document> auditList = new ArrayList<Document>();
            for (String auditDoc : auditDocs) {
                Document auditDocument = Json.newDocument((String)auditDoc);
                if (!auditDocument.getString("operation").equals("DB_SCAN")) continue;
                auditList.add(auditDocument);
            }
            int cnt = 0;
            block15: for (Document d : auditList) {
                String cf = d.getString("columnFamily");
                String qual = d.getString("columnQualifier");
                switch (cf) {
                    case "cf1": {
                        Assert.assertNull((Object)qual);
                        ++cnt;
                        continue block15;
                    }
                    case "cf2": {
                        Assert.assertEquals((Object)"b[2]", (Object)qual);
                        ++cnt;
                        continue block15;
                    }
                    case "cf3": {
                        assert (qual.equals("a"));
                        ++cnt;
                        continue block15;
                    }
                }
                _logger.error("Invalid CF: " + cf + ", invalid Qualifier: " + qual);
                assert (false);
            }
            assert (cnt == 3);
        }
    }

    @Test
    public void testJSONAuditUpdateAndGetNoError() throws Exception {
        String mcfTableName = "test_json_multicf";
        Path mcfTablePath = DBTests.getTablePath(mcfTableName);
        Table mcfTable = null;
        HashMap<String, String> cfMap = new HashMap<String, String>();
        cfMap.put("cf1", "a.b");
        cfMap.put("cf2", "x.y");
        cfMap.put("cf3", "x.y.z");
        try {
            mcfTable = DBTests.createOrReplaceTable(mcfTableName, cfMap);
        }
        catch (Exception e) {
            _logger.error("Failed to create table " + mcfTablePath);
            throw e;
        }
        DBTests.EnableJSONTableAuditing(mcfTablePath.toString());
        DocumentMutation dm = MapRDB.newMutation();
        dm.append("a.b.c", "Value1");
        try {
            mcfTable.update("r1", dm);
            mcfTable.flush();
        }
        catch (Exception e) {
            _logger.error("Failed to append 'a.b.c': " + e.getMessage());
            throw e;
        }
        dm = MapRDB.newMutation();
        dm.increment("x.y.a", 20);
        try {
            mcfTable.update("r1", dm);
            mcfTable.flush();
        }
        catch (Exception e) {
            _logger.error("Failed to increment 'a.b.d': " + e.getMessage());
            throw e;
        }
        dm = MapRDB.newMutation();
        dm.setOrReplace("a.b.d", true).increment("x.y.w", 5);
        try {
            mcfTable.update("r1", dm);
            mcfTable.flush();
        }
        catch (Exception e) {
            _logger.debug("Failed to update multi-CF record with a.b.c and x.y.w: " + e.getMessage());
            throw e;
        }
        this.flushAuditLogs();
        String cmd = "hadoop fs -cat /var/mapr/local/" + nodeName + "/audit/5660/DBAudit*.json";
        String output = DBTests.ExecuteShellCmd(cmd);
        String[] auditDocs = output.split("\n");
        ArrayList<Document> auditList = new ArrayList<Document>();
        for (String auditDoc : auditDocs) {
            Document auditDocument = Json.newDocument((String)auditDoc);
            if (!auditDocument.getString("operation").equals("DB_PUT")) continue;
            auditList.add(auditDocument);
        }
        int cnt = 0;
        block19: for (Document d : auditList) {
            String cf = d.getString("columnFamily");
            String qual = d.getString("columnQualifier");
            switch (cf) {
                case "cf1": {
                    assert (qual.equals("c") || qual.equals("d"));
                    ++cnt;
                    continue block19;
                }
                case "cf2": {
                    assert (qual.equals("w") || qual.equals("a") || qual.equals("b[]"));
                    ++cnt;
                    continue block19;
                }
            }
            _logger.error("Invalid CF: " + cf + ", invalid Qualifier: " + qual);
            assert (false);
        }
        assert (cnt == 4);
    }

    @Test
    public void testJSONAuditUpdateAndGetWithError() throws Exception {
        Double status;
        String qual;
        String cf;
        String mcfTableName = "test_json_multicf";
        Path mcfTablePath = DBTests.getTablePath(mcfTableName);
        Table mcfTable = null;
        HashMap<String, String> cfMap = new HashMap<String, String>();
        cfMap.put("cf1", "a.b");
        cfMap.put("cf2", "x.y");
        cfMap.put("cf3", "x.y.z");
        try {
            mcfTable = DBTests.createOrReplaceTable(mcfTableName, cfMap);
        }
        catch (Exception e) {
            _logger.error("Failed to create table " + mcfTablePath);
            throw e;
        }
        Document putRec = MapRDB.newDocument();
        putRec.set("a.b.c", "Value1").set("a.b.d", 15).set("c.d", "Value2").set("x.y.z.a", "Value3").set("x.y.w", 20).set("x.y.a", true);
        mcfTable.insertOrReplace("r1", putRec);
        System.out.println("Put r1 succeeded");
        mcfTable.flush();
        DBTests.setCFAce(mcfTablePath, "default", Dbserver.DBAccessType.FamilyReadData, "!u:root");
        DBTests.setCFAce(mcfTablePath, "cf1", Dbserver.DBAccessType.FamilyReadData, "u:root");
        DBTests.setCFAce(mcfTablePath, "cf1", Dbserver.DBAccessType.FamilyWriteData, "u:root");
        DBTests.setFieldAce(mcfTablePath, "cf1", "d", Dbserver.DBAccessType.ColumnWriteData, "!u:root");
        DBTests.setCFAce(mcfTablePath, "cf2", Dbserver.DBAccessType.FamilyReadData, "!u:root");
        DBTests.setCFAce(mcfTablePath, "cf3", Dbserver.DBAccessType.FamilyWriteData, "!u:root");
        DBTests.EnableJSONTableAuditing(mcfTablePath.toString());
        String delCmd = "hadoop fs -rm /var/mapr/local/" + nodeName + "/audit/5660/DBAudit*";
        String delOut = DBTests.ExecuteShellCmd(delCmd);
        DocumentMutation dm = null;
        dm = MapRDB.newMutation();
        dm.append("c.d", "Value2");
        try {
            mcfTable.update("r1", dm);
            mcfTable.flush();
            Assert.fail();
        }
        catch (Exception e) {
            _logger.info("Failed to append to c.d : " + e.getMessage(), (Throwable)e);
        }
        dm = MapRDB.newMutation();
        dm.increment("a.b.d", 5);
        try {
            mcfTable.update("r1", dm);
            mcfTable.flush();
            Assert.fail();
        }
        catch (Exception e) {
            _logger.info("Failed to increment a.b.d : " + e.getMessage(), (Throwable)e);
        }
        dm = MapRDB.newMutation();
        dm.increment("x.y.w", 5);
        QueryCondition cond = MapRDB.newCondition().and().notExists("a.b.x").is("a.b.d", QueryCondition.Op.EQUAL, 15).close().build();
        try {
            mcfTable.checkAndMutate("r1", cond, dm);
            mcfTable.flush();
            Assert.fail();
        }
        catch (Exception e) {
            _logger.debug("Failed to increment a.b.d:" + e.getMessage(), (Throwable)e);
        }
        dm = MapRDB.newMutation();
        dm.append("x.y.z.a", "Value3");
        try {
            mcfTable.update("r1", dm);
            mcfTable.flush();
            Assert.fail();
        }
        catch (Exception e) {
            _logger.debug("Failed to append x.y.z.a: " + e.getMessage(), (Throwable)e);
        }
        this.flushAuditLogs();
        String cmd = "hadoop fs -cat /var/mapr/local/" + nodeName + "/audit/5660/DBAudit*.json";
        String output = DBTests.ExecuteShellCmd(cmd);
        String[] auditDocs = output.split("\n");
        ArrayList<Document> putList = new ArrayList<Document>();
        ArrayList<Document> getList = new ArrayList<Document>();
        for (String auditDoc : auditDocs) {
            Document auditDocument = Json.newDocument((String)auditDoc);
            if (auditDocument.getString("operation").equals("DB_PUT")) {
                putList.add(auditDocument);
                continue;
            }
            if (!auditDocument.getString("operation").equals("DB_GET")) continue;
            getList.add(auditDocument);
        }
        int cnt = 0;
        block35: for (Document d : putList) {
            cf = d.getString("columnFamily");
            qual = d.getString("columnQualifier");
            status = d.getDouble("status");
            if (cf == null) continue;
            switch (cf) {
                case "cf1": {
                    Assert.assertEquals((Object)"d", (Object)qual);
                    ++cnt;
                    continue block35;
                }
                case "cf2": {
                    continue block35;
                }
                case "cf3": {
                    ++cnt;
                    continue block35;
                }
                case "default": {
                    continue block35;
                }
            }
            _logger.error("Invalid CF: " + cf + ", invalid Qualifier: " + qual);
            assert (false);
        }
        assert (cnt == 2);
        cnt = 0;
        block36: for (Document d : getList) {
            cf = d.getString("columnFamily");
            qual = d.getString("columnQualifier");
            status = d.getDouble("status");
            switch (cf) {
                case "cf1": {
                    continue block36;
                }
                case "cf2": {
                    assert (status == 13.0);
                    ++cnt;
                    continue block36;
                }
                case "cf3": {
                    continue block36;
                }
                case "default": {
                    if (qual != null) continue block36;
                    assert (status == 13.0);
                    ++cnt;
                    continue block36;
                }
            }
            _logger.error("Invalid CF: " + cf + ", invalid Qualifier: " + qual);
            assert (false);
        }
        assert (cnt == 2);
    }

    static {
        tablePath = DBTests.getTablePath(TABLE_NAME);
        nodeName = null;
        AUDIT_FLUSH_SLEEP = 15000;
    }
}

