/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.rowcol;

import com.mapr.db.impl.Constants;
import com.mapr.db.impl.MapRDBTableImplHelper;
import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.db.rowcol.DBValueBuilderImpl;
import com.mapr.db.rowcol.InsertContext;
import com.mapr.db.rowcol.KeyValue;
import com.mapr.db.rowcol.MutationHelper;
import com.mapr.db.rowcol.RowcolCodec;
import com.mapr.db.rowcol.SerializationContext;
import com.mapr.db.rowcol.SerializedFamilyInfo;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.ojai.Document;
import org.ojai.FieldPath;
import org.ojai.Value;
import org.ojai.annotation.API;
import org.ojai.store.DocumentMutation;
import org.ojai.store.MutationOp;
import org.ojai.types.ODate;
import org.ojai.types.OInterval;
import org.ojai.types.OTime;
import org.ojai.types.OTimestamp;

@API.Internal
public class MutationImpl
implements DocumentMutation {
    private DBDocumentImpl record = new DBDocumentImpl();
    private boolean needsReadOnServer = false;
    private List<FieldPath> fields = new ArrayList<FieldPath>();

    @API.Internal
    public MutationImpl() {
    }

    private void checkForId(FieldPath path) {
        if ("_id".equals(path.getRootSegment().getNameSegment().getName())) {
            throw new UnsupportedOperationException("DocumentMutation can't be used to change _id");
        }
    }

    private MutationImpl setCommon(FieldPath path, KeyValue value) {
        this.checkForId(path);
        this.fields.add(path);
        MutationHelper.mutationCommon(InsertContext.OpType.SET, this.record, path, value);
        this.needsReadOnServer = true;
        return this;
    }

    private MutationImpl setOrReplaceCommon(FieldPath path, KeyValue value) {
        boolean containsArray = MutationHelper.mutationCommon(InsertContext.OpType.SET_OR_REPLACE, this.record, path, value);
        if (containsArray) {
            this.fields.add(path);
            this.needsReadOnServer = true;
        }
        return this;
    }

    private DocumentMutation appendCommon(FieldPath path, KeyValue value) {
        this.fields.add(path);
        MutationHelper.mutationCommon(InsertContext.OpType.APPEND, this.record, path, value);
        this.needsReadOnServer = true;
        return this;
    }

    private DocumentMutation mergeCommon(FieldPath path, KeyValue value) {
        this.fields.add(path);
        MutationHelper.mutationCommon(InsertContext.OpType.MERGE, this.record, path, value);
        this.needsReadOnServer = true;
        return this;
    }

    private MutationImpl incrementCommon(FieldPath path, KeyValue value) {
        this.fields.add(path);
        MutationHelper.mutationCommon(InsertContext.OpType.INCREMENT, this.record, path, value);
        this.needsReadOnServer = true;
        return this;
    }

    public DocumentMutation empty() {
        this.record.empty();
        this.needsReadOnServer = false;
        this.fields = new ArrayList<FieldPath>();
        return this;
    }

    public DocumentMutation setNull(String path) {
        return this.setNull(FieldPath.parseFrom((String)path));
    }

    public DocumentMutation setNull(FieldPath path) {
        return this.setCommon(path, DBValueBuilderImpl.KeyValueBuilder.initFromObject(null));
    }

    public DocumentMutation set(String path, Value v) {
        return this.set(FieldPath.parseFrom((String)path), v);
    }

    public DocumentMutation set(FieldPath path, Value v) {
        return this.setCommon(path, DBValueBuilderImpl.KeyValueBuilder.initFrom(v));
    }

    public DocumentMutation set(String path, boolean b) {
        return this.set(FieldPath.parseFrom((String)path), b);
    }

    public DocumentMutation set(FieldPath path, boolean b) {
        return this.setCommon(path, DBValueBuilderImpl.KeyValueBuilder.initFrom(b));
    }

    public DocumentMutation set(String path, short s) {
        return this.set(FieldPath.parseFrom((String)path), s);
    }

    public DocumentMutation set(FieldPath path, short s) {
        return this.setCommon(path, DBValueBuilderImpl.KeyValueBuilder.initFrom(s));
    }

    public DocumentMutation set(String path, byte b) {
        return this.set(FieldPath.parseFrom((String)path), b);
    }

    public DocumentMutation set(FieldPath path, byte b) {
        return this.setCommon(path, DBValueBuilderImpl.KeyValueBuilder.initFrom(b));
    }

    public DocumentMutation set(String path, int i) {
        return this.set(FieldPath.parseFrom((String)path), i);
    }

    public DocumentMutation set(FieldPath path, int i) {
        return this.setCommon(path, DBValueBuilderImpl.KeyValueBuilder.initFrom(i));
    }

    public DocumentMutation set(String path, long l) {
        return this.set(FieldPath.parseFrom((String)path), l);
    }

    public DocumentMutation set(FieldPath path, long l) {
        return this.setCommon(path, DBValueBuilderImpl.KeyValueBuilder.initFrom(l));
    }

    public DocumentMutation set(String path, float f) {
        return this.set(FieldPath.parseFrom((String)path), f);
    }

    public DocumentMutation set(FieldPath path, float f) {
        return this.setCommon(path, DBValueBuilderImpl.KeyValueBuilder.initFrom(f));
    }

    public DocumentMutation set(String path, double d) {
        return this.set(FieldPath.parseFrom((String)path), d);
    }

    public DocumentMutation set(FieldPath path, double d) {
        return this.setCommon(path, DBValueBuilderImpl.KeyValueBuilder.initFrom(d));
    }

    public MutationImpl set(String path, String value) {
        return this.set(FieldPath.parseFrom((String)path), value);
    }

    public MutationImpl set(FieldPath path, String value) {
        return this.setCommon(path, DBValueBuilderImpl.KeyValueBuilder.initFrom(value));
    }

    public DocumentMutation set(String path, BigDecimal bd) {
        return this.set(FieldPath.parseFrom((String)path), bd);
    }

    public DocumentMutation set(FieldPath path, BigDecimal bd) {
        return this.setCommon(path, DBValueBuilderImpl.KeyValueBuilder.initFrom(bd));
    }

    public DocumentMutation set(String path, OTime t) {
        return this.set(FieldPath.parseFrom((String)path), t);
    }

    public DocumentMutation set(FieldPath path, OTime t) {
        return this.setCommon(path, DBValueBuilderImpl.KeyValueBuilder.initFrom(t));
    }

    public DocumentMutation set(String path, OTimestamp t) {
        return this.set(FieldPath.parseFrom((String)path), t);
    }

    public DocumentMutation set(FieldPath path, OTimestamp t) {
        return this.setCommon(path, DBValueBuilderImpl.KeyValueBuilder.initFrom(t));
    }

    public DocumentMutation set(String path, ODate d) {
        return this.set(FieldPath.parseFrom((String)path), d);
    }

    public DocumentMutation set(FieldPath path, ODate d) {
        return this.setCommon(path, DBValueBuilderImpl.KeyValueBuilder.initFrom(d));
    }

    public DocumentMutation set(String path, List<? extends Object> value) {
        return this.set(FieldPath.parseFrom((String)path), value);
    }

    public DocumentMutation set(FieldPath path, List<? extends Object> value) {
        return this.setCommon(path, DBValueBuilderImpl.KeyValueBuilder.initFrom(value));
    }

    public DocumentMutation set(String path, OInterval intv) {
        return this.set(FieldPath.parseFrom((String)path), intv);
    }

    public DocumentMutation set(FieldPath path, OInterval intv) {
        return this.setCommon(path, DBValueBuilderImpl.KeyValueBuilder.initFrom(intv));
    }

    public DocumentMutation set(String path, ByteBuffer bb) {
        return this.set(FieldPath.parseFrom((String)path), bb);
    }

    public DocumentMutation set(FieldPath path, ByteBuffer bb) {
        return this.setCommon(path, DBValueBuilderImpl.KeyValueBuilder.initFrom(bb));
    }

    public DocumentMutation set(String path, Map<String, ? extends Object> value) {
        return this.set(FieldPath.parseFrom((String)path), value);
    }

    public DocumentMutation set(FieldPath path, Map<String, ? extends Object> value) {
        return this.setCommon(path, DBValueBuilderImpl.KeyValueBuilder.initFrom(value));
    }

    public DocumentMutation set(String path, Document value) {
        return this.set(FieldPath.parseFrom((String)path), value);
    }

    public DocumentMutation set(FieldPath path, Document value) {
        return this.setCommon(path, DBValueBuilderImpl.KeyValueBuilder.initFrom(value));
    }

    public DocumentMutation setOrReplace(String path, Value v) {
        return this.setOrReplace(FieldPath.parseFrom((String)path), v);
    }

    public DocumentMutation setOrReplace(FieldPath path, Value v) {
        return this.setOrReplaceCommon(path, DBValueBuilderImpl.KeyValueBuilder.initFromObject(v));
    }

    public DocumentMutation setOrReplaceNull(String path) {
        return this.setOrReplaceNull(FieldPath.parseFrom((String)path));
    }

    public DocumentMutation setOrReplaceNull(FieldPath path) {
        return this.setOrReplaceCommon(path, DBValueBuilderImpl.KeyValueBuilder.initFromObject(null));
    }

    public DocumentMutation setOrReplace(String path, boolean b) {
        return this.setOrReplace(FieldPath.parseFrom((String)path), b);
    }

    public DocumentMutation setOrReplace(FieldPath path, boolean b) {
        return this.setOrReplaceCommon(path, DBValueBuilderImpl.KeyValueBuilder.initFrom(b));
    }

    public DocumentMutation setOrReplace(String path, short s) {
        return this.setOrReplace(FieldPath.parseFrom((String)path), s);
    }

    public DocumentMutation setOrReplace(FieldPath path, short s) {
        return this.setOrReplaceCommon(path, DBValueBuilderImpl.KeyValueBuilder.initFrom(s));
    }

    public DocumentMutation setOrReplace(String path, byte b) {
        return this.setOrReplace(FieldPath.parseFrom((String)path), b);
    }

    public DocumentMutation setOrReplace(FieldPath path, byte b) {
        return this.setOrReplaceCommon(path, DBValueBuilderImpl.KeyValueBuilder.initFrom(b));
    }

    public DocumentMutation setOrReplace(String path, int i) {
        return this.setOrReplace(FieldPath.parseFrom((String)path), i);
    }

    public DocumentMutation setOrReplace(FieldPath path, int i) {
        return this.setOrReplaceCommon(path, DBValueBuilderImpl.KeyValueBuilder.initFrom(i));
    }

    public DocumentMutation setOrReplace(String path, long l) {
        return this.setOrReplace(FieldPath.parseFrom((String)path), l);
    }

    public DocumentMutation setOrReplace(FieldPath path, long l) {
        return this.setOrReplaceCommon(path, DBValueBuilderImpl.KeyValueBuilder.initFrom(l));
    }

    public DocumentMutation setOrReplace(String path, float f) {
        return this.setOrReplace(FieldPath.parseFrom((String)path), f);
    }

    public DocumentMutation setOrReplace(FieldPath path, float f) {
        return this.setOrReplaceCommon(path, DBValueBuilderImpl.KeyValueBuilder.initFrom(f));
    }

    public DocumentMutation setOrReplace(String path, double d) {
        return this.setOrReplace(FieldPath.parseFrom((String)path), d);
    }

    public DocumentMutation setOrReplace(FieldPath path, double d) {
        return this.setOrReplaceCommon(path, DBValueBuilderImpl.KeyValueBuilder.initFrom(d));
    }

    public MutationImpl setOrReplace(String path, String value) {
        return this.setOrReplace(FieldPath.parseFrom((String)path), value);
    }

    public MutationImpl setOrReplace(FieldPath path, String value) {
        return this.setOrReplaceCommon(path, DBValueBuilderImpl.KeyValueBuilder.initFrom(value));
    }

    public DocumentMutation setOrReplace(String path, BigDecimal bd) {
        return this.setOrReplace(FieldPath.parseFrom((String)path), bd);
    }

    public DocumentMutation setOrReplace(FieldPath path, BigDecimal bd) {
        return this.setOrReplaceCommon(path, DBValueBuilderImpl.KeyValueBuilder.initFrom(bd));
    }

    public DocumentMutation setOrReplace(String path, OTime t) {
        return this.setOrReplace(FieldPath.parseFrom((String)path), t);
    }

    public DocumentMutation setOrReplace(FieldPath path, OTime t) {
        return this.setOrReplaceCommon(path, DBValueBuilderImpl.KeyValueBuilder.initFrom(t));
    }

    public DocumentMutation setOrReplace(String path, OTimestamp t) {
        return this.setOrReplace(FieldPath.parseFrom((String)path), t);
    }

    public DocumentMutation setOrReplace(FieldPath path, OTimestamp t) {
        return this.setOrReplaceCommon(path, DBValueBuilderImpl.KeyValueBuilder.initFrom(t));
    }

    public DocumentMutation setOrReplace(String path, ODate d) {
        return this.setOrReplace(FieldPath.parseFrom((String)path), d);
    }

    public DocumentMutation setOrReplace(FieldPath path, ODate d) {
        return this.setOrReplaceCommon(path, DBValueBuilderImpl.KeyValueBuilder.initFrom(d));
    }

    public DocumentMutation setOrReplace(String path, List<? extends Object> value) {
        return this.setOrReplace(FieldPath.parseFrom((String)path), value);
    }

    public DocumentMutation setOrReplace(FieldPath path, List<? extends Object> value) {
        return this.setOrReplaceCommon(path, DBValueBuilderImpl.KeyValueBuilder.initFrom(value));
    }

    public DocumentMutation setOrReplace(String path, OInterval intv) {
        return this.setOrReplace(FieldPath.parseFrom((String)path), intv);
    }

    public DocumentMutation setOrReplace(FieldPath path, OInterval intv) {
        return this.setOrReplaceCommon(path, DBValueBuilderImpl.KeyValueBuilder.initFrom(intv));
    }

    public DocumentMutation setOrReplace(String path, ByteBuffer bb) {
        return this.setOrReplace(FieldPath.parseFrom((String)path), bb);
    }

    public DocumentMutation setOrReplace(FieldPath path, ByteBuffer bb) {
        return this.setOrReplaceCommon(path, DBValueBuilderImpl.KeyValueBuilder.initFrom(bb));
    }

    public DocumentMutation setOrReplace(String path, Map<String, ? extends Object> value) {
        return this.setOrReplace(FieldPath.parseFrom((String)path), value);
    }

    public DocumentMutation setOrReplace(FieldPath path, Map<String, ? extends Object> value) {
        return this.setOrReplaceCommon(path, DBValueBuilderImpl.KeyValueBuilder.initFrom(value));
    }

    public DocumentMutation setOrReplace(String path, Document value) {
        return this.setOrReplace(FieldPath.parseFrom((String)path), value);
    }

    public DocumentMutation setOrReplace(FieldPath path, Document value) {
        return this.setOrReplaceCommon(path, DBValueBuilderImpl.KeyValueBuilder.initFrom(value));
    }

    public DocumentMutation append(String path, List<? extends Object> value) {
        return this.append(FieldPath.parseFrom((String)path), value);
    }

    public DocumentMutation append(FieldPath path, List<? extends Object> value) {
        KeyValue kv = DBValueBuilderImpl.KeyValueBuilder.initFrom(value);
        this.appendCommon(path, kv);
        return this;
    }

    public DocumentMutation append(String path, String value) {
        return this.append(FieldPath.parseFrom((String)path), value);
    }

    public DocumentMutation append(FieldPath path, String value) {
        KeyValue kv = DBValueBuilderImpl.KeyValueBuilder.initFrom(value);
        this.appendCommon(path, kv);
        return this;
    }

    public DocumentMutation append(String path, byte[] value, int offset, int len) {
        return this.append(FieldPath.parseFrom((String)path), ByteBuffer.wrap(value, offset, len));
    }

    public DocumentMutation append(FieldPath path, byte[] value, int offset, int len) {
        return this.append(path, ByteBuffer.wrap(value, offset, len));
    }

    public DocumentMutation append(String path, byte[] value) {
        return this.append(FieldPath.parseFrom((String)path), ByteBuffer.wrap(value));
    }

    public DocumentMutation append(FieldPath path, byte[] value) {
        return this.append(path, ByteBuffer.wrap(value));
    }

    public DocumentMutation append(String path, ByteBuffer value) {
        return this.append(FieldPath.parseFrom((String)path), value);
    }

    public DocumentMutation append(FieldPath path, ByteBuffer value) {
        return this.appendCommon(path, DBValueBuilderImpl.KeyValueBuilder.initFrom(value));
    }

    public DocumentMutation merge(String path, Document value) {
        return this.merge(FieldPath.parseFrom((String)path), value);
    }

    public DocumentMutation merge(FieldPath path, Document value) {
        return this.mergeCommon(path, DBValueBuilderImpl.KeyValueBuilder.initFrom(value));
    }

    public DocumentMutation merge(String path, Map<String, Object> value) {
        return this.merge(FieldPath.parseFrom((String)path), value);
    }

    public DocumentMutation merge(FieldPath path, Map<String, Object> value) {
        return this.mergeCommon(path, DBValueBuilderImpl.KeyValueBuilder.initFrom(value));
    }

    public DocumentMutation increment(FieldPath path, byte inc) {
        return this.incrementCommon(path, DBValueBuilderImpl.KeyValueBuilder.initFrom(inc));
    }

    public DocumentMutation increment(String path, byte inc) {
        return this.incrementCommon(FieldPath.parseFrom((String)path), DBValueBuilderImpl.KeyValueBuilder.initFrom(inc));
    }

    public DocumentMutation increment(FieldPath path, short inc) {
        return this.incrementCommon(path, DBValueBuilderImpl.KeyValueBuilder.initFrom(inc));
    }

    public DocumentMutation increment(String path, short inc) {
        return this.incrementCommon(FieldPath.parseFrom((String)path), DBValueBuilderImpl.KeyValueBuilder.initFrom(inc));
    }

    public MutationImpl increment(String path, int inc) {
        return this.incrementCommon(FieldPath.parseFrom((String)path), DBValueBuilderImpl.KeyValueBuilder.initFrom(inc));
    }

    public DocumentMutation increment(FieldPath path, int inc) {
        return this.incrementCommon(path, DBValueBuilderImpl.KeyValueBuilder.initFrom(inc));
    }

    public DocumentMutation increment(FieldPath path, long inc) {
        return this.incrementCommon(path, DBValueBuilderImpl.KeyValueBuilder.initFrom(inc));
    }

    public DocumentMutation increment(String path, long inc) {
        return this.incrementCommon(FieldPath.parseFrom((String)path), DBValueBuilderImpl.KeyValueBuilder.initFrom(inc));
    }

    public DocumentMutation increment(String path, float inc) {
        return this.incrementCommon(FieldPath.parseFrom((String)path), DBValueBuilderImpl.KeyValueBuilder.initFrom(inc));
    }

    public DocumentMutation increment(FieldPath path, float inc) {
        return this.incrementCommon(path, DBValueBuilderImpl.KeyValueBuilder.initFrom(inc));
    }

    public DocumentMutation increment(String path, double inc) {
        return this.incrementCommon(FieldPath.parseFrom((String)path), DBValueBuilderImpl.KeyValueBuilder.initFrom(inc));
    }

    public DocumentMutation increment(FieldPath path, double inc) {
        return this.incrementCommon(path, DBValueBuilderImpl.KeyValueBuilder.initFrom(inc));
    }

    public DocumentMutation increment(String path, BigDecimal inc) {
        return this.incrementCommon(FieldPath.parseFrom((String)path), DBValueBuilderImpl.KeyValueBuilder.initFrom(inc));
    }

    public DocumentMutation increment(FieldPath path, BigDecimal inc) {
        return this.incrementCommon(path, DBValueBuilderImpl.KeyValueBuilder.initFrom(inc));
    }

    public DocumentMutation delete(String path) {
        return this.delete(FieldPath.parseFrom((String)path));
    }

    public DocumentMutation delete(FieldPath path) {
        this.checkForId(path);
        boolean readNeeded = MutationHelper.mutationCommon(InsertContext.OpType.DELETE, this.record, path, new KeyValue(Value.Type.NULL));
        if (readNeeded) {
            this.fields.add(path);
            this.needsReadOnServer = true;
        }
        return this;
    }

    @API.Internal
    public boolean needsReadOnServer() {
        return this.needsReadOnServer;
    }

    @API.Internal
    public ByteBuffer rowcolSerialize() {
        SerializedFamilyInfo[] familyInfo = this.rowcolSerialize((Map<FieldPath, Integer>)Constants.DEFAULT_FAMILY_MAP);
        assert (familyInfo.length == 1);
        return familyInfo[0].getByteBuffer();
    }

    @API.Internal
    public SerializedFamilyInfo[] rowcolSerialize(Map<FieldPath, Integer> jsonPathMap, boolean isBulkLoad) {
        SerializationContext ctx = new SerializationContext();
        ctx.setFullRecordOp(false);
        ctx.setStoreRowTS(isBulkLoad);
        ctx.serializeFamilies(this.record, jsonPathMap);
        return ctx.getSerializedBuffers();
    }

    @API.Internal
    public Map<Integer, List<String>> getFieldsNeedRead(Map<FieldPath, Integer> pathCFidMap) {
        if (this.fields.size() > 0) {
            String[] strFields = new String[this.fields.size()];
            for (int i = 0; i < this.fields.size(); ++i) {
                strFields[i] = this.fields.get(i).asPathString();
            }
            Map<Integer, List<String>> pathsPerFam = MapRDBTableImplHelper.getMultipleCFQualifiers(pathCFidMap, false, strFields);
            if (pathsPerFam != null) {
                for (Map.Entry<Integer, List<String>> e : pathsPerFam.entrySet()) {
                    class StringPathComparator
                    implements Comparator<String> {
                        StringPathComparator() {
                        }

                        @Override
                        public int compare(String o1, String o2) {
                            if (o1 == o2) {
                                return 0;
                            }
                            if (o1 == null) {
                                return -1;
                            }
                            if (o2 == null) {
                                return 1;
                            }
                            return FieldPath.parseFrom((String)o1).compareTo(FieldPath.parseFrom((String)o2));
                        }
                    }
                    Collections.sort(e.getValue(), new StringPathComparator());
                }
            }
            return pathsPerFam;
        }
        return null;
    }

    @API.Internal
    public SerializedFamilyInfo[] rowcolSerialize(Map<FieldPath, Integer> jsonPathMap) {
        return this.rowcolSerialize(jsonPathMap, false);
    }

    @API.Internal
    public static MutationImpl fromSerializedValue(ByteBuffer input, boolean needsRead) {
        MutationImpl rm = new MutationImpl();
        rm.needsReadOnServer = needsRead;
        rm.record = (DBDocumentImpl)RowcolCodec.decode(input);
        return rm;
    }

    public Iterator<MutationOp> iterator() {
        throw new UnsupportedOperationException("");
    }

    public DocumentMutation decrement(FieldPath path, byte dec) {
        return this.incrementCommon(path, DBValueBuilderImpl.KeyValueBuilder.initFrom((int)(-dec)));
    }

    public DocumentMutation decrement(String path, byte dec) {
        return this.incrementCommon(FieldPath.parseFrom((String)path), DBValueBuilderImpl.KeyValueBuilder.initFrom((int)(-dec)));
    }

    public DocumentMutation decrement(FieldPath path, short dec) {
        return this.incrementCommon(path, DBValueBuilderImpl.KeyValueBuilder.initFrom((int)(-dec)));
    }

    public DocumentMutation decrement(String path, short dec) {
        return this.incrementCommon(FieldPath.parseFrom((String)path), DBValueBuilderImpl.KeyValueBuilder.initFrom((int)(-dec)));
    }

    public DocumentMutation decrement(String path, int dec) {
        return this.incrementCommon(FieldPath.parseFrom((String)path), DBValueBuilderImpl.KeyValueBuilder.initFrom(-dec));
    }

    public DocumentMutation decrement(FieldPath path, int dec) {
        return this.incrementCommon(path, DBValueBuilderImpl.KeyValueBuilder.initFrom(-dec));
    }

    public DocumentMutation decrement(FieldPath path, long dec) {
        return this.incrementCommon(path, DBValueBuilderImpl.KeyValueBuilder.initFrom(-dec));
    }

    public DocumentMutation decrement(String path, long dec) {
        return this.incrementCommon(FieldPath.parseFrom((String)path), DBValueBuilderImpl.KeyValueBuilder.initFrom(-dec));
    }

    public DocumentMutation decrement(String path, float dec) {
        return this.incrementCommon(FieldPath.parseFrom((String)path), DBValueBuilderImpl.KeyValueBuilder.initFrom(-dec));
    }

    public DocumentMutation decrement(FieldPath path, float dec) {
        return this.incrementCommon(path, DBValueBuilderImpl.KeyValueBuilder.initFrom(-dec));
    }

    public DocumentMutation decrement(String path, double dec) {
        return this.incrementCommon(FieldPath.parseFrom((String)path), DBValueBuilderImpl.KeyValueBuilder.initFrom(-dec));
    }

    public DocumentMutation decrement(FieldPath path, double dec) {
        return this.incrementCommon(path, DBValueBuilderImpl.KeyValueBuilder.initFrom(-dec));
    }

    public DocumentMutation decrement(String path, BigDecimal dec) {
        return this.incrementCommon(FieldPath.parseFrom((String)path), DBValueBuilderImpl.KeyValueBuilder.initFrom(dec.negate()));
    }

    public DocumentMutation decrement(FieldPath path, BigDecimal dec) {
        return this.incrementCommon(path, DBValueBuilderImpl.KeyValueBuilder.initFrom(dec.negate()));
    }
}

