/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.impl;

import com.mapr.db.rowcol.DBValueBuilderImpl;
import com.mapr.db.util.ByteBufs;
import com.mapr.org.apache.hadoop.hbase.util.Bytes;
import java.nio.ByteBuffer;
import org.ojai.Value;
import org.ojai.annotation.API;
import org.ojai.exceptions.DecodingException;
import org.ojai.exceptions.EncodingException;

@API.Internal
public class IdCodec {
    private static final boolean TYPE_ENABLED_FOR_ID = true;
    private static final ByteBuffer EMPTY_BYTE_BUFFER = ByteBufs.allocatePreferred(0);
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final String EMPTY_STRING = "";

    public static boolean isSupportedType(Value.Type type) {
        switch (type) {
            case BINARY: 
            case STRING: {
                return true;
            }
        }
        return false;
    }

    public static String asString(Value in) {
        if (in != null) {
            switch (in.getType()) {
                case STRING: {
                    return in.getString();
                }
                case BINARY: {
                    return Bytes.toStringBinary((ByteBuffer)in.getBinary());
                }
            }
            throw new EncodingException("Id of type " + in.getType() + " is currently not supported.");
        }
        return String.valueOf(in);
    }

    public static byte[] encodeStringBinary(String in) {
        return Bytes.toBytesBinary((String)(String.format("\\x%02d", Value.Type.STRING.getCode()) + in));
    }

    public static ByteBuffer encode(Value in) {
        if (in != null) {
            switch (in.getType()) {
                case NULL: {
                    return EMPTY_BYTE_BUFFER;
                }
                case STRING: {
                    return IdCodec.encode(in.getString());
                }
                case BINARY: {
                    return IdCodec.encode(in.getBinary());
                }
            }
            throw new EncodingException("Encoding of type " + in.getType() + " is currently not supported.");
        }
        return null;
    }

    public static byte[] encodeAsBytes(Value in) {
        if (in != null) {
            switch (in.getType()) {
                case NULL: {
                    return EMPTY_BYTE_ARRAY;
                }
                case STRING: {
                    return IdCodec.encodeAsBytes(in.getString());
                }
                case BINARY: {
                    return IdCodec.encodeAsBytes(in.getBinary());
                }
            }
            throw new EncodingException("Encoding of type " + in.getType() + " is currently not supported.");
        }
        return null;
    }

    public static Value decode(byte[] in) {
        if (in != null && in.length > 0) {
            Value.Type type = IdCodec.getType(in[0]);
            switch (type) {
                case STRING: {
                    return DBValueBuilderImpl.KeyValueBuilder.initFrom(IdCodec.decodeString(in));
                }
                case BINARY: {
                    return DBValueBuilderImpl.KeyValueBuilder.initFrom(ByteBufs.wrap(IdCodec.decodeBytes(in)));
                }
            }
            assert (false);
        }
        return in == null ? null : DBValueBuilderImpl.KeyValueBuilder.initFromNull();
    }

    public static Value decode(ByteBuffer in) {
        if (in != null && in.remaining() > 0) {
            in = (ByteBuffer)in.slice().mark();
            Value.Type type = IdCodec.getType(in.get());
            in.reset();
            switch (type) {
                case STRING: {
                    return DBValueBuilderImpl.KeyValueBuilder.initFrom(IdCodec.decodeString(in));
                }
                case BINARY: {
                    return DBValueBuilderImpl.KeyValueBuilder.initFrom(IdCodec.decodeBinary(in));
                }
            }
            assert (false);
        }
        return in == null ? null : DBValueBuilderImpl.KeyValueBuilder.initFromNull();
    }

    public static ByteBuffer encode(String in) {
        if (in != null) {
            byte[] encodedBytes = Bytes.toBytes((String)in);
            int rowKeySize = encodedBytes.length + 1;
            IdCodec.checkMaxRowKeySize(rowKeySize);
            return (ByteBuffer)ByteBufs.allocatePreferred(rowKeySize).put(Value.Type.STRING.getCode()).put(encodedBytes).flip();
        }
        return null;
    }

    public static byte[] encodeAsBytes(String in) {
        if (in != null) {
            byte[] encodedBytes = Bytes.toBytes((String)in);
            int rowKeySize = encodedBytes.length + 1;
            IdCodec.checkMaxRowKeySize(rowKeySize);
            byte[] retVal = new byte[rowKeySize];
            retVal[0] = Value.Type.STRING.getCode();
            System.arraycopy(encodedBytes, 0, retVal, 1, encodedBytes.length);
            return retVal;
        }
        return null;
    }

    public static String decodeString(byte[] in) {
        if (in != null && in.length > 0) {
            IdCodec.checkType(in[0], Value.Type.STRING);
            return Bytes.toString((byte[])in, (int)1, (int)(in.length - 1));
        }
        return in == null ? null : EMPTY_STRING;
    }

    public static String decodeString(ByteBuffer in) {
        if (in != null) {
            in = in.slice();
            IdCodec.checkType(in.get(), Value.Type.STRING);
            return Bytes.toString((ByteBuffer)in);
        }
        return null;
    }

    public static byte[] encodeAsBytes(byte[] in) {
        if (in != null) {
            IdCodec.checkMaxRowKeySize(in.length + 1);
            byte[] retVal = new byte[in.length + 1];
            retVal[0] = Value.Type.BINARY.getCode();
            System.arraycopy(in, 0, retVal, 1, in.length);
            return retVal;
        }
        return null;
    }

    public static byte[] decodeBytes(byte[] in) {
        if (in != null && in.length > 0) {
            IdCodec.checkType(in[0], Value.Type.BINARY);
            byte[] retVal = new byte[in.length - 1];
            System.arraycopy(in, 1, retVal, 0, retVal.length);
            return retVal;
        }
        return in == null ? null : EMPTY_BYTE_ARRAY;
    }

    public static ByteBuffer encode(ByteBuffer in) {
        if (in != null) {
            int rowKeySize = in.remaining() + 1;
            IdCodec.checkMaxRowKeySize(rowKeySize);
            return (ByteBuffer)ByteBufs.allocatePreferred(rowKeySize).put(Value.Type.BINARY.getCode()).put(in.slice()).flip();
        }
        return null;
    }

    public static byte[] encodeAsBytes(ByteBuffer in) {
        if (in != null) {
            return Bytes.toBytes((ByteBuffer)IdCodec.encode(in));
        }
        return null;
    }

    public static ByteBuffer decodeBinary(ByteBuffer in) {
        if (in != null && in.remaining() > 0) {
            in = in.slice();
            IdCodec.checkType(in.get(), Value.Type.BINARY);
            return (ByteBuffer)ByteBufs.allocatePreferred(in.remaining()).put(in).flip();
        }
        return in == null ? null : EMPTY_BYTE_BUFFER;
    }

    private static Value.Type getType(byte typeCode) {
        Value.Type type = Value.Type.valueOf((int)typeCode);
        if (type == null) {
            throw new DecodingException("Encountered unknown type code: " + typeCode);
        }
        if (!IdCodec.isSupportedType(type)) {
            throw new DecodingException("Decoding of type " + type + " is currently not supported.");
        }
        return type;
    }

    private static void checkType(byte code, Value.Type type) {
        if (code != type.getCode()) {
            throw new DecodingException(String.format("Expected type %d (%s), found %d while decoding.", type.getCode(), type, code));
        }
    }

    private static void checkMaxRowKeySize(int rowKeySize) {
        if (rowKeySize > 32768) {
            throw new IllegalArgumentException(String.format("The encoded size of _id field (%d) is greater than maximum allowed size (%d).", rowKeySize, 32768));
        }
    }
}

