/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.tests.tableops;

import com.mapr.db.MapRDB;
import com.mapr.db.Table;
import com.mapr.db.tests.utils.DBTests;
import com.mapr.db.tests.utils.Datasets;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.ClusterTest;
import java.io.IOException;
import java.util.ArrayList;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;
import org.ojai.DocumentConstants;
import org.ojai.DocumentStream;
import org.ojai.FieldPath;
import org.ojai.store.DocumentMutation;
import org.ojai.store.QueryCondition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ClusterTest.class})
public class TestTableOps
extends BaseTest {
    private static final Logger _logger = LoggerFactory.getLogger(TestTableOps.class);
    private static final String TABLE_NAME = "testtable-TestTableOps";
    private static Table table;

    @BeforeClass
    public static void startupBeforeClass() throws IOException {
        table = DBTests.createOrReplaceTable(TABLE_NAME);
        table.setOption(Table.TableOption.BUFFERWRITE, false);
        table.insertOrReplace(Datasets.SIMPLE_KEYS[0], Datasets.SIMPLE_RECORDS[0]);
    }

    @AfterClass
    public static void cleanupAfterClass() throws IOException, Exception {
        if (table != null) {
            table.close();
            DBTests.deleteTables(TABLE_NAME);
        }
    }

    @Test
    public void testSimpleGet() throws IOException {
        Document d = MapRDB.newDocument((String)"{ \"m\" : { \"a\" : 10, \"b\" : 20 } }");
        table.insertOrReplace("KEY", d);
        d = table.findById("KEY", new String[]{"m.c"});
        Assert.assertNotNull((Object)table.findById(Datasets.SIMPLE_KEYS[0]));
        Assert.assertNull((Object)table.findById(Datasets.SIMPLE_KEYS[1]));
    }

    @Test
    public void setWithUnicodeChar_Bug20501() throws Exception {
        FieldPath fp = FieldPath.parseFrom((String)"`\ud83c\udfda`");
        Document doc = MapRDB.newDocument();
        doc.set(DocumentConstants.ID_FIELD, "r1");
        doc.set(fp, 1);
        table.insertOrReplace(doc);
        Assert.assertEquals((Object)doc.toString(), (Object)table.findById("r1").toString());
    }

    @Test
    public void testRMWUpdateAfterSetOrReplace() throws Exception {
        table.setOption(Table.TableOption.BUFFERWRITE, true);
        Document doc = MapRDB.newDocument().set("a.b.c", 10).set("a.b.d", true);
        table.insertOrReplace("k6", doc);
        table.flush();
        DocumentMutation m = MapRDB.newMutation().setOrReplace("a.b.c", 15);
        table.update("k6", m);
        Document md = MapRDB.newDocument().set("b.c", 20);
        DocumentMutation m2 = MapRDB.newMutation().merge("a", md);
        table.update("k6", m2);
        table.flush();
        Document result = table.findById("k6");
        table.setOption(Table.TableOption.BUFFERWRITE, false);
        Document expected = MapRDB.newDocument().set(DocumentConstants.ID_FIELD, "k6").set("a.b.d", true).set("a.b.c", 20);
        Assert.assertEquals((Object)result.toString(), (Object)expected.toString());
    }

    @Test
    public void testCheckAndMutateAfterSetOrReplace() throws Exception {
        table.setOption(Table.TableOption.BUFFERWRITE, true);
        Document doc = MapRDB.newDocument().set("a.b.c", 10).set("a.b.d", true);
        table.insertOrReplace("k6", doc);
        table.flush();
        DocumentMutation m = MapRDB.newMutation().setOrReplace("a.b.c", 15);
        table.update("k6", m);
        QueryCondition condition = MapRDB.newCondition().is("a.b.d", QueryCondition.Op.EQUAL, true).build();
        Document md = MapRDB.newDocument().set("b.c", 20);
        DocumentMutation m2 = MapRDB.newMutation().merge("a", md);
        table.checkAndMutate("k6", condition, m2);
        table.flush();
        Document result = table.findById("k6");
        table.setOption(Table.TableOption.BUFFERWRITE, false);
        Document expected = MapRDB.newDocument().set(DocumentConstants.ID_FIELD, "k6").set("a.b.d", true).set("a.b.c", 20);
        Assert.assertEquals((Object)result.toString(), (Object)expected.toString());
    }

    @Test
    public void testCheckAndReplaceAfterSetOrReplace() throws Exception {
        table.setOption(Table.TableOption.BUFFERWRITE, true);
        Document doc = MapRDB.newDocument().set("a.b.c", 10).set("a.b.d", true);
        table.insertOrReplace("k6", doc);
        table.flush();
        DocumentMutation m = MapRDB.newMutation().setOrReplace("a.b.c", 15);
        table.update("k6", m);
        QueryCondition condition = MapRDB.newCondition().is("a.b.d", QueryCondition.Op.EQUAL, true).build();
        Document md = MapRDB.newDocument().set("a.b.d", true).set("a.b.c", 20);
        table.checkAndReplace("k6", condition, md);
        table.flush();
        Document result = table.findById("k6");
        table.setOption(Table.TableOption.BUFFERWRITE, false);
        Document expected = MapRDB.newDocument().set(DocumentConstants.ID_FIELD, "k6").set("a.b.d", true).set("a.b.c", 20);
        Assert.assertEquals((Object)result.toString(), (Object)expected.toString());
    }

    @Test
    public void testInNullFilter() throws Exception {
        String id;
        int ndocuments = 5;
        int nresults = 0;
        boolean result = false;
        DBTests.admin().deleteTable(TABLE_NAME);
        table = DBTests.admin().createTable(MapRDB.newTableDescriptor((String)TABLE_NAME));
        for (int i = 0; i < ndocuments; ++i) {
            Document rec = MapRDB.newDocument().set("field1", i % 2);
            table.insertOrReplace("document" + i, rec);
        }
        table.flush();
        ArrayList target1 = new ArrayList();
        QueryCondition condition = MapRDB.newCondition().in("field1", target1).build();
        System.out.println("condition : " + condition.toString());
        DocumentStream results = table.find(condition);
        for (Document document : results) {
            String id2 = document.getIdString();
            System.out.println(document.toString());
            ++nresults;
        }
        Assert.assertEquals((long)nresults, (long)0L);
        ArrayList<Integer> target2 = new ArrayList<Integer>();
        target2.add(0);
        condition = MapRDB.newCondition().or().in("field1", target1).in("field1", target2).close().build();
        System.out.println("condition : " + condition.toString());
        nresults = 0;
        results = table.find(condition);
        for (Document document : results) {
            id = document.getIdString();
            System.out.println(document.toString());
            ++nresults;
        }
        Assert.assertEquals((long)nresults, (long)3L);
        target2 = new ArrayList();
        target2.add(1);
        condition = MapRDB.newCondition().and().in("field1", target1).in("field1", target2).close().build();
        System.out.println("condition : " + condition.toString());
        nresults = 0;
        results = table.find(condition);
        for (Document document : results) {
            id = document.getIdString();
            System.out.println(document.toString());
            ++nresults;
        }
        Assert.assertEquals((long)nresults, (long)0L);
        condition = MapRDB.newCondition().in("field1", target1).build();
        result = table.checkAndDelete("document0", condition);
        Assert.assertEquals((Object)result, (Object)false);
        target2 = new ArrayList();
        target2.add(0);
        condition = MapRDB.newCondition().or().in("field1", target1).in("field1", target2).close().build();
        result = table.checkAndDelete("document0", condition);
        Assert.assertEquals((Object)result, (Object)true);
        Document newDoc = MapRDB.newDocument().set("field1", 100);
        condition = MapRDB.newCondition().in("field1", target1).build();
        result = table.checkAndReplace("document1", condition, newDoc);
        Assert.assertEquals((Object)result, (Object)false);
        target2 = new ArrayList();
        target2.add(1);
        condition = MapRDB.newCondition().or().in("field1", target1).in("field1", target2).close().build();
        result = table.checkAndReplace("document1", condition, newDoc);
        Assert.assertEquals((Object)result, (Object)true);
        condition = MapRDB.newCondition().in("field1", target1).build();
        DocumentMutation mut = MapRDB.newMutation().decrement("field1", 99);
        result = table.checkAndMutate("document1", condition, mut);
        Assert.assertEquals((Object)result, (Object)false);
        target2 = new ArrayList();
        target2.add(100);
        condition = MapRDB.newCondition().or().in("field1", target1).in("field1", target2).close().build();
        result = table.checkAndMutate("document1", condition, mut);
        Assert.assertEquals((Object)result, (Object)true);
        target2 = new ArrayList();
        target2.add(1);
        ArrayList<Integer> target3 = new ArrayList<Integer>();
        target3.add(0);
        target3.add(1);
        condition = MapRDB.newCondition().or().and().in("field1", target1).in("field1", target2).close().in("field1", target3).close().build();
        System.out.println("condition : " + condition.toString());
        nresults = 0;
        results = table.find(condition);
        for (Document document : results) {
            String id3 = document.getIdString();
            System.out.println(document.toString());
            ++nresults;
        }
        Assert.assertEquals((long)nresults, (long)4L);
    }
}

