/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.streams.impl;

import com.mapr.db.MapRDB;
import com.mapr.db.TableSplitInternal;
import com.mapr.db.TabletInfo;
import com.mapr.db.impl.ConditionImpl;
import com.mapr.db.impl.ConditionNode;
import com.mapr.db.impl.IdCodec;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.ojai.DocumentConstants;
import org.ojai.Value;
import org.ojai.store.QueryCondition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarlinSplitterCore {
    static final Logger LOG = LoggerFactory.getLogger(MarlinSplitterCore.class);
    private static final String SEMICOLON = ";";
    private static final String UTF8 = "UTF-8";
    private static final char COLON = ':';

    private static String GetTopicEndKey(String key) {
        if (key == null || key.length() == 0) {
            return null;
        }
        int topicEndIndex = key.indexOf(58);
        if (topicEndIndex < 0) {
            return null;
        }
        return key.substring(0, topicEndIndex) + SEMICOLON;
    }

    public static List<TableSplitInternal> getMarlinSplits(String tablename, TabletInfo[] tablets) throws IOException {
        String nextStartKey = null;
        ArrayList<TableSplitInternal> tableSplitInts = new ArrayList<TableSplitInternal>();
        for (int i = 0; i < tablets.length; ++i) {
            int j;
            TabletInfo tab = tablets[i];
            ConditionImpl cond = (ConditionImpl)tab.getCondition();
            List<ConditionNode.RowkeyRange> rowKeys = cond.getRowkeyRanges();
            if (nextStartKey == null) {
                Value nextTempKey = IdCodec.decode(rowKeys.get(0).getStartRow());
                nextStartKey = nextTempKey.getType() == Value.Type.STRING ? nextTempKey.getString() : "";
            }
            Value tempEndKey = IdCodec.decode(rowKeys.get(rowKeys.size() - 1).getStopRow());
            String curEndKey = null;
            curEndKey = tempEndKey.getType() == Value.Type.STRING ? tempEndKey.getString() : "";
            String topicEndKey = MarlinSplitterCore.GetTopicEndKey(curEndKey);
            if (topicEndKey == null) {
                QueryCondition splitCond = MapRDB.newCondition().and().is(DocumentConstants.ID_FIELD, QueryCondition.Op.GREATER_OR_EQUAL, nextStartKey).is(DocumentConstants.ID_FIELD, QueryCondition.Op.LESS, curEndKey).close().build();
                TableSplitInternal split = new TableSplitInternal(tablename, splitCond, tab.getLocations(), tab.getEstimatedSize());
                tableSplitInts.add(split);
                LOG.trace("Adding MarlinSplits with endKey [" + nextStartKey + ", " + curEndKey + ")");
                nextStartKey = null;
                continue;
            }
            for (j = i + 1; j < tablets.length; ++j) {
                TabletInfo nextTab = tablets[j];
                ConditionImpl nextCond = (ConditionImpl)nextTab.getCondition();
                List<ConditionNode.RowkeyRange> nextRowKeys = nextCond.getRowkeyRanges();
                String nextEndKey = null;
                Value tempNextEndKey = IdCodec.decode(nextRowKeys.get(nextRowKeys.size() - 1).getStopRow());
                nextEndKey = tempNextEndKey.getType() == Value.Type.STRING ? tempNextEndKey.getString() : "";
                if (topicEndKey.compareTo(nextEndKey) > 0) continue;
                QueryCondition splitCond = MapRDB.newCondition().and().is(DocumentConstants.ID_FIELD, QueryCondition.Op.GREATER_OR_EQUAL, nextStartKey).is(DocumentConstants.ID_FIELD, QueryCondition.Op.LESS, topicEndKey).close().build();
                TableSplitInternal split = new TableSplitInternal(tablename, splitCond, tab.getLocations(), tab.getEstimatedSize());
                tableSplitInts.add(split);
                LOG.trace("Adding MarlinSplits with topicEndKey [" + nextStartKey + ", " + topicEndKey + ")");
                nextStartKey = topicEndKey;
                i = j - 1;
                break;
            }
            assert (j < tablets.length);
        }
        return tableSplitInts;
    }
}

