/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mapr.db.Table;
import com.mapr.db.TableDescriptor;
import com.mapr.db.TabletInfo;
import com.mapr.db.exceptions.DBException;
import com.mapr.db.exceptions.DBRetryException;
import com.mapr.db.exceptions.ExceptionHandler;
import com.mapr.db.exceptions.OpNotPermittedException;
import com.mapr.db.exceptions.TableClosedException;
import com.mapr.db.exceptions.TableNotFoundException;
import com.mapr.db.impl.ConditionDescriptor;
import com.mapr.db.impl.ConditionImpl;
import com.mapr.db.impl.ConditionNode;
import com.mapr.db.impl.Constants;
import com.mapr.db.impl.EncodedBufFamIdInfo;
import com.mapr.db.impl.IdCodec;
import com.mapr.db.impl.MapRDBTableImplHelper;
import com.mapr.db.impl.TableDescriptorImpl;
import com.mapr.db.impl.TabletInfoImpl;
import com.mapr.db.ojai.DBDocumentStream;
import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.db.rowcol.DBValueBuilderImpl;
import com.mapr.db.rowcol.KeyValue;
import com.mapr.db.rowcol.MutationImpl;
import com.mapr.db.rowcol.RowcolCodec;
import com.mapr.db.rowcol.SerializedFamilyInfo;
import com.mapr.db.util.ByteBufs;
import com.mapr.fs.MapRHTable;
import com.mapr.fs.MapRResultScanner;
import com.mapr.fs.MapRTabletScanner;
import com.mapr.fs.jni.MapRConstants;
import com.mapr.fs.jni.MapRPut;
import com.mapr.fs.jni.MapRScan;
import com.mapr.fs.jni.MapRUpdateAndGet;
import com.mapr.fs.proto.Dbfilters;
import com.mapr.fs.proto.Dbserver;
import com.mapr.fs.tables.TableProperties;
import com.mapr.org.apache.hadoop.hbase.util.Bytes;
import com.mapr.utils.Collections;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.ojai.Document;
import org.ojai.DocumentConstants;
import org.ojai.DocumentStream;
import org.ojai.FieldPath;
import org.ojai.Value;
import org.ojai.annotation.API;
import org.ojai.store.DocumentMutation;
import org.ojai.store.OpListener;
import org.ojai.store.QueryCondition;
import org.ojai.store.exceptions.DocumentExistsException;
import org.ojai.store.exceptions.DocumentNotFoundException;
import org.ojai.store.exceptions.FailedOp;
import org.ojai.store.exceptions.MultiOpException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API.Internal
public class MapRDBTableImpl
implements Table {
    private static Logger logger = LoggerFactory.getLogger(MapRDBTableImpl.class);
    public static final String PRESERVE_TS_STR = "maprdb.table.impl.preserve_timestamps";
    public static final String GET_DELETES_STR = "maprdb.table.impl.get_deletes";
    public static final String EXCLUDE_EMBEDDEDFAMILY_STR = "maprdb.table.impl.exclude_embeddedfamily";
    public static final String DECOMPRESS_STR = "maprdb.table.impl.decompress";
    public static final String READ_ALL_CFS_STR = "maprdb.table.impl.read_all_cfs";
    private static final long DEFAULT_BLOCK_SIZE = 8192L;
    final MapRHTable maprTable;
    boolean closed;
    LinkedHashMap<String, KeyValue> tableOptionsMap;
    LinkedHashMap<TablePrivateOption, Object> tablePrivateOptionsMap;
    BiMap<FieldPath, Integer> unSortedIdPathMap;
    BiMap<FieldPath, Integer> idPathMap;
    BiMap<FieldPath, Integer> sortedByPathMap;
    BiMap<Integer, String> idToCFNameMap;
    List<Map.Entry<FieldPath, Integer>> sortedById;
    private final TableDescriptorImpl tableDesc;
    private final boolean insOrderInTable;
    ExecutorService executor = Executors.newFixedThreadPool(8);
    @VisibleForTesting
    public int testMulitOpExIdx = 0;

    public MapRDBTableImpl(Path tablePath, Configuration config) throws DBException, TableNotFoundException {
        List cfAttrs = null;
        if (config.getInt("fs.mapr.threads", 0) == 0) {
            config.setInt("fs.mapr.threads", 64);
        }
        try {
            this.maprTable = new MapRHTable();
            this.maprTable.init(config, tablePath);
            if (!this.maprTable.getMapRFS().exists(tablePath)) {
                throw new TableNotFoundException(tablePath);
            }
            cfAttrs = this.maprTable.getMapRFS().listColumnFamily(this.maprTable.getTablePath(), false);
            this.closed = false;
        }
        catch (IOException e) {
            throw ExceptionHandler.handle(e, "<init>()");
        }
        this.tableOptionsMap = new LinkedHashMap();
        this.tablePrivateOptionsMap = new LinkedHashMap();
        this.tableOptionsMap.put("EXCLUDEID", DBValueBuilderImpl.KeyValueBuilder.initFrom(false));
        this.tableOptionsMap.put("BUFFERWRITE", DBValueBuilderImpl.KeyValueBuilder.initFrom(config.getBoolean("BUFFERWRITE", true)));
        TableProperties tblprop = this.maprTable.getInode().getTableProperties();
        if (!tblprop.getAttr().getJson()) {
            throw new OpNotPermittedException(tablePath + ": OJAI APIs are currently not supported with binary tables!");
        }
        this.insOrderInTable = tblprop.getAttr().getInsertionOrder();
        this.tableOptionsMap.put("KEEPINSERTIONORDER", DBValueBuilderImpl.KeyValueBuilder.initFrom(this.insOrderInTable));
        this.tablePrivateOptionsMap.put(TablePrivateOption.PRESERVE_TIMESTAMP, config.getBoolean(PRESERVE_TS_STR, false));
        this.tablePrivateOptionsMap.put(TablePrivateOption.GET_DELETES, config.getBoolean(GET_DELETES_STR, false));
        this.tablePrivateOptionsMap.put(TablePrivateOption.DECODE_TIMESTAMP, false);
        this.tablePrivateOptionsMap.put(TablePrivateOption.EXCLUDE_EMBEDDEDFAMILY, config.getBoolean(EXCLUDE_EMBEDDEDFAMILY_STR, false));
        this.tablePrivateOptionsMap.put(TablePrivateOption.DECOMPRESS, config.getBoolean(DECOMPRESS_STR, true));
        this.tablePrivateOptionsMap.put(TablePrivateOption.READ_ALL_CFS, config.getBoolean(READ_ALL_CFS_STR, true));
        MapRDBTableImplHelper.ComboMap ret = new MapRDBTableImplHelper.ComboMap();
        MapRDBTableImplHelper.getMaps(cfAttrs, ret);
        this.idToCFNameMap = ret.idToName;
        this.unSortedIdPathMap = ret.pathToId;
        this.sortedById = MapRDBTableImplHelper.sortByValueToList(this.unSortedIdPathMap);
        this.idPathMap = MapRDBTableImplHelper.sortByValue(this.unSortedIdPathMap);
        this.sortedByPathMap = MapRDBTableImplHelper.sortByPath(this.unSortedIdPathMap);
        this.tableDesc = new TableDescriptorImpl(tablePath, cfAttrs, tblprop, this.insOrderInTable);
        if (logger.isTraceEnabled() && this.idPathMap.size() > 1) {
            logger.trace("CF Path to Id Map unsorted: '{}'", this.unSortedIdPathMap);
            logger.trace("CF id List: '{}'", this.sortedById);
            logger.trace("CF Path to Id Map sorted by id: '{}'", this.idPathMap);
            logger.trace("CF Path to Id Map sorted by path: '{}'", this.sortedByPathMap);
            logger.trace("CF id to CF name Map: '{}'", this.idToCFNameMap);
        }
    }

    public MapRHTable maprTable() {
        return this.maprTable;
    }

    public BiMap<FieldPath, Integer> idPathMap() {
        return this.idPathMap;
    }

    List<Map.Entry<FieldPath, Integer>> sortedById() {
        return this.sortedById;
    }

    public Map<FieldPath, Integer> sortedByPath() {
        return this.sortedByPathMap;
    }

    public Map<Integer, String> idToCFNameMap() {
        return this.idToCFNameMap;
    }

    @Override
    public MapRDBTableImpl setOption(Table.TableOption option, boolean value) {
        switch (option) {
            case EXCLUDEID: {
                this.tableOptionsMap.put("EXCLUDEID", DBValueBuilderImpl.KeyValueBuilder.initFrom(value));
                break;
            }
            case BUFFERWRITE: {
                this.tableOptionsMap.put("BUFFERWRITE", DBValueBuilderImpl.KeyValueBuilder.initFrom(value));
                break;
            }
            case KEEPINSERTIONORDER: {
                if (value && !this.insOrderInTable) {
                    logger.error("Cannot set insertion order if table creation did not specify it. Ignoring the setting.");
                    return this;
                }
                this.tableOptionsMap.put("KEEPINSERTIONORDER", DBValueBuilderImpl.KeyValueBuilder.initFrom(value));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown table option " + (Object)((Object)option));
            }
        }
        return this;
    }

    private boolean isExcludeId() {
        return this.tableOptionsMap.get("EXCLUDEID").getBoolean();
    }

    private boolean isBufferWrite() {
        return this.tableOptionsMap.get("BUFFERWRITE").getBoolean();
    }

    public boolean isKeepInsertionOrder() {
        return this.tableOptionsMap.get("KEEPINSERTIONORDER").getBoolean();
    }

    public boolean getDeletes() {
        return this.getPrivateOption(TablePrivateOption.GET_DELETES);
    }

    public boolean isStream() {
        return this.tableDesc.isStream();
    }

    public boolean isPreserveTS() {
        return this.getPrivateOption(TablePrivateOption.PRESERVE_TIMESTAMP);
    }

    public boolean shouldDecompress() {
        return this.getPrivateOption(TablePrivateOption.DECOMPRESS);
    }

    public boolean decodeTimestamp() {
        return this.getPrivateOption(TablePrivateOption.DECODE_TIMESTAMP);
    }

    public void setExcludeEmbeddedFamily(boolean v) {
        this.setPrivateOption(TablePrivateOption.EXCLUDE_EMBEDDEDFAMILY, v);
    }

    public boolean excludeEmbeddedFamily() {
        return this.getPrivateOption(TablePrivateOption.EXCLUDE_EMBEDDEDFAMILY);
    }

    public void setReadAllCfs(boolean v) {
        this.setPrivateOption(TablePrivateOption.READ_ALL_CFS, v);
    }

    public boolean readAllCfs() {
        return this.getPrivateOption(TablePrivateOption.READ_ALL_CFS);
    }

    @Override
    public Value getOption(Table.TableOption option) {
        switch (option) {
            case EXCLUDEID: {
                return this.tableOptionsMap.get("EXCLUDEID");
            }
            case BUFFERWRITE: {
                return this.tableOptionsMap.get("BUFFERWRITE");
            }
            case KEEPINSERTIONORDER: {
                return this.tableOptionsMap.get("KEEPINSERTIONORDER");
            }
        }
        throw new IllegalArgumentException("Unknown table option " + (Object)((Object)option));
    }

    public MapRDBTableImpl setPrivateOption(TablePrivateOption option, boolean value) {
        switch (option) {
            case PRESERVE_TIMESTAMP: 
            case GET_DELETES: 
            case DECODE_TIMESTAMP: 
            case EXCLUDE_EMBEDDEDFAMILY: 
            case DECOMPRESS: 
            case READ_ALL_CFS: {
                this.tablePrivateOptionsMap.put(option, value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown table option " + (Object)((Object)option));
            }
        }
        return this;
    }

    public boolean getPrivateOption(TablePrivateOption option) {
        switch (option) {
            case PRESERVE_TIMESTAMP: 
            case GET_DELETES: 
            case DECODE_TIMESTAMP: 
            case EXCLUDE_EMBEDDEDFAMILY: 
            case DECOMPRESS: 
            case READ_ALL_CFS: {
                return (Boolean)this.tablePrivateOptionsMap.get((Object)option);
            }
        }
        throw new IllegalArgumentException("Unknown table option " + (Object)((Object)option));
    }

    @Override
    public String getName() {
        return this.getPath().getName();
    }

    @Override
    public Path getPath() {
        return this.tableDesc.getPath();
    }

    @Override
    public TableDescriptor getTableDescriptor() {
        return this.tableDesc;
    }

    @Override
    public void flush() throws DBException {
        try {
            this.maprTable.flushCommits();
        }
        catch (IOException e) {
            throw ExceptionHandler.handle(e, "flush()");
        }
    }

    private void checkClosed() throws DBException {
        if (this.closed) {
            throw new TableClosedException("Cannot perform the op on a closed table " + this.getPath());
        }
    }

    @Override
    public Document findById(String id) throws DBException {
        return this._findById(IdCodec.encode(id), (QueryCondition)null, (String[])null);
    }

    @Override
    public Document findById(ByteBuffer id) throws DBException {
        return this._findById(IdCodec.encode(id), (QueryCondition)null, (String[])null);
    }

    @Override
    public Document findById(Value id) throws DBException {
        return this._findById(IdCodec.encode(id), (QueryCondition)null, (String[])null);
    }

    private String[] getStringPaths(FieldPath ... fields) {
        if (fields == null) {
            return null;
        }
        String[] stringpaths = new String[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            stringpaths[i] = fields[i].asPathString();
        }
        return stringpaths;
    }

    @Override
    public Document findById(String id, FieldPath ... fields) throws DBException {
        return this.findById(id, this.getStringPaths(fields));
    }

    @Override
    public Document findById(String id, String ... paths) throws DBException {
        return this._findById(IdCodec.encode(id), (QueryCondition)null, paths);
    }

    @Override
    public Document findById(ByteBuffer id, FieldPath ... fields) throws DBException {
        return this.findById(id, this.getStringPaths(fields));
    }

    @Override
    public Document findById(ByteBuffer id, String ... paths) throws DBException {
        return this._findById(IdCodec.encode(id), (QueryCondition)null, paths);
    }

    public Document findById(Value id, FieldPath ... fields) throws DBException {
        return this.findById(id, this.getStringPaths(fields));
    }

    public Document findById(Value id, String ... paths) throws DBException {
        return this._findById(IdCodec.encode(id), (QueryCondition)null, paths);
    }

    @Override
    public Document findById(String id, QueryCondition c) throws DBException {
        return this._findById(IdCodec.encode(id), c, new String[0]);
    }

    @Override
    public Document findById(ByteBuffer id, QueryCondition c) throws DBException {
        return this._findById(IdCodec.encode(id), c, new String[0]);
    }

    public Document findById(Value id, QueryCondition c) throws DBException {
        return this._findById(IdCodec.encode(id), c, new String[0]);
    }

    @Override
    public Document findById(String id, QueryCondition c, FieldPath ... fields) throws DBException {
        return this.findById(id, c, this.getStringPaths(fields));
    }

    @Override
    public Document findById(String id, QueryCondition c, String ... paths) throws DBException {
        return this._findById(IdCodec.encode(id), c, paths);
    }

    @Override
    public Document findById(ByteBuffer id, QueryCondition c, FieldPath ... fields) throws DBException {
        return this.findById(id, c, this.getStringPaths(fields));
    }

    @Override
    public Document findById(ByteBuffer id, QueryCondition c, String ... paths) throws DBException {
        return this._findById(IdCodec.encode(id), c, paths);
    }

    public Document findById(Value id, QueryCondition c, String ... paths) throws DBException {
        return this._findById(IdCodec.encode(id), c, paths);
    }

    public Document findById(Value id, QueryCondition c, FieldPath ... fields) throws DBException {
        return this.findById(id, c, this.getStringPaths(fields));
    }

    private Document _findById(ByteBuffer id, QueryCondition c, String ... paths) throws DBException {
        this.checkClosed();
        Document d = null;
        while (true) {
            try {
                d = MapRDBTableImplHelper.doGet(this, id, c, this.isExcludeId(), paths);
            }
            catch (DBRetryException re) {
                this.updateSchema();
                continue;
            }
            break;
        }
        return d;
    }

    @Override
    public void findById(OpListener listener, String id) {
        this._findById(listener, IdCodec.encode(id), (QueryCondition)null, (String[])null);
    }

    @Override
    public void findById(OpListener listener, ByteBuffer id) {
        this._findById(listener, IdCodec.encode(id), (QueryCondition)null, (String[])null);
    }

    public void findById(OpListener listener, Value id) {
        this._findById(listener, IdCodec.encode(id), (QueryCondition)null, (String[])null);
    }

    @Override
    public void findById(OpListener listener, String id, FieldPath ... fields) {
        this.findById(listener, id, this.getStringPaths(fields));
    }

    @Override
    public void findById(OpListener listener, String id, String ... paths) {
        this._findById(listener, IdCodec.encode(id), null, paths);
    }

    @Override
    public void findById(OpListener listener, ByteBuffer id, FieldPath ... fields) {
        this.findById(listener, id, this.getStringPaths(fields));
    }

    @Override
    public void findById(OpListener listener, ByteBuffer id, String ... paths) {
        this._findById(listener, IdCodec.encode(id), null, paths);
    }

    public void findById(OpListener listener, Value id, String ... paths) {
        this._findById(listener, IdCodec.encode(id), null, paths);
    }

    public void findById(OpListener listener, Value id, FieldPath ... fields) {
        this.findById(listener, id, this.getStringPaths(fields));
    }

    @Override
    public void findById(OpListener listener, String id, QueryCondition c) {
        this._findById(listener, IdCodec.encode(id), c, new String[0]);
    }

    @Override
    public void findById(OpListener listener, ByteBuffer id, QueryCondition c) {
        this._findById(listener, IdCodec.encode(id), c, new String[0]);
    }

    public void findById(OpListener listener, Value id, QueryCondition c) {
        this._findById(listener, IdCodec.encode(id), c, new String[0]);
    }

    @Override
    public void findById(OpListener listener, String id, QueryCondition c, FieldPath ... fields) {
        this.findById(listener, id, c, this.getStringPaths(fields));
    }

    @Override
    public void findById(OpListener listener, String id, QueryCondition c, String ... paths) {
        this._findById(listener, IdCodec.encode(id), c, paths);
    }

    @Override
    public void findById(OpListener listener, ByteBuffer id, QueryCondition c, FieldPath ... fields) {
        this.findById(listener, id, c, this.getStringPaths(fields));
    }

    @Override
    public void findById(OpListener listener, ByteBuffer id, QueryCondition c, String ... paths) {
        this._findById(listener, IdCodec.encode(id), c, paths);
    }

    public void findById(OpListener listener, Value id, QueryCondition c, FieldPath ... fields) {
        this.findById(listener, id, c, this.getStringPaths(fields));
    }

    public void findById(OpListener listener, Value id, QueryCondition c, String ... paths) {
        this._findById(listener, IdCodec.encode(id), c, paths);
    }

    private void _findById(OpListener listener, ByteBuffer id, QueryCondition c, String ... paths) {
        this.executor.execute(new AsyncReader(listener, id, c, paths));
    }

    @Override
    public DocumentStream find() throws DBException {
        return this.find((QueryCondition)null, (String[])null);
    }

    @Override
    public DocumentStream find(String ... paths) throws DBException {
        return this.find((QueryCondition)null, paths);
    }

    @Override
    public DocumentStream find(FieldPath ... fields) throws DBException {
        return this.find((QueryCondition)null, this.getStringPaths(fields));
    }

    @Override
    public DocumentStream find(QueryCondition c) throws DBException {
        return this.find(c, (String[])null);
    }

    @Override
    public DocumentStream find(QueryCondition c, String ... paths) throws DBException {
        this.checkClosed();
        DocumentStream d = null;
        while (true) {
            try {
                d = this.doFind(c, paths);
            }
            catch (DBRetryException re) {
                this.updateSchema();
                continue;
            }
            break;
        }
        return d;
    }

    private DocumentStream doFind(QueryCondition c, String ... paths) throws DBException {
        MapRDBTableImplHelper.CondAndProjPaths bothpaths = new MapRDBTableImplHelper.CondAndProjPaths();
        MapRDBTableImplHelper.setPaths(c, paths, bothpaths);
        MapRScan maprscan = MapRDBTableImplHelper.toMapRScan(this, c, bothpaths.allPaths);
        try {
            long id = this.maprTable.getInode().getScanner(maprscan);
            MapRResultScanner scanner = new MapRResultScanner(maprscan, this.maprTable, id);
            this.maprTable.addScanner(scanner);
            if (paths != null) {
                return new DBDocumentStream(scanner, this.isExcludeId(), this, bothpaths.condPaths, paths);
            }
            return new DBDocumentStream(scanner, this.isExcludeId(), this);
        }
        catch (IOException e) {
            throw ExceptionHandler.handle(e, "find()");
        }
    }

    @Override
    public DocumentStream find(QueryCondition c, FieldPath ... fields) throws DBException {
        return this.find(c, this.getStringPaths(fields));
    }

    @Override
    public void insertOrReplace(Document r) throws DBException {
        Preconditions.checkNotNull((Object)r, (Object)"Document being inserted cannot be null");
        DBDocumentImpl mdbRec = RowcolCodec.getDBDocument(r);
        Value id = mdbRec.getId();
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"Document needs to have '_id' in the map as a key.");
        this.insertOrReplace(id, r);
    }

    @Override
    public void insertOrReplace(String id, Document r) throws DBException {
        this._insertOrReplace(IdCodec.encode(id), r);
    }

    @Override
    public void insertOrReplace(ByteBuffer id, Document r) throws DBException {
        this._insertOrReplace(IdCodec.encode(id), r);
    }

    public void insertOrReplace(Value id, Document r) throws DBException {
        this._insertOrReplace(IdCodec.encode(id), r);
    }

    private void checkDuplicateIds(ByteBuffer id, Document r) {
        Value recIdVal = r.getId();
        ByteBuffer encodedRecId = null;
        if (recIdVal != null && !(encodedRecId = IdCodec.encode(recIdVal)).equals(id)) {
            String errorMsg = null;
            errorMsg = recIdVal.getType() == Value.Type.STRING ? "Document needs to have '_id' value same as passed id of " + IdCodec.decodeString(id) + " while Document has " + recIdVal.getString() : "Document needs to have '_id' value same as the passed in id ";
            throw new IllegalArgumentException(errorMsg);
        }
    }

    private void _insertOrReplace(ByteBuffer inId, Document r) throws DBException {
        Preconditions.checkNotNull((Object)r, (Object)"Document being inserted cannot be null");
        this.checkClosed();
        ByteBuffer id = ByteBufs.ensurePreferred(inId);
        this.checkDuplicateIds(id, r);
        SerializedFamilyInfo[] info = RowcolCodec.encode(r, this.idPathMap, false, this.isPreserveTS());
        assert (info.length == this.sortedById().size());
        EncodedBufFamIdInfo ebf = MapRDBTableImplHelper.getEncBufsAndFamilyIds(info);
        MapRPut mput = MapRDBTableImplHelper.toMapRPut(id, ebf.familyIds, ebf.encBuffers, (byte)0);
        try {
            if (this.isBufferWrite()) {
                this.maprTable.put(mput);
            } else {
                this.maprTable.syncPut(mput, true);
            }
        }
        catch (IOException e) {
            throw ExceptionHandler.handle(e, "insertOrReplace()");
        }
    }

    private ByteBuffer getKeyFieldsValue(Document r, String fieldAsKey) throws DBException {
        if (r == null) {
            throw new IllegalArgumentException("Document cannot be null");
        }
        if (fieldAsKey == null) {
            throw new IllegalArgumentException("Requested key cannot be null.");
        }
        Value value = r.getValue(fieldAsKey);
        if (value == null) {
            throw new IllegalArgumentException("Requested key's value cannot be null in the record.");
        }
        return IdCodec.encode(value);
    }

    @Override
    public void insertOrReplace(Document r, FieldPath fieldAsKey) throws DBException {
        this.insertOrReplace(r, fieldAsKey.asPathString());
    }

    @Override
    public void insertOrReplace(Document r, String fieldAsKey) throws DBException {
        ByteBuffer id = this.getKeyFieldsValue(r, fieldAsKey);
        this._insertOrReplace(id, r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<FailedOp> processBatch(List<Document> batch, BatchingType type, String fieldAsKey) {
        AsyncBatchInfo abi = new AsyncBatchInfo(batch.size(), type, fieldAsKey);
        for (int i = 0; i < batch.size(); ++i) {
            this.executor.execute(new AsyncBatchElement(batch.get(i), abi, i));
        }
        try {
            AsyncBatchInfo i = abi;
            synchronized (i) {
                while (abi.numCompl < abi.numObj) {
                    abi.wait();
                }
            }
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        batch.clear();
        return abi.failedDocuments;
    }

    @Override
    public void insertOrReplace(DocumentStream rs) throws MultiOpException {
        String fak = null;
        this.insertOrReplace(rs, fak);
    }

    @Override
    public void insertOrReplace(DocumentStream rs, FieldPath fieldAsKey) throws MultiOpException {
        this.insertOrReplace(rs, fieldAsKey.asPathString());
    }

    @Override
    public void insertOrReplace(DocumentStream rs, String fieldAsKey) throws MultiOpException {
        Iterator itrs = rs.iterator();
        List<Object> failedDocuments = null;
        ArrayList<Document> batchedDocumentList = new ArrayList<Document>();
        boolean hitWriteError = false;
        while (itrs.hasNext()) {
            Document readDocument = (Document)itrs.next();
            if (readDocument == null) {
                failedDocuments = new ArrayList<FailedOp>();
                failedDocuments.add(new FailedOp(readDocument, (Exception)new IllegalArgumentException()));
                if (rs instanceof DBDocumentStream) {
                    ((DBDocumentStream)rs).makeIteratorNotOpen();
                }
                throw new MultiOpException(failedDocuments);
            }
            batchedDocumentList.add(readDocument);
            if (batchedDocumentList.size() == 8) {
                failedDocuments = this.processBatch(batchedDocumentList, BatchingType.INSERTORREPLACE, fieldAsKey);
            }
            if (failedDocuments == null || failedDocuments.size() == 0) continue;
            hitWriteError = true;
            break;
        }
        if (!hitWriteError && batchedDocumentList.size() != 0) {
            failedDocuments = this.processBatch(batchedDocumentList, BatchingType.INSERTORREPLACE, fieldAsKey);
        }
        if (failedDocuments != null && failedDocuments.size() != 0) {
            if (rs instanceof DBDocumentStream) {
                ((DBDocumentStream)rs).makeIteratorNotOpen();
            }
            throw new MultiOpException(failedDocuments);
        }
    }

    @Override
    public void update(String id, DocumentMutation m) throws DBException {
        this._update(IdCodec.encode(id), m);
    }

    @Override
    public void update(ByteBuffer id, DocumentMutation m) throws DBException {
        this._update(IdCodec.encode(id), m);
    }

    public void update(Value id, DocumentMutation m) throws DBException {
        this._update(IdCodec.encode(id), m);
    }

    private void _update(ByteBuffer inId, DocumentMutation m) throws DBException {
        this.checkClosed();
        ByteBuffer id = ByteBufs.ensurePreferred(inId);
        MutationImpl rmi = (MutationImpl)m;
        SerializedFamilyInfo[] info = rmi.rowcolSerialize((Map<FieldPath, Integer>)this.idPathMap);
        boolean isRMW = rmi.needsReadOnServer();
        if (isRMW) {
            MapRUpdateAndGet muag = new MapRUpdateAndGet();
            assert (info.length == this.idPathMap.size());
            EncodedBufFamIdInfo ebf = MapRDBTableImplHelper.getEncBufsAndFamilyIds(info);
            Map<Integer, List<String>> fieldsMap = rmi.getFieldsNeedRead((Map<FieldPath, Integer>)this.idPathMap);
            byte[] serRowConstraint = MapRDBTableImplHelper.fieldPathsToSerRowConstraint(fieldsMap);
            assert (serRowConstraint != null);
            try {
                this.maprTable.updateRecord(id, ebf.encBuffers, ebf.familyIds, serRowConstraint, this.isBufferWrite(), muag);
            }
            catch (IOException e) {
                throw ExceptionHandler.handle(e, "update()");
            }
        } else {
            MapRDBTableImplHelper.insertOrReplace(this, id, info);
        }
    }

    @Override
    public void delete(String id) throws DBException {
        this._delete(IdCodec.encode(id));
    }

    @Override
    public void delete(ByteBuffer id) throws DBException {
        this._delete(IdCodec.encode(id));
    }

    public void delete(Value id) throws DBException {
        this._delete(IdCodec.encode(id));
    }

    @Override
    public void delete(Document r) throws DBException {
        Preconditions.checkArgument((r != null ? 1 : 0) != 0, (Object)"Document being deleted cannot be null");
        DBDocumentImpl mdbRec = RowcolCodec.getDBDocument(r);
        Value id = mdbRec.getId();
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"Document needs to have '_id' in the map as a key.");
        this.delete(id);
    }

    @Override
    public void delete(Document r, FieldPath fieldAsKey) throws DBException {
        this.delete(r, fieldAsKey.asPathString());
    }

    @Override
    public void delete(Document r, String fieldAsKey) throws DBException {
        this._delete(this.getKeyFieldsValue(r, fieldAsKey));
    }

    private void _delete(ByteBuffer inId) throws DBException {
        this.checkClosed();
        int[] famIds = new int[this.sortedById().size()];
        int i = 0;
        for (Map.Entry<FieldPath, Integer> entry : this.sortedById()) {
            famIds[i] = entry.getValue();
            ++i;
        }
        ByteBuffer id = ByteBufs.ensurePreferred(inId);
        MapRPut mput = MapRDBTableImplHelper.toMapRPut(id, famIds, null, (byte)17);
        try {
            if (this.isBufferWrite()) {
                this.maprTable.put(mput);
            } else {
                this.maprTable.syncPut(mput, true);
            }
        }
        catch (IOException e) {
            throw ExceptionHandler.handle(e, "delete()");
        }
    }

    @Override
    public void delete(DocumentStream rs, FieldPath fieldAsKey) throws MultiOpException {
        this.delete(rs, fieldAsKey.asPathString());
    }

    @Override
    public void delete(DocumentStream rs) throws MultiOpException {
        String fak = null;
        this.delete(rs, fak);
    }

    @Override
    public void delete(DocumentStream rs, String fieldAsKey) throws MultiOpException {
        Iterator itrs = rs.iterator();
        List<Object> failedDocuments = new ArrayList<FailedOp>();
        ArrayList<Document> batchedDocumentList = new ArrayList<Document>();
        boolean hitDeleteError = false;
        while (itrs.hasNext()) {
            Document readDocument = (Document)itrs.next();
            if (readDocument == null) {
                failedDocuments = new ArrayList();
                failedDocuments.add(new FailedOp(readDocument, (Exception)new IllegalArgumentException()));
                if (rs instanceof DBDocumentStream) {
                    ((DBDocumentStream)rs).makeIteratorNotOpen();
                }
                throw new MultiOpException(failedDocuments);
            }
            batchedDocumentList.add(readDocument);
            if (batchedDocumentList.size() == 8) {
                failedDocuments = this.processBatch(batchedDocumentList, BatchingType.DELETE, fieldAsKey);
            }
            if (failedDocuments == null || failedDocuments.size() == 0) continue;
            hitDeleteError = true;
            break;
        }
        if (!hitDeleteError && batchedDocumentList.size() != 0) {
            failedDocuments = this.processBatch(batchedDocumentList, BatchingType.DELETE, fieldAsKey);
        }
        if (failedDocuments != null && failedDocuments.size() != 0) {
            if (rs instanceof DBDocumentStream) {
                ((DBDocumentStream)rs).makeIteratorNotOpen();
            }
            throw new MultiOpException(failedDocuments);
        }
    }

    @Override
    public void increment(String id, String field, long inc) throws DBException {
        this._update(IdCodec.encode(id), new MutationImpl().increment(field, inc));
    }

    @Override
    public void increment(ByteBuffer id, String field, long inc) throws DBException {
        this._update(IdCodec.encode(id), new MutationImpl().increment(field, inc));
    }

    public void increment(Value id, String field, long inc) throws DBException {
        this._update(IdCodec.encode(id), new MutationImpl().increment(field, inc));
    }

    @Override
    public void increment(String id, String field, float inc) throws DBException {
        this._update(IdCodec.encode(id), new MutationImpl().increment(field, inc));
    }

    @Override
    public void increment(ByteBuffer id, String field, float inc) throws DBException {
        this._update(IdCodec.encode(id), new MutationImpl().increment(field, inc));
    }

    public void increment(Value id, String field, float inc) throws DBException {
        this._update(IdCodec.encode(id), new MutationImpl().increment(field, inc));
    }

    @Override
    public void increment(String id, String field, double inc) throws DBException {
        this._update(IdCodec.encode(id), new MutationImpl().increment(field, inc));
    }

    @Override
    public void increment(ByteBuffer id, String field, double inc) throws DBException {
        this._update(IdCodec.encode(id), new MutationImpl().increment(field, inc));
    }

    public void increment(Value id, String field, double inc) throws DBException {
        this._update(IdCodec.encode(id), new MutationImpl().increment(field, inc));
    }

    @Override
    public void increment(String id, String field, BigDecimal inc) throws DBException {
        this._update(IdCodec.encode(id), new MutationImpl().increment(field, inc));
    }

    @Override
    public void increment(ByteBuffer id, String field, BigDecimal inc) throws DBException {
        this._update(IdCodec.encode(id), new MutationImpl().increment(field, inc));
    }

    public void increment(Value id, String field, BigDecimal inc) throws DBException {
        this._update(IdCodec.encode(id), new MutationImpl().increment(field, inc));
    }

    @Override
    public void increment(String id, String field, byte inc) throws DBException {
        this._update(IdCodec.encode(id), new MutationImpl().increment(field, inc));
    }

    @Override
    public void increment(ByteBuffer id, String field, byte inc) throws DBException {
        this._update(IdCodec.encode(id), new MutationImpl().increment(field, inc));
    }

    public void increment(Value id, String field, byte inc) throws DBException {
        this._update(IdCodec.encode(id), new MutationImpl().increment(field, inc));
    }

    @Override
    public void increment(String id, String field, short inc) throws DBException {
        this._update(IdCodec.encode(id), new MutationImpl().increment(field, inc));
    }

    @Override
    public void increment(ByteBuffer id, String field, short inc) throws DBException {
        this._update(IdCodec.encode(id), new MutationImpl().increment(field, inc));
    }

    public void increment(Value id, String field, short inc) throws DBException {
        this._update(IdCodec.encode(id), new MutationImpl().increment(field, inc));
    }

    @Override
    public void increment(String id, String field, int inc) throws DBException {
        this._update(IdCodec.encode(id), new MutationImpl().increment(field, inc));
    }

    @Override
    public void increment(ByteBuffer id, String field, int inc) throws DBException {
        this._update(IdCodec.encode(id), new MutationImpl().increment(field, inc));
    }

    public void increment(Value id, String field, int inc) throws DBException {
        this._update(IdCodec.encode(id), new MutationImpl().increment(field, inc));
    }

    @Override
    public void insert(String id, Document r) throws DBException {
        this._insert(IdCodec.encode(id), r);
    }

    @Override
    public void insert(ByteBuffer id, Document r) throws DBException {
        this._insert(IdCodec.encode(id), r);
    }

    public void insert(Value id, Document r) throws DBException {
        this._insert(IdCodec.encode(id), r);
    }

    @Override
    public void insert(Document r) throws DBException {
        Document mdbRec = r instanceof Document ? r : (Document)DBValueBuilderImpl.KeyValueBuilder.initFrom(r);
        Value id = mdbRec.getId();
        if (id == null) {
            throw new IllegalArgumentException("Document needs to have '_id' in the map as a key.");
        }
        this.insert(id, r);
    }

    private void _insert(ByteBuffer inId, Document r) throws DBException {
        this.checkClosed();
        ByteBuffer id = ByteBufs.ensurePreferred(inId);
        if (!this._checkAndReplace(id, Constants.ROW_NOT_EXISTS_CONDITION, r)) {
            throw new DocumentExistsException("A row with key \"" + Bytes.toStringBinary((ByteBuffer)id) + "\" already exist in the table");
        }
    }

    @Override
    public void insert(Document r, FieldPath fieldAsKey) throws DBException {
        this.insert(r, fieldAsKey.asPathString());
    }

    @Override
    public void insert(Document r, String fieldAsKey) throws DBException {
        this._insert(this.getKeyFieldsValue(r, fieldAsKey), r);
    }

    @Override
    public void insert(DocumentStream rs, FieldPath fieldAsKey) throws MultiOpException {
        this.insert(rs, fieldAsKey.asPathString());
    }

    @Override
    public void insert(DocumentStream rs) throws MultiOpException {
        String fak = null;
        this.insertOrReplace(rs, fak);
    }

    @Override
    public void insert(DocumentStream rs, String fieldAsKey) throws MultiOpException {
        Iterator itrs = rs.iterator();
        List<Object> failedDocuments = null;
        ArrayList<Document> batchedDocumentList = new ArrayList<Document>();
        boolean hitError = false;
        while (itrs.hasNext()) {
            Document readDocument = (Document)itrs.next();
            if (readDocument == null) {
                failedDocuments = new ArrayList<FailedOp>();
                failedDocuments.add(new FailedOp(readDocument, (Exception)new IllegalArgumentException()));
                if (rs instanceof DBDocumentStream) {
                    ((DBDocumentStream)rs).makeIteratorNotOpen();
                }
                throw new MultiOpException(failedDocuments);
            }
            batchedDocumentList.add(readDocument);
            if (batchedDocumentList.size() == 8) {
                failedDocuments = this.processBatch(batchedDocumentList, BatchingType.INSERT, fieldAsKey);
            }
            if (failedDocuments == null || failedDocuments.size() == 0) continue;
            hitError = true;
            break;
        }
        if (!hitError && batchedDocumentList.size() != 0) {
            failedDocuments = this.processBatch(batchedDocumentList, BatchingType.INSERT, fieldAsKey);
        }
        if (failedDocuments != null && failedDocuments.size() != 0) {
            if (rs instanceof DBDocumentStream) {
                ((DBDocumentStream)rs).makeIteratorNotOpen();
            }
            throw new MultiOpException(failedDocuments);
        }
    }

    @Override
    public void replace(String id, Document r) throws DBException {
        this._replace(IdCodec.encode(id), r);
    }

    @Override
    public void replace(ByteBuffer id, Document r) throws DBException {
        this._replace(IdCodec.encode(id), r);
    }

    public void replace(Value id, Document r) throws DBException {
        this._replace(IdCodec.encode(id), r);
    }

    @Override
    public void replace(Document r) throws DBException {
        Document mdbRec = r instanceof Document ? r : (Document)DBValueBuilderImpl.KeyValueBuilder.initFrom(r);
        Value id = mdbRec.getId();
        if (id == null) {
            throw new IllegalArgumentException("Document needs to have '_id' in the map as a key.");
        }
        this.replace(id, r);
    }

    private void _replace(ByteBuffer inId, Document r) throws DBException {
        this.checkClosed();
        ByteBuffer id = ByteBufs.ensurePreferred(inId);
        if (!this._checkAndReplace(id, Constants.ROW_EXISTS_CONDITION, r)) {
            throw new DocumentNotFoundException("A row with key \"" + Bytes.toStringBinary((ByteBuffer)id) + "\" does not exist in the table");
        }
    }

    @Override
    public void replace(Document r, FieldPath fieldAsKey) throws DBException {
        this.replace(r, fieldAsKey.asPathString());
    }

    @Override
    public void replace(Document r, String fieldAsKey) throws DBException {
        ByteBuffer id = this.getKeyFieldsValue(r, fieldAsKey);
        this._replace(id, r);
    }

    @Override
    public void replace(DocumentStream rs, FieldPath fieldAsKey) throws MultiOpException {
        this.replace(rs, fieldAsKey.asPathString());
    }

    @Override
    public void replace(DocumentStream rs) throws MultiOpException {
        String fak = null;
        this.replace(rs, fak);
    }

    @Override
    public void replace(DocumentStream rs, String fieldAsKey) throws MultiOpException {
        Iterator itrs = rs.iterator();
        List<Object> failedDocuments = null;
        ArrayList<Document> batchedDocumentList = new ArrayList<Document>();
        boolean hitError = false;
        while (itrs.hasNext()) {
            Document readDocument = (Document)itrs.next();
            if (readDocument == null) {
                failedDocuments = new ArrayList<FailedOp>();
                failedDocuments.add(new FailedOp(readDocument, (Exception)new IllegalArgumentException()));
                if (rs instanceof DBDocumentStream) {
                    ((DBDocumentStream)rs).makeIteratorNotOpen();
                }
                throw new MultiOpException(failedDocuments);
            }
            batchedDocumentList.add(readDocument);
            if (batchedDocumentList.size() == 8) {
                failedDocuments = this.processBatch(batchedDocumentList, BatchingType.REPLACE, fieldAsKey);
            }
            if (failedDocuments == null || failedDocuments.size() == 0) continue;
            hitError = true;
            break;
        }
        if (!hitError && batchedDocumentList.size() != 0) {
            failedDocuments = this.processBatch(batchedDocumentList, BatchingType.REPLACE, fieldAsKey);
        }
        if (failedDocuments != null && failedDocuments.size() != 0) {
            if (rs instanceof DBDocumentStream) {
                ((DBDocumentStream)rs).makeIteratorNotOpen();
            }
            throw new MultiOpException(failedDocuments);
        }
    }

    @Override
    public boolean checkAndMutate(String id, QueryCondition condition, DocumentMutation m) throws DBException {
        return this._checkAndMutate(IdCodec.encode(id), condition, m);
    }

    @Override
    public boolean checkAndMutate(ByteBuffer id, QueryCondition condition, DocumentMutation m) throws DBException {
        return this._checkAndMutate(IdCodec.encode(id), condition, m);
    }

    public boolean checkAndMutate(Value id, QueryCondition condition, DocumentMutation m) throws DBException {
        return this._checkAndMutate(IdCodec.encode(id), condition, m);
    }

    private boolean _checkAndMutate(ByteBuffer inId, QueryCondition condition, DocumentMutation m) throws DBException {
        if (m == null) {
            throw new NullPointerException("DocumentMutation cannot be null");
        }
        if (condition == null || condition.isEmpty()) {
            throw new IllegalArgumentException("QueryCondition cannot be null or empty");
        }
        this.checkClosed();
        ConditionDescriptor condDesc = ((ConditionImpl)condition).getDescriptor(this.idPathMap);
        ByteBuffer serCond = ByteBufs.ensurePreferred(condDesc.getSerialized());
        MutationImpl rmi = (MutationImpl)m;
        SerializedFamilyInfo[] info = rmi.rowcolSerialize((Map<FieldPath, Integer>)this.idPathMap);
        assert (info.length == this.idPathMap.size());
        MapRUpdateAndGet muag = new MapRUpdateAndGet();
        EncodedBufFamIdInfo ebf = MapRDBTableImplHelper.getEncBufsAndFamilyIds(info);
        byte[] serRowConstraint = MapRDBTableImplHelper.fieldPathsToSerRowConstraint(MapRDBTableImplHelper.mergeFieldPathList(rmi.getFieldsNeedRead((Map<FieldPath, Integer>)this.idPathMap), MapRDBTableImplHelper.condFieldPathMapToCondFieldPathStrMap(condDesc.getFamilyFieldPathsMap())));
        ByteBuffer id = ByteBufs.ensurePreferred(inId);
        try {
            this.maprTable.checkAndMutate(id, ebf.encBuffers, ebf.familyIds, serRowConstraint, serCond, this.isBufferWrite(), muag);
        }
        catch (IOException e) {
            throw ExceptionHandler.handle(e, "checkAndMutate()");
        }
        return muag.conditionSuccess;
    }

    @Override
    public boolean checkAndDelete(String id, QueryCondition condition) throws DBException {
        return this._checkAndDelete(IdCodec.encode(id), condition);
    }

    @Override
    public boolean checkAndDelete(ByteBuffer id, QueryCondition condition) throws DBException {
        return this._checkAndDelete(IdCodec.encode(id), condition);
    }

    public boolean checkAndDelete(Value id, QueryCondition condition) throws DBException {
        return this._checkAndDelete(IdCodec.encode(id), condition);
    }

    private boolean _checkAndDelete(ByteBuffer inId, QueryCondition condition) throws DBException {
        if (condition == null || condition.isEmpty()) {
            throw new IllegalArgumentException("QueryCondition cannot be null or empty");
        }
        this.checkClosed();
        ByteBuffer id = ByteBufs.ensurePreferred(inId);
        ConditionDescriptor condDesc = ((ConditionImpl)condition).getDescriptor(this.idPathMap);
        ByteBuffer serCond = ByteBufs.ensurePreferred(condDesc.getSerialized());
        int[] famIds = new int[this.idPathMap().size()];
        int i = 0;
        for (Map.Entry entry : this.idPathMap().entrySet()) {
            famIds[i++] = (Integer)entry.getValue();
        }
        MapRUpdateAndGet muag = new MapRUpdateAndGet();
        byte[] serRowConstraint = MapRDBTableImplHelper.fieldPathsToSerRowConstraint(MapRDBTableImplHelper.condFieldPathMapToCondFieldPathStrMap(condDesc.getFamilyFieldPathsMap()));
        try {
            this.maprTable.checkAndReplaceOrDelete(id, null, famIds, serRowConstraint, serCond, this.isBufferWrite(), true, muag);
        }
        catch (IOException e) {
            throw ExceptionHandler.handle(e, "checkAndDelete");
        }
        return muag.conditionSuccess;
    }

    @Override
    public boolean checkAndReplace(String id, QueryCondition condition, Document r) throws DBException {
        return this._checkAndReplace(IdCodec.encode(id), condition, r);
    }

    @Override
    public boolean checkAndReplace(ByteBuffer id, QueryCondition condition, Document r) throws DBException {
        return this._checkAndReplace(IdCodec.encode(id), condition, r);
    }

    public boolean checkAndReplace(Value id, QueryCondition condition, Document r) throws DBException {
        return this._checkAndReplace(IdCodec.encode(id), condition, r);
    }

    private boolean _checkAndReplace(ByteBuffer inId, QueryCondition condition, Document r) throws DBException {
        this.checkClosed();
        Preconditions.checkNotNull((Object)r, (Object)"Document being inserted cannot be null");
        Preconditions.checkArgument((condition != null && !condition.isEmpty() ? 1 : 0) != 0, (Object)"QueryCondition cannot be null or empty");
        ByteBuffer id = ByteBufs.ensurePreferred(inId);
        ConditionDescriptor condDesc = ((ConditionImpl)condition).getDescriptor(this.idPathMap);
        ByteBuffer serCond = ByteBufs.ensurePreferred(condDesc.getSerialized());
        SerializedFamilyInfo[] info = RowcolCodec.encode(r, this.idPathMap);
        assert (info.length == this.idPathMap.size());
        EncodedBufFamIdInfo ebf = MapRDBTableImplHelper.getEncBufsAndFamilyIds(info);
        MapRUpdateAndGet muag = new MapRUpdateAndGet();
        byte[] serRowConstraint = MapRDBTableImplHelper.fieldPathsToSerRowConstraint(MapRDBTableImplHelper.condFieldPathMapToCondFieldPathStrMap(condDesc.getFamilyFieldPathsMap()));
        try {
            this.maprTable.checkAndReplaceOrDelete(id, ebf.encBuffers, ebf.familyIds, serRowConstraint, serCond, this.isBufferWrite(), false, muag);
        }
        catch (IOException e) {
            throw ExceptionHandler.handle(e, "checkAndDelete");
        }
        return muag.conditionSuccess;
    }

    @Override
    public synchronized void close() throws DBException {
        try {
            if (!this.closed) {
                this.maprTable.close();
                this.executor.shutdownNow();
                this.closed = true;
            }
        }
        catch (IOException ioe) {
            throw new DBException(ioe.getMessage(), ioe);
        }
    }

    @Override
    public TabletInfo getTabletInfo(String _id) throws DBException {
        return this.getTabletInfo(DBValueBuilderImpl.KeyValueBuilder.initFrom(_id));
    }

    @Override
    public TabletInfo getTabletInfo(ByteBuffer _id) throws DBException {
        return this.getTabletInfo(DBValueBuilderImpl.KeyValueBuilder.initFrom(_id));
    }

    public TabletInfo getTabletInfo(Value _id) throws DBException {
        try {
            MapRTabletScanner scanner = this.maprTable.getTabletScanner(Bytes.getBytes((ByteBuffer)IdCodec.encode(_id)));
            Dbserver.TabletDesc tablet = scanner.next();
            if (tablet != null) {
                return this.toTabletInfo(tablet);
            }
        }
        catch (IOException e) {
            throw ExceptionHandler.handle(e, "getTabletInfo()");
        }
        return null;
    }

    @Override
    public TabletInfo[] getTabletInfos() throws DBException {
        ArrayList tabletInfos = Lists.newArrayList();
        try {
            List nextTabletSet;
            MapRTabletScanner scanner = this.maprTable.getTabletScanner();
            while ((nextTabletSet = scanner.nextSet()) != null) {
                for (Dbserver.TabletDesc tablet : nextTabletSet) {
                    tabletInfos.add(this.toTabletInfo(tablet));
                }
            }
            return tabletInfos.toArray(new TabletInfo[tabletInfos.size()]);
        }
        catch (IOException e) {
            throw ExceptionHandler.handle(e, "getTabletInfos()");
        }
    }

    @Override
    public TabletInfo[] getTabletInfos(QueryCondition condition) throws DBException {
        try {
            return this._getTabletInfos(condition);
        }
        catch (IOException e) {
            throw ExceptionHandler.handle(e, "getTabletInfos()");
        }
    }

    private TabletInfo[] _getTabletInfos(QueryCondition condition) throws IOException {
        List nextTabletSet;
        if (condition == null) {
            return this.getTabletInfos();
        }
        ConditionImpl cond = (ConditionImpl)condition;
        List<ConditionNode.RowkeyRange> rowkeys = cond.getRowkeyRanges();
        boolean noKeyRange = false;
        byte[] startRow = null;
        byte[] endRow = null;
        if (rowkeys == null) {
            noKeyRange = true;
        } else {
            startRow = rowkeys.get(0).getStartRow();
            endRow = rowkeys.get(0).getStopRow();
            if (startRow == null && endRow == null || startRow.length == 0 && endRow.length == 0) {
                noKeyRange = true;
            }
        }
        if (noKeyRange) {
            return this.getTabletInfos();
        }
        ArrayList tabletInfos = Lists.newArrayList();
        MapRTabletScanner scanner = this.maprTable.getTabletScanner();
        boolean doneScanningTablets = false;
        while ((nextTabletSet = scanner.nextSet()) != null) {
            for (Dbserver.TabletDesc tablet : nextTabletSet) {
                byte[] srow = tablet.getStartKey().toByteArray();
                byte[] erow = tablet.getEndKey().toByteArray();
                if (srow == null || erow == null) {
                    throw new DBException("Missing start and/or endkey in tablet");
                }
                int leftRangeComp = startRow != null && startRow.length != 0 ? (erow.length == 0 ? -1 : Bytes.compareTo((byte[])startRow, (byte[])erow)) : -1;
                int rightRangeComp = endRow != null && endRow.length != 0 ? (srow.length == 0 ? 1 : Bytes.compareTo((byte[])endRow, (byte[])srow)) : 1;
                if (leftRangeComp < 0 && rightRangeComp < 0) {
                    doneScanningTablets = true;
                    break;
                }
                if (startRow == endRow) {
                    if (leftRangeComp >= 0 || rightRangeComp < 0) continue;
                    tabletInfos.add(this.toTabletInfo(tablet));
                    continue;
                }
                if (leftRangeComp >= 0 || rightRangeComp <= 0) continue;
                tabletInfos.add(this.toTabletInfo(tablet));
            }
            if (!doneScanningTablets) continue;
            break;
        }
        return tabletInfos.toArray(new TabletInfo[tabletInfos.size()]);
    }

    private TabletInfo toTabletInfo(Dbserver.TabletDesc tablet) throws IOException {
        int cid = tablet.getFid().getCid();
        String host = this.maprTable.getServerForCid(cid);
        String[] tokens = host.split(":");
        if (tokens == null || tokens.length != 2) {
            throw new IOException("Bad host information for cid=" + cid + ", host=" + host);
        }
        long estimatedSize = 0L;
        long estimatedNumRows = 0L;
        Dbserver.TabletStatResponse tsr = this.maprTable.getMapRFS().getTabletStat(this.tableDesc.getPath(), tablet.getFid());
        if (tsr != null && tsr.hasUsage()) {
            Dbserver.SpaceUsage su = tsr.getUsage();
            estimatedNumRows = su.getNumRows();
            estimatedSize = su.getNumLogicalBlocks() * 8192L;
        }
        ConditionImpl c = this.getCondition(IdCodec.decode(tablet.getStartKey().asReadOnlyByteBuffer()), IdCodec.decode(tablet.getEndKey().asReadOnlyByteBuffer()));
        return new TabletInfoImpl(c, new String[]{tokens[0]}, estimatedSize, estimatedNumRows);
    }

    private ConditionImpl getCondition(Value startValue, Value stopValue) {
        ConditionImpl c = new ConditionImpl();
        if (!this.isNullValue(startValue) && !this.isNullValue(stopValue)) {
            c.and();
        }
        if (!this.isNullValue(startValue)) {
            switch (startValue.getType()) {
                case BINARY: {
                    c.is(DocumentConstants.ID_FIELD, QueryCondition.Op.GREATER_OR_EQUAL, startValue.getBinary());
                    break;
                }
                case STRING: {
                    c.is(DocumentConstants.ID_FIELD, QueryCondition.Op.GREATER_OR_EQUAL, startValue.getString());
                    break;
                }
                default: {
                    throw new IllegalStateException("Encountered an unsupported type " + startValue.getType() + " for _id");
                }
            }
        }
        if (!this.isNullValue(stopValue)) {
            switch (stopValue.getType()) {
                case BINARY: {
                    c.is(DocumentConstants.ID_FIELD, QueryCondition.Op.LESS, stopValue.getBinary());
                    break;
                }
                case STRING: {
                    c.is(DocumentConstants.ID_FIELD, QueryCondition.Op.LESS, stopValue.getString());
                    break;
                }
                default: {
                    throw new IllegalStateException("Encountered an unsupported type " + stopValue.getType() + " for _id");
                }
            }
        }
        if (!this.isNullValue(startValue) && !this.isNullValue(stopValue)) {
            c.close();
        }
        return c.build();
    }

    private boolean isNullValue(Value startValue) {
        return startValue == null || startValue.getType() == Value.Type.NULL;
    }

    private int[] mergeFamilyIDs(int[] mutationFamilies, Set<Integer> conditionFamilies) {
        TreeSet mergedSet = Sets.newTreeSet(conditionFamilies);
        for (int i : mutationFamilies) {
            mergedSet.add(i);
        }
        return Collections.toIntArray((Collection)mergedSet);
    }

    public boolean isReadOnly() {
        return false;
    }

    @API.Internal
    public DocumentStream segmentKeyScan() throws DBException {
        this.checkClosed();
        MapRScan maprscan = new MapRScan();
        maprscan.batch = 0;
        maprscan.caching = 0;
        maprscan.startRow = MapRConstants.EMPTY_START_ROW;
        maprscan.stopRow = MapRConstants.EMPTY_END_ROW;
        maprscan.filter = null;
        maprscan.rowConstraint = MapRDBTableImplHelper.toRowConstraint(this, null);
        Dbfilters.KeySamplingFilterProto ksFilter = Dbfilters.KeySamplingFilterProto.newBuilder().build();
        Dbfilters.FilterMsg filterMsg = Dbfilters.FilterMsg.newBuilder().setId("3427db73").setSerializedState(ksFilter.toByteString()).build();
        byte[] serFilt = Bytes.getBytes((ByteBuffer)filterMsg.toByteString().asReadOnlyByteBuffer());
        maprscan.setFilter(serFilt);
        try {
            long id = this.maprTable.getInode().getScanner(maprscan);
            MapRResultScanner scanner = new MapRResultScanner(maprscan, this.maprTable, id);
            this.maprTable.addScanner(scanner);
            return new DBDocumentStream(scanner, this.isExcludeId(), this);
        }
        catch (IOException e) {
            throw ExceptionHandler.handle(e, "segmentKeyScan()");
        }
    }

    public void updateSchema() throws DBException {
        List cfAttrs = null;
        try {
            cfAttrs = this.maprTable.getMapRFS().listColumnFamily(this.maprTable.getTablePath(), false);
        }
        catch (IOException e) {
            throw ExceptionHandler.handle(e, "updateSchema()");
        }
        MapRDBTableImplHelper.ComboMap ret = new MapRDBTableImplHelper.ComboMap();
        MapRDBTableImplHelper.getMaps(cfAttrs, ret);
        this.idToCFNameMap = ret.idToName;
        this.unSortedIdPathMap = ret.pathToId;
        this.sortedById = MapRDBTableImplHelper.sortByValueToList(this.unSortedIdPathMap);
        this.idPathMap = MapRDBTableImplHelper.sortByValue(this.unSortedIdPathMap);
        this.sortedByPathMap = MapRDBTableImplHelper.sortByPath(this.unSortedIdPathMap);
    }

    private void deleteFamilyInfo(String familyName) throws DBException {
        Integer idToDel = null;
        for (Map.Entry entry : this.idToCFNameMap.entrySet()) {
            Integer cfId = (Integer)entry.getKey();
            String cfName = (String)entry.getValue();
            if (!cfName.equals(familyName)) continue;
            idToDel = cfId;
            break;
        }
        if (idToDel != null) {
            this.idToCFNameMap.remove(idToDel);
            BiMap pathIdMap = this.idPathMap.inverse();
            this.unSortedIdPathMap.remove(pathIdMap.get(idToDel));
            this.sortedById = MapRDBTableImplHelper.sortByValueToList(this.unSortedIdPathMap);
            this.idPathMap = MapRDBTableImplHelper.sortByValue(this.unSortedIdPathMap);
            this.sortedByPathMap = MapRDBTableImplHelper.sortByPath(this.unSortedIdPathMap);
        }
    }

    class AsyncBatchElement
    implements Runnable {
        Document rec;
        int recIdx;
        AsyncBatchInfo info;

        AsyncBatchElement(Document inRec, AsyncBatchInfo abi, int myIdx) {
            this.rec = inRec;
            this.info = abi;
            this.recIdx = myIdx;
        }

        @Override
        public void run() {
            try {
                if (MapRDBTableImpl.this.testMulitOpExIdx != 0 && this.recIdx == MapRDBTableImpl.this.testMulitOpExIdx) {
                    throw new DBException("Simulated insert error for " + this.recIdx);
                }
                ByteBuffer useKey = null;
                if (this.info.fieldAsKey != null) {
                    useKey = MapRDBTableImpl.this.getKeyFieldsValue(this.rec, this.info.fieldAsKey);
                }
                switch (this.info.type) {
                    case INSERTORREPLACE: {
                        if (useKey == null) {
                            MapRDBTableImpl.this.insertOrReplace(this.rec);
                            break;
                        }
                        MapRDBTableImpl.this._insertOrReplace(useKey, this.rec);
                        break;
                    }
                    case INSERT: {
                        if (useKey == null) {
                            MapRDBTableImpl.this.insert(this.rec);
                            break;
                        }
                        MapRDBTableImpl.this._insert(useKey, this.rec);
                        break;
                    }
                    case REPLACE: {
                        if (useKey == null) {
                            MapRDBTableImpl.this.replace(this.rec);
                            break;
                        }
                        MapRDBTableImpl.this._replace(useKey, this.rec);
                        break;
                    }
                    case DELETE: {
                        if (useKey == null) {
                            MapRDBTableImpl.this.delete(this.rec);
                            break;
                        }
                        MapRDBTableImpl.this._delete(useKey);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported batching type " + (Object)((Object)this.info.type));
                    }
                }
            }
            catch (Exception e) {
                this.info.addToFailList(this.rec, e);
            }
            catch (OutOfMemoryError oom) {
                this.info.addToFailList(this.rec, (Exception)((Object)new DBException("Out of memory", oom)));
            }
            this.info.incrementCompl();
        }
    }

    private class AsyncBatchInfo {
        List<FailedOp> failedDocuments;
        volatile int numObj;
        volatile int numCompl;
        BatchingType type;
        String fieldAsKey;

        AsyncBatchInfo(int num, BatchingType opType, String fieldforKey) {
            this.numObj = num;
            this.numCompl = 0;
            this.type = opType;
            this.failedDocuments = null;
            this.fieldAsKey = fieldforKey;
        }

        public synchronized void addToFailList(Document rec, Exception e) {
            if (this.failedDocuments == null) {
                this.failedDocuments = new ArrayList<FailedOp>();
            }
            this.failedDocuments.add(new FailedOp(rec, e));
        }

        public synchronized void incrementCompl() {
            ++this.numCompl;
            if (this.numCompl == this.numObj) {
                this.notify();
            }
        }
    }

    class AsyncReader
    implements Runnable {
        OpListener cbListener;
        ByteBuffer encodedId;
        QueryCondition c;
        String[] paths;

        AsyncReader(OpListener list, ByteBuffer inId, QueryCondition inCond, String ... inPaths) {
            this.cbListener = list;
            this.encodedId = inId;
            this.c = inCond;
            this.paths = inPaths;
        }

        @Override
        public void run() {
            try {
                this.cbListener.onSuccess(MapRDBTableImpl.this._findById(this.encodedId, this.c, this.paths));
            }
            catch (Exception e) {
                this.cbListener.onFailure(e);
            }
        }
    }

    static enum BatchingType {
        INSERTORREPLACE,
        INSERT,
        REPLACE,
        DELETE;

    }

    public static enum TablePrivateOption {
        PRESERVE_TIMESTAMP,
        GET_DELETES,
        DECODE_TIMESTAMP,
        EXCLUDE_EMBEDDEDFAMILY,
        DECOMPRESS,
        READ_ALL_CFS;

    }
}

