/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.impl;

import com.google.common.collect.BiMap;
import com.google.common.collect.EnumBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.mapr.db.impl.ConditionDescriptor;
import com.mapr.fs.jni.MapRConstants;
import com.mapr.fs.proto.Dbfilters;
import com.mapr.org.apache.hadoop.hbase.util.Bytes;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ojai.FieldPath;
import org.ojai.annotation.API;
import org.ojai.store.QueryCondition;

@API.Internal
public abstract class ConditionNode
implements Cloneable {
    static final String HASH_OF_CONDITION_FILTER = "8cbdcd12";
    static final String HASH_OF_ROW_FILTER = "469dbd04";
    static final String HASH_OF_ALWAYSFALSE_FILTER = "d71875e1";
    static final String HASH_OF_KEYSAMPLING_FILTER = "3427db73";
    static final String HASH_OF_FILTER_LIST = "a42ebf64";
    static final String HASH_OF_NULL_COMPARATOR = "8543f5eb";
    static final String HASH_OF_BINARY_COMPARATOR = "05f39865";
    static final String HASH_OF_JSON_COMPARATOR = "45a94888";
    static final String HASH_OF_REGEX_COMPARATOR = "e2d7ba40";
    static final String HASH_OF_TYPE_COMPARATOR = "1e95fd6b";
    static final String HASH_OF_SIZE_COMPARATOR = "2e7025c4";
    static final String DUMMY_FIELD_X = "X";
    static final String EMPTY_STR = "";
    static final Set<Integer> EMPTY_FIELD_IDS = ImmutableSet.of();
    static final Set<FieldPath> EMPTY_FIELD_PATHS = ImmutableSet.of();
    static final char DOLLAR_CHAR = '$';
    static final char COLON_CHAR = ':';
    static final char QUOTE_CHAR = '\"';
    static final char COMMA_CHAR = ',';
    static final char SPACE_CHAR = ' ';
    static final char NEWLINE_CHAR = '\n';
    static final char OPEN_BRACKET = '[';
    static final char CLOSE_BRACKET = ']';
    static final char OPEN_PARAN = '(';
    static final char CLOSE_PARAN = ')';
    static final char OPEN_MAP = '{';
    static final char CLOSE_MAP = '}';
    static final BiMap<QueryCondition.Op, Dbfilters.CompareOpProto> opProtoMap = EnumBiMap.create(QueryCondition.Op.class, Dbfilters.CompareOpProto.class);
    static final Map<Dbfilters.CompareOpProto, String> opSymbolMap;
    static final Map<Dbfilters.CompareOpProto, String> opJsonOpMap;
    static final List<RowkeyRange> FULL_TABLE_RANGE;

    boolean isLeaf() {
        return true;
    }

    StringBuilder treeBuilder(StringBuilder sb) {
        return this.treeBuilder(ConditionNode.indent(sb, 2), 2);
    }

    abstract ConditionDescriptor getDescriptor(BiMap<FieldPath, Integer> var1);

    abstract StringBuilder expressionBuilder(StringBuilder var1);

    abstract StringBuilder treeBuilder(StringBuilder var1, int var2);

    abstract StringBuilder jsonBuilder(StringBuilder var1);

    abstract List<RowkeyRange> getRowkeyRanges();

    abstract void addProjections(Set<FieldPath> var1);

    protected ConditionNode clone() {
        try {
            return (ConditionNode)super.clone();
        }
        catch (CloneNotSupportedException e) {
            assert (false) : "Clone failed!!!";
            return null;
        }
    }

    abstract boolean checkAndPrune();

    boolean isEmpty() {
        return false;
    }

    static StringBuilder indent(StringBuilder sb, int indent) {
        for (int i = 0; i < indent; ++i) {
            sb.append(' ');
        }
        return sb;
    }

    static {
        opProtoMap.put((Object)QueryCondition.Op.LESS, (Object)Dbfilters.CompareOpProto.LESS);
        opProtoMap.put((Object)QueryCondition.Op.LESS_OR_EQUAL, (Object)Dbfilters.CompareOpProto.LESS_OR_EQUAL);
        opProtoMap.put((Object)QueryCondition.Op.EQUAL, (Object)Dbfilters.CompareOpProto.EQUAL);
        opProtoMap.put((Object)QueryCondition.Op.NOT_EQUAL, (Object)Dbfilters.CompareOpProto.NOT_EQUAL);
        opProtoMap.put((Object)QueryCondition.Op.GREATER_OR_EQUAL, (Object)Dbfilters.CompareOpProto.GREATER_OR_EQUAL);
        opProtoMap.put((Object)QueryCondition.Op.GREATER, (Object)Dbfilters.CompareOpProto.GREATER);
        assert (opProtoMap.size() == QueryCondition.Op.values().length) : "Map is missing some of the QueryCondition.Op elements";
        opSymbolMap = Maps.newEnumMap(Dbfilters.CompareOpProto.class);
        opSymbolMap.put(Dbfilters.CompareOpProto.NO_OP, "!ERR!");
        opSymbolMap.put(Dbfilters.CompareOpProto.LESS, "<");
        opSymbolMap.put(Dbfilters.CompareOpProto.LESS_OR_EQUAL, "<=");
        opSymbolMap.put(Dbfilters.CompareOpProto.EQUAL, "=");
        opSymbolMap.put(Dbfilters.CompareOpProto.NOT_EQUAL, "!=");
        opSymbolMap.put(Dbfilters.CompareOpProto.GREATER_OR_EQUAL, ">=");
        opSymbolMap.put(Dbfilters.CompareOpProto.GREATER, ">");
        assert (opSymbolMap.size() == Dbfilters.CompareOpProto.values().length) : "Map is missing some of the CompareOpProto elements";
        opJsonOpMap = Maps.newEnumMap(Dbfilters.CompareOpProto.class);
        FULL_TABLE_RANGE = ImmutableList.of((Object)new RowkeyRange(MapRConstants.EMPTY_BYTE_ARRAY, MapRConstants.EMPTY_BYTE_ARRAY));
    }

    public static class RowkeyRange {
        protected final byte[] startRow;
        protected final byte[] stopRow;

        public RowkeyRange(byte[] startRow, byte[] stopRow) {
            this.startRow = startRow;
            this.stopRow = stopRow;
        }

        public byte[] getStartRow() {
            return this.startRow == null ? MapRConstants.EMPTY_BYTE_ARRAY : this.startRow;
        }

        public byte[] getStopRow() {
            return this.stopRow == null ? MapRConstants.EMPTY_BYTE_ARRAY : this.stopRow;
        }

        public String toString() {
            return "RowkeyRange [startRow=" + Bytes.toStringBinary((byte[])this.startRow) + ", stopRow=" + Bytes.toStringBinary((byte[])this.stopRow) + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.startRow);
            result = 31 * result + Arrays.hashCode(this.stopRow);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RowkeyRange other = (RowkeyRange)obj;
            if (!Arrays.equals(this.startRow, other.startRow)) {
                return false;
            }
            return Arrays.equals(this.stopRow, other.stopRow);
        }
    }
}

