/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.impl;

import com.google.common.collect.BiMap;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.mapr.db.impl.AlwaysFalseCondition;
import com.mapr.db.impl.ConditionBlock;
import com.mapr.db.impl.ConditionDescriptor;
import com.mapr.db.impl.ConditionLeaf;
import com.mapr.db.impl.ConditionNode;
import com.mapr.db.impl.Constants;
import com.mapr.db.impl.LikeToRegexConvertor;
import com.mapr.db.rowcol.DBValueBuilderImpl;
import com.mapr.fs.proto.Dbfilters;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.ojai.DocumentConstants;
import org.ojai.FieldPath;
import org.ojai.Value;
import org.ojai.annotation.API;
import org.ojai.store.QueryCondition;
import org.ojai.types.ODate;
import org.ojai.types.OInterval;
import org.ojai.types.OTime;
import org.ojai.types.OTimestamp;

@API.Internal
public class ConditionImpl
implements QueryCondition {
    private static final String EMPTY = "<EMPTY>";
    private static final String EMPTY_DOC = "{}";
    private static final ConditionDescriptor EMPTY_DESC = new ConditionDescriptor(ByteBuffer.wrap(new byte[0]));
    private ConditionNode root;
    private boolean built = false;
    private Stack<ConditionBlock> groupsStack;
    private List<ConditionNode.RowkeyRange> rowkeyRanges;

    public ConditionImpl() {
    }

    ConditionImpl(String id, ByteString serializedState) {
        switch (id) {
            case "d71875e1": {
                this.root = new AlwaysFalseCondition();
                break;
            }
            case "469dbd04": 
            case "8cbdcd12": {
                this.root = new ConditionLeaf(id, serializedState);
                break;
            }
            case "a42ebf64": {
                this.root = new ConditionBlock(serializedState);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown filter in the serialized message: " + id);
            }
        }
        this.build();
    }

    public boolean isEmpty() {
        return this.root == null || this.root.isEmpty();
    }

    public boolean isBuilt() {
        return this.built;
    }

    public String asPrefix() {
        if (this.root == null) {
            return EMPTY;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[\n");
        this.root.treeBuilder(sb);
        if (this.built) {
            sb.append("\n]");
        }
        return sb.toString();
    }

    public String jsonString() {
        if (this.root == null || this.root.isEmpty()) {
            return EMPTY_DOC;
        }
        StringBuilder sb = new StringBuilder();
        this.root.jsonBuilder(sb);
        return sb.toString();
    }

    public Set<FieldPath> getProjections() {
        HashSet<FieldPath> proj = new HashSet<FieldPath>();
        if (!this.isEmpty()) {
            this.root.addProjections(proj);
        }
        proj.remove(DocumentConstants.ID_FIELD);
        return proj;
    }

    public String asInfix() {
        return this.isEmpty() ? EMPTY : this.root.expressionBuilder(new StringBuilder()).toString();
    }

    public String toString() {
        return this.asInfix();
    }

    public int hashCode() {
        return this.getDescriptor(Constants.DEFAULT_FAMILY_MAP).hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConditionImpl other = (ConditionImpl)obj;
        return this.getDescriptor(Constants.DEFAULT_FAMILY_MAP).equals(other.getDescriptor(Constants.DEFAULT_FAMILY_MAP));
    }

    public ConditionImpl and() {
        return this.addGroup(new ConditionBlock(ConditionBlock.BlockType.and));
    }

    public ConditionImpl or() {
        return this.addGroup(new ConditionBlock(ConditionBlock.BlockType.or));
    }

    public ConditionImpl close() {
        if (this.groupsStack == null || this.groupsStack.isEmpty()) {
            throw new IllegalStateException("Not in a condition block.");
        }
        this.groupsStack.pop().close();
        return this;
    }

    public ConditionImpl build() {
        return this.build(false);
    }

    public ConditionImpl cloneOptimized() {
        ConditionImpl pruned = new ConditionImpl();
        if (this.root != null) {
            pruned.root = this.root.clone();
        }
        return pruned.build(true);
    }

    public ConditionImpl condition(QueryCondition conditionToAdd) {
        if (conditionToAdd == null) {
            throw new IllegalArgumentException("A null condition can not be added.");
        }
        if (conditionToAdd == this) {
            throw new IllegalArgumentException("A condition can not be added to itself");
        }
        if (!conditionToAdd.isBuilt()) {
            throw new IllegalArgumentException("The specified condition is not built\n" + conditionToAdd);
        }
        if (conditionToAdd.isEmpty()) {
            throw new IllegalArgumentException("Can not add an empty condition");
        }
        this.checkStateForModification();
        ConditionImpl other = (ConditionImpl)conditionToAdd;
        if (this.root == null) {
            this.root = other.getRoot().clone();
        } else {
            this.groupsStack.peek().add(other.getRoot().clone());
        }
        return this;
    }

    public ConditionImpl exists(String path) {
        return this.exists(FieldPath.parseFrom((String)path));
    }

    public ConditionImpl exists(FieldPath path) {
        return this.addLeaf(new ConditionLeaf(path, Dbfilters.CompareOpProto.NOT_EQUAL, null));
    }

    public ConditionImpl notExists(String path) {
        return this.notExists(FieldPath.parseFrom((String)path));
    }

    public ConditionImpl in(String path, List<? extends Object> listOfValue) {
        return this.in(FieldPath.parseFrom((String)path), (List)listOfValue);
    }

    public ConditionImpl in(FieldPath path, List<? extends Object> listOfValue) {
        if (listOfValue.isEmpty()) {
            return this.addAlwaysFalseCondition(new AlwaysFalseCondition());
        }
        ConditionBlock inBlock = new ConditionBlock(ConditionBlock.BlockType.or);
        for (Object object : listOfValue) {
            inBlock.add(new ConditionLeaf(path, Dbfilters.CompareOpProto.EQUAL, DBValueBuilderImpl.KeyValueBuilder.initFromObject(object)));
        }
        return this.addGroup(inBlock.close()).close();
    }

    public ConditionImpl notIn(String path, List<? extends Object> listOfValue) {
        return this.notIn(FieldPath.parseFrom((String)path), (List)listOfValue);
    }

    public ConditionImpl notIn(FieldPath path, List<? extends Object> listOfValue) {
        ConditionBlock notInBlock = new ConditionBlock(ConditionBlock.BlockType.and);
        for (Object object : listOfValue) {
            notInBlock.add(new ConditionLeaf(path, Dbfilters.CompareOpProto.NOT_EQUAL, DBValueBuilderImpl.KeyValueBuilder.initFromObject(object)));
        }
        return this.addGroup(notInBlock.close()).close();
    }

    public ConditionImpl notExists(FieldPath path) {
        return this.addLeaf(new ConditionLeaf(path, Dbfilters.CompareOpProto.EQUAL, null));
    }

    public ConditionImpl typeOf(String path, Value.Type type) {
        return this.typeOf(FieldPath.parseFrom((String)path), type);
    }

    public ConditionImpl typeOf(FieldPath path, Value.Type type) {
        return this.addLeaf(new ConditionLeaf(path, Dbfilters.CompareOpProto.EQUAL, DBValueBuilderImpl.KeyValueBuilder.initFrom((int)type.getCode()), Dbfilters.ComparatorModeProto.CMP_TYPE));
    }

    public ConditionImpl notTypeOf(String path, Value.Type type) {
        return this.notTypeOf(FieldPath.parseFrom((String)path), type);
    }

    public ConditionImpl notTypeOf(FieldPath path, Value.Type type) {
        return this.addLeaf(new ConditionLeaf(path, Dbfilters.CompareOpProto.NOT_EQUAL, DBValueBuilderImpl.KeyValueBuilder.initFrom((int)type.getCode()), Dbfilters.ComparatorModeProto.CMP_TYPE));
    }

    public ConditionImpl matches(String path, String regex) {
        return this.matches(FieldPath.parseFrom((String)path), regex);
    }

    public ConditionImpl matches(FieldPath path, String regex) {
        return this.addLeaf(new ConditionLeaf(path, Dbfilters.CompareOpProto.EQUAL, DBValueBuilderImpl.KeyValueBuilder.initFrom(regex), Dbfilters.ComparatorModeProto.CMP_PATTERN));
    }

    public ConditionImpl notMatches(String path, String regex) {
        return this.notMatches(FieldPath.parseFrom((String)path), regex);
    }

    public ConditionImpl notMatches(FieldPath path, String regex) {
        return this.addLeaf(new ConditionLeaf(path, Dbfilters.CompareOpProto.NOT_EQUAL, DBValueBuilderImpl.KeyValueBuilder.initFrom(regex), Dbfilters.ComparatorModeProto.CMP_PATTERN));
    }

    public QueryCondition like(String path, String likeExpression) {
        return this.matches(path, new LikeToRegexConvertor(likeExpression).parse().getRegexString());
    }

    public QueryCondition like(FieldPath path, String likeExpression) {
        return this.matches(path, new LikeToRegexConvertor(likeExpression).parse().getRegexString());
    }

    public QueryCondition like(String path, String likeExpression, Character escapeChar) {
        return this.matches(path, new LikeToRegexConvertor(likeExpression, escapeChar).parse().getRegexString());
    }

    public QueryCondition like(FieldPath path, String likeExpression, Character escapeChar) {
        return this.matches(path, new LikeToRegexConvertor(likeExpression, escapeChar).parse().getRegexString());
    }

    public QueryCondition notLike(String path, String likeExpression) {
        return this.notMatches(path, new LikeToRegexConvertor(likeExpression).parse().getRegexString());
    }

    public QueryCondition notLike(FieldPath path, String likeExpression) {
        return this.notMatches(path, new LikeToRegexConvertor(likeExpression).parse().getRegexString());
    }

    public QueryCondition notLike(String path, String likeExpression, Character escapeChar) {
        return this.notMatches(path, new LikeToRegexConvertor(likeExpression, escapeChar).parse().getRegexString());
    }

    public QueryCondition notLike(FieldPath path, String likeExpression, Character escapeChar) {
        return this.notMatches(path, new LikeToRegexConvertor(likeExpression, escapeChar).parse().getRegexString());
    }

    public QueryCondition is(String path, QueryCondition.Op op, boolean value) {
        return this.is(FieldPath.parseFrom((String)path), op, value);
    }

    public ConditionImpl is(FieldPath path, QueryCondition.Op op, boolean value) {
        return this.addLeaf(new ConditionLeaf(path, op, DBValueBuilderImpl.KeyValueBuilder.initFrom(value)));
    }

    public ConditionImpl is(String path, QueryCondition.Op op, String value) {
        return this.is(FieldPath.parseFrom((String)path), op, value);
    }

    public ConditionImpl is(FieldPath path, QueryCondition.Op op, String value) {
        return this.addLeaf(new ConditionLeaf(path, op, DBValueBuilderImpl.KeyValueBuilder.initFrom(value)));
    }

    public ConditionImpl is(String path, QueryCondition.Op op, byte value) {
        return this.is(FieldPath.parseFrom((String)path), op, value);
    }

    public ConditionImpl is(FieldPath path, QueryCondition.Op op, byte value) {
        return this.addLeaf(new ConditionLeaf(path, op, DBValueBuilderImpl.KeyValueBuilder.initFrom(value)));
    }

    public ConditionImpl is(String path, QueryCondition.Op op, short value) {
        return this.is(FieldPath.parseFrom((String)path), op, value);
    }

    public ConditionImpl is(FieldPath path, QueryCondition.Op op, short value) {
        return this.addLeaf(new ConditionLeaf(path, op, DBValueBuilderImpl.KeyValueBuilder.initFrom(value)));
    }

    public ConditionImpl is(String path, QueryCondition.Op op, int value) {
        return this.is(FieldPath.parseFrom((String)path), op, value);
    }

    public ConditionImpl is(FieldPath path, QueryCondition.Op op, int value) {
        return this.addLeaf(new ConditionLeaf(path, op, DBValueBuilderImpl.KeyValueBuilder.initFrom(value)));
    }

    public ConditionImpl is(String path, QueryCondition.Op op, long value) {
        return this.is(FieldPath.parseFrom((String)path), op, value);
    }

    public ConditionImpl is(FieldPath path, QueryCondition.Op op, long value) {
        return this.addLeaf(new ConditionLeaf(path, op, DBValueBuilderImpl.KeyValueBuilder.initFrom(value)));
    }

    public ConditionImpl is(String path, QueryCondition.Op op, float value) {
        return this.is(FieldPath.parseFrom((String)path), op, value);
    }

    public ConditionImpl is(FieldPath path, QueryCondition.Op op, float value) {
        return this.addLeaf(new ConditionLeaf(path, op, DBValueBuilderImpl.KeyValueBuilder.initFrom(value)));
    }

    public ConditionImpl is(String path, QueryCondition.Op op, double value) {
        return this.is(FieldPath.parseFrom((String)path), op, value);
    }

    public ConditionImpl is(FieldPath path, QueryCondition.Op op, double value) {
        return this.addLeaf(new ConditionLeaf(path, op, DBValueBuilderImpl.KeyValueBuilder.initFrom(value)));
    }

    public ConditionImpl is(String path, QueryCondition.Op op, BigDecimal value) {
        return this.is(FieldPath.parseFrom((String)path), op, value);
    }

    public ConditionImpl is(FieldPath path, QueryCondition.Op op, BigDecimal value) {
        throw new UnsupportedOperationException("BigDecimal type not supported");
    }

    public ConditionImpl is(String path, QueryCondition.Op op, ODate value) {
        return this.is(FieldPath.parseFrom((String)path), op, value);
    }

    public ConditionImpl is(FieldPath path, QueryCondition.Op op, ODate value) {
        return this.addLeaf(new ConditionLeaf(path, op, DBValueBuilderImpl.KeyValueBuilder.initFrom(value)));
    }

    public ConditionImpl is(String path, QueryCondition.Op op, OTime value) {
        return this.is(FieldPath.parseFrom((String)path), op, value);
    }

    public ConditionImpl is(FieldPath path, QueryCondition.Op op, OTime value) {
        return this.addLeaf(new ConditionLeaf(path, op, DBValueBuilderImpl.KeyValueBuilder.initFrom(value)));
    }

    public ConditionImpl is(String path, QueryCondition.Op op, OTimestamp value) {
        return this.is(FieldPath.parseFrom((String)path), op, value);
    }

    public ConditionImpl is(FieldPath path, QueryCondition.Op op, OTimestamp value) {
        return this.addLeaf(new ConditionLeaf(path, op, DBValueBuilderImpl.KeyValueBuilder.initFrom(value)));
    }

    public ConditionImpl is(String path, QueryCondition.Op op, OInterval value) {
        return this.is(FieldPath.parseFrom((String)path), op, value);
    }

    public ConditionImpl is(FieldPath path, QueryCondition.Op op, OInterval value) {
        throw new UnsupportedOperationException("Interval type not supported");
    }

    public ConditionImpl is(String path, QueryCondition.Op op, ByteBuffer value) {
        return this.is(FieldPath.parseFrom((String)path), op, value);
    }

    public ConditionImpl is(FieldPath path, QueryCondition.Op op, ByteBuffer value) {
        return this.addLeaf(new ConditionLeaf(path, op, DBValueBuilderImpl.KeyValueBuilder.initFrom(value)));
    }

    public QueryCondition sizeOf(String path, QueryCondition.Op op, long size) {
        return this.sizeOf(FieldPath.parseFrom((String)path), op, size);
    }

    public QueryCondition sizeOf(FieldPath path, QueryCondition.Op op, long size) {
        return this.addLeaf(new ConditionLeaf(path, op, DBValueBuilderImpl.KeyValueBuilder.initFrom((int)size), Dbfilters.ComparatorModeProto.CMP_SIZE));
    }

    public ConditionImpl equals(String path, Map<String, ? extends Object> value) {
        return this.equals(FieldPath.parseFrom((String)path), (Map)value);
    }

    public ConditionImpl equals(FieldPath path, Map<String, ? extends Object> value) {
        return this.addLeaf(new ConditionLeaf(path, Dbfilters.CompareOpProto.EQUAL, DBValueBuilderImpl.KeyValueBuilder.initFrom(value)));
    }

    public ConditionImpl equals(String path, List<? extends Object> value) {
        return this.equals(FieldPath.parseFrom((String)path), (List)value);
    }

    public ConditionImpl equals(FieldPath path, List<? extends Object> value) {
        return this.addLeaf(new ConditionLeaf(path, Dbfilters.CompareOpProto.EQUAL, DBValueBuilderImpl.KeyValueBuilder.initFrom(value)));
    }

    public ConditionImpl notEquals(String path, Map<String, ? extends Object> value) {
        return this.notEquals(FieldPath.parseFrom((String)path), (Map)value);
    }

    public ConditionImpl notEquals(FieldPath path, Map<String, ? extends Object> value) {
        return this.addLeaf(new ConditionLeaf(path, Dbfilters.CompareOpProto.NOT_EQUAL, DBValueBuilderImpl.KeyValueBuilder.initFrom(value)));
    }

    public ConditionImpl notEquals(String path, List<? extends Object> value) {
        return this.notEquals(FieldPath.parseFrom((String)path), (List)value);
    }

    public ConditionImpl notEquals(FieldPath path, List<? extends Object> value) {
        return this.addLeaf(new ConditionLeaf(path, Dbfilters.CompareOpProto.NOT_EQUAL, DBValueBuilderImpl.KeyValueBuilder.initFrom(value)));
    }

    @API.Internal
    public ConditionDescriptor getDescriptor() {
        return this.getDescriptor(Constants.DEFAULT_FAMILY_MAP);
    }

    @API.Internal
    public ConditionDescriptor getDescriptor(BiMap<FieldPath, Integer> pathIdMap) {
        this.checkIfBuilt();
        return this.isEmpty() ? EMPTY_DESC : this.root.getDescriptor(pathIdMap);
    }

    @API.Internal
    public List<ConditionNode.RowkeyRange> getRowkeyRanges() {
        this.checkIfBuilt();
        return this.rowkeyRanges;
    }

    @API.Internal
    public static QueryCondition parseFrom(ByteBuffer buf) {
        try {
            if (buf.remaining() > 0) {
                Dbfilters.FilterMsg msg = Dbfilters.FilterMsg.parseFrom((ByteString)ByteString.copyFrom((ByteBuffer)buf));
                return new ConditionImpl(msg.getId(), msg.getSerializedState());
            }
            return new ConditionImpl().build();
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException("Unable to parse the provided data.", e);
        }
    }

    ConditionNode getRoot() {
        return this.root;
    }

    private ConditionImpl addLeaf(ConditionLeaf leaf) {
        this.checkStateForModification();
        if (this.root == null) {
            this.root = leaf;
        } else {
            this.groupsStack.peek().add(leaf);
        }
        return this;
    }

    private ConditionImpl addAlwaysFalseCondition(AlwaysFalseCondition fc) {
        this.checkStateForModification();
        if (this.root == null) {
            this.root = fc;
        } else {
            this.groupsStack.peek().add(fc);
        }
        return this;
    }

    private ConditionImpl addGroup(ConditionBlock newGroup) {
        this.checkStateForModification();
        if (this.groupsStack == null) {
            this.groupsStack = new Stack();
        }
        if (this.root == null) {
            this.root = newGroup;
        } else {
            this.groupsStack.peek().add(newGroup);
        }
        this.groupsStack.push(newGroup);
        return this;
    }

    private ConditionImpl build(boolean optimize) {
        if (this.built) {
            throw new IllegalStateException("The condition is already built.");
        }
        if (this.groupsStack != null && !this.groupsStack.isEmpty()) {
            throw new IllegalStateException("At least one condition group is not closed." + this.asPrefix());
        }
        if (this.root != null && !this.root.isEmpty()) {
            this.rowkeyRanges = this.root.getRowkeyRanges();
            if (optimize && this.root.checkAndPrune()) {
                this.root = null;
            }
        } else {
            this.rowkeyRanges = ConditionNode.FULL_TABLE_RANGE;
        }
        this.built = true;
        return this;
    }

    private void checkIfBuilt() {
        if (!this.built) {
            throw new IllegalStateException("The condition is not built yet.\n" + this.asPrefix());
        }
    }

    private void checkStateForModification() {
        if (this.built) {
            throw new IllegalStateException("The condition is already built.");
        }
        if (this.root != null && this.groupsStack == null) {
            throw new IllegalArgumentException("A condition can only be added as root or a child of another logical connecter.");
        }
    }
}

