/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.tests.utils;

import com.google.common.collect.Lists;
import com.mapr.db.Admin;
import com.mapr.db.MapRDB;
import com.mapr.db.Table;
import com.mapr.db.TableDescriptor;
import com.mapr.fs.AceHelper;
import com.mapr.fs.FSTests;
import com.mapr.fs.proto.Dbserver;
import com.mapr.fs.tables.CFPermissions;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.ojai.Document;
import org.ojai.DocumentStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBTests
extends FSTests {
    private static final Logger _logger = LoggerFactory.getLogger(DBTests.class);
    private static volatile Admin admin_;

    public static synchronized Admin admin() throws IOException {
        if (admin_ == null) {
            admin_ = MapRDB.newAdmin((Configuration)DBTests.getConf());
        }
        return admin_;
    }

    public static boolean tableExists(String table) throws IOException {
        Path tablePath = DBTests.getTablePath(table);
        return DBTests.maprfs().exists(tablePath);
    }

    public static Table getTable(String table) throws IOException {
        Path tablePath = DBTests.getTablePath(table);
        return MapRDB.getTable((Path)tablePath);
    }

    public static Table createTable(String table) throws IOException {
        Path tablePath = DBTests.getTablePath(table);
        return DBTests.admin().createTable(tablePath);
    }

    public static Table createOrReplaceTable(String table) throws IOException {
        Path tablePath = DBTests.getTablePath(table);
        if (DBTests.maprfs().exists(tablePath)) {
            _logger.info("Table {} exists, deleting.", (Object)tablePath);
            DBTests.maprfs().delete(tablePath);
        }
        _logger.info("Creating table {}.", (Object)tablePath);
        return DBTests.admin().createTable(tablePath);
    }

    public static Table createOrReplaceTable(String table, String[] splitKeys) throws IOException {
        Path tablePath = DBTests.getTablePath(table);
        if (DBTests.maprfs().exists(tablePath)) {
            _logger.info("Table {} exists, deleting.", (Object)tablePath);
            DBTests.maprfs().delete(tablePath);
        }
        _logger.info("Creating table {}.", (Object)tablePath);
        return DBTests.admin().createTable(MapRDB.newTableDescriptor((Path)tablePath), splitKeys);
    }

    public static Table createOrReplaceTable(String table, Map<String, String> cfPath) throws IOException {
        Path tablePath = DBTests.getTablePath(table);
        if (DBTests.maprfs().exists(tablePath)) {
            _logger.info("Table {} exists, deleting.", (Object)tablePath);
            DBTests.maprfs().delete(tablePath);
        }
        TableDescriptor desc = MapRDB.newTableDescriptor((Path)tablePath);
        int familyCount = 0;
        for (Map.Entry<String, String> cf : cfPath.entrySet()) {
            if (familyCount++ == 0 && !cf.getKey().equals("default")) {
                desc.addFamily(MapRDB.newDefaultFamilyDescriptor());
                ++familyCount;
            }
            desc.addFamily(MapRDB.newFamilyDescriptor((String)cf.getKey(), (String)cf.getValue()));
        }
        _logger.info("Creating table {}.", (Object)tablePath);
        return DBTests.admin().createTable(desc);
    }

    public static Table createOrReplaceTable(String clusterPath, String table, Map<String, String> cfPathMap) throws IOException {
        String clusterPrefix = clusterPath.endsWith("/") ? clusterPath.substring(0, clusterPath.length() - 2) : clusterPath;
        clusterPrefix = DBTests.getTestRoot((String)clusterPrefix).toString();
        Path tablePath = new Path(clusterPrefix + table);
        if (DBTests.maprfs().exists(tablePath)) {
            _logger.info("Table {} exists, deleting.", (Object)tablePath);
            DBTests.maprfs().delete(tablePath);
        }
        TableDescriptor desc = MapRDB.newTableDescriptor((Path)tablePath);
        int familyCount = 0;
        for (Map.Entry<String, String> cf : cfPathMap.entrySet()) {
            if (familyCount++ == 0 && !cf.getKey().equals("default")) {
                desc.addFamily(MapRDB.newDefaultFamilyDescriptor());
                ++familyCount;
            }
            desc.addFamily(MapRDB.newFamilyDescriptor((String)cf.getKey(), (String)cf.getValue()));
        }
        _logger.info("Creating table {}.", (Object)tablePath);
        return DBTests.admin().createTable(desc);
    }

    public static void rmdir(Path path) throws IOException {
        if (DBTests.maprfs().exists(path)) {
            DBTests.maprfs().delete(path, true);
        }
    }

    public static void deleteTables(String ... tables) throws IOException {
        for (String table : tables) {
            Path tablePath = DBTests.getTablePath(table);
            if (!DBTests.maprfs().exists(tablePath)) continue;
            _logger.info("Deleting table {}.", (Object)tablePath);
            DBTests.maprfs().delete(tablePath);
        }
    }

    public static void justDeleteTables(String ... tables) throws IOException {
        for (String table : tables) {
            Path tablePath = DBTests.getTablePath(table);
            _logger.info("Deleting table {}.", (Object)tablePath);
            DBTests.maprfs().delete(tablePath);
        }
    }

    public static Path getTablePath(String table) {
        return new Path(DBTests.getTestRoot(), DBTests.fixTableName(table));
    }

    public static Path getTablePath(String clusterPath, String table) {
        String clusterPrefix = clusterPath.endsWith("/") ? clusterPath.substring(0, clusterPath.length() - 2) : clusterPath;
        return new Path(DBTests.getTestRoot((String)clusterPrefix), DBTests.fixTableName(table));
    }

    private static String fixTableName(String table) {
        return table.startsWith("/") ? "." + table : table;
    }

    public static void setFieldAce(Path tablePath, String family, String fieldName, Dbserver.DBAccessType accessType, String ace) throws IOException {
        CFPermissions cfPermissions = new CFPermissions(family);
        String permission = (String)AceHelper.colPermissionMap.get(accessType);
        cfPermissions.addColPermission(fieldName, permission, ace);
        DBTests.mapradmin().setFamilyPermissions(tablePath, family, cfPermissions);
    }

    public static void setCFAce(Path tablePath, String family, Dbserver.DBAccessType accessType, String ace) throws IOException {
        CFPermissions cfPermissions = new CFPermissions(family);
        String permission = (String)AceHelper.cfPermissionMap.get(accessType);
        cfPermissions.addCFPermission(permission, ace);
        DBTests.mapradmin().setFamilyPermissions(tablePath, family, cfPermissions);
    }

    public static String ExecuteShellCmd(String cmd) throws Exception {
        StringBuffer output = new StringBuffer();
        try {
            String line;
            Process p = Runtime.getRuntime().exec(cmd);
            p.waitFor();
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = reader.readLine()) != null) {
                System.out.println(line + "\n");
                output.append(line + "\n");
            }
        }
        catch (Exception e) {
            _logger.error("Executing shell command " + cmd + " failed: " + e.getMessage());
            throw e;
        }
        return output.toString();
    }

    public static void EnableVolumeAuditing(String volume) throws Exception {
        String cmd = "maprcli volume audit -name " + volume + " -enabled true";
        _logger.info(cmd);
        String output = DBTests.ExecuteShellCmd(cmd);
        if (!output.isEmpty()) {
            _logger.info("Output: " + output);
        }
    }

    public static void DisableVolumeAuditing(String volume) throws Exception {
        String cmd = "maprcli volume audit -name " + volume + " -enabled false";
        _logger.info(cmd);
        String output = DBTests.ExecuteShellCmd(cmd);
        if (!output.isEmpty()) {
            _logger.info("Output: " + output);
        }
    }

    public static void EnableJSONTableAuditing(String tablePath) throws Exception {
        assert (tablePath != null && !tablePath.isEmpty());
        String[] tablePathDirs = tablePath.split("/");
        DBTests.EnableVolumeAuditing("mapr.cluster.root");
        DBTests.EnableVolumeAuditing("mapr.tmp");
        String cmd = "maprcli audit cluster -enabled true";
        _logger.info(cmd);
        String output = DBTests.ExecuteShellCmd(cmd);
        if (!output.isEmpty()) {
            _logger.info("Output: " + output);
        }
        cmd = "maprcli audit data -enabled true";
        _logger.info(cmd);
        output = DBTests.ExecuteShellCmd(cmd);
        if (!output.isEmpty()) {
            _logger.info("Output: " + output);
        }
        String volPath = "";
        for (int i = 0; i < tablePathDirs.length; ++i) {
            volPath = volPath + tablePathDirs[i];
            if (i < tablePathDirs.length - 1) {
                volPath = volPath + "/";
            }
            cmd = "hadoop mfs -setaudit on " + volPath;
            _logger.info(cmd);
            output = DBTests.ExecuteShellCmd(cmd);
            if (output.isEmpty()) continue;
            _logger.info("Output: " + output);
        }
    }

    public static void DisableJSONTableAuditing(String tablePath) throws Exception {
        assert (tablePath != null && !tablePath.isEmpty());
        String[] tablePathDirs = tablePath.split("/");
        DBTests.DisableVolumeAuditing("mapr.cluster.root");
        DBTests.DisableVolumeAuditing("mapr.tmp");
        String cmd = "maprcli audit cluster -enabled false";
        _logger.info(cmd);
        String output = DBTests.ExecuteShellCmd(cmd);
        if (!output.isEmpty()) {
            _logger.info("Output: " + output);
        }
        cmd = "maprcli audit data -enabled false";
        _logger.info(cmd);
        output = DBTests.ExecuteShellCmd(cmd);
        if (!output.isEmpty()) {
            _logger.info("Output: " + output);
        }
        String volPath = "";
        for (int i = 0; i < tablePathDirs.length; ++i) {
            volPath = volPath + tablePathDirs[i];
            if (i < tablePathDirs.length - 1) {
                volPath = volPath + "/";
            }
            cmd = "hadoop mfs -setaudit off " + volPath;
            _logger.info(cmd);
            output = DBTests.ExecuteShellCmd(cmd);
            if (output.isEmpty()) continue;
            _logger.info("Output: " + output);
        }
    }

    public static List<Document> getAllDocumentsAndCloseStream(DocumentStream stream) {
        ArrayList documents = Lists.newArrayList();
        for (Document document : stream) {
            documents.add(document);
        }
        stream.close();
        return documents;
    }
}

