package com.mapr.db.util;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MCFTree {

  public class Node {
    String field;
    Map<String, Node> children;
    String parent;
    ByteBuffer docBuffer;
    boolean visited;
    int level;

    Node(String n, String s, ByteBuffer buff, int l) {
      field = n;
      children = new HashMap<String,Node>();
      parent = s;
      docBuffer = buff;
      visited = false;
      level = l-1;
    }

    public String getFieldName() {
      return field;
    }

    public void addChild(Node n) {
      children.put(n.getFieldName(), n);
    }

    public Node findChild(String fname) {
      Node n = children.get(fname);
      return ((n != null) && (n.isVisited())) ? null : n;
    }

    public boolean hasBuffer() {
      return (docBuffer == null) ? false : true;
    }

    public ByteBuffer getBuffer() {
      return docBuffer;
    }

    public void setVisited() {
      visited = true;
    }

    /**
     * Function which checks to see if all childs are visited.
     * @return boolean (true/false) indicating if any child node is yet to be visited.
     */
    public boolean isSubtreeVisited() {
      for (Map.Entry<String,Node> c : children.entrySet()) {
        if (!c.getValue().isVisited()) {
          return false;
        }
      }
      return true;
    }

    public boolean isVisited() {
      return visited;
    }

    public String getParent() {
      return parent;
    }

    public Map<String, Node> getChildren() {
      return children;
    }

    public int getLevel() {
      return level;
    }

    public boolean isRoot() {
      return (level == 0)? true : false;
    }
  }

  private List<Map<String,Node>> root = null;
  private int nodeCount;

  public MCFTree() {
    root = new ArrayList<Map<String,Node>>();
    Map<String, Node> m = new HashMap<String, Node>();
    m.put(new String(""), new Node("", null, null, 1));
    root.add(m);
    nodeCount = 1;
  }

  private Node getParent(int level, String fieldName) {
    Map<String, Node> m = (level > 0) ? root.get(level-1) : null;
    return (m == null) ? null : m.get(fieldName);
  }

  public void addBuffer(int level, String fieldName, ByteBuffer buff) {
    Map<String, Node> m = root.get(level-1);
    Node n = m.get(fieldName);
    n.docBuffer = buff;
  }


  public void insertNode(int level, String fieldName, String p, ByteBuffer buff) throws Exception {
    //first get the parent
    if (level > (root.size()+1)) {
      throw new Exception("Can not add to the current node");
    }
    if (search(level-1,fieldName) != null) {
      //node already exists...no need to insert
      return;
    }
    Node parent = getParent(level-1, p);
    if ((level > 1) && (parent == null)) {
      throw new Exception("Can not find parent. Can not add "+fieldName);
    }
    Node newNode = new Node(fieldName, p, buff, level);

    if (parent != null) {
     parent.addChild(newNode);
    }
    Map<String, Node> currentLevel = null;
    if (level <= root.size()) {
      currentLevel = root.get(level-1);
    }
    if (currentLevel == null) {
      currentLevel = new HashMap<String, Node>();
      root.add(currentLevel);
    }
    currentLevel.put(fieldName, newNode);
    nodeCount++;

  }

  public Node search(int level, String f) {
    if ((level < 0) || (level >= root.size())) return null;
    Map<String, Node> m =  root.get(level);
    return (m == null)? null:m.get(f);
  }

  public int getNumNodes() {
    return nodeCount;
  }

}
