package com.mapr.db.rowcol;

import java.nio.ByteBuffer;

/*
 * Class represents the action and serialized bytebuffer while encoding
 * a record into multiple column families. 
 * 
 */
public interface SerializedFamilyInfo {
  /* returns the column familyId */
  int getFamilyId();
  /* returns the action that needs to be taken for this family */
  SerializationAction getAction();
  /* 
   * returns the bytebuffer associated with this family. This is non
   * NULL only when the action is "set".
   */
  ByteBuffer getByteBuffer();
}
