package com.mapr.db.rowcol;

import org.ojai.Value;
import org.ojai.Value.Type;

public class RowcolType {
  // There is one to one mapping of Ojai value type to rowcol type
  // there is one additional type defined in the RowColType which is to denote
  // the end of field marker. It denotes the end of elements in map or array
  public static byte rowColType(Value.Type type) {
    return type.getCode();
  }

  public static Value.Type valueType(int rowColType) {
    return Type.valueOf(rowColType);
  }

  // NOTE - This value should not conflict with any of the valid values
  // defined in the Value.Type
  public static final int END_OF_FIELD_TYPE = 0x00;

  // NOTE : Bit 5,6,7 are reserved for encoding the op type in the rowcol format
  public static final byte OPTYPE_SHIFT = 5;
  public static final byte OPTYPE_MASK = (byte) 0x07;

  public static final byte TYPE_MASK = 0x1f;

}
