package com.mapr.db.rowcol;

import org.ojai.FieldPath;

import com.mapr.db.rowcol.InsertContext.OpType;

public class MutationHelper {

  /**
   * This is the common entry point to insert different types of
   * mutation operations in a record.
   * @param opType The type of operation, such as set, set_or_replace, delete, and inc
   * to be applied to the given field
   * @param rec the record that is holding the mutation operation. Eventually this
   * record will be serialized to encode the mutation in rowcol format
   * @param field the path of the field on which the mutation is applied
   * @param value the value for the mutation. For delete, it's the NULL type of the key value
   * @return TRUE if the applied operation has an array that requires
   * read, transform and write back on the server.
   */
  public static boolean mutationCommon(OpType opType,
      DBDocumentImpl rec, FieldPath field, KeyValue value) {

    assert(opType != OpType.NONE) : "Mutation can't have none type";

    InsertContext ctx = new InsertContext();
    ctx.setOpType(opType);
    rec.createOrInsert(field.iterator(), value, ctx);
    return ctx.hasAbsArrayIndex();
  }
}
