package com.mapr.db.rowcol;

/*
 * Class which is passed for inserting each element in the document tree
 * It is used to pass information for inserting and getting the information
 * back out of the parsing
 */
public class InsertContext {
  public enum OpType {
    NONE,
    SET_OR_REPLACE,
    SET,
    DELETE,
    APPEND,
    INCREMENT,
    MERGE ;

    public static OpType valueOf(byte code) {
      switch(code) {
      case 0 : return NONE;
      case 1 : return SET_OR_REPLACE;
      case 2 : return SET;
      case 3 : return DELETE;
      case 4 : return APPEND;
      case 5 : return INCREMENT;
      case 6 : return MERGE;
      default : throw new IllegalArgumentException("Invalid OpType provided for k-v pair : " + code);
      }
    }
  }

  private OpType opType;
  private byte flags;
  public static final byte IsAtRootShift = 0;
  public static final byte IsAtRootMask = 0x1;
  public static final byte HasAbsArrayIndexShift = 1;
  public static final byte HasAbsArrayIndexMask = 0x2;
  public void SetIsAtRoot(boolean v) {
    if (v) {
      flags |= 1 << IsAtRootShift;
    } else {
      flags &= ~IsAtRootMask;
    }
  }

  public boolean IsAtRoot() {
    return ((flags & IsAtRootMask) == 0) ? false : true;
  }

  public void setHasAbsArrayIndex(boolean v) {
    if (v) {
      flags |= 1 << HasAbsArrayIndexShift;
    } else {
      flags &= ~(1 << HasAbsArrayIndexShift);
    }
  }

  public boolean hasAbsArrayIndex() {
    return ((flags & HasAbsArrayIndexMask) == 0) ? false : true;
  }

  public OpType getOpType() {
    return opType;
  }

  public void setOpType(OpType o) {
    opType = o;
  }

  public InsertContext() {
    /* for the beginning set it at root */
    flags = IsAtRootMask;
    opType = OpType.NONE;
  }

}
