/* Copyright (c) 2015 & onwards. MapR Tech, Inc., All rights reserved */
package com.mapr.db.rowcol;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;

import org.ojai.Document;
import org.ojai.Value;
import org.ojai.types.ODate;
import org.ojai.types.OInterval;
import org.ojai.types.OTime;
import org.ojai.types.OTimestamp;

public interface DBValueBuilder {

  public KeyValue newDBValue();

  public KeyValue initFromNull();

  public KeyValue initFrom(boolean value);

  public KeyValue initFrom(String value);

  public KeyValue initFrom(byte value);

  public KeyValue initFrom(short value);

  public KeyValue initFrom(int value);

  public KeyValue initFrom(long value);

  public KeyValue initFrom(float value);

  public KeyValue initFrom(double value);

  public KeyValue initFrom(OTime value);

  public KeyValue initFrom(ODate value);

  public KeyValue initFrom(BigDecimal value);

  public KeyValue initFrom(OTimestamp value);

  public KeyValue initFrom(OInterval value);

  public KeyValue initFrom(ByteBuffer value);

  public KeyValue initFrom(List<? extends Object> list);

  public KeyValue initFrom(Map<String, ? extends Object> map);

  public KeyValue initFrom(Document value);

  public KeyValue initFrom(Value value);

  public KeyValue initFromObject(Object value);

  public KeyValue initFromArray(Object value);

  public KeyValue initFromArray(byte[] values);

  public KeyValue initFromArray(short[] values);

  public KeyValue initFromArray(int[] values) ;

  public KeyValue initFromArray(long[] values);

  public KeyValue initFromArray(float[] values);

  public KeyValue initFromArray(double[] values) ;

  public KeyValue initFromArray(boolean[] values) ;

  public KeyValue initFromArray(char[] values) ;

  public KeyValue initFromArray(Object[] values);


}
