/* Copyright (c) 2015 & onwards. MapR Tech, Inc., All rights reserved */
package com.mapr.db.rowcol;

import java.nio.ByteBuffer;

import org.ojai.Value;


public abstract class BaseSerializationContext {


  /* metadata and data on current node */
  Value.Type type;


  private byte timeDescriptor = 0;
  

  private int numBitsForValue;
  private int[] keyValueSize;
  private int orderInMap;
  private boolean isNewRecord;
  private boolean isArrayElement;

  public byte getTimeDescriptor() {
    return timeDescriptor;
  }

  public void setTimeDescriptor(byte timeDescriptor) {
    this.timeDescriptor = timeDescriptor;
  }
  
  public boolean isArrayElement() {
    return isArrayElement;
  }

  public void setIsArrayElement(boolean isArrayElement) {
    this.isArrayElement = isArrayElement;
  }

  public boolean isRoot() {
    return isNewRecord;
  }

  public void setNewRecord(boolean isNewRecord) {
    this.isNewRecord = isNewRecord;
  }

  public int getOrderInMap() {
    return orderInMap;
  }

  public void setOrderInMap(int orderInMap) {
    this.orderInMap = orderInMap;
  }

  public void setType(Value.Type t) {
    type = t;
  }

  public Value.Type getType() {
    return type;
  }

  public void setNumBitsForValue(int num) {
    numBitsForValue = num;
  }

  public void setKeyValueSize(ByteBuffer input) {
    keyValueSize = KeyValueSizeDescriptor.decodeKeyValueSize(numBitsForValue, input);
  }

  public int[] getKeyValueSize() {
    return keyValueSize;
  }
}
