package com.mapr.db.ojai;

import java.util.Iterator;
import java.util.NoSuchElementException;

import org.ojai.Document;
import org.ojai.DocumentReader;

class DBDocumentReaderIterable implements Iterable<DocumentReader> {

  final private DBDocumentStream mapRDBRecordStream;
  Iterator<Document> recordIterator;

  DBDocumentReaderIterable(DBDocumentStream recordStream) {
    this.mapRDBRecordStream = recordStream;
    recordIterator = mapRDBRecordStream.iterator();
  }

  @Override
  public Iterator<DocumentReader> iterator() {
    return new Iterator<DocumentReader>() {

      Document rec = null;

      @Override
      public boolean hasNext() {
        if (rec == null) {
          if (recordIterator.hasNext()) {
            rec = recordIterator.next();
            return true;
          }
          return false;
        } else {
          return true;
        }
      }

      @Override
      public DocumentReader next() {
        if (rec == null) {
          if (!hasNext()) {
            throw new NoSuchElementException("next() called after hasNext() " +
                "returned false.");
          }
        }
        Document temp = rec;
        rec = null;
        return temp.asReader();
      }

      @Override
      public void remove() {
        throw new UnsupportedOperationException();
      }

    };
  }

}
