/* Copyright (c) 2015 & onwards. MapR Tech, Inc., All rights reserved */
package com.mapr.db.ojai;

import com.mapr.db.ControlInfo;

import org.ojai.DocumentReader;
import org.ojai.Value;
import org.ojai.annotation.API;

@API.Public
public interface DBDocumentReaderBase extends DocumentReader {
  /**
   * Retrieves control information, such as create/delete/append, associated
   * with the current key-value pair being parsed.
   *
   * @return the ControlInfo for the current key-value pair
   */
  ControlInfo getControlInfo();

  /**
   * @return The _id of the DBDocument of this DocumentReader.
   */
  Value getId();

}
