/* Copyright (c) 2015 & onwards. MapR Tech, Inc., All rights reserved */
package com.mapr.db.ojai;

import org.ojai.Value.Type;

import com.mapr.db.rowcol.KeyValue;

class ContainerContext {
  private final Type type;
  private int index;
  private final String fieldName;
  private final KeyValue kv;
  static final ContainerContext NULL = new ContainerContext(null);

  ContainerContext(Type t) {
    this(t, null, null);
  }

  ContainerContext(Type t, String key) {
    this(t, key, null);
  }

  ContainerContext(Type t, String key, KeyValue v) {
    kv = v;
    type = t;
    index = -1;
    fieldName = key;
  }

  public Type getType() {
    return type;
  }

  int getIndex() {
    if (type != Type.ARRAY) {
      throw new IllegalStateException("getIndex() called on a map");
    }
    return index;
  }

  void incrementIndex() {
    if (type != Type.ARRAY) {
      throw new IllegalStateException("incrementIndex() called on a map");
    }
    index++;
  }

  void setIndex(int i) {
    if (type != Type.ARRAY) {
      throw new IllegalStateException("incrementIndex() called on a map");
    }
    index = i;
  }

  @Override
  public String toString() {
    return "[" + type + ", " + index + ", " + fieldName + "]@" + hashCode();
  }

  public String getFieldName() {
    return fieldName;
  }

  public KeyValue getKv() {
    return kv;
  }

  public boolean isMap() {
    return type == Type.MAP;
  }

}
