/* Copyright (c) 2015 & onwards. MapR Tech, Inc., All rights reserved */
package com.mapr.db.impl;

import org.ojai.DocumentConstants;
import org.ojai.FieldPath;
import org.ojai.annotation.API;
import org.ojai.store.QueryCondition;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.mapr.db.MapRDB;

/**
 * This class contains constants used internally by DB-Client.
 */
@API.Internal
public final class Constants {

  public static BiMap <FieldPath, Integer> DEFAULT_FAMILY_MAP = ImmutableBiMap.of(FieldPath.EMPTY, 0);

  // Maximum row key size
  public static final int MAX_ROW_KEY_SIZE = 32*1024;

  // Empty rowkey for first start key in the first segment
  public static final String EMPTY_ROWKEY = "";

  // Number of threads processing async get requests
  public static final int NUM_ASYNC_READERS = 8;

  // Table Options constants
  public static final String EXCLUDEID_STR = "EXCLUDEID";
  public static final String BUFFERWRITE_STR = "BUFFERWRITE";
  public static final String KEEPINSERTIONORDER_STR = "KEEPINSERTIONORDER";

  // default column family name for JSON table.
  public static final String DEFAULT_FAMILY = "default";
  public static final String DEFAULT_FAMILY_JSON_PATH = "";

  // default family fake id to name map
  public static BiMap<Integer, String> DEFAULT_NAME_MAP = ImmutableBiMap.of(0, DEFAULT_FAMILY);

  // Number of rows to batch for streaming read based insert
  public static final int JSON_INSERT_BATCH_SIZE = 8;

  // number of milliseconds in a day
  public static final long MILLISECONDS_IN_A_DAY = 24 * 60 * 60 * 1000;

  // Used as an anchor field for path into non-default column family.
  public static final String DUMMY_FIELD_V = "v";

  // Used as an anchor field for path into non-default column family.
  public static final FieldPath DUMMY_FIELDPATH_V = FieldPath.parseFrom(DUMMY_FIELD_V);

  // Field segment seperator
  public static final String FIELD_SEPARATOR = ".";
  public static final char FIELD_SEPARATOR_CHAR = '.';

  public static final String CF_COLUMN_SEPARATOR = ":";

  public static final QueryCondition ROW_EXISTS_CONDITION =
      MapRDB.newCondition().exists(DocumentConstants.ID_FIELD).build();
  public static final QueryCondition ROW_NOT_EXISTS_CONDITION =
      MapRDB.newCondition().notExists(DocumentConstants.ID_FIELD).build();

  // Switch to flip to enable/disable insertion order on client.
  // Note that if table creation property did not enable it, then client cannot
  // enable it.
  public static final boolean DEFAULT_INSERTION_ORDER = true;

  public static final String COLUMNSPECCONF = "columnspeccconf";

  public static final int ISROOT_CHECKSUM = 1;
  public static final int ISNOTROOT_CHECKSUM = 2;
  public static final int DOC_BEGIN_CHECKSUM = 3;
  public static final int DOC_END_CHECKSUM = 4;
  public static final int MAP_BEGIN_CHECKSUM = 5;
  public static final int MAP_END_CHECKSUM = 6;
  public static final int ARRAY_BEGIN_CHECKSUM = 7;
  public static final int ARRAY_END_CHECKSUM = 8;
  public static final int VALUENULL_CHECKSUM = 9;

}
