/* Copyright (c) 2015 & onwards. MapR Tech, Inc., All rights reserved */
package com.mapr.db.impl;

import com.mapr.db.util.ByteBufs;

import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Set;

import org.ojai.FieldPath;
import org.ojai.annotation.API;

import com.mapr.fs.proto.Dbfilters.FilterMsg;

@API.Internal
public class ConditionDescriptor {
  FilterMsg filterMsg;
  ByteBuffer serialized;
  Map<Integer, ? extends Set<FieldPath>> familyFieldPathsMap;

  ConditionDescriptor(ByteBuffer serializedCondition) {
    this.serialized = serializedCondition;
  }

  ConditionDescriptor(FilterMsg filterMsg,
      Map<Integer, ? extends Set<FieldPath>> familyFieldPathsMap) {
    this.filterMsg = filterMsg;
    this.familyFieldPathsMap = familyFieldPathsMap;
  }

  public FilterMsg getFilterMsg() {
    return filterMsg;
  }

  public ByteBuffer getSerialized() {
    if (serialized == null && filterMsg != null) {
      byte[] b = filterMsg.toByteArray();
      serialized = ByteBufs.wrap(b);
    }
    return serialized;
  }

  public Map<Integer, ? extends Set<FieldPath>> getFamilyFieldPathsMap() {
    return familyFieldPathsMap;
  }

  @Override
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + ((familyFieldPathsMap == null) ? 0 : familyFieldPathsMap.hashCode());
    result = prime * result + ((serialized == null) ? 0 : serialized.hashCode());
    return result;
  }

  @Override
  public boolean equals(Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    ConditionDescriptor other = (ConditionDescriptor) obj;
    if (familyFieldPathsMap == null) {
      if (other.familyFieldPathsMap != null)
        return false;
    } else if (!familyFieldPathsMap.equals(other.familyFieldPathsMap))
      return false;
    if (serialized == null) {
      if (other.serialized != null)
        return false;
    } else if (!serialized.equals(other.serialized))
      return false;
    return true;
  }

}
