/* Copyright (c) 2016 & onwards. MapR Tech, Inc., All rights reserved */
package com.mapr.db.impl;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import org.ojai.FieldPath;
import org.ojai.annotation.API;
import org.ojai.store.QueryCondition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.ByteString;
import com.mapr.db.rowcol.SerializationAction;
import com.mapr.db.rowcol.SerializedFamilyInfo;
import com.mapr.fs.jni.MapRConstants;
import com.mapr.fs.proto.Dbfilters.FilterMsg;
import com.mapr.fs.proto.Dbfilters.AlwaysFalseFilterProto;

@API.Internal
class AlwaysFalseCondition extends ConditionNode {

  static Logger logger = LoggerFactory.getLogger(AlwaysFalseCondition.class);

  @Override
  protected AlwaysFalseCondition clone() {
    AlwaysFalseCondition newCond = (AlwaysFalseCondition) super.clone();
    return newCond;
  }

  @Override
  boolean checkAndPrune() {
    return false;
  }

  @Override
  void addProjections(Set<FieldPath> proj) {
  }

  @Override
  StringBuilder expressionBuilder(StringBuilder sb) {
    return treeBuilder(sb, 0);
  }

  @Override
  StringBuilder treeBuilder(StringBuilder sb, int level) {
    return sb.append(OPEN_PARAN)
             .append("false")
             .append(CLOSE_PARAN);
  }

  @Override
  StringBuilder jsonBuilder(StringBuilder sb) {
    return sb.append(OPEN_MAP)
             .append(OPEN_BRACKET).append(SPACE_CHAR).append(CLOSE_BRACKET)
             .append(CLOSE_MAP);
  }

  @Override
  ConditionDescriptor getDescriptor(BiMap<FieldPath, Integer> pathIdMap) {
    AlwaysFalseFilterProto conditionFilter = AlwaysFalseFilterProto.newBuilder()
                                                               .build();
    FilterMsg filterMsg = FilterMsg.newBuilder()
                           .setId(HASH_OF_ALWAYSFALSE_FILTER)
                           .setSerializedState(conditionFilter.toByteString())
                           .build();

    ImmutableMap.Builder<Integer, Set<FieldPath>> mapBuilder = ImmutableMap.builder();
    return new ConditionDescriptor(filterMsg, mapBuilder.build());
  }

  @Override
  List<RowkeyRange> getRowkeyRanges() {
    return FULL_TABLE_RANGE;
  }

}
