/* Copyright (c) 2015 & onwards. MapR Tech, Inc., All rights reserved */
package com.mapr.db.exceptions;

import org.apache.hadoop.fs.Path;

/**
 * This class is used to wrap a checked exception for any operation on a
 * non-existing table.
 */
public class TableNotFoundException extends DBException {
  private static final long serialVersionUID = 1029734454133759420L;

  /** Default constructor. */
  public TableNotFoundException() {
    super();
  }

  /**
   * Constructor.
   * @param tablePath message
   */
  public TableNotFoundException(Path tablePath) {
    this(String.valueOf(tablePath));
  }

  /**
   * Constructor.
   * @param tablePath message
   */
  public TableNotFoundException(String tablePath) {
    super(msg(tablePath));
  }

  /**
   * Constructor taking another exception.
   * @param t exception to grab data from
   */
  public TableNotFoundException(Throwable t) {
    super(t);
  }

  /**
   * Constructor taking a message and another exception.
   * @param tablePath message
   * @param t exception to grab data from
   */
  public TableNotFoundException(String tablePath, Throwable t) {
    super(msg(tablePath), t);
  }

  public TableNotFoundException(Path tablePath, Exception e) {
    this(String.valueOf(tablePath), e);
  }

  private static String msg(String tablePath) {
    return String.format("The table specified by the path '%s' was not found.", tablePath);
  }

}
