/* Copyright (c) 2015 & onwards. MapR Tech, Inc., All rights reserved */
package com.mapr.db.exceptions;

import org.apache.hadoop.fs.Path;

/**
 * This class is used to wrap a checked exception when the table already exists.
 * Thrown for a create operation on an existing table's object.
 */
public class TableExistsException extends DBException {
  private static final long serialVersionUID = 7404893528730028693L;

  /** Default constructor. */
  public TableExistsException() {
    super();
  }

  /**
   * Constructor.
   * @param tablePath message
   */
  public TableExistsException(Path tablePath) {
    this(String.valueOf(tablePath));
  }

  /**
   * Constructor.
   * @param tablePath message
   */
  public TableExistsException(String tablePath) {
    super(msg(tablePath));
  }

  /**
   * Constructor taking another exception.
   * @param t exception to grab data from
   */
  public TableExistsException(Throwable t) {
    super(t);
  }

  /**
   * Constructor taking a message and another exception.
   * @param tablePath message
   * @param t exception to grab data from
   */
  public TableExistsException(String tablePath, Throwable t) {
    super(msg(tablePath), t);
  }

  public TableExistsException(Path tablePath, Exception e) {
    this(String.valueOf(tablePath), e);
  }

  private static String msg(String tablePath) {
    return String.format("The table specified by the path '%s' already exists.", tablePath);
  }

}
