/* Copyright (c) 2015 & onwards. MapR Tech, Inc., All rights reserved */
package com.mapr.db.exceptions;

/**
 * This class is used to wrap a checked exception for any operation on a
 * table that has been closed.
 */
public class TableClosedException extends DBException {

  private static final long serialVersionUID = 37359285593735L;

  /** Default constructor. */
  public TableClosedException() {
    super();
  }

  /**
   * Constructor.
   * @param s message
   */
  public TableClosedException(String s) {
    super(s);
  }

  /**
   * Constructor taking another exception.
   * @param t exception to grab data from
   */
  public TableClosedException(Throwable t) {
    super(t);
  }

  /**
   * Constructor taking a message and another exception.
   * @param s message
   * @param t exception to grab data from
   */
  public TableClosedException(String s, Throwable t) {
    super(s, t);
  }

}
