/* Copyright (c) 2015 & onwards. MapR Tech, Inc., All rights reserved */
package com.mapr.db.exceptions;

/**
 * This class is used to wrap a checked exception when we try to insert/update/
 * delete from a table that is read-only.
 */
public class ReadOnlyException extends DBException {
  private static final long serialVersionUID = 1664939836394563779L;

  /** Default constructor. */
  public ReadOnlyException() {
    super();
  }

  /**
   * Constructor.
   * @param s message
   */
  public ReadOnlyException(String s) {
    super(s);
  }

  /**
   * Constructor taking another exception.
   * @param t exception to grab data from
   */
  public ReadOnlyException(Throwable t) {
    super(t);
  }

  /**
   * Constructor taking a message and another exception.
   * @param s message
   * @param t exception to grab data from
   */
  public ReadOnlyException(String s, Throwable t) {
    super(s, t);
  }

}
