/* Copyright (c) 2015 & onwards. MapR Tech, Inc., All rights reserved */
package com.mapr.db.exceptions;

/**
 * This class is used to wrap checked exceptions when the server returns EPERM.
 * The client can take the appropriate action to allow the operation.
 */
public class OpNotPermittedException extends DBException {
  private static final long serialVersionUID = 4644529982282573984L;

  /** Default constructor. */
  public OpNotPermittedException() {
    super();
  }

  /**
   * Constructor.
   * @param s message
   */
  public OpNotPermittedException(String s) {
    super(s);
  }

  /**
   * Constructor taking another exception.
   * @param t exception to grab data from
   */
  public OpNotPermittedException(Throwable t) {
    super(t);
  }

  /**
   * Constructor taking a message and another exception.
   * @param s message
   * @param t exception to grab data from
   */
  public OpNotPermittedException(String s, Throwable t) {
    super(s, t);
  }
}
