/* Copyright (c) 2015 & onwards. MapR Tech, Inc., All rights reserved */
package com.mapr.db.exceptions;

import org.apache.hadoop.fs.Path;

/**
 * This class is used to wrap a checked exception for any operation on a
 * non-existing family.
 */
public class FamilyNotFoundException extends DBException {
  private static final long serialVersionUID = 1029734454133759420L;

  /** Default constructor. */
  public FamilyNotFoundException() {
    super();
  }

  /**
   * Constructor.
   * @param familyName message
   */
  public FamilyNotFoundException(Path tablePath, String familyName) {
    super(msg(tablePath, familyName));
  }

  /**
   * Constructor taking another exception.
   * @param t exception to grab data from
   */
  public FamilyNotFoundException(Throwable t) {
    super(t);
  }

  /**
   * Constructor taking a message and another exception.
   * @param familyName message
   * @param t exception to grab data from
   */
  public FamilyNotFoundException(Path tablePath, String familyName, Throwable t) {
    super(msg(tablePath, familyName), t);
  }

  private static String msg(Path tablePath, String familyName) {
    return String.format("The family '%s' was not found in table '%s'.", familyName, tablePath);
  }

}
