/* Copyright (c) 2015 & onwards. MapR Tech, Inc., All rights reserved */
package com.mapr.db.exceptions;

import org.apache.hadoop.fs.Path;

import com.mapr.db.FamilyDescriptor;

/**
 * This class is used to wrap a checked exception when the family already exists.
 */
public class FamilyExistsException extends DBException {
  private static final long serialVersionUID = 199041966637113317L;

  /** Default constructor. */
  public FamilyExistsException() {
    super();
  }

  /**
   * Constructor.
   * @param familyName message
   */
  public FamilyExistsException(Path tablePath, FamilyDescriptor familyName) {
    super(msg(tablePath, familyName));
  }

  /**
   * Constructor taking another exception.
   * @param t exception to grab data from
   */
  public FamilyExistsException(Throwable t) {
    super(t);
  }

  /**
   * Constructor taking a message and another exception.
   * @param tablePath 
   * @param familyDesc message
   * @param t exception to grab data from
   */
  public FamilyExistsException(Path tablePath, FamilyDescriptor familyDesc, Throwable t) {
    super(msg(tablePath, familyDesc), t);
  }

  private static String msg(Path tablePath, FamilyDescriptor familyDesc) {
    return String.format(
        "The family with name '%s' or json path '%s' already exists in table '%s'.",
        familyDesc.getName(), familyDesc.getJsonFieldPath(), tablePath);
  }

}
