/* Copyright (c) 2015 & onwards. MapR Tech, Inc., All rights reserved */
package com.mapr.db.exceptions;

import org.apache.hadoop.fs.Path;

/**
 * This class is used to wrap a checked exception for any operation
 * which needs a retry (as suggested by jni/server).
 */
public class DBRetryException extends DBException {
  private static final long serialVersionUID = 3310297344541759420L;

  /** Default constructor. */
  public DBRetryException() {
    super();
  }

  /**
   * Constructor.
   * @param tablePath message
   */
  public DBRetryException(Path tablePath) {
    this(String.valueOf(tablePath));
  }

  /**
   * Constructor.
   * @param tablePath message
   */
  public DBRetryException(String tablePath) {
    super(msg(tablePath));
  }

  /**
   * Constructor taking another exception.
   * @param t exception to grab data from
   */
  public DBRetryException(Throwable t) {
    super(t);
  }

  /**
   * Constructor taking a message and another exception.
   * @param tablePath message
   * @param t exception to grab data from
   */
  public DBRetryException(String tablePath, Throwable t) {
    super(msg(tablePath), t);
  }

  public DBRetryException(Path tablePath, Exception e) {
    this(String.valueOf(tablePath), e);
  }

  private static String msg(String tablePath) {
    return String.format("The '%s' operation failed and needs a client side retry.", tablePath);
  }
}
