/* Copyright (c) 2015 & onwards. MapR Tech, Inc., All rights reserved */
package com.mapr.db.exceptions;

import org.ojai.store.exceptions.StoreException;

/**
 * This class is the base class of all exceptions thrown from MapR-DB client code.
 */
public class DBException extends StoreException {

  private static final long serialVersionUID = 1717485350337711990L;

  /** Default constructor. */
  public DBException() {
    super();
  }

  /**
   * Constructor.
   * @param s message
   */
  public DBException(String s) {
    super(s);
  }

  /**
   * Constructor taking another exception.
   * @param t exception to grab data from
   */
  public DBException(Throwable t) {
    super(t);
  }

  /**
   * Constructor taking a message and another exception.
   * @param s message
   * @param t exception to grab data from
   */
  public DBException(String s, Throwable t) {
    super(s, t);
  }

}
