/* Copyright (c) 2015 & onwards. MapR Tech, Inc., All rights reserved */
package com.mapr.db.exceptions;

/**
 * This class is used to wrap checked exceptions when the server returns EACCES.
 * The client can take the appropriate action to ensure access.
 */
public class AccessDeniedException extends DBException {
  private static final long serialVersionUID = 8423572068057822140L;

  /** Default constructor. */
  public AccessDeniedException() {
    super();
  }

  /**
   * Constructor.
   * @param s message
   */
  public AccessDeniedException(String s) {
    super(s);
  }

  /**
   * Constructor taking another exception.
   * @param t exception to grab data from
   */
  public AccessDeniedException(Throwable t) {
    super(t);
  }

  /**
   * Constructor taking a message and another exception.
   * @param s message
   * @param t exception to grab data from
   */
  public AccessDeniedException(String s, Throwable t) {
    super(s, t);
  }

}
