/* Copyright (c) 2015 & onwards. MapR Tech, Inc., All rights reserved */
package com.mapr.db;

import org.ojai.DocumentStream;
import org.ojai.annotation.API;
import org.ojai.store.QueryCondition;

@API.Public
public interface TabletInfo {

  /**
   * @return the {@linkplain QueryCondition} which when passed to
   * {@linkplain Table#find(QueryCondition)} will limit Records
   * in the returned {@linkplain DocumentStream} to this tablet
   */
  public QueryCondition getCondition();

  /**
   * @return the list of nodes by hostname where this tablet is
   *         currently hosted
   */
  public String[] getLocations();

  /**
   * @return the estimated size of data in number of bytes stored
   *         in this tablet
   */
  public long getEstimatedSize();

  /**
   * @return the estimated number of rows stored in this tablet
   */
  public long getEstimatedNumRows();

}
