/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.tests.tableops;

import com.mapr.db.MapRDB;
import com.mapr.db.Table;
import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.db.tests.utils.DBTests;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.ClusterTest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;
import org.ojai.DocumentStream;
import org.ojai.store.QueryCondition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ClusterTest.class})
public class TestMapRDBWithClusterEmptyKeys
extends BaseTest {
    private static final Logger _logger = LoggerFactory.getLogger(TestMapRDBWithClusterEmptyKeys.class);
    private static final String TEST_NAME = "TestMapRDBWithClusterEmptyKeys";

    @Test
    public void testSimple() throws IOException, InterruptedException {
        String tableName = "testSimple-TestMapRDBWithClusterEmptyKeys";
        Table t = DBTests.createOrReplaceTable(tableName);
        DBDocumentImpl putRec = new DBDocumentImpl();
        putRec.set("a.b", 1).set("", 2);
        t.insertOrReplace("KEY", (Document)putRec);
        t.flush();
        Document d = t.findById("KEY");
        Iterator itr = t.find().iterator();
        for (Document document : t.find()) {
        }
    }

    @Test
    public void testNestedMapEmptyKeys() throws IOException, InterruptedException {
        String tableName = "testNestedEmptyKeys-TestMapRDBWithClusterEmptyKeys";
        Table t = DBTests.createOrReplaceTable(tableName);
        DBDocumentImpl putRec = new DBDocumentImpl();
        putRec.set("a.b", 1);
        DBDocumentImpl put2 = new DBDocumentImpl().set("", "empty.empty");
        putRec.set("", (Document)put2);
        t.insertOrReplace("KEY", (Document)putRec);
        t.flush();
        Document d = t.findById("KEY");
        Iterator itr = t.find().iterator();
        for (Document document : t.find()) {
        }
    }

    @Test
    public void testNestedArrayEmptyKeys() throws IOException, InterruptedException {
        String tableName = "testNestedEmptyKeys-TestMapRDBWithClusterEmptyKeys";
        Table t = DBTests.createOrReplaceTable(tableName);
        DBDocumentImpl putRec = new DBDocumentImpl();
        putRec.set("a.b", 1);
        ArrayList<String> l = new ArrayList<String>();
        l.add("empty");
        putRec.set("", l);
        t.insertOrReplace("KEY", (Document)putRec);
        t.flush();
        Document d = t.findById("KEY");
        Iterator itr = t.find().iterator();
        for (Document document : t.find()) {
        }
    }

    @Test
    public void testMultipleEmptyKeys() throws IOException, InterruptedException {
        String tableName = "testMultipleEmptyKeys-TestMapRDBWithClusterEmptyKeys";
        Table t = DBTests.createOrReplaceTable(tableName);
        DBDocumentImpl putRec = new DBDocumentImpl();
        putRec.set("a", 1);
        ArrayList<String> l = new ArrayList<String>();
        l.add("array-empty");
        DBDocumentImpl putList = new DBDocumentImpl();
        putList.set("", l);
        putRec.set("b", (Document)putList);
        DBDocumentImpl putMap = new DBDocumentImpl().set("", "map-empty");
        putRec.set("c", (Document)putMap);
        t.insertOrReplace("KEY", (Document)putRec);
        t.flush();
        Document d = t.findById("KEY");
        Iterator itr = t.find().iterator();
        for (Document document : t.find()) {
        }
    }

    @Test
    public void testLargeDocumentEmptyKeys() throws IOException, InterruptedException {
        String tableName = "testLargeDocumentEmptyKeys-TestMapRDBWithClusterEmptyKeys";
        Table t = DBTests.createOrReplaceTable(tableName);
        for (int i = 0; i < 10; ++i) {
            Document d = MapRDB.newDocument().set("_id", "blank-" + i).set("a", "A").set("b.c.d.e.f", "alpha");
            Document d2 = MapRDB.newDocument().set("", "<empty>");
            d.set("b.c.e", d2);
            t.insertOrReplace(d);
        }
        t.flush();
        QueryCondition c = MapRDB.newCondition().is("a", QueryCondition.Op.EQUAL, "A").build();
        DocumentStream rs = t.find(c, new String[]{"b.c"});
        try {
            Iterator iter = rs.iterator();
            while (iter.hasNext()) {
                iter.next();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

