/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.tests.tableops;

import com.mapr.db.MapRDB;
import com.mapr.db.Table;
import com.mapr.db.tests.utils.DBTests;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.StressTest;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;
import org.ojai.DocumentStream;
import org.ojai.store.DocumentMutation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={StressTest.class})
public class TTLTest
extends BaseTest {
    private static final Logger _logger = LoggerFactory.getLogger(TTLTest.class);
    private static final String TABLE_NAME = "/tmp/testtable-TTLTest";

    @Ignore
    public void loopTTL() throws Exception {
        for (int i = 0; i < 100; ++i) {
            System.out.println("ITER " + i);
            this.testTTL();
            this.testTTLWithMultiCF();
        }
    }

    @Test
    public void testTTL() throws Exception {
        DBTests.admin().deleteTable(TABLE_NAME);
        Table myTab = DBTests.admin().createTable(MapRDB.newTableDescriptor((String)TABLE_NAME).addFamily(MapRDB.newDefaultFamilyDescriptor().setTTL(30L)));
        Document r = MapRDB.newDocument();
        r.set("field1", 100);
        myTab.insertOrReplace("K1", r);
        Document r2 = MapRDB.newDocument();
        r2.set("field3", 10000);
        myTab.insertOrReplace("K2", r2);
        myTab.flush();
        r = myTab.findById("K1");
        Assert.assertEquals((long)100L, (long)r.getInt("field1"));
        r2 = myTab.findById("K2");
        Assert.assertEquals((long)10000L, (long)r2.getInt("field3"));
        Thread.sleep(25000L);
        DocumentMutation m = MapRDB.newMutation();
        m.setOrReplace("field2", 5000);
        myTab.update("K1", m);
        myTab.flush();
        Thread.sleep(10000L);
        r = myTab.findById("K1");
        _logger.trace("K1 record is {}", (Object)r);
        Assert.assertEquals((long)100L, (long)r.getInt("field1"));
        Assert.assertEquals((long)5000L, (long)r.getInt("field2"));
        r2 = myTab.findById("K2");
        Assert.assertNull((Object)r2);
        DocumentStream s = myTab.find();
        Iterator i = s.iterator();
        r = (Document)i.next();
        Assert.assertEquals((long)100L, (long)r.getInt("field1"));
        Assert.assertEquals((long)5000L, (long)r.getInt("field2"));
        Assert.assertFalse((boolean)i.hasNext());
        Thread.sleep(26000L);
        r = myTab.findById("K1");
        Assert.assertNull((Object)r);
        r2 = myTab.findById("K2");
        Assert.assertNull((Object)r2);
        s = myTab.find();
        i = s.iterator();
        Assert.assertFalse((boolean)i.hasNext());
        DBTests.deleteTables(TABLE_NAME);
    }

    @Test
    public void testCheckAndPutAfterTTLExpiry() throws Exception {
        boolean checkAndPutFailed = false;
        DBTests.admin().deleteTable(TABLE_NAME);
        Table myTab = DBTests.admin().createTable(MapRDB.newTableDescriptor((String)TABLE_NAME).addFamily(MapRDB.newDefaultFamilyDescriptor().setTTL(10L)));
        Document r = MapRDB.newDocument();
        r.set("field1", 100);
        myTab.insertOrReplace("K1", r);
        myTab.flush();
        Thread.sleep(15000L);
        r = MapRDB.newDocument();
        r.set("field1", 200);
        r.set("field2", "First");
        DocumentMutation mutation = MapRDB.newMutation();
        mutation.increment("field1", 5).append("field2", "Last");
        try {
            myTab.insert("K1", r);
            myTab.flush();
            myTab.update("K1", mutation);
            myTab.flush();
        }
        catch (Exception e) {
            Assert.fail((String)"Insert or update after TTL expiry unexpectedly failed");
            checkAndPutFailed = true;
        }
        Assert.assertFalse((boolean)checkAndPutFailed);
        DBTests.deleteTables(TABLE_NAME);
    }

    @Ignore(value="Cannot set TTL in multi CF cases")
    public void testTTLWithMultiCF() throws Exception {
        DBTests.admin().deleteTable(TABLE_NAME);
        System.out.println("Slower test -- will sleep for TTL expiry!");
        Table myTab = DBTests.admin().createTable(MapRDB.newTableDescriptor((String)TABLE_NAME).addFamily(MapRDB.newDefaultFamilyDescriptor().setTTL(8L)).addFamily(MapRDB.newFamilyDescriptor((String)"CF1", (String)"a.b").setTTL(20L)).addFamily(MapRDB.newFamilyDescriptor((String)"CF2", (String)"a.b.c.d").setTTL(10L)).addFamily(MapRDB.newFamilyDescriptor((String)"CF3", (String)"b").setTTL(10L)));
        Document r = MapRDB.newDocument();
        r.set("c", "F1");
        r.set("d", "F2");
        r.set("a.b.f1", "f1");
        r.set("a.b.f2", "f2");
        r.set("a.b.c.d.f1", 100);
        r.set("a.b.c.d.f2", 200);
        r.set("b.f1", 100);
        r.set("b.f2", 300);
        myTab.insertOrReplace("K1", r);
        myTab.flush();
        Thread.sleep(5000L);
        r = myTab.findById("K1");
        Assert.assertEquals((Object)"F1", (Object)r.getString("c"));
        Assert.assertEquals((Object)"F2", (Object)r.getString("d"));
        Assert.assertEquals((Object)"f1", (Object)r.getString("a.b.f1"));
        Assert.assertEquals((Object)"f2", (Object)r.getString("a.b.f2"));
        Assert.assertEquals((long)100L, (long)r.getInt("a.b.c.d.f1"));
        Assert.assertEquals((long)200L, (long)r.getInt("a.b.c.d.f2"));
        Assert.assertEquals((long)100L, (long)r.getInt("b.f1"));
        Assert.assertEquals((long)300L, (long)r.getInt("b.f2"));
        DocumentStream s = myTab.find();
        Iterator i = s.iterator();
        r = (Document)i.next();
        Assert.assertEquals((Object)"F1", (Object)r.getString("c"));
        Assert.assertEquals((Object)"F2", (Object)r.getString("d"));
        Assert.assertEquals((Object)"f1", (Object)r.getString("a.b.f1"));
        Assert.assertEquals((Object)"f2", (Object)r.getString("a.b.f2"));
        Assert.assertEquals((long)100L, (long)r.getInt("a.b.c.d.f1"));
        Assert.assertEquals((long)200L, (long)r.getInt("a.b.c.d.f2"));
        Assert.assertEquals((long)100L, (long)r.getInt("b.f1"));
        Assert.assertEquals((long)300L, (long)r.getInt("b.f2"));
        Assert.assertFalse((boolean)i.hasNext());
        Thread.sleep(4000L);
        r = myTab.findById("K1");
        Assert.assertNull((Object)r.getValue("c"));
        Assert.assertNull((Object)r.getValue("d"));
        Assert.assertEquals((Object)"f1", (Object)r.getString("a.b.f1"));
        Assert.assertEquals((Object)"f2", (Object)r.getString("a.b.f2"));
        Assert.assertEquals((long)100L, (long)r.getInt("a.b.c.d.f1"));
        Assert.assertEquals((long)200L, (long)r.getInt("a.b.c.d.f2"));
        Assert.assertEquals((long)100L, (long)r.getInt("b.f1"));
        Assert.assertEquals((long)300L, (long)r.getInt("b.f2"));
        s = myTab.find();
        i = s.iterator();
        r = (Document)i.next();
        Assert.assertNull((Object)r.getValue("c"));
        Assert.assertNull((Object)r.getValue("d"));
        Assert.assertEquals((Object)"f1", (Object)r.getString("a.b.f1"));
        Assert.assertEquals((Object)"f2", (Object)r.getString("a.b.f2"));
        Assert.assertEquals((long)100L, (long)r.getInt("a.b.c.d.f1"));
        Assert.assertEquals((long)200L, (long)r.getInt("a.b.c.d.f2"));
        Assert.assertEquals((long)100L, (long)r.getInt("b.f1"));
        Assert.assertEquals((long)300L, (long)r.getInt("b.f2"));
        Thread.sleep(5000L);
        r = myTab.findById("K1");
        Assert.assertNull((Object)r.getValue("c"));
        Assert.assertNull((Object)r.getValue("d"));
        Assert.assertEquals((Object)"f1", (Object)r.getString("a.b.f1"));
        Assert.assertEquals((Object)"f2", (Object)r.getString("a.b.f2"));
        Assert.assertNull((Object)r.getValue("a.b.c.d.f1"));
        Assert.assertNull((Object)r.getValue("a.b.c.d.f2"));
        Assert.assertNull((Object)r.getValue("b.f1"));
        Assert.assertNull((Object)r.getValue("b.f2"));
        s = myTab.find();
        i = s.iterator();
        r = (Document)i.next();
        Assert.assertNull((Object)r.getValue("c"));
        Assert.assertNull((Object)r.getValue("d"));
        Assert.assertEquals((Object)"f1", (Object)r.getString("a.b.f1"));
        Assert.assertEquals((Object)"f2", (Object)r.getString("a.b.f2"));
        Assert.assertNull((Object)r.getValue("a.b.c.d.f1"));
        Assert.assertNull((Object)r.getValue("a.b.c.d.f2"));
        Assert.assertNull((Object)r.getValue("b.f1"));
        Assert.assertNull((Object)r.getValue("b.f2"));
        Thread.sleep(10000L);
        r = myTab.findById("K1");
        Assert.assertNull((Object)r);
        s = myTab.find();
        i = s.iterator();
        Assert.assertFalse((boolean)i.hasNext());
        DBTests.deleteTables(TABLE_NAME);
    }
}

